/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpKit;
import com.ebaiyihui.health.management.common.vo.OnlineOutpatientUsageReqVo;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.BaseinfoEntity;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.Insuinfo;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.MedicalPayDto;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.MedicalPaycallReqVo;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.PatientInfoRequest;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.PayCreateOrderVo;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.RequestContent;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.RequestCreateOrderVo;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.RequestRefundOrderVo;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.ResponseNotifyRestVo;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.TencentCreadOrderResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.UserQueryRequest;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.UserQueryResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.YbBaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.YbPatientInfoResponse;
import com.ebaiyihui.onlineoutpatient.core.business.callbackwhilepaysuccess.core.UpdateOrderRecordService;
import com.ebaiyihui.onlineoutpatient.core.common.constants.UrlConstants;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PayChannelEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PayTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServerTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.TencentOrderTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.TencentPayTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.WeChatPayTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.WhetherEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryMchCodeMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ServiceMerchantConfigMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ServicePayBillMapper;
import com.ebaiyihui.onlineoutpatient.core.exception.BusinessException;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryMchCodeEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ServicePayBillEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.OrderSender;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.PayAsyncService;
import com.ebaiyihui.onlineoutpatient.core.service.PayCallBackService;
import com.ebaiyihui.onlineoutpatient.core.service.client.ServicepkgServiceOrderFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.PayCallBackServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.manager.GnHisManagerService;
import com.ebaiyihui.onlineoutpatient.core.service.mobile.MobileBenefitPackageService;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.JsonUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.RedisUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.SignUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.StringUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.id.UUIDUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.HisDeptAndDocCodeVo;
import com.ebaiyihui.onlineoutpatient.core.vo.MedicalNotifyReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderTaskVo;
import com.ebaiyihui.onlineoutpatient.core.vo.PayNotifyResultVo;
import com.ebaiyihui.onlineoutpatient.core.vo.PayReqInfoVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestPayByPackageVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestRefundVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ResPatientInformationVo;
import com.ebaiyihui.onlineoutpatient.core.vo.UnregisterPayMethodReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.UnregisterPayMethodResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.PatientInfoVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.PreSettlementReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.RegisteredSaveResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.RegistrationConfirmReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.RegistrationConfirmResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.TransModelVo;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.AliPayCreateOrderRequest;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.AliPayExtendParamsEntrty;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.AliPayMedicalRequesExtEntrty;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.AlipayNotifyParam;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.MedicalPaymentRequest;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.QueryMedicalSettlementOrderRequest;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.RefundOrderRequest;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.RefundRequestContent;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.ResultResponse;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.TencentCreadOrderRequest;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.TencentRefundRequest;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.UndoOrderRequest;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.YdBaseResponse;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.YdCreadOrderResponse;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PayCallBackServiceImpl
implements PayCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PayCallBackServiceImpl.class);
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private PayAsyncService payAsyncService;
    @Autowired
    private ServicepkgServiceOrderFeignClient servicepkgServiceOrderClient;
    @Autowired
    private BaseInquiryOrderServiceImpl baseInquiryOrderService;
    @Autowired
    private OrderSender orderSender;
    @Autowired
    private InquiryMchCodeMapper inquiryMchCodeMapper;
    @Autowired
    private HisTemplateService hisTemplateService;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;
    @Autowired
    private UpdateOrderRecordService updateOrderRecordService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private MobileBenefitPackageService mobileBenefitPackageService;
    @Autowired
    private GnHisManagerService gnHisManagerService;
    private static final String SUCCESS = "1";
    private static final String ONE = "1";
    private static final String ONE_ONE = "-1";
    private static final String MEDICAL_URL = "https://testapi.chinachdu.com/medicare/";
    private static final String NOTIFY_URL = "https://testapi.chinachdu.com/";
    private static final String RETURN_URL = "https://xxxxx";
    private static final String ORGAN_CODE = "130188";
    private static final String GN_ORGAN_CODE = "360";

    public BaseResponse<String> doWhilePayCallBack(ResponseNotifyRestVo dto) {
        BaseResponse x;
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity wrapperEntity = new OrderEntity();
        wrapperEntity.setOrderSeq(dto.getOutTradeNo());
        queryWrapper.setEntity((Object)wrapperEntity);
        OrderEntity orderInfo = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapper);
        if (orderInfo == null) {
            return BaseResponse.success((Object)"fail");
        }
        log.info("\u652f\u4ed8\u56de\u8c03\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f:{}", (Object)orderInfo.toString());
        if (this.vaildParams(dto, orderInfo)) {
            return BaseResponse.success((Object)"fail");
        }
        orderInfo.setStatus(OrderStatusEnum.PAID.getValue());
        orderInfo.setBankTradeNo(dto.getTradeNo());
        orderInfo.setPaymentTime(dto.getPayTime());
        orderInfo.setPayMethod(dto.getPayChannel());
        orderInfo.setDealSeq(dto.getDealTradeNo());
        log.info("\u652f\u4ed8\u56de\u8c03\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f:{}", (Object)orderInfo.toString());
        this.baseInquiryOrderService.updateById((Object)orderInfo);
        AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(orderInfo.getXId());
        admissionEntity.setServTime(orderInfo.getServTime());
        admissionEntity.setStartTime(dto.getPayTime());
        admissionEntity.setTotalNum(orderInfo.getTotalNum());
        admissionEntity.setCurrentNum(orderInfo.getTotalNum());
        admissionEntity.setDoctorName(orderInfo.getDoctorName());
        if (null != orderInfo.getScheduleDate()) {
            admissionEntity.setScheduleDate(orderInfo.getScheduleDate());
            Date scheduleDate = orderInfo.getScheduleDate();
            String scheduleDateStr = DateUtils.dateToSimpleString((Date)scheduleDate);
            String scheduleEndTime = orderInfo.getScheduleEndTime();
            String newDateTimeStr = scheduleDateStr + " " + scheduleEndTime + ":00";
            Date expirationDateTime = DateUtils.stringToFullDate((String)newDateTimeStr);
            admissionEntity.setStatus(AdmissionStatusEnum.WAIT_ADMISSION.getValue());
            admissionEntity.setEndTime(expirationDateTime);
        } else {
            admissionEntity.setEndTime(DateUtils.getDateAfter((Date)new Date(), (int)1));
            admissionEntity.setStatus(AdmissionStatusEnum.TO_BE_RECEIVED.getValue());
            admissionEntity.setConvertWaitTime(new Date());
        }
        admissionEntity.setPauseTime(Long.valueOf(0L));
        admissionEntity.setOrganId(orderInfo.getHospitalId());
        log.info("\u652f\u4ed8\u56de\u8c03\u6dfb\u52a0\u5c31\u8bca\u8bb0\u5f55:{}", (Object)admissionEntity.toString());
        Integer insertAdmissionRes = this.admissionMapper.updateById((Object)admissionEntity);
        if (insertAdmissionRes != null && insertAdmissionRes > 0) {
            this.payAsyncService.asyncTask(orderInfo, admissionEntity);
        }
        if (null != orderInfo.getScheduleDate()) {
            OrderTaskVo orderTaskVo3 = new OrderTaskVo();
            orderTaskVo3.setType(Integer.valueOf(3));
            orderTaskVo3.setId(orderInfo.getXId());
            log.info("\u5b9a\u65f6\u5904\u7406\u60a3\u8005\u672a\u70b9\u51fb'\u5019\u8bca\u62a5\u9053\u63a5\u53e3'\uff0c\u63d0\u793a\u60a3\u8005\u53bb\u5019\u8bca\uff0corderTaskVo3\uff1a{}", (Object)orderTaskVo3.toString());
            this.orderSender.sendDelay(orderTaskVo3);
            OrderTaskVo orderTaskVo4 = new OrderTaskVo();
            orderTaskVo4.setType(Integer.valueOf(4));
            orderTaskVo4.setId(orderInfo.getXId());
            log.info("\u9884\u7ea6\u6392\u73ed\u7ed3\u675f\u65f6\u95f4\u5c31\u8bca\u8ba2\u5355\u5904\u7406orderTaskVo4\uff1a{}", (Object)orderTaskVo4.toString());
            this.orderSender.sendDelay(orderTaskVo4);
        } else {
            OrderTaskVo orderTaskVo2 = new OrderTaskVo();
            orderTaskVo2.setType(Integer.valueOf(2));
            orderTaskVo2.setId(orderInfo.getXId());
            log.info("\u65e0\u6392\u73ed\u8ba2\u5355\u9884\u7ea6\u7ed3\u675f\u65f6\u95f4\u8ba2\u5355\u5904\u7406 orderTaskVo2\uff1a{}", (Object)orderTaskVo2.toString());
            this.orderSender.sendDelay(orderTaskVo2);
        }
        log.info("\u652f\u4ed8\u56de\u8c03\u6210\u529f");
        InquiryMchCodeEntity inquiryEntity = this.getHisUrl(orderInfo.getAppCode(), orderInfo.getHospitalId());
        PatientEntity patientEntity = this.patientMapper.selectById(orderInfo.getPatientId());
        if (null == patientEntity) {
            return BaseResponse.error((String)"\u60a3\u8005\u4e0d\u5b58\u5728");
        }
        if (orderInfo.getServType().equals(ServiceTypeEnum.NOS.getValue()) && null != inquiryEntity && StringUtils.isNotEmpty((String)inquiryEntity.getHisUrl()) && "HYT".equals(inquiryEntity.getAppCode()) && (x = this.HYTHis(dto, orderInfo, admissionEntity, patientEntity)) != null) {
            return x;
        }
        return BaseResponse.success((Object)"success");
    }

    private BaseResponse<String> HYTHis(ResponseNotifyRestVo dto, OrderEntity orderInfo, AdmissionEntity admissionEntity, PatientEntity patientEntity) {
        log.info("\u56de\u8c03\u4e2d\u8c03\u7528his\u5f00\u59cb\u65f6\u95f4\uff1a{}" + System.currentTimeMillis());
        HisDeptAndDocCodeVo hisDeptAndDocCode = this.internetHospitalDetailInfoService.getHisDeptAndDocCode(orderInfo.getDeptId().toString(), orderInfo.getDoctorId());
        if (null == hisDeptAndDocCode) {
            return BaseResponse.error((String)"\u533b\u751f\u670d\u52a1\u8c03\u7528\u51fa\u9519");
        }
        PreSettlementReqVo preSettlementReqVo = this.getPreSettlementRequest(orderInfo, patientEntity, hisDeptAndDocCode);
        log.info("\u6302\u53f7\u4fdd\u5b58\u5165\u53c2:" + preSettlementReqVo.toString());
        RegisteredSaveResVo registeredSaveResVo = this.hisTemplateService.registeredSave(preSettlementReqVo);
        if (null != registeredSaveResVo && registeredSaveResVo.getResult().equals("1")) {
            log.info("registeredSaveResVo:" + registeredSaveResVo.toString());
            OrderEntity order = new OrderEntity();
            order.setXId(orderInfo.getXId());
            order.setClinicCode(registeredSaveResVo.getClinicCode());
            order.setInvoiceNo(registeredSaveResVo.getInvoiceNo());
            this.orderMapper.updateById((Object)order);
            log.info("order:" + JSON.toJSONString((Object)order));
            RegistrationConfirmReqVo registrationConfirmReqVo = new RegistrationConfirmReqVo();
            registrationConfirmReqVo.setCarNo(patientEntity.getMedicalNO());
            registrationConfirmReqVo.setClino(order.getClinicCode());
            registrationConfirmReqVo.setInvoiceNo(registeredSaveResVo.getInvoiceNo());
            registrationConfirmReqVo.setCost(orderInfo.getOwnCost());
            registrationConfirmReqVo.setPayMode("WX");
            PayNotifyResultVo payNotifyReqVO = (PayNotifyResultVo)JSON.parseObject((String)dto.getNotifyResultStr(), PayNotifyResultVo.class);
            log.info("payNotifyReqVO:" + JSON.toJSONString((Object)payNotifyReqVO));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            String format = simpleDateFormat.format(orderInfo.getPaymentTime());
            BigDecimal bigDecimal = new BigDecimal(orderInfo.getOwnCost());
            BigDecimal ownCost = bigDecimal.multiply(new BigDecimal(100));
            String transInfo = "SUCCESS|OK|" + payNotifyReqVO.getAppid() + "|" + payNotifyReqVO.getMchId() + "|" + payNotifyReqVO.getNonceStr() + "|" + payNotifyReqVO.getSign() + "|SUCCESS|" + payNotifyReqVO.getOpenid() + "|" + payNotifyReqVO.getIsSubscribe() + "|" + payNotifyReqVO.getTradeType() + "|" + payNotifyReqVO.getBankType() + "|" + ownCost + "|" + payNotifyReqVO.getFeeType() + "|" + payNotifyReqVO.getTransactionId() + "|" + orderInfo.getDealSeq() + "||" + format + "|SUCCESS|" + ownCost + "|1|" + registeredSaveResVo.getInvoiceNo() + "|" + patientEntity.getMedicalNO() + "|0|1";
            registrationConfirmReqVo.setTransInfo(transInfo);
            RegistrationConfirmResVo registrationConfirmResVo = this.hisTemplateService.registrationConfirmation(registrationConfirmReqVo);
            if (null == registrationConfirmResVo || registrationConfirmResVo.getResult().equals(ONE_ONE)) {
                log.info("\u6302\u53f7\u786e\u8ba4\u5931\u8d25");
                RequestRefundVo requestRefundVo = new RequestRefundVo();
                requestRefundVo.setOrderId(orderInfo.getXId());
                BaseResponse baseResponse = this.refundCalls(requestRefundVo);
                AdmissionEntity admission = new AdmissionEntity();
                admission.setStatus(AdmissionStatusEnum.REFUNDED_REFUSE.getValue());
                admission.setXId(admissionEntity.getXId());
                Integer update = this.admissionMapper.update(admission);
                if (!update.equals(WhetherEnum.ALLOW.getValue())) {
                    log.info("\u6302\u53f7\u6210\u529f,\u9000\u6b3e\u6210\u529f,\u9000\u53f7\u6210\u529f,\u5c31\u8bca\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
                    return BaseResponse.error((String)"\u5c31\u8bca\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
                }
            }
        } else {
            log.info("\u6302\u53f7\u4fdd\u5b58\u8c03\u7528\u5931\u8d25");
            RequestRefundVo requestRefundVo = new RequestRefundVo();
            requestRefundVo.setOrderId(orderInfo.getXId());
            BaseResponse baseResponse = this.refundCalls(requestRefundVo);
            AdmissionEntity admission = new AdmissionEntity();
            admission.setStatus(AdmissionStatusEnum.REFUNDED_REFUSE.getValue());
            admission.setXId(admissionEntity.getXId());
            Integer update = this.admissionMapper.update(admission);
            if (!update.equals(WhetherEnum.ALLOW.getValue())) {
                log.info("\u6302\u53f7\u5931\u8d25,\u9000\u6b3e\u6210\u529f,\u5c31\u8bca\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
                return BaseResponse.error((String)"\u5c31\u8bca\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
            }
            return BaseResponse.error((String)"\u6302\u53f7\u4fdd\u5b58\u8c03\u7528\u5931\u8d25");
        }
        log.info("\u6302\u53f7\u786e\u8ba4\u6210\u529f");
        return null;
    }

    private PreSettlementReqVo getPreSettlementRequest(OrderEntity orderInfo, PatientEntity patientEntity, HisDeptAndDocCodeVo hisDeptAndDocCode) {
        PreSettlementReqVo preSettlementReqVo = new PreSettlementReqVo();
        PatientInfoVo patientInfoVo = new PatientInfoVo();
        patientInfoVo.setBirthDay(patientEntity.getBirthDates());
        patientInfoVo.setCardNO(patientEntity.getMedicalNO());
        patientInfoVo.setSex(patientEntity.getGender().toString());
        patientInfoVo.setPhone(patientEntity.getAccountPhone());
        patientInfoVo.setName(patientEntity.getPatientName());
        patientInfoVo.setPactCode(patientEntity.getPactCode());
        patientInfoVo.setIdCard(patientEntity.getIdcard());
        patientInfoVo.setAddress(patientEntity.getAddress());
        TransModelVo transModelVo = new TransModelVo();
        transModelVo.setMachineNO("byhl");
        transModelVo.setTransNO(UUIDUtil.getUUID());
        transModelVo.setBankTransNO(UUIDUtil.getUUID());
        preSettlementReqVo.setTransModelVo(transModelVo);
        preSettlementReqVo.setPatientInfoVo(patientInfoVo);
        preSettlementReqVo.setDeptCode(hisDeptAndDocCode.getDeptCode());
        preSettlementReqVo.setDoctCode(hisDeptAndDocCode.getDoctorCode());
        preSettlementReqVo.setDoctName(hisDeptAndDocCode.getDoctorName());
        preSettlementReqVo.setDeptName(hisDeptAndDocCode.getDeptName());
        preSettlementReqVo.setRegLeve("16");
        preSettlementReqVo.setNoonID("0");
        preSettlementReqVo.setRegType("0");
        preSettlementReqVo.setRegLeveName("\u4e92\u8054\u7f51\u590d\u8bca\u53f7");
        preSettlementReqVo.setFundType(patientEntity.getFundType());
        preSettlementReqVo.setHospFlag(orderInfo.getHospFlag().toString());
        preSettlementReqVo.setMarkNO(patientEntity.getCardNo());
        preSettlementReqVo.setMarkType(patientEntity.getFundType());
        preSettlementReqVo.setNoonID("0");
        preSettlementReqVo.setOrderID("");
        preSettlementReqVo.setSchemaID("");
        preSettlementReqVo.setPayType(PayTypeEnum.WX.name());
        return preSettlementReqVo;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public BaseResponse<String> callbackRefundPaySuccess(ResponseNotifyRestVo dto) {
        log.info("\u9000\u6b3e\u56de\u8c03doWhilePayCallBack dto :{}", (Object)JsonUtil.convertObject((Object)dto));
        OrderEntity orderInfo = this.getOrderByOrderSeq(dto.getOutTradeNo());
        if (this.refundParams(dto, orderInfo)) {
            return BaseResponse.success((Object)"fail");
        }
        log.info("\u9000\u6b3e\u56de\u8c03\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f:{}", (Object)orderInfo.toString());
        log.info("\u9000\u6b3e\u65f6\u95f4:{}" + dto.getRefundTime());
        orderInfo.setStatus(OrderStatusEnum.REFUNDED.getValue());
        orderInfo.setRefundTime(dto.getRefundTime());
        this.orderMapper.updateOrderEntity(orderInfo);
        log.info("\u9000\u6b3e\u56de\u8c03\u6210\u529f:{}", (Object)"success");
        PatientEntity patientEntity = this.patientMapper.selectById(orderInfo.getPatientId());
        InquiryMchCodeEntity inquiryEntity = this.getHisUrl(orderInfo.getAppCode(), orderInfo.getHospitalId());
        if (orderInfo.getServType().equals(ServiceTypeEnum.NOS.getValue()) && patientEntity != null && StringUtils.isNotEmpty((String)orderInfo.getClinicCode()) && null != inquiryEntity && StringUtils.isNotEmpty((String)inquiryEntity.getHisUrl()) && "HYT".equals(inquiryEntity.getAppCode()) && this.HYTRefund(dto, orderInfo)) {
            return BaseResponse.error((String)"\u9000\u53f7\u56de\u5199\u652f\u4ed8\u65b9\u5f0f");
        }
        return BaseResponse.success((Object)"success");
    }

    private boolean HYTRefund(ResponseNotifyRestVo dto, OrderEntity orderInfo) {
        UnregisterPayMethodReqVo unregisterPayMethodReqVo = new UnregisterPayMethodReqVo();
        PayNotifyResultVo payNotifyReqVO = (PayNotifyResultVo)JSON.parseObject((String)dto.getNotifyResultStr(), PayNotifyResultVo.class);
        log.info("payNotifyReqVO:" + JSON.toJSONString((Object)payNotifyReqVO));
        PayReqInfoVo payReqInfoVo = (PayReqInfoVo)JSON.parseObject((String)payNotifyReqVO.getReqInfo(), PayReqInfoVo.class);
        log.info("payReqInfoVo:" + JSON.toJSONString((Object)payReqInfoVo));
        BigDecimal bigDecimal = new BigDecimal(orderInfo.getOwnCost());
        BigDecimal ownCost = bigDecimal.multiply(new BigDecimal(100));
        String sign = "";
        if (StringUtils.isNotEmpty((String)payNotifyReqVO.getSign())) {
            sign = payNotifyReqVO.getSign();
        }
        String transInfo = "SUCCESS|OK|SUCCESS|||SUCCESS|" + payNotifyReqVO.getAppid() + "|" + payNotifyReqVO.getMchId() + "|" + payNotifyReqVO.getNonceStr() + "|" + payReqInfoVo.getOutRefundNo() + "||" + payReqInfoVo.getRefundFee() + "|" + payReqInfoVo.getRefundId() + "|" + payReqInfoVo.getRefundRecvAccout() + "|" + sign + "|" + payReqInfoVo.getTotalFee() + "|" + payReqInfoVo.getTransactionId() + "|" + payReqInfoVo.getOutTradeNo() + "||";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String format = simpleDateFormat.format(orderInfo.getPaymentTime());
        unregisterPayMethodReqVo.setTransInfo(transInfo);
        unregisterPayMethodReqVo.setClinicCode(orderInfo.getClinicCode());
        UnregisterPayMethodResVo unregisterPayMethodResVo = this.hisTemplateService.unregisterPayMethod(unregisterPayMethodReqVo);
        if (null == unregisterPayMethodResVo || unregisterPayMethodResVo.getResult().equals(ONE_ONE)) {
            log.info("\u9000\u53f7\u56de\u5199\u652f\u4ed8\u65b9\u5f0f\u5931\u8d25");
            return true;
        }
        log.info("\u9000\u53f7\u56de\u5199\u652f\u4ed8\u65b9\u5f0f\u6210\u529f");
        return false;
    }

    private boolean vaildParams(ResponseNotifyRestVo dto, OrderEntity orderInfo) {
        if (orderInfo == null) {
            log.error("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355,\u652f\u4ed8\u7cfb\u7edf\u4ea4\u6613\u7f16\u53f7={},\u4e1a\u52a1\u7cfb\u7edf\u4ea4\u6613\u7f16\u53f7={}", (Object)dto.getOutTradeNo());
            return true;
        }
        if (!orderInfo.getOrderSeq().equals(dto.getOutTradeNo())) {
            log.error("\u8ba2\u5355\u4fe1\u606f\u4e0e\u56de\u8c03\u53c2\u6570\u4e0d\u5339\u914d,\u8ba2\u5355={},\u56de\u8c03\u53c2\u6570={}", (Object)orderInfo.toString(), (Object)dto.toString());
            return true;
        }
        if (orderInfo.getServType().equals(ServiceTypeEnum.NOS.getValue()) && StringUtils.isNotEmpty((String)orderInfo.getOwnCost())) {
            BigDecimal bigDecimal = new BigDecimal(orderInfo.getOwnCost());
            if (0 != bigDecimal.compareTo(dto.getTotalAmount())) {
                log.error("\u8ba2\u5355\u91d1\u989d\u4e0e\u652f\u4ed8\u91d1\u989d\u4e0d\u5339\u914d,\u8ba2\u5355={},\u56de\u8c03\u53c2\u6570={}", (Object)orderInfo.toString(), (Object)dto.toString());
                return true;
            }
        } else if (0 != orderInfo.getPayAmount().compareTo(dto.getTotalAmount())) {
            log.error("\u8ba2\u5355\u91d1\u989d\u4e0e\u652f\u4ed8\u91d1\u989d\u4e0d\u5339\u914d,\u8ba2\u5355={},\u56de\u8c03\u53c2\u6570={}", (Object)orderInfo.toString(), (Object)dto.toString());
            return true;
        }
        if (OrderStatusEnum.TOPAY.getValue().intValue() != orderInfo.getStatus().intValue()) {
            log.error("doWhilePayCallBack \u8ba2\u5355\u72b6\u6001\u5f02\u5e38,\u8ba2\u5355\u975e\u5f85\u652f\u4ed8\u72b6\u6001!:{}", (Object)orderInfo.getStatus());
            return true;
        }
        return false;
    }

    private InquiryMchCodeEntity getHisUrl(String appCode, String hospitalId) {
        QueryWrapper wrapper = new QueryWrapper();
        InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
        inquiryMchCodeEntity.setAppCode(appCode);
        inquiryMchCodeEntity.setHospitalId(hospitalId);
        log.info("inquiryMchCodeEntity:{}" + inquiryMchCodeEntity.toString());
        wrapper.setEntity((Object)inquiryMchCodeEntity);
        InquiryMchCodeEntity entity = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)wrapper);
        return entity;
    }

    private boolean refundParams(ResponseNotifyRestVo dto, OrderEntity orderInfo) {
        if (orderInfo == null) {
            log.error("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355,\u652f\u4ed8\u7cfb\u7edf\u4ea4\u6613\u7f16\u53f7={},\u4e1a\u52a1\u7cfb\u7edf\u4ea4\u6613\u7f16\u53f7={}", (Object)dto.getOutTradeNo());
            return true;
        }
        if (!orderInfo.getOrderSeq().equals(dto.getOutTradeNo())) {
            log.error("\u8ba2\u5355\u4fe1\u606f\u4e0e\u56de\u8c03\u53c2\u6570\u4e0d\u5339\u914d,\u8ba2\u5355={},\u56de\u8c03\u53c2\u6570={}", (Object)orderInfo.toString(), (Object)dto.toString());
            return true;
        }
        if (orderInfo.getServType().equals(ServiceTypeEnum.NOS.getValue()) && StringUtils.isNotEmpty((String)orderInfo.getOwnCost())) {
            BigDecimal bigDecimal = new BigDecimal(orderInfo.getOwnCost());
            if (0 != bigDecimal.compareTo(dto.getTotalAmount())) {
                log.error("\u8ba2\u5355\u91d1\u989d\u4e0e\u9000\u6b3e\u91d1\u989d\u4e0d\u5339\u914d,\u8ba2\u5355={},\u56de\u8c03\u53c2\u6570={}", (Object)orderInfo.toString(), (Object)dto.toString());
                return true;
            }
        } else if (0 != orderInfo.getPayAmount().compareTo(dto.getTotalAmount())) {
            log.error("\u8ba2\u5355\u91d1\u989d\u4e0e\u9000\u6b3e\u91d1\u989d\u4e0d\u5339\u914d,\u8ba2\u5355={},\u56de\u8c03\u53c2\u6570={}", (Object)orderInfo.toString(), (Object)dto.toString());
            return true;
        }
        if (!OrderStatusEnum.PAID.getValue().equals(orderInfo.getStatus()) && !OrderStatusEnum.REFUNDED.getValue().equals(orderInfo.getStatus())) {
            log.error("----------doWhilePayCallBack \u8ba2\u5355\u72b6\u6001\u5f02\u5e38,\u8ba2\u5355\u975e\u5df2\u652f\u4ed8\u6216\u8005\u9000\u6b3e\u4e2d\u72b6\u6001!-------------:{}", (Object)orderInfo);
            return true;
        }
        return false;
    }

    private AdmissionEntity createAdmissionEntity(OrderEntity orderInfo) {
        AdmissionEntity entity = new AdmissionEntity();
        entity.setOrganId(orderInfo.getHospitalId());
        entity.setOrderId(orderInfo.getXId());
        entity.setPatientId(orderInfo.getPatientId());
        entity.setDoctorId(orderInfo.getDoctorId());
        entity.setDoctorName(orderInfo.getDoctorName());
        entity.setDoctorType(orderInfo.getDoctorType());
        entity.setServType(orderInfo.getServType());
        entity.setMedicalRecordId(orderInfo.getMedicalRecordId());
        return entity;
    }

    public BaseResponse payCalls(PayCreateOrderVo payCreateOrderVo) {
        QueryWrapper admWapper = new QueryWrapper();
        AdmissionEntity admissionEntity = new AdmissionEntity();
        admissionEntity.setOrderId(payCreateOrderVo.getOrderId());
        admWapper.setEntity((Object)admissionEntity);
        AdmissionEntity admission = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)admWapper);
        if (AdmissionStatusEnum.EXPIRED.getValue().equals(admission.getStatus())) {
            return BaseResponse.error((String)"\u8d85\u8fc7\u9884\u7ea6\u65f6\u95f4,\u8ba2\u5355\u5df2\u5931\u6548");
        }
        OrderEntity orderEntity = this.orderMapper.findById(payCreateOrderVo.getOrderId());
        if (null == orderEntity) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
        }
        if (OrderStatusEnum.CANCEL.getValue().equals(orderEntity.getStatus())) {
            return BaseResponse.error((String)"\u8ba2\u5355\u5df2\u5931\u6548");
        }
        log.info("orderEntity:{}" + orderEntity.toString());
        orderEntity.setFundType(payCreateOrderVo.getFundType());
        if (Objects.equals("2", orderEntity.getFundType())) {
            return this.aliPayMedical(orderEntity, payCreateOrderVo.getMedicalPaycallReqVo());
        }
        if (Objects.equals("3", orderEntity.getFundType())) {
            return this.wechatPayMedical(orderEntity, payCreateOrderVo.getMedicalPaycallReqVo());
        }
        if (Objects.equals("4", orderEntity.getFundType())) {
            return this.wechatPayMedicalGn(orderEntity, payCreateOrderVo.getMedicalPaycallReqVo());
        }
        orderEntity.setPayMethod(payCreateOrderVo.getPayChannel());
        this.orderMapper.updateById((Object)orderEntity);
        RequestCreateOrderVo requestCreateOrderVo = new RequestCreateOrderVo();
        if (payCreateOrderVo.getPayChannel().equals(PayChannelEnum.PACKAGE.getPayChannel())) {
            RequestPayByPackageVo requestPayByPackageVo = new RequestPayByPackageVo();
            requestPayByPackageVo.setOrderId(payCreateOrderVo.getOrderId());
            requestPayByPackageVo.setPackageId(Long.valueOf(Long.parseLong(payCreateOrderVo.getPayType())));
            requestPayByPackageVo.setServerType(payCreateOrderVo.getServerType());
            BaseResponse baseResponse = this.payByPackage(requestPayByPackageVo);
            return baseResponse;
        }
        if ((payCreateOrderVo.getPayChannel().equals(PayChannelEnum.WECHAT.getPayChannel()) || payCreateOrderVo.getPayChannel().equals(PayChannelEnum.ALIPAY.getPayChannel())) && payCreateOrderVo.getPayType().equals(WeChatPayTypeEnum.JSAPI.getDisplay())) {
            requestCreateOrderVo.setUserSign(payCreateOrderVo.getUserSign());
        }
        requestCreateOrderVo.setPayChannel(payCreateOrderVo.getPayChannel());
        requestCreateOrderVo.setPayType(payCreateOrderVo.getPayType());
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
        inquiryMchCodeEntity.setAppCode(orderEntity.getAppCode());
        inquiryMchCodeEntity.setHospitalId(orderEntity.getHospitalId());
        log.info("inquiryMchCodeEntity:{}" + inquiryMchCodeEntity.toString());
        queryWrapper.setEntity((Object)inquiryMchCodeEntity);
        InquiryMchCodeEntity entity = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)queryWrapper);
        if (null == entity) {
            return BaseResponse.error((String)"\u8be5\u533b\u9662\u7684\u5546\u6237\u53f7\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u5546\u6237\u53f7");
        }
        log.info("entity:{}" + entity.toString());
        String serviceCode = orderEntity.getAppCode() + "_" + StringUtil.toFirstChar((String)orderEntity.getHospitalName()) + "_" + ServiceTypeEnum.getCode((Integer)orderEntity.getServType());
        requestCreateOrderVo.setServiceCode(serviceCode);
        requestCreateOrderVo.setOutTradeNo(orderEntity.getOrderSeq());
        requestCreateOrderVo.setActuallyAmount(orderEntity.getPayAmount());
        requestCreateOrderVo.setTotalAmount(orderEntity.getPayAmount());
        requestCreateOrderVo.setProductInfo(this.projProperties.getProductInfo());
        requestCreateOrderVo.setProductInfo(this.projProperties.getProductInfo());
        requestCreateOrderVo.setPayNotifyUrl(MessageFormat.format(this.projProperties.getPayNotifyUrl(), entity.getAppCode()));
        requestCreateOrderVo.setNonceStr(SignUtil.getNonceStr());
        QueryWrapper wrapper = new QueryWrapper();
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = new ServiceMerchantConfigEntity();
        serviceMerchantConfigEntity.setAppCode(orderEntity.getAppCode());
        serviceMerchantConfigEntity.setHospitalId(orderEntity.getHospitalId());
        if ("ZHJYJF".equals(payCreateOrderVo.getFundType())) {
            serviceMerchantConfigEntity.setBizSysSeq("ZHJYJF");
        } else {
            serviceMerchantConfigEntity.setBizSysSeq(ServiceTypeEnum.getCode((Integer)orderEntity.getServType()));
        }
        serviceMerchantConfigEntity.setApplyName(payCreateOrderVo.getPayChannel());
        wrapper.setEntity((Object)serviceMerchantConfigEntity);
        log.info("\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u8868\u5165\u53c2:{}" + serviceMerchantConfigEntity.toString());
        ServiceMerchantConfigEntity serviceMerchantConfig = (ServiceMerchantConfigEntity)this.serviceMerchantConfigMapper.selectOne((Wrapper)wrapper);
        if (serviceMerchantConfig == null) {
            log.info("\u672a\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u652f\u4ed8\u5e94\u7528code");
            return null;
        }
        log.info("\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u8868\u51fa\u53c2serviceMerchantConfig:{}" + serviceMerchantConfig.toString());
        requestCreateOrderVo.setApplyCode(serviceMerchantConfig.getMerchantSeq());
        requestCreateOrderVo.setMchCode(serviceMerchantConfig.getMerchantSeq());
        Map map = SignUtil.getKeyAndValue((Object)requestCreateOrderVo);
        log.info("\u83b7\u53d6\u7684map\u4e3a\uff1a{}" + JSON.toJSONString((Object)map));
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfig.getApplyKey(), (String[])new String[0]);
        requestCreateOrderVo.setSign(sign);
        String url = this.projProperties.getPayCallsNew();
        try {
            String result = com.ebaiyihui.onlineoutpatient.core.utils.HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)requestCreateOrderVo));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), BaseResponse.class);
            log.info("baseResponse:{}" + JSON.toJSONString((Object)baseResponse));
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u652f\u4ed8\u63a5\u53e3\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public BaseResponse refundCalls(RequestRefundVo requestRefundVo) {
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        OrderEntity orderEntity1 = new OrderEntity();
        orderEntity1.setXId(requestRefundVo.getOrderId());
        objectQueryWrapper.setEntity((Object)orderEntity1);
        OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectOne((Wrapper)objectQueryWrapper);
        AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(orderEntity.getXId());
        if (StringUtils.isNotEmpty((String)admissionEntity.getPackageId())) {
            ResultData resultData = this.mobileBenefitPackageService.refundBenefitService(orderEntity, admissionEntity.getPackageId());
            if (!resultData.isSuccess()) {
                return BaseResponse.error((String)resultData.getMsg());
            }
            orderEntity.setStatus(OrderStatusEnum.REFUNDED.getValue());
            orderEntity.setRefundTime(new Date());
            this.orderMapper.updateOrderEntity(orderEntity);
            return BaseResponse.success();
        }
        ServicePayBillEntity payBillEntity = (ServicePayBillEntity)this.servicePayBillMapper.selectById((Serializable)((Object)orderEntity.getBillPayId()));
        ServicePayBillEntity refundBillEntity = new ServicePayBillEntity();
        BeanUtils.copyProperties((Object)payBillEntity, (Object)refundBillEntity);
        refundBillEntity.setId(UUIDUtil.getUUID());
        refundBillEntity.setCreateTime(new Date());
        refundBillEntity.setUpdateTime(new Date());
        orderEntity.setBillRefundId(refundBillEntity.getId());
        this.orderMapper.updateById((Object)orderEntity);
        this.servicePayBillMapper.insert((Object)refundBillEntity);
        log.info("orderEntity:{}" + orderEntity.toString());
        PatientEntity patientEntity = this.patientMapper.selectById(orderEntity.getPatientId());
        InquiryMchCodeEntity inquiryEntity = this.getHisUrl(orderEntity.getAppCode(), orderEntity.getHospitalId());
        if (Objects.equals(orderEntity.getFundType(), "2")) {
            if (StringUtils.isBlank((String)requestRefundVo.getPayAuthNo())) {
                return BaseResponse.success((Object)"\u533b\u4fdd\u8ba2\u5355\u6682\u65f6\u53ea\u652f\u6301\u5c0f\u7a0b\u5e8f\u9000\u6b3e\uff0c\u8bf7\u524d\u5f80\u5c0f\u7a0b\u5e8f\u6388\u6743\u9000\u6b3e");
            }
            this.aliRefundMedical(orderEntity, requestRefundVo.getPayAuthNo());
            return BaseResponse.success((Object)"\u9000\u6b3e\u6210\u529f");
        }
        if (Objects.equals(orderEntity.getFundType(), "3")) {
            if (StringUtils.isBlank((String)requestRefundVo.getPayAuthNo())) {
                return BaseResponse.success((Object)"\u533b\u4fdd\u8ba2\u5355\u6682\u65f6\u53ea\u652f\u6301\u5c0f\u7a0b\u5e8f\u9000\u6b3e\uff0c\u8bf7\u524d\u5f80\u5c0f\u7a0b\u5e8f\u6388\u6743\u9000\u6b3e");
            }
            if (this.tencentRefundMedical(orderEntity, requestRefundVo, ORGAN_CODE).booleanValue()) {
                return BaseResponse.success((Object)"\u9000\u6b3e\u6210\u529f");
            }
            return BaseResponse.error((String)"\u9000\u6b3e\u5931\u8d25");
        }
        if (Objects.equals(orderEntity.getFundType(), "4")) {
            if (StringUtils.isBlank((String)requestRefundVo.getPayAuthNo())) {
                return BaseResponse.error((String)"\u533b\u4fdd\u8ba2\u5355\u6682\u65f6\u53ea\u652f\u6301\u5c0f\u7a0b\u5e8f\u9000\u6b3e\uff0c\u8bf7\u524d\u5f80\u5c0f\u7a0b\u5e8f\u6388\u6743\u9000\u6b3e");
            }
            if (this.tencentRefundMedical(orderEntity, requestRefundVo, GN_ORGAN_CODE).booleanValue()) {
                return BaseResponse.success((Object)"\u9000\u6b3e\u6210\u529f");
            }
            return BaseResponse.error((String)"\u9000\u6b3e\u5931\u8d25");
        }
        if (orderEntity.getPayMethod().equals(PayChannelEnum.PACKAGE.getPayChannel())) {
            OnlineOutpatientUsageReqVo outpatientUsageReqVo = new OnlineOutpatientUsageReqVo();
            outpatientUsageReqVo.setId(Long.valueOf(Long.parseLong(orderEntity.getDealSeq().split("_")[0])));
            BaseResponse baseResponse = null;
            if (ServerTypeEnum.ONLINE_CONSULTATION.getValue().equals(requestRefundVo.getServerType())) {
                baseResponse = this.servicepkgServiceOrderClient.increaseOnlineOutpatientUsage(outpatientUsageReqVo);
                log.info("\u670d\u52a1\u5305\u9000\u6b3e\u7ed3\u679c\uff1a{}", (Object)baseResponse.toString());
                if (!baseResponse.isSuccess()) {
                    return BaseResponse.error((String)"\u5728\u7ebf\u95ee\u8bca\u670d\u52a1\u5305\u9000\u6b3e\u5931\u8d25");
                }
            } else if (ServerTypeEnum.FOLLOW_UP.getValue().equals(requestRefundVo.getServerType())) {
                baseResponse = this.servicepkgServiceOrderClient.increaseFollowUpOutpatientUsage(outpatientUsageReqVo);
                log.info("\u670d\u52a1\u5305\u9000\u6b3e\u7ed3\u679c\uff1a{}", (Object)baseResponse.toString());
                if (!baseResponse.isSuccess()) {
                    return BaseResponse.error((String)"\u590d\u8bca\u5f00\u836f\u670d\u52a1\u5305\u9000\u6b3e\u5931\u8d25");
                }
            }
            orderEntity.setStatus(OrderStatusEnum.REFUNDED.getValue());
            orderEntity.setRefundTime(new Date());
            this.orderMapper.updateOrderEntity(orderEntity);
            return baseResponse;
        }
        RequestRefundOrderVo requestCreateOrderVo = new RequestRefundOrderVo();
        requestCreateOrderVo.setPayChannel(orderEntity.getPayMethod());
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
        inquiryMchCodeEntity.setAppCode(orderEntity.getAppCode());
        inquiryMchCodeEntity.setHospitalId(orderEntity.getHospitalId());
        log.info("inquiryMchCodeEntity:{}" + inquiryMchCodeEntity.toString());
        queryWrapper.setEntity((Object)inquiryMchCodeEntity);
        InquiryMchCodeEntity entity = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)queryWrapper);
        if (null == entity) {
            return BaseResponse.error((String)"\u8be5\u533b\u9662\u7684\u5546\u6237\u53f7\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u5546\u6237\u53f7");
        }
        log.info("entity:{}" + entity.toString());
        requestCreateOrderVo.setOutTradeNo(orderEntity.getOrderSeq());
        requestCreateOrderVo.setDealTradeNo(orderEntity.getDealSeq());
        requestCreateOrderVo.setRefundAmount(orderEntity.getPayAmount());
        requestCreateOrderVo.setTotalAmount(orderEntity.getPayAmount());
        requestCreateOrderVo.setNonceStr(SignUtil.getNonceStr());
        requestCreateOrderVo.setRefundNotifyUrl(MessageFormat.format(this.projProperties.getRefundNotifyUrl(), entity.getAppCode()));
        QueryWrapper wrapper = new QueryWrapper();
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = new ServiceMerchantConfigEntity();
        serviceMerchantConfigEntity.setAppCode(orderEntity.getAppCode());
        serviceMerchantConfigEntity.setHospitalId(orderEntity.getHospitalId());
        if ("ZHJYJF".equals(orderEntity.getFundType())) {
            serviceMerchantConfigEntity.setBizSysSeq("ZHJYJF");
        } else {
            serviceMerchantConfigEntity.setBizSysSeq(ServiceTypeEnum.getCode((Integer)orderEntity.getServType()));
        }
        serviceMerchantConfigEntity.setApplyName(orderEntity.getPayMethod());
        wrapper.setEntity((Object)serviceMerchantConfigEntity);
        log.info("\u9000\u6b3e\u4e2d\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u8868\u5165\u53c2:{}" + serviceMerchantConfigEntity.toString());
        ServiceMerchantConfigEntity serviceMerchantConfig = (ServiceMerchantConfigEntity)this.serviceMerchantConfigMapper.selectOne((Wrapper)wrapper);
        if (serviceMerchantConfig == null) {
            log.info("\u672a\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u652f\u4ed8\u5e94\u7528code");
            return null;
        }
        log.info("\u9000\u6b3e\u4e2d\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u8868\u51fa\u53c2serviceMerchantConfigEntity:{}" + serviceMerchantConfigEntity.toString());
        requestCreateOrderVo.setApplyCode(serviceMerchantConfig.getMerchantSeq());
        requestCreateOrderVo.setMchCode(serviceMerchantConfig.getMerchantSeq());
        Map map = SignUtil.getKeyAndValue((Object)requestCreateOrderVo);
        log.info("\u83b7\u53d6\u7684map\u4e3a\uff1a{}" + JSON.toJSONString((Object)map));
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfig.getApplyKey(), (String[])new String[0]);
        requestCreateOrderVo.setSign(sign);
        String url = this.projProperties.getRefundCallsNew();
        try {
            String result = com.ebaiyihui.onlineoutpatient.core.utils.HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)requestCreateOrderVo));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), BaseResponse.class);
            log.info("baseResponse:{}" + JSON.toJSONString((Object)baseResponse));
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u9000\u6b3e\u63a5\u53e3\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public BaseResponse payByPackage(RequestPayByPackageVo requestPayByPackageVo) {
        BaseResponse baseResponse;
        OrderEntity orderEntity = this.getOrderById(requestPayByPackageVo.getOrderId());
        OnlineOutpatientUsageReqVo outpatientUsageReqVo = new OnlineOutpatientUsageReqVo();
        outpatientUsageReqVo.setId(requestPayByPackageVo.getPackageId());
        if (ServerTypeEnum.ONLINE_CONSULTATION.getValue().equals(requestPayByPackageVo.getServerType())) {
            baseResponse = this.servicepkgServiceOrderClient.decreaseOnlineOutpatientUsage(outpatientUsageReqVo);
            if (!baseResponse.isSuccess()) {
                return BaseResponse.error((String)"\u5728\u7ebf\u95ee\u8bca\u670d\u52a1\u5305\u4f7f\u7528\u5931\u8d25");
            }
            if (null == orderEntity) {
                return BaseResponse.error((String)"\u5728\u7ebf\u95ee\u8bca\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
        } else if (ServerTypeEnum.FOLLOW_UP.getValue().equals(requestPayByPackageVo.getServerType())) {
            baseResponse = this.servicepkgServiceOrderClient.decreaseFollowUpOutpatientUsage(outpatientUsageReqVo);
            if (!baseResponse.isSuccess()) {
                return BaseResponse.error((String)"\u590d\u8bca\u5f00\u836f\u670d\u52a1\u5305\u4f7f\u7528\u5931\u8d25");
            }
            if (null == orderEntity) {
                return BaseResponse.error((String)"\u590d\u8bca\u5f00\u836f\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
        } else {
            return BaseResponse.error((String)"\u672a\u627e\u5230\u76f8\u5173\u670d\u52a1\u5305\u4fe1\u606f");
        }
        orderEntity.setPayMethod(PayChannelEnum.PACKAGE.getPayChannel());
        orderEntity.setStatus(OrderStatusEnum.PAID.getValue());
        orderEntity.setDealSeq(requestPayByPackageVo.getPackageId().toString() + "_" + System.currentTimeMillis());
        orderEntity.setPaymentTime(new Date());
        orderEntity.setBankTradeNo(requestPayByPackageVo.getPackageId().toString());
        this.orderMapper.updateOrderEntity(orderEntity);
        AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(orderEntity.getXId());
        if (null != orderEntity.getScheduleDate()) {
            Date scheduleDate = orderEntity.getScheduleDate();
            String scheduleDateStr = DateUtils.dateToSimpleString((Date)scheduleDate);
            String scheduleEndTime = orderEntity.getScheduleEndTime();
            String newDateTimeStr = scheduleDateStr + " " + scheduleEndTime + ":00";
            Date expirationDateTime = DateUtils.stringToFullDate((String)newDateTimeStr);
            admissionEntity.setEndTime(expirationDateTime);
            admissionEntity.setStatus(AdmissionStatusEnum.WAIT_ADMISSION.getValue());
        } else {
            admissionEntity.setEndTime(DateUtils.getDateAfter((Date)new Date(), (int)1));
            admissionEntity.setConvertWaitTime(new Date());
            admissionEntity.setStatus(AdmissionStatusEnum.TO_BE_RECEIVED.getValue());
        }
        log.info("\u652f\u4ed8\u56de\u8c03\u6dfb\u52a0\u5c31\u8bca\u8bb0\u5f55:{}", (Object)admissionEntity.toString());
        Integer insertAdmissionRes = this.admissionMapper.updateById((Object)admissionEntity);
        if (insertAdmissionRes != null && insertAdmissionRes > 0) {
            this.payAsyncService.asyncTask(orderEntity, admissionEntity);
        }
        if (null != orderEntity.getScheduleDate()) {
            OrderTaskVo orderTaskVo3 = new OrderTaskVo();
            orderTaskVo3.setType(Integer.valueOf(3));
            orderTaskVo3.setId(orderEntity.getXId());
            log.info("\u5b9a\u65f6\u5904\u7406\u60a3\u8005\u672a\u70b9\u51fb'\u5019\u8bca\u62a5\u9053\u63a5\u53e3'\uff0c\u63d0\u793a\u60a3\u8005\u53bb\u5019\u8bca\uff0corderTaskVo3\uff1a{}", (Object)orderTaskVo3.toString());
            this.orderSender.sendDelay(orderTaskVo3);
            OrderTaskVo orderTaskVo4 = new OrderTaskVo();
            orderTaskVo4.setType(Integer.valueOf(4));
            orderTaskVo4.setId(orderEntity.getXId());
            log.info("\u9884\u7ea6\u6392\u73ed\u7ed3\u675f\u65f6\u95f4\u5c31\u8bca\u8ba2\u5355\u5904\u7406orderTaskVo4\uff1a{}", (Object)orderTaskVo4.toString());
            this.orderSender.sendDelay(orderTaskVo4);
        } else {
            OrderTaskVo orderTaskVo2 = new OrderTaskVo();
            orderTaskVo2.setType(Integer.valueOf(2));
            orderTaskVo2.setId(orderEntity.getXId());
            log.info("\u65e0\u6392\u73ed\u8ba2\u5355\u9884\u7ea6\u7ed3\u675f\u65f6\u95f4\u8ba2\u5355\u5904\u7406 orderTaskVo2\uff1a{}", (Object)orderTaskVo2.toString());
            this.orderSender.sendDelay(orderTaskVo2);
        }
        log.info("\u670d\u52a1\u5305\u652f\u4ed8\u6210\u529f");
        return BaseResponse.success((Object)"success");
    }

    private OrderEntity getOrderByOrderSeq(String orderSeq) {
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity wrapperEntity = new OrderEntity();
        wrapperEntity.setOrderSeq(orderSeq);
        queryWrapper.setEntity((Object)wrapperEntity);
        OrderEntity orderEntity = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapper);
        if (null == orderEntity) {
            return null;
        }
        return orderEntity;
    }

    private OrderEntity getOrderById(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity wrapperEntity = new OrderEntity();
        wrapperEntity.setXId(id);
        queryWrapper.setEntity((Object)wrapperEntity);
        OrderEntity orderEntity = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapper);
        if (null == orderEntity) {
            return null;
        }
        return orderEntity;
    }

    public BaseResponse<YdCreadOrderResponse> createMedicalOrder(MedicalPayDto param) {
        try {
            if (ORGAN_CODE.equals(param.getOrganCode())) {
                UserQueryResponse userQueryResponse = this.getNoSecretUserInfo(param);
                param.setPayAuthNo(userQueryResponse.getPay_auth_no());
                YbPatientInfoResponse ybPatientInfoResponse = this.getPatientInfo(param);
                Insuinfo insuinfo = (Insuinfo)ybPatientInfoResponse.getInsuinfo().get(0);
                BaseinfoEntity baseinfo = ybPatientInfoResponse.getBaseinfo();
                param.setInsutype(insuinfo.getInsutype());
                param.setInsuplcAdmdvs(insuinfo.getInsuplc_admdvs());
                param.setPsnType(insuinfo.getPsn_type());
                param.setPsnName(baseinfo.getPsn_name());
                param.setPsnNo(baseinfo.getPsn_no());
                if ("369900".equals(insuinfo.getInsuplc_admdvs())) {
                    param.setMdtrtareaAdmvs("369900");
                } else {
                    param.setMdtrtareaAdmvs("360100");
                }
            }
            OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)param.getOrderId()));
            MedicalPaymentRequest medicalPaymentRequest = new MedicalPaymentRequest();
            medicalPaymentRequest.setOrganCode(param.getOrganCode());
            medicalPaymentRequest.setInsuplc_admdvs(param.getInsuplcAdmdvs());
            medicalPaymentRequest.setMdtrtarea_admvs(param.getMdtrtareaAdmvs());
            medicalPaymentRequest.setUldLatlnt(param.getUldLatlnt());
            medicalPaymentRequest.setInsutype(param.getInsutype());
            HisDeptAndDocCodeVo hisDeptAndDocCode = this.internetHospitalDetailInfoService.getHisDeptAndDocCode(String.valueOf(orderEntity.getDeptId()), orderEntity.getDoctorId());
            medicalPaymentRequest.setDeptCode(hisDeptAndDocCode.getDeptCode());
            medicalPaymentRequest.setDeptName(hisDeptAndDocCode.getDeptName());
            medicalPaymentRequest.setDoctorCode(hisDeptAndDocCode.getDoctorCode());
            medicalPaymentRequest.setDoctorName(hisDeptAndDocCode.getDoctorName());
            PatientEntity patientEntity = this.patientMapper.selectById(orderEntity.getPatientId());
            medicalPaymentRequest.setMdtrt_cert_no(patientEntity.getIdcard());
            medicalPaymentRequest.setPsn_name(param.getPsnName());
            medicalPaymentRequest.setPsn_no(param.getPsnNo());
            medicalPaymentRequest.setOpenid(param.getOpenId());
            medicalPaymentRequest.setPay_auth_no(param.getPayAuthNo());
            medicalPaymentRequest.setPsnType(param.getPsnType());
            medicalPaymentRequest.setIpt_otp_no(orderEntity.getXId());
            medicalPaymentRequest.setChrgBchno(orderEntity.getXId());
            medicalPaymentRequest.setMedfeeSumamt(String.valueOf(orderEntity.getPayAmount()));
            medicalPaymentRequest.setBegntime(DateUtils.dateToFullString((Date)orderEntity.getXCreateTime()));
            ArrayList<String> diseinfoList = new ArrayList<String>();
            diseinfoList.add("1");
            medicalPaymentRequest.setDiseinfoList(diseinfoList);
            ArrayList<String> drugsList = new ArrayList<String>();
            drugsList.add("1");
            medicalPaymentRequest.setDrugsList(drugsList);
            ArrayList inspectList = new ArrayList();
            medicalPaymentRequest.setInspectList(inspectList);
            log.info("\u533b\u4fdd\u4e0b\u5355url\uff1a{}", (Object)(this.projProperties.getBaseAddress() + "/medicare/medicalPayment/nc/medicalInsurancePayment"));
            log.info("\u533b\u4fdd\u4e0b\u5355param\uff1a{}", (Object)JSON.toJSONString((Object)medicalPaymentRequest));
            String respStr = HttpUtil.post((String)(this.projProperties.getBaseAddress() + "/medicare/medicalPayment/nc/medicalInsurancePayment"), (String)JSON.toJSONString((Object)medicalPaymentRequest), (int)450000);
            log.info("\u533b\u4fdd\u4e0b\u5355\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)respStr));
            ResultResponse response = (ResultResponse)JSON.parseObject((String)respStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            YdCreadOrderResponse data = (YdCreadOrderResponse)((YdBaseResponse)response.getBody()).getData();
            orderEntity.setTotCost(data.getFeeSumamt());
            orderEntity.setPayCost(data.getPsnAcctPay());
            orderEntity.setPubCost(data.getFundPay());
            orderEntity.setOwnCost(data.getOwnPayAmt());
            this.orderMapper.updateById((Object)orderEntity);
            UndoOrderRequest undoOrderRequest = new UndoOrderRequest();
            undoOrderRequest.setIdNo(patientEntity.getIdcard());
            undoOrderRequest.setIdType("01");
            undoOrderRequest.setInsuplc_admdvs(param.getInsuplcAdmdvs());
            undoOrderRequest.setPayOrdId(data.getPayOrdId());
            undoOrderRequest.setPayToken(data.getPayToken());
            undoOrderRequest.setUserName(patientEntity.getPatientName());
            undoOrderRequest.setOrganCode(param.getOrganCode());
            undoOrderRequest.setExtData("");
            undoOrderRequest.setPayAuthNo(param.getPayAuthNo());
            this.redisUtil.set("yb_" + orderEntity.getXId(), JSONObject.toJSONString((Object)undoOrderRequest));
            return BaseResponse.success((Object)data);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u533b\u4fdd\u4e0b\u5355\u5931\u8d25" + e);
            throw new RuntimeException(e);
        }
    }

    private BaseResponse wechatPayMedicalGn(OrderEntity orderEntity, MedicalPaycallReqVo medicalPaycallReqVo) {
        String data = this.redisUtil.get("yb_" + orderEntity.getXId());
        orderEntity.setOrderSeq(UUIDUtil.generateViewId());
        this.orderMapper.updateById((Object)orderEntity);
        ResPatientInformationVo patientById = this.patientMapper.getPatientById(orderEntity.getPatientId());
        if (Objects.isNull(patientById)) {
            return BaseResponse.error((String)"\u60a3\u8005\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        UndoOrderRequest undoOrderRequest = (UndoOrderRequest)JSONObject.parseObject((String)data, UndoOrderRequest.class);
        TencentCreadOrderResponse response = new TencentCreadOrderResponse();
        try {
            TencentCreadOrderRequest tencentCreadOrderRequest = new TencentCreadOrderRequest();
            tencentCreadOrderRequest.setGmt_out_create(DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
            tencentCreadOrderRequest.setOrganCode(GN_ORGAN_CODE);
            tencentCreadOrderRequest.setOrder_type(TencentOrderTypeEnum.INTREG_PAY.getValue());
            tencentCreadOrderRequest.setBody(TencentOrderTypeEnum.INTREG_PAY.getDesc());
            tencentCreadOrderRequest.setOpenid(medicalPaycallReqVo.getOpenId());
            tencentCreadOrderRequest.setNonce_str(SignUtil.getNonceStr());
            tencentCreadOrderRequest.setConsume_type("0");
            tencentCreadOrderRequest.setHosp_out_trade_no(orderEntity.getXId());
            tencentCreadOrderRequest.setTotal_fee(String.valueOf(Double.valueOf(orderEntity.getTotCost()) * 100.0));
            String cash_fee = String.valueOf(Double.valueOf(orderEntity.getOwnCost()) * 100.0);
            tencentCreadOrderRequest.setCash_fee(cash_fee);
            if (new BigDecimal(cash_fee).equals(new BigDecimal("0.0"))) {
                tencentCreadOrderRequest.setPay_type(TencentPayTypeEnum.MEDICAL_INSURANCE.getValue());
            } else {
                tencentCreadOrderRequest.setPay_type(TencentPayTypeEnum.CASH_MEDICAL_INSURANCE.getValue());
            }
            tencentCreadOrderRequest.setAllow_fee_change("0");
            tencentCreadOrderRequest.setNotify_url("https://testapi.chinachdu.com/GNYFY/netinquiry/pay/tencentNotify");
            tencentCreadOrderRequest.setReturn_url(RETURN_URL);
            tencentCreadOrderRequest.setInsurance_fee(new BigDecimal(orderEntity.getPayCost()).add(new BigDecimal(orderEntity.getPubCost())).multiply(new BigDecimal(100)).toString());
            tencentCreadOrderRequest.setUser_card_type("1");
            tencentCreadOrderRequest.setUser_card_no(patientById.getIdcard());
            tencentCreadOrderRequest.setUser_name(undoOrderRequest.getUserName());
            tencentCreadOrderRequest.setIs_dept("4");
            tencentCreadOrderRequest.setCash_add_fee("0");
            tencentCreadOrderRequest.setSerial_no(orderEntity.getXId());
            RequestContent requestContent = new RequestContent();
            requestContent.setPayOrdId(undoOrderRequest.getPayOrdId());
            requestContent.setPayAuthNo(undoOrderRequest.getPayAuthNo());
            requestContent.setSetlLatlnt("0,0");
            tencentCreadOrderRequest.setRequest_content(requestContent);
            log.info("GN\u5fae\u4fe1\u533b\u4fdd\u7edf\u4e00\u4e0b\u5355\u8bf7\u6c42url\u662f:{}=========\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)(MEDICAL_URL + UrlConstants.YB_TENCENT_CREADORDER_URL), (Object)JSON.toJSONString((Object)tencentCreadOrderRequest));
            String respStr = HttpKit.jsonPost((String)(MEDICAL_URL + UrlConstants.YB_TENCENT_CREADORDER_URL), (String)JSON.toJSONString((Object)tencentCreadOrderRequest));
            log.info("GN\u5fae\u4fe1\u533b\u4fdd\u7edf\u4e00\u4e0b\u5355\u7684\u54cd\u5e94\u7ed3\u679c\u662f:{}", (Object)respStr);
            ResultResponse tencentCreadOrderResponse = (ResultResponse)JSON.parseObject((String)respStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            String code = tencentCreadOrderResponse.getCode();
            if ("1".equals(code) && !Objects.isNull(tencentCreadOrderResponse.getBody())) {
                response = (TencentCreadOrderResponse)tencentCreadOrderResponse.getBody();
                response.setOrderId(orderEntity.getOrderSeq());
                return BaseResponse.success((Object)response);
            }
            return BaseResponse.error((String)JSON.parseObject((String)respStr).get((Object)"msg").toString());
        }
        catch (Exception e) {
            log.error("GN\u8c03\u7528\u533b\u4fdd\u7edf\u4e00\u652f\u4ed8\u670d\u52a1\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private BaseResponse wechatPayMedical(OrderEntity orderEntity, MedicalPaycallReqVo medicalPaycallReqVo) {
        String data = this.redisUtil.get("yb_" + orderEntity.getXId());
        orderEntity.setOrderSeq(UUIDUtil.generateViewId());
        this.orderMapper.updateById((Object)orderEntity);
        UndoOrderRequest undoOrderRequest = (UndoOrderRequest)JSONObject.parseObject((String)data, UndoOrderRequest.class);
        TencentCreadOrderResponse response = new TencentCreadOrderResponse();
        try {
            TencentCreadOrderRequest tencentCreadOrderRequest = new TencentCreadOrderRequest();
            tencentCreadOrderRequest.setGmt_out_create(DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
            tencentCreadOrderRequest.setOrganCode(ORGAN_CODE);
            tencentCreadOrderRequest.setOrder_type(TencentOrderTypeEnum.INTREG_PAY.getValue());
            tencentCreadOrderRequest.setBody(TencentOrderTypeEnum.INTREG_PAY.getDesc());
            tencentCreadOrderRequest.setOpenid(medicalPaycallReqVo.getOpenId());
            tencentCreadOrderRequest.setNonce_str(SignUtil.getNonceStr());
            tencentCreadOrderRequest.setConsume_type("0");
            tencentCreadOrderRequest.setHosp_out_trade_no(orderEntity.getOrderSeq());
            tencentCreadOrderRequest.setTotal_fee(String.valueOf(Double.valueOf(orderEntity.getTotCost()) * 100.0));
            String cash_fee = String.valueOf(Double.valueOf(orderEntity.getOwnCost()) * 100.0);
            tencentCreadOrderRequest.setCash_fee(cash_fee);
            if (new BigDecimal(cash_fee).equals(new BigDecimal("0.0"))) {
                tencentCreadOrderRequest.setPay_type(TencentPayTypeEnum.MEDICAL_INSURANCE.getValue());
            } else {
                tencentCreadOrderRequest.setPay_type(TencentPayTypeEnum.CASH_MEDICAL_INSURANCE.getValue());
            }
            tencentCreadOrderRequest.setAllow_fee_change("0");
            tencentCreadOrderRequest.setNotify_url("https://testapi.chinachdu.com/NCZK/netinquiry/pay/tencentNotify");
            tencentCreadOrderRequest.setReturn_url(RETURN_URL);
            tencentCreadOrderRequest.setInsurance_fee(new BigDecimal(orderEntity.getPayCost()).add(new BigDecimal(orderEntity.getPubCost())).multiply(new BigDecimal(100)).toString());
            tencentCreadOrderRequest.setUser_card_type("1");
            tencentCreadOrderRequest.setUser_card_no(orderEntity.getIdCard());
            tencentCreadOrderRequest.setUser_name(undoOrderRequest.getUserName());
            tencentCreadOrderRequest.setIs_dept("4");
            tencentCreadOrderRequest.setCash_add_fee("0");
            tencentCreadOrderRequest.setSerial_no(orderEntity.getOrderSeq());
            RequestContent requestContent = new RequestContent();
            requestContent.setPayOrdId(undoOrderRequest.getPayOrdId());
            requestContent.setPayAuthNo(undoOrderRequest.getPayAuthNo());
            requestContent.setSetlLatlnt("0,0");
            tencentCreadOrderRequest.setRequest_content(requestContent);
            log.info("\u5fae\u4fe1\u533b\u4fdd\u7edf\u4e00\u4e0b\u5355\u8bf7\u6c42url\u662f:{}=========\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)(MEDICAL_URL + UrlConstants.YB_TENCENT_CREADORDER_URL), (Object)JSON.toJSONString((Object)tencentCreadOrderRequest));
            String respStr = HttpKit.jsonPost((String)(MEDICAL_URL + UrlConstants.YB_TENCENT_CREADORDER_URL), (String)JSON.toJSONString((Object)tencentCreadOrderRequest));
            log.info("\u5fae\u4fe1\u533b\u4fdd\u7edf\u4e00\u4e0b\u5355\u7684\u54cd\u5e94\u7ed3\u679c\u662f:{}", (Object)respStr);
            3 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            ResultResponse tencentCreadOrderResponse = (ResultResponse)JSON.parseObject((String)respStr, (Type)typeReference.getType(), (Feature[])new Feature[0]);
            String code = tencentCreadOrderResponse.getCode();
            if ("1".equals(code) && !Objects.isNull(tencentCreadOrderResponse.getBody())) {
                response = (TencentCreadOrderResponse)tencentCreadOrderResponse.getBody();
                response.setOrderId(orderEntity.getOrderSeq());
                return BaseResponse.success((Object)response);
            }
            return BaseResponse.error((String)JSON.parseObject((String)respStr).get((Object)"msg").toString());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u533b\u4fdd\u7edf\u4e00\u652f\u4ed8\u670d\u52a1\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private BaseResponse aliPayMedical(OrderEntity orderEntity, MedicalPaycallReqVo medicalPaycallReqVo) {
        String orderSeq = UUIDUtil.generateViewId();
        AliPayCreateOrderRequest aliPayCreateOrderRequest = new AliPayCreateOrderRequest();
        BeanUtils.copyProperties((Object)medicalPaycallReqVo, (Object)aliPayCreateOrderRequest);
        AliPayExtendParamsEntrty aliPayExtendParamsEntrty = new AliPayExtendParamsEntrty();
        aliPayExtendParamsEntrty.setSys_service_provider_id("");
        aliPayExtendParamsEntrty.setIsInsurancePay("T");
        aliPayExtendParamsEntrty.setMedical_card_inst_id(medicalPaycallReqVo.getMedical_card_inst_id());
        aliPayExtendParamsEntrty.setMedical_card_id(medicalPaycallReqVo.getMedical_card_id());
        JSONObject medicalRequesCotennt = new JSONObject();
        aliPayExtendParamsEntrty.setMedical_request_content(medicalRequesCotennt);
        AliPayMedicalRequesExtEntrty aliPayMedicalRequesExtEntrty = new AliPayMedicalRequesExtEntrty();
        aliPayMedicalRequesExtEntrty.setBill_no(medicalPaycallReqVo.getPayOrdId());
        aliPayMedicalRequesExtEntrty.setSerial_no(medicalPaycallReqVo.getPayOrdId());
        aliPayMedicalRequesExtEntrty.setOut_trade_no(orderSeq);
        aliPayMedicalRequesExtEntrty.setGmt_out_create(DateUtils.dateToFullString((Date)new Date()));
        aliPayMedicalRequesExtEntrty.setPay_auth_no(medicalPaycallReqVo.getPay_auth_no());
        aliPayMedicalRequesExtEntrty.setChinfo("gjydzf");
        aliPayMedicalRequesExtEntrty.setIndustry("HOSPITAL");
        aliPayMedicalRequesExtEntrty.setScene("TREATMENT");
        aliPayMedicalRequesExtEntrty.setInsurance_pay_scene("APPOINTMENT");
        aliPayExtendParamsEntrty.setMedical_request_ext(aliPayMedicalRequesExtEntrty);
        aliPayCreateOrderRequest.setExtend_params(aliPayExtendParamsEntrty);
        aliPayCreateOrderRequest.setOut_trade_no(orderSeq);
        aliPayCreateOrderRequest.setTotal_amount(orderEntity.getPayAmount());
        aliPayCreateOrderRequest.setSubject(this.projProperties.getProductInfo());
        aliPayCreateOrderRequest.setProduct_code("QUICK_MSECURITY_PAY");
        aliPayCreateOrderRequest.setOrganCode("360ZFB");
        aliPayCreateOrderRequest.setTime_expire(DateUtils.dateToFullString((Date)DateUtils.dateAddMinutes((Date)new Date(), (int)30)));
        aliPayCreateOrderRequest.setNotifyUrl(MessageFormat.format(this.projProperties.getPayNotifyUrl(), orderEntity.getAppCode()));
        orderEntity.setOrderSeq(orderSeq);
        this.orderMapper.updateById((Object)orderEntity);
        String url = this.projProperties.getBaseAddress() + "/medicare/ali/alipayTradeAppPay";
        try {
            String result = com.ebaiyihui.onlineoutpatient.core.utils.HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)aliPayCreateOrderRequest));
            ResultResponse response = (ResultResponse)JSON.parseObject((String)result, ResultResponse.class);
            return BaseResponse.success((Object)response.getBody());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u652f\u4ed8\u5b9d\u652f\u4ed8\u5931\u8d25" + e.getMessage());
            throw new BusinessException("\u8bf7\u6c42\u652f\u4ed8\u5b9d\u652f\u4ed8\u5931\u8d25");
        }
    }

    public String medicalCallbackWhilePaySuccessAsync(HttpServletRequest request) {
        Map params = this.convertRequestParamsToMap(request);
        String paramsJson = JSON.toJSONString((Object)params);
        log.info("\u652f\u4ed8\u5b9d\u56de\u8c03\uff0c{}", (Object)paramsJson);
        String json = JSON.toJSONString((Object)params);
        AlipayNotifyParam alipayNotifyParam = (AlipayNotifyParam)JSON.parseObject((String)json, AlipayNotifyParam.class);
        String tradeStatus = alipayNotifyParam.getTradeStatus();
        if (tradeStatus.equals("TRADE_SUCCESS")) {
            log.info("\u652f\u4ed8\u6210\u529f");
        } else {
            log.info("\u652f\u4ed8\u5931\u8d25");
        }
        return "success";
    }

    public BaseResponse medicalCallbackWhilePaySuccess(MedicalNotifyReqVo param) {
        OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)param.getOrderId()));
        if (Objects.isNull(orderEntity)) {
            return BaseResponse.error((String)"\u672a\u67e5\u5230\u76f8\u5173\u8ba2\u5355\u4fe1\u606f");
        }
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(orderEntity.getPatientId());
        String url = this.projProperties.getBaseAddress() + "/medicare/medicalPayment/ybByAliPayOrderQuery";
        QueryMedicalSettlementOrderRequest request = new QueryMedicalSettlementOrderRequest();
        request.setPayToken(param.getPayToken());
        request.setPayOrdId(param.getPayOrdId());
        request.setOutTradeNo(orderEntity.getOrderSeq());
        request.setUserName(patientEntity.getPatientName());
        request.setIdNo(patientEntity.getIdcard());
        request.setIdType("01");
        request.setOrganCode("360ZFB");
        request.setExpContent("");
        request.setOrgCodg("");
        int i = 1;
        int time = 100;
        while (time <= 6000) {
            try {
                Thread.sleep(time);
                String result = com.ebaiyihui.onlineoutpatient.core.utils.HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)request));
                JSONObject jsonResponse = JSON.parseObject((String)result);
                JSONObject jsonbody = jsonResponse.getJSONObject("body");
                JSONObject jsonMedical = jsonbody.getJSONObject("queryMedicalSettlementOrderResponse");
                JSONObject jsonAlipay = jsonbody.getJSONObject("alipayTradeQueryResponse");
                JSONObject body1 = jsonMedical.getJSONObject("body");
                JSONObject body2 = jsonAlipay.getJSONObject("body");
                String payOrdId = body1.get((Object)"payOrdId").toString();
                String traceTime = body1.get((Object)"traceTime").toString();
                String tradeNo = body2.get((Object)"tradeNo").toString();
                String ordStas = body1.get((Object)"ordStas").toString();
                String tradeStatus = body2.get((Object)"tradeStatus").toString();
                if (Objects.equals(tradeStatus, "TRADE_SUCCESS") && Objects.equals(ordStas, "6")) {
                    ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
                    responseNotifyRestVo.setTradeNo(tradeNo);
                    responseNotifyRestVo.setPayTime(DateUtils.parseDate((String)traceTime, (String)"yyyyMMddHHmmss"));
                    responseNotifyRestVo.setDealTradeNo(orderEntity.getOrderSeq());
                    this.updateOrderRecordService.updateOrderRecord(responseNotifyRestVo, orderEntity);
                    return BaseResponse.success((Object)"\u652f\u4ed8\u6210\u529f");
                }
                time += ++i * 2 * 100;
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u652f\u4ed8\u7ed3\u679c\u5931\u8d25" + e.getMessage());
                time += ++i * 2 * 100;
            }
        }
        return BaseResponse.error((String)"\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c\u5931\u8d25");
    }

    public BaseResponse adminRefund(RequestRefundVo requestRefundVo) {
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        OrderEntity orderEntity1 = new OrderEntity();
        orderEntity1.setXId(requestRefundVo.getOrderId());
        objectQueryWrapper.setEntity((Object)orderEntity1);
        OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectOne((Wrapper)objectQueryWrapper);
        RequestRefundOrderVo requestCreateOrderVo = new RequestRefundOrderVo();
        requestCreateOrderVo.setPayChannel(orderEntity.getPayMethod());
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
        inquiryMchCodeEntity.setAppCode(orderEntity.getAppCode());
        inquiryMchCodeEntity.setHospitalId(orderEntity.getHospitalId());
        log.info("inquiryMchCodeEntity:{}" + inquiryMchCodeEntity.toString());
        queryWrapper.setEntity((Object)inquiryMchCodeEntity);
        InquiryMchCodeEntity entity = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)queryWrapper);
        if (null == entity) {
            return BaseResponse.error((String)"\u8be5\u533b\u9662\u7684\u5546\u6237\u53f7\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u5546\u6237\u53f7");
        }
        log.info("entity:{}" + entity.toString());
        requestCreateOrderVo.setOutTradeNo(orderEntity.getOrderSeq());
        requestCreateOrderVo.setDealTradeNo(orderEntity.getDealSeq());
        requestCreateOrderVo.setRefundAmount(orderEntity.getPayAmount());
        requestCreateOrderVo.setTotalAmount(orderEntity.getPayAmount());
        requestCreateOrderVo.setNonceStr(SignUtil.getNonceStr());
        requestCreateOrderVo.setRefundNotifyUrl(MessageFormat.format(this.projProperties.getRefundNotifyUrl(), entity.getAppCode()));
        QueryWrapper wrapper = new QueryWrapper();
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = new ServiceMerchantConfigEntity();
        serviceMerchantConfigEntity.setAppCode(orderEntity.getAppCode());
        serviceMerchantConfigEntity.setHospitalId(orderEntity.getHospitalId());
        if ("ZHJYJF".equals(orderEntity.getFundType())) {
            serviceMerchantConfigEntity.setBizSysSeq("ZHJYJF");
        } else {
            serviceMerchantConfigEntity.setBizSysSeq(ServiceTypeEnum.getCode((Integer)orderEntity.getServType()));
        }
        serviceMerchantConfigEntity.setApplyName(orderEntity.getPayMethod());
        wrapper.setEntity((Object)serviceMerchantConfigEntity);
        log.info("\u9000\u6b3e\u4e2d\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u8868\u5165\u53c2:{}" + serviceMerchantConfigEntity.toString());
        ServiceMerchantConfigEntity serviceMerchantConfig = (ServiceMerchantConfigEntity)this.serviceMerchantConfigMapper.selectOne((Wrapper)wrapper);
        if (serviceMerchantConfig == null) {
            log.info("\u672a\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u652f\u4ed8\u5e94\u7528code");
            return null;
        }
        log.info("\u9000\u6b3e\u4e2d\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u8868\u51fa\u53c2serviceMerchantConfigEntity:{}" + serviceMerchantConfigEntity.toString());
        requestCreateOrderVo.setApplyCode(serviceMerchantConfig.getMerchantSeq());
        requestCreateOrderVo.setMchCode(serviceMerchantConfig.getMerchantSeq());
        Map map = SignUtil.getKeyAndValue((Object)requestCreateOrderVo);
        log.info("\u83b7\u53d6\u7684map\u4e3a\uff1a{}" + JSON.toJSONString((Object)map));
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfig.getApplyKey(), (String[])new String[0]);
        requestCreateOrderVo.setSign(sign);
        String url = this.projProperties.getRefundCallsNew();
        try {
            String result = com.ebaiyihui.onlineoutpatient.core.utils.HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)requestCreateOrderVo));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), BaseResponse.class);
            log.info("baseResponse:{}" + JSON.toJSONString((Object)baseResponse));
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u9000\u6b3e\u63a5\u53e3\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    private UserQueryResponse getNoSecretUserInfo(MedicalPayDto vo) throws Exception {
        UserQueryResponse response = new UserQueryResponse();
        UserQueryRequest userQueryRequest = new UserQueryRequest();
        userQueryRequest.setQrcode(vo.getQrcode());
        userQueryRequest.setOpenid(vo.getOpenId());
        userQueryRequest.setOrganCode(vo.getOrganCode());
        log.info("\u83b7\u53d6\u7528\u6237\u514d\u5bc6\u6388\u6743\u4fe1\u606f\u8bf7\u6c42url\u662f:{}=========\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)(MEDICAL_URL + UrlConstants.YB_USERQUERY_URL), (Object)JSON.toJSONString((Object)userQueryRequest));
        String respStr = HttpKit.jsonPost((String)(MEDICAL_URL + UrlConstants.YB_USERQUERY_URL), (String)JSON.toJSONString((Object)userQueryRequest));
        log.info("\u83b7\u53d6\u7528\u6237\u514d\u5bc6\u6388\u6743\u4fe1\u606f\u7684\u54cd\u5e94\u7ed3\u679c\u662f:{}", (Object)respStr);
        JSONObject result = (JSONObject)JSON.parseObject((String)respStr, JSONObject.class);
        String code = result.get((Object)"code").toString();
        if (!"1".equals(code)) {
            throw new BusinessException("\u83b7\u53d6\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff0c" + result.get((Object)"message").toString().replaceAll("[^\\u4E00-\\u9FA5]", ""));
        }
        response = (UserQueryResponse)JSONObject.parseObject((String)result.get((Object)"body").toString(), UserQueryResponse.class);
        return response;
    }

    private YbPatientInfoResponse getPatientInfo(MedicalPayDto vo) throws Exception {
        YbPatientInfoResponse response = new YbPatientInfoResponse();
        PatientInfoRequest patientInfoRequest = new PatientInfoRequest();
        patientInfoRequest.setMdtrt_cert_type("02");
        patientInfoRequest.setMdtrt_cert_no(vo.getIdNo());
        patientInfoRequest.setOrganCode(vo.getOrganCode());
        patientInfoRequest.setPsn_name(vo.getPsnName());
        log.info("\u83b7\u53d6\u4eba\u5458\u57fa\u672c\u4fe1\u606f\u8bf7\u6c42url\u662f:{}=========\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)(MEDICAL_URL + UrlConstants.YB_PATIENTINFO_URL), (Object)JSONObject.toJSONString((Object)patientInfoRequest));
        String respStr = HttpKit.jsonPost((String)(MEDICAL_URL + UrlConstants.YB_PATIENTINFO_URL), (String)JSONObject.toJSONString((Object)patientInfoRequest));
        log.info("\u83b7\u53d6\u4eba\u5458\u57fa\u672c\u4fe1\u606f\u7684\u54cd\u5e94\u7ed3\u679c\u662f:{}", (Object)respStr);
        JSONObject result = (JSONObject)JSON.parseObject((String)respStr, JSONObject.class);
        String code = result.get((Object)"code").toString();
        if (!"1".equals(code) || Objects.isNull(result.get((Object)"body"))) {
            throw new BusinessException("\u83b7\u53d6\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff0c" + result.get((Object)"message").toString().replaceAll("[^\\u4E00-\\u9FA5]", ""));
        }
        4 typeReference = new /* Unavailable Anonymous Inner Class!! */;
        YbBaseResponse ybBaseResponseResultResponse = (YbBaseResponse)JSONObject.parseObject((String)result.get((Object)"body").toString(), (Type)typeReference.getType(), (Feature[])new Feature[0]);
        response = (YbPatientInfoResponse)ybBaseResponseResultResponse.getOutput();
        return response;
    }

    private Map<String, String> convertRequestParamsToMap(HttpServletRequest request) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            retMap.put(name, valueStr);
        }
        return retMap;
    }

    private void aliRefundMedical(OrderEntity orderEntity, String payAuthNo) {
        RefundOrderRequest refundOrderRequest = new RefundOrderRequest();
        AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(orderEntity.getXId());
        String data = this.redisUtil.get("yb_" + orderEntity.getXId());
        UndoOrderRequest undoOrderRequest = (UndoOrderRequest)JSONObject.parseObject((String)data, UndoOrderRequest.class);
        PatientEntity patientEntity = this.patientMapper.selectById(orderEntity.getPatientId());
        refundOrderRequest.setAppRefdSn(orderEntity.getDealSeq());
        refundOrderRequest.setAppRefdTime(DateUtils.dateToString((Date)new Date(), (String)"yyyyMMddHHmmss"));
        refundOrderRequest.setCashRefdAmt(orderEntity.getOwnCost());
        refundOrderRequest.setFundRefdAmt(orderEntity.getPubCost());
        refundOrderRequest.setPsnAcctRefdAmt(orderEntity.getPayCost());
        refundOrderRequest.setTotlRefdAmt(orderEntity.getTotCost());
        refundOrderRequest.setEcToken("");
        refundOrderRequest.setExpContent("");
        refundOrderRequest.setIdNo(patientEntity.getIdcard());
        refundOrderRequest.setOrganCode("360ZFB");
        refundOrderRequest.setPayAuthNo(payAuthNo);
        refundOrderRequest.setPayOrdId(undoOrderRequest.getPayOrdId());
        refundOrderRequest.setRefdType("ALL");
        refundOrderRequest.setUserName(patientEntity.getPatientName());
        String url = this.projProperties.getBaseAddress() + "/medicare//medicalPayment/ybAliReturnOrderAndRevoke";
        try {
            String result = com.ebaiyihui.onlineoutpatient.core.utils.HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)refundOrderRequest));
            log.info("\u533b\u4fdd\u8ba2\u5355\u9000\u8d39\u7ed3\u679c:{}", (Object)result);
            ResultResponse response = (ResultResponse)JSON.parseObject((String)result, ResultResponse.class);
            if (!response.isSuccess()) {
                throw new BusinessException(response.getMessage());
            }
            orderEntity.setStatus(OrderStatusEnum.REFUNDED.getValue());
            orderEntity.setRefundTime(new Date());
            this.orderMapper.updateOrderEntity(orderEntity);
            this.admissionMapper.updateStatusByAdmId(admissionEntity.getXId(), AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u652f\u4ed8\u5b9d\u652f\u4ed8\u5931\u8d25" + e.getMessage());
            throw new BusinessException("\u9000\u6b3e\u5931\u8d25");
        }
    }

    private Boolean tencentRefundMedical(OrderEntity orderEntity, RequestRefundVo requestRefundVo, String organCode) {
        try {
            MedicalPayDto medicalPayDto = new MedicalPayDto();
            medicalPayDto.setOpenId(requestRefundVo.getOpenId());
            medicalPayDto.setQrcode(requestRefundVo.getQrCode());
            medicalPayDto.setOrganCode(organCode);
            AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(orderEntity.getXId());
            RefundOrderRequest refundOrderRequest = new RefundOrderRequest();
            String data = this.redisUtil.get("yb_" + orderEntity.getXId());
            UndoOrderRequest undoOrderRequest = (UndoOrderRequest)JSONObject.parseObject((String)data, UndoOrderRequest.class);
            refundOrderRequest.setAppRefdSn(orderEntity.getDealSeq());
            refundOrderRequest.setAppRefdTime(DateUtils.dateToString((Date)new Date(), (String)"yyyyMMddHHmmss"));
            refundOrderRequest.setCashRefdAmt(orderEntity.getOwnCost());
            refundOrderRequest.setFundRefdAmt(orderEntity.getPubCost());
            refundOrderRequest.setPsnAcctRefdAmt(orderEntity.getPayCost());
            refundOrderRequest.setTotlRefdAmt(orderEntity.getTotCost());
            refundOrderRequest.setEcToken("");
            refundOrderRequest.setExpContent("");
            refundOrderRequest.setIdNo(orderEntity.getIdCard());
            refundOrderRequest.setOrganCode(organCode);
            refundOrderRequest.setPayAuthNo(requestRefundVo.getPayAuthNo());
            refundOrderRequest.setPayOrdId(undoOrderRequest.getPayOrdId());
            refundOrderRequest.setUserName(undoOrderRequest.getUserName());
            refundOrderRequest.setRefdType("ALL");
            TencentRefundRequest tencentRefundRequest = new TencentRefundRequest();
            tencentRefundRequest.setOrganCode(organCode);
            tencentRefundRequest.setMed_trans_id(orderEntity.getDealSeq());
            tencentRefundRequest.setCancel_bill_no(orderEntity.getXId());
            tencentRefundRequest.setCancel_serial_no(orderEntity.getXId());
            tencentRefundRequest.setHosp_out_refund_no(orderEntity.getOrderSeq());
            tencentRefundRequest.setNonce_str(UUID.randomUUID().toString().replace("-", ""));
            RefundRequestContent refundRequestContent = new RefundRequestContent();
            refundRequestContent.setPayOrdId(undoOrderRequest.getPayOrdId());
            refundRequestContent.setRef_reason("\u60a3\u8005\u9000\u8d39");
            tencentRefundRequest.setRequest_content(refundRequestContent);
            refundOrderRequest.setTencentRefundRequest(tencentRefundRequest);
            String url = "https://testapi.chinachdu.com/medicare/medicalPayment/ybWechatReturnOrderAndRevoke";
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)refundOrderRequest));
            log.info("\u533b\u4fdd\u8ba2\u5355\u9000\u8d39\u7ed3\u679c:{}", (Object)result);
            ResultResponse response = (ResultResponse)JSON.parseObject((String)result, ResultResponse.class);
            if (!response.isSuccess()) {
                throw new BusinessException(response.getMessage());
            }
            orderEntity.setStatus(OrderStatusEnum.REFUNDED.getValue());
            orderEntity.setRefundTime(new Date());
            this.orderMapper.updateOrderEntity(orderEntity);
            this.admissionMapper.updateStatusByAdmId(admissionEntity.getXId(), AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue());
            if (Objects.equals(orderEntity.getAppCode(), "GNYFY") && Objects.equals(orderEntity.getServType(), 3)) {
                BaseResponse gnCancelOrder = this.gnHisManagerService.gnCancelOrder(orderEntity);
                log.info("gnCancelOrder:{}", (Object)JSON.toJSONString((Object)gnCancelOrder));
            }
            return true;
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u5fae\u4fe1\u9000\u6b3e\u5931\u8d25" + e);
            throw new BusinessException("\u9000\u6b3e\u5931\u8d25");
        }
    }
}

