/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.nczk.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ZkDocPreOrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ZkPatPreOrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ICDMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.MedicalAdmissionRefMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMedicalRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.MedicalAdmissionRefEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientMedicalRecordEntity;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.SmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.nczk.ZkFastDoctorService;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.IDCardUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.PageUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.FbImInfoDetailDocReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.FbImInfoDetailDocResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.PatientInfoVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.ZkDoctorRefundReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.ZkFbImInfoListDocReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.ZkFbImInfoListResVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZkFastDoctorServiceImpl
implements ZkFastDoctorService {
    @Autowired
    private MedicalAdmissionRefMapper medicalAdmissionRefMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private PatientMedicalRecordMapper patientMedicalRecordMapper;
    @Autowired
    private SmallProgramPushService smallProgramPushService;
    @Autowired
    private IMInformService imInformService;
    @Autowired
    private DoctorInfofeignClient doctorCilent;
    @Autowired
    private ICDMapper icdMapper;
    @Autowired
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;

    public BaseResponse<PageUtil<ZkFbImInfoListResVo>> queryImInfoList(ZkFbImInfoListDocReqVo param) {
        IPage pages = this.medicalAdmissionRefMapper.queryImInfoList(new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue()), param);
        List records = pages.getRecords();
        Map<String, List<ZkFbImInfoListResVo>> collect = records.stream().collect(Collectors.groupingBy(ZkFbImInfoListResVo::getPatientId));
        List<Object> resVo = new ArrayList();
        for (String key : collect.keySet()) {
            List<ZkFbImInfoListResVo> zkFbImInfoListResVos = collect.get(key);
            ZkFbImInfoListResVo record = zkFbImInfoListResVos.get(0);
            Integer age = IDCardUtil.getAge((String)record.getIdCard());
            Integer gender = IDCardUtil.getGenderForInteger((String)record.getIdCard());
            record.setAge(age);
            record.setGender(gender);
            String statusDesc = ZkDocPreOrderStatusEnum.getDescByValue((Integer)record.getStatus());
            record.setStatusDesc(statusDesc);
            record.setStatus(ZkDocPreOrderStatusEnum.getDocByValue((Integer)record.getStatus()));
            resVo.add(record);
        }
        resVo = resVo.stream().sorted(Comparator.comparing(ZkFbImInfoListResVo::getCreateTime).reversed()).collect(Collectors.toList());
        PageUtil pageUtil = new PageUtil();
        pageUtil.setList(resVo);
        pageUtil.setTotal(pages.getTotal());
        return BaseResponse.success((Object)pageUtil);
    }

    public BaseResponse doctorRefund(ZkDoctorRefundReqVo param) {
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectById((Serializable)((Object)param.getAdmId()));
        if (Objects.isNull(admissionEntity)) {
            return BaseResponse.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        admissionEntity.setStatus(AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue());
        admissionEntity.setXRemark(param.getRefundReason());
        MedicalAdmissionRefEntity medicalAdmissionRefEntity = (MedicalAdmissionRefEntity)this.medicalAdmissionRefMapper.selectOne((Wrapper)new QueryWrapper().lambda().eq(MedicalAdmissionRefEntity::getAdmissionId, (Object)param.getAdmId()));
        OrderEntity orderEntity = this.orderMapper.findByAdmId(param.getAdmId());
        if (Objects.equals(orderEntity.getKeepOrder(), 2) || Objects.equals(orderEntity.getKeepOrder(), 3)) {
            admissionEntity.setXRemark("\u6781\u901f\u8d2d\u836f\u8ba2\u5355\u533b\u751f\u62d2\u7edd\u5f00\u65b9");
            this.admissionMapper.update(admissionEntity);
            medicalAdmissionRefEntity.setPreStatus(ZkPatPreOrderStatusEnum.REFUND_PRE.getValue());
            medicalAdmissionRefEntity.setRemark(param.getRefundReason());
            this.smallProgramPushService.zkDoctorRefund(param.getAdmId());
            this.imInformService.zkFastPreFailDoc(param.getAdmId(), param.getRefundReason());
            this.medicalAdmissionRefMapper.updateById((Object)medicalAdmissionRefEntity);
        }
        this.admissionMapper.update(admissionEntity);
        return BaseResponse.success((Object)true);
    }

    public BaseResponse<FbImInfoDetailDocResVo> queryImInfoDetail(FbImInfoDetailDocReqVo param) {
        FbImInfoDetailDocResVo resVo = new FbImInfoDetailDocResVo();
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectById((Serializable)((Object)param.getAdmissionId()));
        OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)admissionEntity.getOrderId()));
        if (Objects.isNull(admissionEntity) || Objects.isNull(orderEntity)) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
        }
        resVo.setDoctorId(orderEntity.getDoctorId());
        resVo.setOrderId(orderEntity.getXId());
        resVo.setAdmId(admissionEntity.getXId());
        resVo.setServType(orderEntity.getServType());
        resVo.setKeepOrder(orderEntity.getKeepOrder());
        resVo.setStatus(admissionEntity.getStatus());
        resVo.setDeptId(orderEntity.getDeptId().toString());
        resVo.setDeptName(orderEntity.getDeptName());
        resVo.setAdmTime(DateUtils.dateToString((Date)admissionEntity.getXCreateTime(), (String)"yyyy-MM-dd"));
        MedicalAdmissionRefEntity medicalAdmissionRefEntity = (MedicalAdmissionRefEntity)this.medicalAdmissionRefMapper.selectOne((Wrapper)new QueryWrapper().lambda().eq(MedicalAdmissionRefEntity::getAdmissionId, (Object)param.getAdmissionId()));
        resVo.setPreStatus(ZkDocPreOrderStatusEnum.getDocByValue((Integer)Integer.parseInt(medicalAdmissionRefEntity.getPreStatus())));
        PatientEntity patientEntity = this.patientMapper.selectById(orderEntity.getPatientId());
        PatientInfoVo patientInfoVo = new PatientInfoVo();
        patientInfoVo.setPatientName(patientEntity.getPatientName());
        patientInfoVo.setPatientId(patientEntity.getXId());
        patientInfoVo.setGender(IDCardUtil.getGenderForInteger((String)patientEntity.getIdcard()));
        patientInfoVo.setAge(IDCardUtil.getAge((String)patientEntity.getIdcard()));
        patientInfoVo.setIdcard(patientEntity.getIdcard());
        patientInfoVo.setPatientUserId(orderEntity.getPatientUserId());
        patientInfoVo.setCardNo(orderEntity.getIdCard());
        patientInfoVo.setPortrait("");
        resVo.setPatientInfo(patientInfoVo);
        PatientMedicalRecordEntity patientMedicalRecordEntity = this.patientMedicalRecordMapper.findById(orderEntity.getMedicalRecordId());
        resVo.setBgDiagnose(patientMedicalRecordEntity.getTags());
        List medicalRecords = this.admissionMapper.queryMedicalRecordByAdmId(param.getAdmissionId());
        resVo.setMedicalRecord(medicalRecords);
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(orderEntity.getDoctorId());
        BaseResponse res = this.doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
        if (null != res && res.isSuccess()) {
            resVo.setDoctorName(((PersonnelInfo)res.getData()).getDoctorName());
            resVo.setDoctorPortrait(((PersonnelInfo)res.getData()).getPortrait());
        }
        resVo.setPatientImageUrl("");
        PatientDynamicMedicalEntityVo entityVo = this.internetHospitalDetailInfoService.getMedicalInfoByAdmId(param.getAdmissionId());
        if (Objects.nonNull(entityVo)) {
            resVo.setIcdName(entityVo.getPrimaryDiagno());
            String[] names = entityVo.getPrimaryDiagno().split(";");
            List<String> namesList = Arrays.asList(names);
            List codeList = this.icdMapper.selctCodeByName(namesList);
            String code = StringUtils.join((Collection)codeList, (String)";");
            resVo.setIcdCode(code);
        }
        return BaseResponse.success((Object)resVo);
    }
}

