/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.xgReport.impl;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.onlineoutpatient.common.dto.GetReportListsData;
import com.ebaiyihui.onlineoutpatient.common.vo.CheckReportDetailsReq;
import com.ebaiyihui.onlineoutpatient.common.vo.CheckReportDetailsRes;
import com.ebaiyihui.onlineoutpatient.common.vo.GetReportListsReq;
import com.ebaiyihui.onlineoutpatient.common.vo.GetReportListsRes;
import com.ebaiyihui.onlineoutpatient.common.vo.LisReportListReq;
import com.ebaiyihui.onlineoutpatient.common.vo.LisReportListRes;
import com.ebaiyihui.onlineoutpatient.common.vo.LisReportListResData;
import com.ebaiyihui.onlineoutpatient.common.vo.LisReportListResMicData;
import com.ebaiyihui.onlineoutpatient.common.vo.ListReportHosReq;
import com.ebaiyihui.onlineoutpatient.common.vo.ListReportHosRes;
import com.ebaiyihui.onlineoutpatient.common.vo.NetReportBaseRequest;
import com.ebaiyihui.onlineoutpatient.common.vo.PacsReportListReq;
import com.ebaiyihui.onlineoutpatient.common.vo.PacsReportListRes;
import com.ebaiyihui.onlineoutpatient.common.vo.ReportDetailData;
import com.ebaiyihui.onlineoutpatient.common.vo.ReportDetailMicData;
import com.ebaiyihui.onlineoutpatient.common.vo.ReportDetailReq;
import com.ebaiyihui.onlineoutpatient.common.vo.ReportDetailRes;
import com.ebaiyihui.onlineoutpatient.common.vo.ReportInfo;
import com.ebaiyihui.onlineoutpatient.core.service.xgReport.NetReportService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.SnowflakeIdWorker;
import com.ebaiyihui.onlineoutpatient.core.utils.gateway.GateWayCommonUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.gateway.RouteEnum;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class NetReportServiceImpl
implements NetReportService {
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public BaseResponse<ListReportHosRes> queryReportHosList(ListReportHosReq param) {
        GetReportListsReq listReportParam = new GetReportListsReq();
        listReportParam.setCardNo(param.getCardNo());
        listReportParam.setPatientId(param.getPatientId());
        listReportParam.setReportType(param.getReportType());
        listReportParam.setBeginTime(DateUtils.dateToSimpleString((Date)DateUtils.getAddYear((Date)DateUtils.getCurrentDate(), (int)-3)));
        listReportParam.setEndTime(DateUtils.getCurrentDateSimpleToString());
        GatewayRequest gatewayRequest = this.getGateWayParam((NetReportBaseRequest)param, (Object)listReportParam);
        GatewayResponse response = new GatewayResponse();
        try {
            response = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.REPORT_LISTS.getValue(), gatewayRequest, GetReportListsRes.class);
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25{}", (Throwable)e);
            return BaseResponse.error((String)"\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25\uff01");
        }
        GetReportListsRes gateWayData = (GetReportListsRes)this.checkHisResponse((BaseResponse)response);
        if (gateWayData == null) {
            return BaseResponse.success();
        }
        List reportDataList = gateWayData.getDatas();
        if (null == reportDataList) {
            this.logger.error("request his gateway error - \u6682\u65e0\u6570\u636e");
            return BaseResponse.success();
        }
        Map<String, List<ReportInfo>> map = reportDataList.stream().map(arg_0 -> this.matchReportData(arg_0)).collect(Collectors.groupingBy(ReportInfo::getReportType));
        ListReportHosRes data = new ListReportHosRes();
        List<ReportInfo> reportInfoList = map.get(param.getReportType());
        if (CollectionUtils.isEmpty(reportInfoList)) {
            reportInfoList = new ArrayList<ReportInfo>();
        }
        for (ReportInfo reportInfo : reportInfoList) {
            if (!StringUtils.isBlank((CharSequence)reportInfo.getReportDate())) continue;
            reportInfo.setReportDate(reportInfo.getReportTime());
        }
        reportInfoList.sort(Comparator.comparing(ReportInfo::getReportDate).reversed());
        data.setReportList(reportInfoList);
        return BaseResponse.success((Object)data);
    }

    public BaseResponse<ReportDetailRes> queryReportDetail(ReportDetailReq param) {
        LisReportListReq lisReportListReq = new LisReportListReq();
        lisReportListReq.setReportNo(param.getReportNo());
        GatewayRequest gatewayRequest = this.getGateWayParam((NetReportBaseRequest)param, (Object)lisReportListReq);
        GatewayResponse response = new GatewayResponse();
        try {
            response = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.LIS_REPORT_LIST.getValue(), gatewayRequest, LisReportListRes.class);
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25{}", (Throwable)e);
            return BaseResponse.error((String)"\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25\uff01");
        }
        LisReportListRes gateWayData = (LisReportListRes)this.checkHisResponse((BaseResponse)response);
        if (null == gateWayData) {
            return BaseResponse.success();
        }
        ReportDetailRes reportDetail = new ReportDetailRes();
        BeanUtils.copyProperties((Object)gateWayData, (Object)reportDetail);
        List lisReportListResDataList = gateWayData.getDatas();
        if (null == lisReportListResDataList) {
            this.logger.error("request his gateway error - \u6682\u65e0\u6570\u636e");
            return BaseResponse.success();
        }
        List reportDetailDataList = lisReportListResDataList.stream().map(arg_0 -> this.matchJyReportDetail(arg_0)).collect(Collectors.toList());
        reportDetail.setDatas(reportDetailDataList);
        try {
            if (StringUtils.isNotEmpty((CharSequence)reportDetail.getPatientDOB())) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date birthday = simpleDateFormat.parse(reportDetail.getPatientDOB());
                String age = String.valueOf(DateUtils.getAgeByBirth((Date)birthday));
                reportDetail.setAge(age);
            }
        }
        catch (ParseException e) {
            this.logger.info(e.toString());
            return BaseResponse.error((String)"\u8f6c\u6362\u65f6\u95f4\u5f02\u5e38");
        }
        return BaseResponse.success((Object)reportDetail);
    }

    public BaseResponse<CheckReportDetailsRes> queryCheckReportDetail(CheckReportDetailsReq param) {
        PacsReportListReq pacsReportListReq = new PacsReportListReq();
        pacsReportListReq.setReportNo(param.getReportNo());
        GatewayRequest gatewayRequest = this.getGateWayParam((NetReportBaseRequest)param, (Object)pacsReportListReq);
        GatewayResponse response = new GatewayResponse();
        try {
            response = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.PACS_REPORT_LIST.getValue(), gatewayRequest, PacsReportListRes.class);
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25{}", (Throwable)e);
            return BaseResponse.error((String)"\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25\uff01");
        }
        PacsReportListRes gateWayData = (PacsReportListRes)this.checkHisResponse((BaseResponse)response);
        if (null == gateWayData) {
            return BaseResponse.success();
        }
        CheckReportDetailsRes reportDetail = new CheckReportDetailsRes();
        BeanUtils.copyProperties((Object)gateWayData, (Object)reportDetail);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reportDetail.getAge()})) {
            reportDetail.setAge(reportDetail.getAge().replace("\u5c81", ""));
        }
        reportDetail.setCheckImages(gateWayData.getCheckImages());
        return BaseResponse.success((Object)reportDetail);
    }

    private ReportDetailData matchJyReportDetail(LisReportListResData lisReportListResData) {
        ReportDetailData reportDetailData = new ReportDetailData();
        BeanUtils.copyProperties((Object)lisReportListResData, (Object)reportDetailData);
        List micDataList = lisReportListResData.getMicDatas();
        if (micDataList != null) {
            List detailMicDataList = micDataList.stream().map(arg_0 -> this.matchJyReportData(arg_0)).collect(Collectors.toList());
            reportDetailData.setMicDatas(detailMicDataList);
        }
        return reportDetailData;
    }

    private ReportDetailMicData matchJyReportData(LisReportListResMicData lisReportListResMicData) {
        ReportDetailMicData reportDetailMicData = new ReportDetailMicData();
        BeanUtils.copyProperties((Object)lisReportListResMicData, (Object)reportDetailMicData);
        return reportDetailMicData;
    }

    private ReportInfo matchReportData(GetReportListsData hisReportData) {
        ReportInfo reportData = new ReportInfo();
        reportData.setReportNo(hisReportData.getReportNo());
        reportData.setReportName(hisReportData.getReportName());
        reportData.setReportType(hisReportData.getReportType());
        reportData.setReportDate(hisReportData.getReportDate());
        reportData.setReportTime(hisReportData.getReportTime());
        reportData.setTsName(hisReportData.getTsName());
        reportData.setTsCode(hisReportData.getTsCode());
        return reportData;
    }

    private <T> T checkHisResponse(BaseResponse<T> response) {
        if (response == null) {
            this.logger.error("request his gateway error - \u65e0\u54cd\u5e94");
            return null;
        }
        if (!response.isSuccess()) {
            this.logger.error("request his gateway error - \u8bf7\u6c42\u7ed3\u679c-\u5931\u8d25");
            return null;
        }
        if (response.getData() == null) {
            this.logger.error("request his gateway error - \u8fd4\u56de\u5b9e\u4f53\u6570\u636e\u5f02\u5e38");
            return null;
        }
        return (T)response.getData();
    }

    private <T> GatewayRequest<T> getGateWayParam(NetReportBaseRequest baseRequest, T body) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setOrganCode(baseRequest.getOrganCode());
        gatewayRequest.setBody(body);
        gatewayRequest.setChannel(baseRequest.getChannel());
        gatewayRequest.setChannelName(baseRequest.getChannelName());
        String transactionId = UUID.randomUUID().toString();
        gatewayRequest.setTransactionId(transactionId);
        this.logger.info("his gateway - transactionId:{}", (Object)transactionId);
        return gatewayRequest;
    }
}

