/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.utils;

import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Component;

@Component(value="redisUtil")
public final class RedisUtil {
    @Resource
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    public String get(String key) {
        String result = (String)this.redisTemplate.execute(connection -> {
            RedisSerializer serializer = this.redisTemplate.getStringSerializer();
            byte[] value = connection.get(serializer.serialize((Object)key));
            return (String)serializer.deserialize(value);
        });
        return result;
    }

    public boolean set(String key, String value) {
        boolean result = (Boolean)this.redisTemplate.execute(connection -> {
            RedisSerializer serializer = this.redisTemplate.getStringSerializer();
            connection.set(serializer.serialize((Object)key), serializer.serialize((Object)value));
            return true;
        });
        return result;
    }

    public boolean set(String key, String value, long expirationTime) {
        boolean result = (Boolean)this.redisTemplate.execute(connection -> {
            RedisSerializer serializer = this.redisTemplate.getStringSerializer();
            connection.set(serializer.serialize((Object)key), serializer.serialize((Object)value), Expiration.seconds((long)expirationTime), RedisStringCommands.SetOption.UPSERT);
            return true;
        });
        return result;
    }

    public boolean delete(String key) {
        boolean result = (Boolean)this.redisTemplate.execute(connection -> {
            RedisSerializer serializer = this.redisTemplate.getStringSerializer();
            connection.del((byte[][])new byte[][]{serializer.serialize((Object)key)});
            return true;
        });
        return result;
    }

    public boolean setHash(String key, String hashKey, String value) {
        return (Boolean)this.redisTemplate.execute(connection -> {
            RedisSerializer serializer = this.redisTemplate.getStringSerializer();
            connection.hSet(serializer.serialize((Object)key), serializer.serialize((Object)hashKey), serializer.serialize((Object)value));
            return true;
        });
    }

    public Object getHash(String key, String hashKey) {
        return this.redisTemplate.execute(connection -> {
            RedisSerializer serializer = this.redisTemplate.getStringSerializer();
            connection.hGet(serializer.serialize((Object)key), serializer.serialize((Object)hashKey));
            return true;
        });
    }

    public boolean rPush(String key, String value) {
        return (Boolean)this.redisTemplate.execute(connection -> {
            RedisSerializer serializer = this.redisTemplate.getStringSerializer();
            connection.rPush(serializer.serialize((Object)key), (byte[][])new byte[][]{serializer.serialize((Object)value)});
            return true;
        });
    }

    public List<?> lRange(String key, long l, long l1) {
        ListOperations list = this.redisTemplate.opsForList();
        return list.range((Object)key, l, l1);
    }

    public void add(String key, String value) {
        this.redisTemplate.opsForSet().add((Object)key, (Object[])new String[]{value});
    }

    public Set<String> setMembers(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    public void zAdd(String key, String value, double scoure) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        zset.add((Object)key, (Object)value, scoure);
    }

    public Set<String> rangeByScore(String key, double scoure, double scoure1) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        return zset.rangeByScore((Object)key, scoure, scoure1);
    }

    public Boolean getLock(String key, Long lockTime) {
        String lock = this.get(key);
        if (lock == null) {
            this.set(key, "lock", lockTime.longValue());
            return true;
        }
        return false;
    }

    public boolean del(String key) {
        return this.stringRedisTemplate.delete((Object)key);
    }
}

