/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.callbackrefundpaysuccess.core;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.ResponseNotifyRestVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PayBillStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ServiceMerchantConfigMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ServicePayBillMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ServicePayBillEntity;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.manager.ManagerOrderService;
import com.ebaiyihui.onlineoutpatient.core.utils.JsonUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.SignUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.InvalidPresDto;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CheckOrderService {
    private static final Logger log = LoggerFactory.getLogger(CheckOrderService.class);
    @Autowired
    private BaseInquiryOrderServiceImpl baseInquiryOrderService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private ManagerOrderService managerOrderService;
    @Autowired
    private AdmissionMapper admissionMapper;

    public BaseResponse<String> checkOrderService(ResponseNotifyRestVo dto) {
        log.info("\u9000\u6b3e\u56de\u8c03doWhilePayCallBack dto :{}", (Object)JsonUtil.convertObject((Object)dto));
        OrderEntity orderInfo = this.getOrderByOrderSeq(dto.getOutTradeNo());
        if (this.refundParams(dto, orderInfo)) {
            return BaseResponse.success((Object)"fail");
        }
        log.info("\u9000\u6b3e\u65f6\u95f4:{}" + dto.getRefundTime());
        orderInfo.setStatus(OrderStatusEnum.REFUNDED.getValue());
        orderInfo.setRefundTime(dto.getRefundTime());
        this.orderMapper.updateOrderEntity(orderInfo);
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setRefundTime(dto.getRefundTime());
        servicePayBillEntity.setId(orderInfo.getBillRefundId());
        servicePayBillEntity.setRefundAmount(dto.getRefundMoney());
        servicePayBillEntity.setRefundNo(dto.getRefundNo());
        servicePayBillEntity.setStatus(PayBillStatusEnum.REFUNDED.getValue());
        servicePayBillEntity.setTradeStatus("SUCCESS");
        this.servicePayBillMapper.updateById((Object)servicePayBillEntity);
        log.info("\u9000\u6b3e\u56de\u8c03\u6210\u529f:{}", (Object)"success");
        AdmissionEntity admission = this.admissionMapper.queryAdmByOrderId(orderInfo.getXId());
        log.info("\u5931\u6548\u5904\u65b9admission:{}", (Object)JSON.toJSONString((Object)admission));
        if (admission != null && Objects.equals(admission.getServType(), 7)) {
            InvalidPresDto invalidPresDto = new InvalidPresDto();
            invalidPresDto.setAdmId(admission.getXId());
            this.managerOrderService.invalidPres(invalidPresDto);
        }
        return BaseResponse.success((Object)"success");
    }

    public OrderEntity getOrderByOrderSeq(String orderSeq) {
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity wrapperEntity = new OrderEntity();
        wrapperEntity.setOrderSeq(orderSeq);
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        OrderEntity orderEntity = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapper);
        if (null == orderEntity) {
            return null;
        }
        return orderEntity;
    }

    private boolean refundParams(ResponseNotifyRestVo dto, OrderEntity orderInfo) {
        Map map = SignUtil.getKeyAndValue((Object)dto);
        QueryWrapper wrapper = new QueryWrapper();
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = new ServiceMerchantConfigEntity();
        serviceMerchantConfigEntity.setAppCode(orderInfo.getAppCode());
        serviceMerchantConfigEntity.setHospitalId(orderInfo.getHospitalId());
        if ("ZHJYJF".equals(orderInfo.getFundType())) {
            serviceMerchantConfigEntity.setBizSysSeq("ZHJYJF");
        } else {
            serviceMerchantConfigEntity.setBizSysSeq(ServiceTypeEnum.getCode((Integer)orderInfo.getServType()));
        }
        serviceMerchantConfigEntity.setBizSysSeq(ServiceTypeEnum.getCode((Integer)orderInfo.getServType()));
        serviceMerchantConfigEntity.setApplyName(orderInfo.getPayMethod());
        wrapper.setEntity((Object)serviceMerchantConfigEntity);
        log.info("\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u8868\u5165\u53c2:{}" + serviceMerchantConfigEntity.toString());
        ServiceMerchantConfigEntity serviceMerchantConfig = (ServiceMerchantConfigEntity)this.serviceMerchantConfigMapper.selectOne((Wrapper)wrapper);
        if (serviceMerchantConfig == null) {
            log.info("\u672a\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u652f\u4ed8\u5e94\u7528code");
            return true;
        }
        log.info("\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u8868\u51fa\u53c2serviceMerchantConfigEntity:{}" + serviceMerchantConfigEntity.toString());
        if (!SignUtil.checkSign((Map)map, (String)serviceMerchantConfig.getApplyKey())) {
            log.info("\u56de\u8c03\u4e2d\u8be5\u8ba2\u5355\u7684\u7b7e\u540d\u4e0d\u6b63\u786e,\u8ba2\u5355\u4fe1\u606f:{}", (Object)orderInfo.toString());
            return true;
        }
        if (orderInfo == null) {
            log.error("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355,\u652f\u4ed8\u7cfb\u7edf\u4ea4\u6613\u7f16\u53f7={},\u4e1a\u52a1\u7cfb\u7edf\u4ea4\u6613\u7f16\u53f7={}", (Object)dto.getOutTradeNo());
            return true;
        }
        if (!orderInfo.getOrderSeq().equals(dto.getOutTradeNo())) {
            log.error("\u8ba2\u5355\u4fe1\u606f\u4e0e\u56de\u8c03\u53c2\u6570\u4e0d\u5339\u914d,\u8ba2\u5355={},\u56de\u8c03\u53c2\u6570={}", (Object)orderInfo.toString(), (Object)dto.toString());
            return true;
        }
        if (orderInfo.getServType().equals(ServiceTypeEnum.NOS.getValue()) && StringUtils.isNotEmpty((String)orderInfo.getOwnCost())) {
            BigDecimal bigDecimal = new BigDecimal(orderInfo.getOwnCost());
            if (0 != bigDecimal.compareTo(dto.getTotalAmount())) {
                log.error("\u8ba2\u5355\u91d1\u989d\u4e0e\u9000\u6b3e\u91d1\u989d\u4e0d\u5339\u914d,\u8ba2\u5355={},\u56de\u8c03\u53c2\u6570={}", (Object)orderInfo.toString(), (Object)dto.toString());
                return true;
            }
        } else if (0 != orderInfo.getPayAmount().compareTo(dto.getTotalAmount())) {
            log.error("\u8ba2\u5355\u91d1\u989d\u4e0e\u9000\u6b3e\u91d1\u989d\u4e0d\u5339\u914d,\u8ba2\u5355={},\u56de\u8c03\u53c2\u6570={}", (Object)orderInfo.toString(), (Object)dto.toString());
            return true;
        }
        if (!OrderStatusEnum.PAID.getValue().equals(orderInfo.getStatus()) && !OrderStatusEnum.REFUNDED.getValue().equals(orderInfo.getStatus())) {
            log.error("----------doWhilePayCallBack \u8ba2\u5355\u72b6\u6001\u5f02\u5e38,\u8ba2\u5355\u975e\u5df2\u652f\u4ed8\u6216\u8005\u9000\u6b3e\u4e2d\u72b6\u6001!-------------:{}", (Object)orderInfo);
            return true;
        }
        return false;
    }
}

