/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.createorder;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.dto.ImmediateConsultationDTO;
import com.ebaiyihui.onlineoutpatient.common.vo.ImmediateConsultationVo;
import com.ebaiyihui.onlineoutpatient.common.vo.serviceconfig.RequestGetDoctorOfficeStatus;
import com.ebaiyihui.onlineoutpatient.common.vo.serviceconfig.RequestOnlineOrOfflineVo;
import com.ebaiyihui.onlineoutpatient.core.business.createorder.CreateOrderFactory;
import com.ebaiyihui.onlineoutpatient.core.business.createorder.service.CreateOrder;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.service.InquiryServiceConfigService;
import com.ebaiyihui.onlineoutpatient.core.service.RedisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.utils.RedisUtil;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateOrderManage {
    private static final Logger log = LoggerFactory.getLogger(CreateOrderManage.class);
    @Autowired
    private CreateOrderFactory createOrderFactory;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private RedisTemplateService redisTemplateService;
    @Autowired
    private PatientMapper patientMapper;
    private static final Long EXPIRE_DATE = 2L;
    @Autowired
    private InquiryServiceConfigService inquiryServiceConfigService;

    public BaseResponse<ImmediateConsultationVo> checkProcess(ImmediateConsultationDTO immediateConsultationDTO) {
        String redisKey = immediateConsultationDTO.getPatientId() + "_" + immediateConsultationDTO.getDoctorId() + "_" + immediateConsultationDTO.getMedicalRecordId() + "_" + immediateConsultationDTO.getDeptId() + "_" + immediateConsultationDTO.getServType();
        log.info("redisKey:{}" + redisKey);
        Boolean flag = this.redisTemplateService.addLock(redisKey, redisKey, EXPIRE_DATE.longValue());
        if (!flag.booleanValue()) {
            return BaseResponse.error((String)"\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u8ba2\u5355");
        }
        log.info("\u52a0\u9501\u6210\u529f");
        if (Objects.equals(immediateConsultationDTO.getServType(), 7)) {
            RequestGetDoctorOfficeStatus requestGetDoctorOfficeStatus = new RequestGetDoctorOfficeStatus();
            requestGetDoctorOfficeStatus.setAppCode(immediateConsultationDTO.getAppCode());
            requestGetDoctorOfficeStatus.setDoctorId(immediateConsultationDTO.getDoctorId());
            requestGetDoctorOfficeStatus.setHospitalId(immediateConsultationDTO.getOrganId());
            BaseResponse requestOnlineOrOfflineVo = this.inquiryServiceConfigService.getDoctorOfficeStatus(requestGetDoctorOfficeStatus);
            if (null != requestOnlineOrOfflineVo.getData()) {
                log.info("================\u4fbf\u6c11\u4e0b\u5355\u6821\u9a8c\u533b\u751f\u662f\u5426\u5728\u7ebf:{}", (Object)((RequestOnlineOrOfflineVo)requestOnlineOrOfflineVo.getData()).getOfficeStatus());
                if (((RequestOnlineOrOfflineVo)requestOnlineOrOfflineVo.getData()).getOfficeStatus() != 1) {
                    return BaseResponse.error((String)"\u8be5\u533b\u751f\u4e0d\u5728\u7ebf\uff0c\u65e0\u6cd5\u8fdb\u884c\u670d\u52a1");
                }
            }
        }
        CreateOrder createOrder = (CreateOrder)this.createOrderFactory.get(immediateConsultationDTO.getOrganId());
        log.info("createOrder{}", (Object)JSON.toJSONString((Object)createOrder));
        BaseResponse orderCheckResponse = createOrder.orderCheck(immediateConsultationDTO);
        log.info("\u8ba2\u5355\u6821\u9a8c\u8fd4\u56de\u503c{}", (Object)JSON.toJSONString((Object)orderCheckResponse));
        this.redisUtil.del(redisKey);
        log.info("\u5220\u9664\u9501");
        if (null == orderCheckResponse || !orderCheckResponse.getCode().equals("1")) {
            return BaseResponse.error((String)orderCheckResponse.getMsg());
        }
        BaseResponse buyCheckRespVoBaseResponse = createOrder.preSettlementCheck(immediateConsultationDTO, (ImmediateConsultationVo)orderCheckResponse.getData());
        if (null == buyCheckRespVoBaseResponse) {
            PatientEntity patientEntity = this.patientMapper.selectById(immediateConsultationDTO.getPatientId());
            if (patientEntity != null) {
                ((ImmediateConsultationVo)orderCheckResponse.getData()).setPatientCredNo(patientEntity.getIdcard());
            }
            return orderCheckResponse;
        }
        return buyCheckRespVoBaseResponse;
    }
}

