/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.receiver;

import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Component
public class BmAutoMessageReceiver {
    private static final Logger log = LoggerFactory.getLogger(BmAutoMessageReceiver.class);
    @Resource
    private AdmissionMapper admissionMapper;
    @Resource
    private IMInformService imInformService;

    @RabbitListener(queues={"auto.message.bm.name"})
    @RabbitHandler
    public void process(String admId) {
        try {
            log.info("======\u50ac\u53551\u5206\u949f\u672a\u63a5\u8bcaMQ\u4efb\u52a1=========: {}", (Object)admId);
            AdmissionEntity admission = this.admissionMapper.findById(admId);
            if (admission != null) {
                if (Objects.equals(admission.getStatus(), AdmissionStatusEnum.TO_BE_RECEIVED.getValue())) {
                    this.imInformService.bmAutoSendIm(admId, "\u975e\u5e38\u62b1\u6b49\u8ba9\u60a8\u4e45\u7b49\u4e86\uff0c\u6211\u6b63\u5728\u5c3d\u5feb\u67e5\u770b\u60a8\u7684\u5c31\u8bca\u4fe1\u606f\uff0c\u8bf7\u60a8\u7a0d\u7b49\u7247\u523b\u3002", admission.getDoctorName(), "TEXT");
                } else {
                    log.info("======\u8ba2\u5355\u5df2\u88ab\u63a5\u8bca=========: {}", (Object)admId);
                }
            } else {
                log.info("======\u50ac\u53551\u5206\u949f\u672a\u63a5\u8bcaMQ\u4efb\u52a1\u672a\u627e\u5230\u6570\u636e=========: {}", (Object)admId);
            }
        }
        catch (Exception e) {
            log.error("======\u50ac\u53551\u5206\u949f\u672a\u63a5\u8bcaMQ\u4efb\u52a1\u5f02\u5e38=========: {}", (Object)e.getMessage());
        }
    }
}

