/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.receiver;

import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMedicalRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientMedicalRecordEntity;
import com.ebaiyihui.onlineoutpatient.core.service.manager.impl.IhuyiManage;
import com.ebaiyihui.onlineoutpatient.core.vo.ResPatientInformationVo;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Component
public class BmConfirmMedicalRecordsReceiver {
    private static final Logger log = LoggerFactory.getLogger(BmConfirmMedicalRecordsReceiver.class);
    @Resource
    private IhuyiManage ihuyiManage;
    @Resource
    private AdmissionMapper admissionMapper;
    @Resource
    private PatientMedicalRecordMapper patientMedicalRecordMapper;
    @Resource
    private PatientMapper patientMapper;

    @RabbitListener(queues={"confirm.medical.records.bm.name"})
    @RabbitHandler
    public void process(String admId) {
        try {
            log.info("======\u60a3\u8005\u4e94\u5206\u949f\u672a\u786e\u8ba4\u75c5\u5386MQ\u4efb\u52a1=========: {}", (Object)admId);
            AdmissionEntity admission = this.admissionMapper.findById(admId);
            if (Objects.isNull(admission)) {
                log.error("======\u672a\u627e\u5230\u5c31\u8bca\u4fe1\u606f=========");
                return;
            }
            if (Objects.equals(admission.getStatus(), AdmissionStatusEnum.IN_CONSULTATION.getValue())) {
                PatientMedicalRecordEntity recordEntity = this.patientMedicalRecordMapper.findById(admission.getMedicalRecordId());
                if (Objects.isNull(recordEntity)) {
                    log.error("======\u672a\u627e\u5230\u75c5\u5386\u4fe1\u606f=========");
                    return;
                }
                if (!Objects.equals(recordEntity.getCanEdit(), 2)) {
                    ResPatientInformationVo patientById = this.patientMapper.getPatientById(admission.getPatientId());
                    if (!Objects.isNull(patientById)) {
                        this.ihuyiManage.callPatient(patientById.getPatientName(), patientById.getTelphone());
                    } else {
                        log.error("======\u672a\u627e\u5230\u60a3\u8005\u4fe1\u606f=========");
                    }
                }
            } else {
                log.error("======\u8ba2\u5355\u72b6\u6001\u4e0d\u4e3a\u8fdb\u884c\u4e2d=========");
            }
        }
        catch (Exception e) {
            log.error("======\u60a3\u8005\u4e94\u5206\u949f\u672a\u786e\u8ba4\u75c5\u5386MQ\u4efb\u52a1\u5f02\u5e38=========: {}", (Object)e.getMessage());
        }
    }
}

