/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.receiver;

import com.alibaba.fastjson.JSON;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.OrderSender;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorFeignClientNew;
import com.ebaiyihui.onlineoutpatient.core.service.manager.impl.IhuyiManage;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderTaskVo;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Component
public class BmDelayedCallReceiver {
    private static final Logger log = LoggerFactory.getLogger(BmDelayedCallReceiver.class);
    @Resource
    private IhuyiManage ihuyiManage;
    @Resource
    private AdmissionMapper admissionMapper;
    @Resource
    private DoctorFeignClientNew doctorFeignClientNew;
    @Resource
    private OrderSender orderSender;

    @RabbitListener(queues={"call.routing.name"})
    @RabbitHandler
    public void process(String admId) {
        try {
            log.info("======\u4e00\u5206\u534a\u8d85\u65f6\u672a\u63a5\u8bcaMQ\u4efb\u52a1=========: {}", (Object)admId);
            AdmissionEntity admission = this.admissionMapper.findById(admId);
            if (admission != null) {
                if (Objects.equals(admission.getStatus(), AdmissionStatusEnum.TO_BE_RECEIVED.getValue())) {
                    BaseDTO baseDTO = new BaseDTO();
                    baseDTO.setId(Integer.valueOf(admission.getDoctorId()));
                    BaseResponse doctorDetailInfo = this.doctorFeignClientNew.endQueryDoctorDetailInfo(baseDTO);
                    log.info("======\u67e5\u8be2\u5230\u7684\u533b\u751f\u4fe1\u606f=========: {}", (Object)JSON.toJSONString((Object)doctorDetailInfo));
                    if (doctorDetailInfo.isSuccess()) {
                        this.ihuyiManage.callDoctor(((DoctorEntityInfoVO)doctorDetailInfo.getData()).getName(), ((DoctorEntityInfoVO)doctorDetailInfo.getData()).getContactMobile());
                        OrderTaskVo orderTaskVo1 = new OrderTaskVo();
                        orderTaskVo1.setType(Integer.valueOf(11));
                        orderTaskVo1.setId(admId);
                        this.orderSender.sendDelay(orderTaskVo1);
                    } else {
                        log.info("======\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u5931\u8d25=========: {}", (Object)doctorDetailInfo.getMsg());
                    }
                } else {
                    log.info("======\u8ba2\u5355\u5df2\u88ab\u63a5\u8bca=========: {}", (Object)admId);
                }
            } else {
                log.info("======\u4e00\u5206\u534a\u8d85\u65f6\u672a\u63a5\u8bcaMQ\u4efb\u52a1\u672a\u627e\u5230\u6570\u636e=========: {}", (Object)admId);
            }
        }
        catch (Exception e) {
            log.error("======\u4e00\u5206\u534a\u8d85\u65f6\u672a\u63a5\u8bcaMQ\u4efb\u52a1\u5f02\u5e38=========: {}", (Object)e.getMessage());
        }
    }
}

