/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.receiver;

import com.alibaba.fastjson.JSON;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.OrderSender;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorFeignClientNew;
import com.ebaiyihui.onlineoutpatient.core.service.manager.ManagerOrderService;
import com.ebaiyihui.onlineoutpatient.core.service.manager.impl.IhuyiManage;
import com.ebaiyihui.onlineoutpatient.core.vo.InvalidPresDto;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderTaskVo;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Component
public class BmNotPresReceiver {
    private static final Logger log = LoggerFactory.getLogger(BmNotPresReceiver.class);
    @Resource
    private IhuyiManage ihuyiManage;
    @Resource
    private AdmissionMapper admissionMapper;
    @Resource
    private IMInformService imInformService;
    @Resource
    private DoctorFeignClientNew doctorFeignClientNew;
    @Resource
    private ManagerOrderService managerOrderService;
    @Resource
    private OrderSender orderSender;

    @RabbitListener(queues={"pres.bm.name"})
    @RabbitHandler
    public void process(String admId) {
        try {
            log.info("======\u533b\u751f\u63a5\u535510\u5206\u949f\u540e\u672a\u5f00\u65b9MQ\u4efb\u52a1=========: {}", (Object)admId);
            InvalidPresDto invalidPresDto = new InvalidPresDto();
            invalidPresDto.setAdmId(admId);
            BaseResponse booleanBaseResponse = this.managerOrderService.queryPresType(invalidPresDto);
            log.info("booleanBaseResponse{}", (Object)JSON.toJSONString((Object)booleanBaseResponse));
            log.info("booleanBaseResponse{}", (Object)JSON.toJSONString((Object)booleanBaseResponse.isSuccess()));
            if (!booleanBaseResponse.isSuccess()) {
                AdmissionEntity admission = this.admissionMapper.findById(admId);
                if (admission != null) {
                    if (Objects.equals(AdmissionStatusEnum.IN_CONSULTATION.getValue(), admission.getStatus())) {
                        BaseDTO req = new BaseDTO();
                        req.setId(Integer.valueOf(admission.getDoctorId()));
                        BaseResponse doctorDetailInfo = this.doctorFeignClientNew.endQueryDoctorDetailInfo(req);
                        log.info("======\u67e5\u8be2\u5230\u7684\u533b\u751f\u4fe1\u606f=========: {}", (Object)JSON.toJSONString((Object)doctorDetailInfo));
                        if (doctorDetailInfo.isSuccess()) {
                            this.ihuyiManage.callDoctor(((DoctorEntityInfoVO)doctorDetailInfo.getData()).getName(), ((DoctorEntityInfoVO)doctorDetailInfo.getData()).getContactMobile());
                            OrderTaskVo orderTaskVo1 = new OrderTaskVo();
                            orderTaskVo1.setType(Integer.valueOf(15));
                            orderTaskVo1.setId(admId);
                            this.orderSender.sendDelay(orderTaskVo1);
                        } else {
                            log.info("======\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u5931\u8d25=========: {}", (Object)doctorDetailInfo.getMsg());
                        }
                    } else {
                        log.info("======\u5c31\u8bca\u4e0d\u5728\u8fdb\u884c\u4e2d=========: {}", (Object)admId);
                    }
                } else {
                    log.info("======\u67e5\u8be2\u5c31\u8bca\u4fe1\u606f\u5931\u8d25=========: {}", (Object)admId);
                }
            }
        }
        catch (Exception e) {
            log.error("======\u533b\u751f\u63a5\u535510\u5206\u949f\u540e\u672a\u5f00\u65b9MQ\u4efb\u52a1\u5f02\u5e38=========: {}", (Object)e.getMessage());
        }
    }
}

