/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.receiver;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.IMQueryMsgReqVO;
import com.ebaiyihui.imforward.client.vo.IMSingleMsgResultVO;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.OrderSender;
import com.ebaiyihui.onlineoutpatient.core.service.impl.AdmissionServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.manager.impl.IhuyiManage;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderTaskVo;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Component
public class BmReplyToDoctorReceiver {
    private static final Logger log = LoggerFactory.getLogger(BmReplyToDoctorReceiver.class);
    @Resource
    private IhuyiManage ihuyiManage;
    @Resource
    private AdmissionMapper admissionMapper;
    @Resource
    private AdmissionServiceImpl admissionService;
    @Resource
    private OrderSender orderSender;
    @Resource
    private PatientMapper patientMapper;

    @RabbitListener(queues={"reply.to.doctor.bm.name"})
    @RabbitHandler
    public void process(String admId) {
        try {
            log.info("======\u60a3\u8005\u4e09\u5206\u949f\u672a\u56de\u590d\u533b\u751fMQ\u4efb\u52a1=========: {}", (Object)admId);
            AdmissionEntity admission = this.admissionMapper.findById(admId);
            PatientEntity oneByPatientId = this.patientMapper.findOneByPatientId(admission.getPatientId());
            if (Objects.equals(admission.getStatus(), AdmissionStatusEnum.IN_CONSULTATION.getValue())) {
                IMQueryMsgReqVO reqVO = new IMQueryMsgReqVO();
                reqVO.setAppCode("EHOS_PATIENT");
                reqVO.setAppointmentId(Collections.singletonList(admission.getXId()));
                reqVO.setBusinessCode("zxzx");
                reqVO.setMsgType("1");
                reqVO.setPage(Integer.valueOf(0));
                reqVO.setPageSize(Integer.valueOf(10000000));
                reqVO.setSortOrder("ASC");
                reqVO.setUserId(oneByPatientId.getUserId());
                BaseResponse msgContentNew = this.admissionService.getAllMsgContentNew(reqVO);
                if (!((List)msgContentNew.getData()).isEmpty()) {
                    int size = ((List)msgContentNew.getData()).size();
                    IMSingleMsgResultVO resultVO = (IMSingleMsgResultVO)((List)msgContentNew.getData()).get(size - 1);
                    log.info("resultVO{}", (Object)JSON.toJSONString((Object)resultVO));
                    if (resultVO.getSender().endsWith("EHOS_DOCTOR") && (resultVO.getMsgContent().endsWith("?") || resultVO.getMsgContent().endsWith("\uff1f"))) {
                        LocalDateTime now;
                        DateTimeFormatter formatter;
                        String sendTime = resultVO.getSendTime();
                        LocalDateTime sendDateTime = LocalDateTime.parse(sendTime, formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                        long minutes = Duration.between(sendDateTime, now = LocalDateTime.now()).toMinutes();
                        if (minutes >= 3L) {
                            this.ihuyiManage.callPatient(oneByPatientId.getPactName(), oneByPatientId.getTelphone());
                        } else {
                            OrderTaskVo orderTaskVo = new OrderTaskVo();
                            orderTaskVo.setType(Integer.valueOf(14));
                            orderTaskVo.setTimes(Integer.valueOf(1));
                            orderTaskVo.setId(admission.getXId());
                            this.orderSender.sendDelay(orderTaskVo);
                        }
                    } else {
                        OrderTaskVo orderTaskVo = new OrderTaskVo();
                        orderTaskVo.setType(Integer.valueOf(14));
                        orderTaskVo.setTimes(Integer.valueOf(1));
                        orderTaskVo.setId(admission.getXId());
                        this.orderSender.sendDelay(orderTaskVo);
                    }
                }
            } else {
                log.info("======\u8ba2\u5355\u4e0d\u5728\u8fdb\u884c\u4e2d\u72b6\u6001=========");
            }
        }
        catch (Exception e) {
            log.error("======\u60a3\u8005\u4e09\u5206\u949f\u672a\u56de\u590d\u533b\u751fMQ\u4efb\u52a1\u5f02\u5e38=========: {}", (Object)e.getMessage());
        }
    }
}

