/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.receiver;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.domain.InqueryDoctorData;
import com.alipay.api.response.AlipayCommerceMedicalIndustrydataInquirydoctorUploadResponse;
import com.ebaiyihui.framework.utils.StringUtil;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ChangeTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.service.manager.AliMedicalPushService;
import com.ebaiyihui.onlineoutpatient.core.utils.IDCardUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.RedisUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorAliListVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorMessageEventsVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class DoctorInformationService {
    private static final Logger log = LoggerFactory.getLogger(DoctorInformationService.class);
    public static final int ONE = 1;
    public static final int MAX_SIZE = 100;
    @Autowired
    private AliMedicalPushService aliMedicalPushService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ProjProperties projProperties;
    public static final String ALI_DOCTOR = "online:cache:doctor:pro:ALI_DOCTOR";

    @RabbitListener(queues={"doctor.information.data"})
    @RabbitHandler
    public void addDoctorReceiver(DoctorMessageEventsVo doctorMessageEventsVo) {
        log.info("\u5f00\u59cb\u533b\u751f\u4fe1\u606f\u540c\u6b65");
        Boolean alipayDoctorStart = this.projProperties.getAlipayDoctorStart();
        if (alipayDoctorStart == null || !alipayDoctorStart.booleanValue()) {
            log.info("\u533b\u751f\u4fe1\u606f\u540c\u6b65-\u63a8\u9001\u72b6\u6001\u5173\u95ed\u6216\u7a7a\uff0c\u505c\u6b62\u6267\u884c\uff1a{}", (Object)alipayDoctorStart);
            return;
        }
        try {
            if (CollectionUtils.isEmpty((Collection)doctorMessageEventsVo.getDoctorListVo())) {
                log.info("\u533b\u751f\u4fe1\u606f\u540c\u6b65-\u6570\u636e\u7a7a\uff0c\u505c\u6b62\u6267\u884c");
                return;
            }
            log.info("\u5f00\u59cb\u533b\u751f\u4fe1\u606f\u540c\u6b65,\u533b\u751f\u6570\u91cf:" + doctorMessageEventsVo.getDoctorListVo().size());
            ArrayList<InqueryDoctorData> doctorList = new ArrayList<InqueryDoctorData>();
            boolean redisTrue = false;
            for (DoctorAliListVo doctor : doctorMessageEventsVo.getDoctorListVo()) {
                if (ObjectUtils.isEmpty((Object)doctor) || StringUtil.isEmpty((String)doctor.getIdCard())) {
                    log.info("\u8be5\u6761\u533b\u751f\u6570\u636e\u8eab\u4efd\u8bc1\u8bc1\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u8be5\u6761:{}", (Object)JSONObject.toJSONString((Object)doctor));
                    continue;
                }
                String s = this.redisUtil.get(ALI_DOCTOR + doctor.getIdCard());
                if (!StringUtil.isEmpty((String)s)) {
                    log.info("\u533b\u751f\u4fe1\u606f\u540c\u6b65-\u8be5\u533b\u751f\u4fe1\u606f\u5df2\u540c\u6b65\u8fc7\uff0c\u8df3\u8fc7\u6267\u884c\uff1akey{}", (Object)(ALI_DOCTOR + doctor.getIdCard()));
                    continue;
                }
                Integer sex = IDCardUtil.getGenderForInteger((String)doctor.getIdCard());
                if (sex == null) {
                    log.info("\u533b\u751f\u4fe1\u606f\u540c\u6b65-\u8be5\u533b\u751f\u6027\u522b\u5f02\u5e38\uff0c\u8df3\u8fc7\u6267\u884c\uff1akey{}", (Object)JSONObject.toJSONString((Object)doctor));
                    continue;
                }
                InqueryDoctorData inqueryDoctorData = new InqueryDoctorData();
                inqueryDoctorData.setAvator(doctor.getPortrait());
                inqueryDoctorData.setChangeType(ChangeTypeEnum.getValue((Integer)doctorMessageEventsVo.getDataType()));
                inqueryDoctorData.setDepartmentName(doctor.getDeptName());
                inqueryDoctorData.setDoctorDesc(StringUtil.isEmpty((String)doctor.getIntroduction()) ? "\u6682\u65e0" : doctor.getIntroduction());
                inqueryDoctorData.setDoctorName(doctor.getDoctorName());
                inqueryDoctorData.setGender(sex.equals(1) ? "MALE" : "FEMALE");
                inqueryDoctorData.setHospitalName(doctor.getOrganName());
                inqueryDoctorData.setIdNo(doctor.getIdCard());
                inqueryDoctorData.setPracticingDoctorCertificateNo(null);
                inqueryDoctorData.setPracticeYear(null);
                inqueryDoctorData.setSkilledDesc(doctor.getProfession());
                inqueryDoctorData.setSkilledDisease(null);
                inqueryDoctorData.setSpecialTags(null);
                inqueryDoctorData.setTitle(this.getTitle(doctor.getTitle()));
                log.info("\u533b\u751f\u6570\u636e\u5b8c\u6574\uff0c\u6dfb\u52a0\u533b\u751f:{}", (Object)JSONObject.toJSONString((Object)inqueryDoctorData));
                doctorList.add(inqueryDoctorData);
                if (doctorList.size() == 100) {
                    log.info("\u5df2\u6ee1100\u6761\uff0c\u76f4\u63a5\u63a8\u9001\u652f\u4ed8\u5b9d\uff0c\u533b\u751f\u6570\u91cf:{}", (Object)doctorList.size());
                    AlipayCommerceMedicalIndustrydataInquirydoctorUploadResponse response = this.aliMedicalPushService.doctorUpload(doctorList, UUID.randomUUID().toString());
                    if (response.isSuccess()) {
                        log.info("\u8c03\u7528\u6210\u529f:{}", (Object)JSONObject.toJSONString((Object)response));
                        redisTrue = true;
                    } else {
                        log.info("\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + response.getMsg() + "\uff0c" + response.getSubMsg());
                        doctorList = new ArrayList();
                    }
                }
                if (!redisTrue) continue;
                log.info("\u5b58\u50a8\u533b\u751f\u4fe1\u606f\u7f13\u5b58\u8bb0\u5f55");
                for (InqueryDoctorData inqueryDoctor : doctorList) {
                    this.redisUtil.set(ALI_DOCTOR + inqueryDoctor.getIdNo(), JSONObject.toJSONString((Object)inqueryDoctor));
                }
                doctorList = new ArrayList();
                redisTrue = false;
            }
            log.info("\u63a8\u9001\u533b\u751f\u4fe1\u606f\u5230\u652f\u4ed8\u5b9d\uff0c\u533b\u751f\u6570\u91cf:{}", (Object)doctorList.size());
            if (!CollectionUtils.isEmpty(doctorList)) {
                AlipayCommerceMedicalIndustrydataInquirydoctorUploadResponse response = this.aliMedicalPushService.doctorUpload(doctorList, UUID.randomUUID().toString());
                if (response.isSuccess()) {
                    log.info("\u8c03\u7528\u6210\u529f:{}", (Object)JSONObject.toJSONString((Object)response));
                    redisTrue = true;
                } else {
                    log.info("\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + response.getMsg() + "\uff0c" + response.getSubMsg());
                }
                if (redisTrue) {
                    log.info("\u5b58\u50a8\u533b\u751f\u4fe1\u606f\u7f13\u5b58\u8bb0\u5f55");
                    for (InqueryDoctorData inqueryDoctor : doctorList) {
                        try {
                            boolean set = this.redisUtil.set(ALI_DOCTOR + inqueryDoctor.getIdNo(), JSONObject.toJSONString((Object)inqueryDoctor));
                            log.info("\u5b58\u50a8\u533b\u751f\u7f13\u5b58\u5b8c\u6210,\u5b58\u50a8\u60c5\u51b5:{}\uff0c\u6570\u636e\uff1a{}", (Object)set, (Object)JSONObject.toJSONString((Object)inqueryDoctor));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            log.info("\u5b58\u50a8\u533b\u751f\u7f13\u5b58\u5b8c\u6210\u51fa\u73b0\u5f02\u5e38,{},\u6570\u636e\uff1a{}", (Object)e, (Object)JSONObject.toJSONString((Object)inqueryDoctor));
                        }
                    }
                }
            }
            log.info("\u533b\u751f\u4fe1\u606f\u540c\u6b65mq\u5b8c\u6210");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u533b\u751f\u4fe1\u606f\u540c\u6b65mq\u6d88\u8d39\u5f02\u5e38" + e);
        }
        log.info("\u533b\u751f\u4fe1\u606f\u540c\u6b65mq\u6d88\u8d39\u5b8c\u6bd5!");
    }

    private String getTitle(String title) {
        if (StringUtils.isBlank((CharSequence)title)) {
            return null;
        }
        if ("\u533b\u5e08".equals(title)) {
            return "PHYSICIANS";
        }
        if ("\u4e3b\u6cbb\u533b\u5e08".equals(title)) {
            return "ATTENDING_PHYSICIANS";
        }
        if ("\u526f\u4e3b\u4efb\u533b\u5e08".equals(title)) {
            return "DEPUTY_CHIEF_PHYSICIANS";
        }
        if ("\u4e3b\u4efb\u533b\u5e08".equals(title)) {
            return "CHIEF_PHYSICIANS";
        }
        return null;
    }
}

