/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctoruser.api.common.enums.DoctorTypeEnum;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.PatientNoResponseReqVo;
import com.ebaiyihui.onlineoutpatient.common.vo.serviceconfig.RequestGetDoctorOfficeStatus;
import com.ebaiyihui.onlineoutpatient.common.vo.serviceconfig.RequestOnlineOrOfflineVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.TeamDoctorInfoMapper;
import com.ebaiyihui.onlineoutpatient.core.exception.AdmissionException;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.TeamDoctorInfoEntity;
import com.ebaiyihui.onlineoutpatient.core.service.AliSmsPushService;
import com.ebaiyihui.onlineoutpatient.core.service.InquiryServiceConfigService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.utils.PushUtils;
import com.ebaiyihui.onlineoutpatient.core.vo.PushConfigurationDetailVO;
import com.ebaiyihui.push.pojo.alisms.AliSmsSendAuthCodeReqPhoneVO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AliSmsPushServiceImpl
implements AliSmsPushService {
    private static final Logger log = LoggerFactory.getLogger(AliSmsPushServiceImpl.class);
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private DoctorInfofeignClient doctorInfoClient;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private PushUtils pushUtils;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private InquiryServiceConfigService inquiryServiceConfigService;
    @Autowired
    private TeamDoctorInfoMapper teamDoctorInfoMapper;
    private static final String ONE = "-1";

    public void onlineVisitsApplicationSuccessfulAliSmsPush(String doctorId, String patientId, String admId) {
        log.info("\u4e0b\u5355\u6210\u529f\uff0c\u533b\u751f\u77ed\u4fe1\u63a8\u9001:{},{},{}", new Object[]{doctorId, patientId, admId});
        OrderEntity orderEntity = this.getOrderInfo(admId);
        if (null == orderEntity) {
            log.info("=======admd\u4e0b\u6ca1\u6709\u8ba2\u5355=======");
            return;
        }
        if (DoctorTypeEnum.TEAM.getValue() == orderEntity.getDoctorType()) {
            List teamDoctorInfoEntityList = this.teamDoctorInfoMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(TeamDoctorInfoEntity::getAdmId, (Object)admId));
            if (CollectionUtil.isNotEmpty((Collection)teamDoctorInfoEntityList)) {
                log.info("------\u77ed\u4fe1\u7fa4\u53d1\u5f00\u59cb-----" + JSONObject.toJSONString(teamDoctorInfoEntityList.stream().map(i -> i.getDoctorId()).collect(Collectors.toList())));
                for (TeamDoctorInfoEntity teamDoctorInfoEntity : teamDoctorInfoEntityList) {
                    if (Objects.equals("DYSJPT", orderEntity.getAppCode())) {
                        this.dyMessagePush(orderEntity, patientId, teamDoctorInfoEntity.getDoctorId(), admId);
                        continue;
                    }
                    this.aliMessagePush(orderEntity, patientId, teamDoctorInfoEntity.getDoctorId(), admId);
                }
            }
        } else if (Objects.equals("DYSJPT", orderEntity.getAppCode())) {
            this.dyMessagePush(orderEntity, patientId, doctorId, admId);
        } else {
            this.aliMessagePush(orderEntity, patientId, doctorId, admId);
        }
    }

    public void onlineDoctorReceptionSmsNotificationSmsPush(String doctorId, String patientId, String admId) {
        log.info("\u533b\u751f\u63a5\u5355\uff0c\u60a3\u8005\u77ed\u4fe1\u63a8\u9001:{},{},{}", new Object[]{doctorId, patientId, admId});
        OrderEntity orderEntity = this.getOrderInfo(admId);
        log.info("\u533b\u751f\u63a5\u5355\uff0c\u60a3\u8005\u77ed\u4fe1\u63a8\u9001,\u8ba2\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)orderEntity));
        if (ObjectUtil.isNull((Object)orderEntity)) {
            log.info("=======admd\u4e0b\u6ca1\u6709\u8ba2\u5355=======");
            return;
        }
        if (Objects.equals("DYSJPT", orderEntity.getAppCode())) {
            this.patientSmsPush(doctorId, patientId, orderEntity);
        }
    }

    private void patientSmsPush(String doctorId, String patientId, OrderEntity orderEntity) {
        if (!Objects.equals("DYSJPT", orderEntity.getAppCode())) {
            log.info("=======\u5f53\u524d\u8bf7\u6c42\u7684appCode\u4e0d\u662f\u5fb7\u9633\u533b\u9662appCode\u4e0d\u80fd\u8fdb\u884c\u5fb7\u9633\u533b\u9662\u77ed\u4fe1\u53d1\u9001\uff0c\u5185\u5bb9\uff1a{}=======", (Object)JSON.toJSONString((Object)orderEntity));
            return;
        }
        log.info("=======\u5fb7\u9633\u533b\u751f\u63a5\u8bca\u77ed\u4fe1\u53d1\u9001\uff0c\u5185\u5bb9\uff1a{}=======", (Object)JSON.toJSONString((Object)orderEntity));
        RequestGetDoctorOfficeStatus requestGetDoctorOfficeStatus = new RequestGetDoctorOfficeStatus();
        requestGetDoctorOfficeStatus.setAppCode(orderEntity.getAppCode());
        requestGetDoctorOfficeStatus.setDoctorId(doctorId);
        requestGetDoctorOfficeStatus.setHospitalId(orderEntity.getHospitalId());
        BaseResponse requestOnlineOrOfflineVo = this.inquiryServiceConfigService.getDoctorOfficeStatus(requestGetDoctorOfficeStatus);
        if (null == requestOnlineOrOfflineVo.getData()) {
            log.info("=======\u533b\u751f\u4e0a\u4e0b\u7ebf\u72b6\u6001\u4e3anull=======");
            return;
        }
        if (((RequestOnlineOrOfflineVo)requestOnlineOrOfflineVo.getData()).getOfficeStatus().equals(-1)) {
            log.info("=======\u533b\u751f\u4e0b\u7ebf,\u4e0d\u63a8\u9001=======");
            return;
        }
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == patientEntity) {
            return;
        }
        String doctorName = ((PersonnelInfo)this.queryDoctorByDoctorId(doctorId).getData()).getDoctorName();
        HashMap<String, String> smsMap = new HashMap<String, String>(2);
        String ms = StringUtils.isEmpty((CharSequence)doctorName) ? "" : doctorName + "\u533b\u751f\u5df2\u63a5\u8bca\uff0c\u8bf7\u60a8\u5c3d\u5feb\u524d\u5f80\u5c0f\u7a0b\u5e8f\u8fdb\u5165\u95ee\u8bca\u9875\uff0c\u4e0e\u533b\u751f\u5f00\u59cb\u6c9f\u901a";
        smsMap.put("phone", patientEntity.getTelphone());
        smsMap.put("ms", ms);
        String result = HttpUtil.post((String)"https://smtpj-dysmt-cn.chinachdu.com/index.php/index/index/sendtohos", smsMap);
        if (result.contains("-")) {
            log.info("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
            log.info(ErrorEnum.OTHER_SERVICE_ERROR_DEFAULT_CODE.getMsg());
        }
        log.info("\u63a5\u5355\u6210\u529f\uff0c\u60a3\u8005\u77ed\u4fe1\u63a8\u9001\u7ed3\u675f");
    }

    public void dyMessagePush(OrderEntity orderEntity, String patientId, String doctorId, String admId) {
        if (!Objects.equals("DYSJPT", orderEntity.getAppCode())) {
            log.info("=======\u5f53\u524d\u8bf7\u6c42\u7684appCode\u4e0d\u662f\u5fb7\u9633\u533b\u9662appCode\u4e0d\u80fd\u8fdb\u884c\u5fb7\u9633\u533b\u9662\u77ed\u4fe1\u53d1\u9001\uff0c\u5185\u5bb9\uff1a{}=======", (Object)JSON.toJSONString((Object)orderEntity));
            return;
        }
        RequestGetDoctorOfficeStatus requestGetDoctorOfficeStatus = new RequestGetDoctorOfficeStatus();
        requestGetDoctorOfficeStatus.setAppCode(orderEntity.getAppCode());
        requestGetDoctorOfficeStatus.setDoctorId(doctorId);
        requestGetDoctorOfficeStatus.setHospitalId(orderEntity.getHospitalId());
        BaseResponse requestOnlineOrOfflineVo = this.inquiryServiceConfigService.getDoctorOfficeStatus(requestGetDoctorOfficeStatus);
        if (null == requestOnlineOrOfflineVo.getData()) {
            log.info("=======\u533b\u751f\u4e0a\u4e0b\u7ebf\u72b6\u6001\u4e3anull=======");
            return;
        }
        if (((RequestOnlineOrOfflineVo)requestOnlineOrOfflineVo.getData()).getOfficeStatus().equals(-1)) {
            log.info("=======\u533b\u751f\u4e0b\u7ebf,\u4e0d\u63a8\u9001=======");
            return;
        }
        String phoneNum = ((PersonnelInfo)this.queryDoctorByDoctorId(doctorId).getData()).getPhoneNum();
        String patientName = this.getpatientByPatientId(patientId);
        HashMap<String, String> smsMap = new HashMap<String, String>(2);
        String ms = StringUtils.isEmpty((CharSequence)patientName) ? "" : patientName + "\u60a3\u8005\u5411\u60a8\u7533\u8bf7\u95ee\u8bca\uff0c\u70b9\u51fb\u5fb7\u9633\u5e02\u6c11\u901a\uff08\u533b\u751f\u7aef\uff09APP-\u5728\u7ebf\u95ee\u8bca\u63a5\u5f85\u60a3\u8005\u3002";
        smsMap.put("phone", phoneNum);
        smsMap.put("ms", ms);
        String result = HttpUtil.post((String)"https://smtpj-dysmt-cn.chinachdu.com/index.php/index/index/sendtohos", smsMap);
        if (result.contains("-")) {
            log.info("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
            log.info(ErrorEnum.OTHER_SERVICE_ERROR_DEFAULT_CODE.getMsg());
        }
        log.info("\u4e0b\u5355\u6210\u529f\uff0c\u533b\u751f\u77ed\u4fe1\u63a8\u9001\u7ed3\u675f");
    }

    public void aliMessagePush(OrderEntity orderEntity, String patientId, String doctorId, String admId) {
        RequestGetDoctorOfficeStatus requestGetDoctorOfficeStatus = new RequestGetDoctorOfficeStatus();
        requestGetDoctorOfficeStatus.setAppCode(orderEntity.getAppCode());
        requestGetDoctorOfficeStatus.setDoctorId(doctorId);
        requestGetDoctorOfficeStatus.setHospitalId(orderEntity.getHospitalId());
        BaseResponse requestOnlineOrOfflineVo = this.inquiryServiceConfigService.getDoctorOfficeStatus(requestGetDoctorOfficeStatus);
        if (null == requestOnlineOrOfflineVo.getData()) {
            log.info("=======\u533b\u751f\u4e0a\u4e0b\u7ebf\u72b6\u6001\u4e3anull=======");
            return;
        }
        if (((RequestOnlineOrOfflineVo)requestOnlineOrOfflineVo.getData()).getOfficeStatus().equals(-1)) {
            log.info("=======\u533b\u751f\u4e0b\u7ebf,\u4e0d\u63a8\u9001=======");
            return;
        }
        String phoneNum = ((PersonnelInfo)this.queryDoctorByDoctorId(doctorId).getData()).getPhoneNum();
        String patientName = this.getpatientByPatientId(patientId);
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getAliSmsTemplateCode());
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(admId).getClientCode());
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("name", patientName);
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(phoneNum);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(admId).getDoctorCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
        log.info("\u4e0b\u5355\u6210\u529f\uff0c\u533b\u751f\u77ed\u4fe1\u63a8\u9001\u7ed3\u675f");
    }

    public void onlineVisitsApplicationNoResponseInTwoHoursAliSmsPush(PatientNoResponseReqVo patientNoResponseReqVo) throws AdmissionException {
        OrderEntity orderEntity = this.getOrderInfo(patientNoResponseReqVo.getAdmId());
        if (null == orderEntity) {
            log.info("=======admd\u4e0b\u6ca1\u6709\u8ba2\u5355=======");
            return;
        }
        RequestGetDoctorOfficeStatus requestGetDoctorOfficeStatus = new RequestGetDoctorOfficeStatus();
        requestGetDoctorOfficeStatus.setAppCode(orderEntity.getAppCode());
        requestGetDoctorOfficeStatus.setDoctorId(orderEntity.getDoctorId());
        requestGetDoctorOfficeStatus.setHospitalId(orderEntity.getHospitalId());
        BaseResponse requestOnlineOrOfflineVo = this.inquiryServiceConfigService.getDoctorOfficeStatus(requestGetDoctorOfficeStatus);
        if (null == requestOnlineOrOfflineVo.getData()) {
            log.info("=======\u533b\u751f\u4e0a\u4e0b\u7ebf\u72b6\u6001\u4e3anull=======");
            return;
        }
        if (((RequestOnlineOrOfflineVo)requestOnlineOrOfflineVo.getData()).getOfficeStatus().equals(-1)) {
            log.info("=======\u533b\u751f\u4e0b\u7ebf,\u4e0d\u63a8\u9001=======");
            return;
        }
        AdmissionEntity admissionEntity = this.admissionMapper.findById(patientNoResponseReqVo.getAdmId());
        if (null == admissionEntity) {
            return;
        }
        if (admissionEntity.getServType() == 7) {
            log.error("\u4fbf\u6c11\u95e8\u8bca\uff0c\u4e0d\u63a8\u9001");
            return;
        }
        if ("1".equals(patientNoResponseReqVo.getType())) {
            log.error("\u8868\u793a\u533b\u751f\u672a\u56de\u590d\u6d88\u606f10\u5206\u949f\uff0c\u4e0d\u63a8\u9001");
            return;
        }
        if (!AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admissionEntity.getStatus())) {
            log.info("=====\u5c31\u8bca\u72b6\u6001\u4e0d\u662f\u95ee\u8bca\u4e2d\u7684\u72b6\u6001\uff0c\u4e0d\u4f1a\u63a8\u9001\u77ed\u606f\u6d88\u606f=====");
            return;
        }
        String doctorId = admissionEntity.getDoctorId();
        String patientId = admissionEntity.getPatientId();
        String phoneNum = ((PersonnelInfo)this.queryDoctorByDoctorId(doctorId).getData()).getPhoneNum();
        String patientName = this.getpatientByPatientId(patientId);
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getNoReplyInTwoHoursAliSmsTemplateCode());
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(patientNoResponseReqVo.getAdmId()).getClientCode());
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("patientName", patientName);
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(phoneNum);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(patientNoResponseReqVo.getAdmId()).getDoctorCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
    }

    public void onlineVisitsApplicationNoResponseInTenMinutesAliSmsPush(String admId) throws AdmissionException {
        AdmissionEntity admissionEntity = this.admissionMapper.findById(admId);
        if (null == admissionEntity) {
            return;
        }
        if (!AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admissionEntity.getStatus())) {
            log.info("=====\u5c31\u8bca\u72b6\u6001\u4e0d\u662f\u95ee\u8bca\u4e2d\u7684\u72b6\u6001=====");
            return;
        }
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            return;
        }
        String patientId = orderEntity.getPatientId();
        String doctorId = orderEntity.getDoctorId();
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == patientEntity) {
            return;
        }
        String phoneNum = patientEntity.getTelphone();
        String doctorName = ((PersonnelInfo)this.queryDoctorByDoctorId(doctorId).getData()).getDoctorName();
        AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVO();
        aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(this.projProperties.getNoReplyInInTenMinuteAliSmsTemplateCode());
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(this.getSmsClientCode(admId).getClientCode());
        HashMap<String, String> nameMap = new HashMap<String, String>(1);
        nameMap.put("doctorName", doctorName);
        aliSmsSendAuthCodeReqPhoneVO.setParams(nameMap);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(phoneNum);
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(this.getSmsClientCode(admId).getPatientCode());
        this.getEchatMessageApi(aliSmsSendAuthCodeReqPhoneVO);
    }

    private BaseResponse<PersonnelInfo> queryDoctorByDoctorId(String doctorId) {
        log.info("\u533b\u751f\u7528\u6237\u8c03\u7528:{} ", (Object)JSON.toJSONString((Object)doctorId));
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(doctorId);
        BaseResponse personnelInfoBaseResponse = this.doctorInfoClient.queryPersonnelInfo(queryPersonnelInfoReq);
        log.info("req :{}", (Object)JSON.toJSONString((Object)personnelInfoBaseResponse));
        return personnelInfoBaseResponse;
    }

    private String getpatientByPatientId(String patientId) {
        log.info("\u60a3\u8005\u8c03\u7528\u5165\u53c2:{} ", (Object)JSON.toJSONString((Object)patientId));
        PatientEntity patientEntity = this.patientMapper.selectById(patientId);
        log.info("patientEntity :{}", (Object)JSON.toJSONString((Object)patientEntity));
        return patientEntity.getPatientName();
    }

    private String getEchatMessageApi(AliSmsSendAuthCodeReqPhoneVO aliSmsSendAuthCodeReqPhoneVO) {
        log.info("\u77ed\u4fe1\u63a8\u9001\u5165\u53c2" + JSON.toJSONString((Object)aliSmsSendAuthCodeReqPhoneVO));
        String url = this.projProperties.getAliSmsPushUrl();
        BaseResponse response = null;
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)aliSmsSendAuthCodeReqPhoneVO));
            response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), BaseResponse.class);
            log.info("response:{}" + JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u63a8\u9001\u63a5\u53e3\u5931\u8d25" + e.getMessage());
        }
        if (ONE.equals(response.getErrCode())) {
            log.info("=================\u77ed\u4fe1\u63a8\u9001\u5931\u8d25================");
            return "\u77ed\u4fe1\u63a8\u9001\u5931\u8d25";
        }
        return null;
    }

    private PushConfigurationDetailVO getSmsClientCode(String admId) {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            return null;
        }
        String appCode = orderEntity.getAppCode();
        PushConfigurationDetailVO pushConfig = this.pushUtils.getPushConfig(appCode, "sms", "doctor", "sms");
        if (null == pushConfig) {
            return null;
        }
        return pushConfig;
    }

    private OrderEntity getOrderInfo(String admId) {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            return null;
        }
        return orderEntity;
    }
}

