/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.core.common.enums.DoctorLabelEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.DoctorLabelMapper;
import com.ebaiyihui.onlineoutpatient.core.model.DoctorLabelEntity;
import com.ebaiyihui.onlineoutpatient.core.service.DoctorLabelService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.utils.id.UUIDUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorLabelReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.InsertDoctorLabelReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.QueryDoctorLabelReqVo;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DoctorLabelServiceImpl
implements DoctorLabelService {
    private static final Logger log = LoggerFactory.getLogger(DoctorLabelServiceImpl.class);
    @Autowired
    private DoctorLabelMapper doctorLabelMapper;
    @Autowired
    private DoctorInfofeignClient doctorClient;

    public BaseResponse<Integer> deleteDoctorLabel(DoctorLabelReqVo doctorLabelReqVo) {
        log.info("\u5220\u9664\u533b\u751f\u6807\u7b7e\u63a5\u53e3\u5165\u53c2,deleteDoctorLabel:{},", (Object)doctorLabelReqVo.toString());
        if (null == doctorLabelReqVo.getDoctorLabelId()) {
            return BaseResponse.error((String)"\u4f20\u5165\u7684id\u4e3a\u7a7a");
        }
        Integer count = this.doctorLabelMapper.deleteById((Serializable)((Object)doctorLabelReqVo.getDoctorLabelId()));
        if (count == 1) {
            return BaseResponse.success(null);
        }
        return BaseResponse.error((String)"\u5220\u9664\u533b\u751f\u6807\u7b7e\u5931\u8d25\uff01");
    }

    public BaseResponse<String> insertDoctorLabel(InsertDoctorLabelReqVo insertDoctorLabelReqVo) {
        log.info("\u6dfb\u52a0\u533b\u751f\u6807\u7b7e\u63a5\u53e3\u5165\u53c2,insertDoctorLabel:{},", (Object)insertDoctorLabelReqVo.toString());
        QueryWrapper queryWrapper = new QueryWrapper();
        DoctorLabelEntity entity = new DoctorLabelEntity();
        entity.setHospitalId(insertDoctorLabelReqVo.getHospitalId());
        entity.setAppCode(insertDoctorLabelReqVo.getAppCode());
        entity.setDoctorId(insertDoctorLabelReqVo.getDoctorId());
        queryWrapper.setEntity((Object)entity);
        DoctorLabelEntity selectEntity = (DoctorLabelEntity)this.doctorLabelMapper.selectOne((Wrapper)queryWrapper);
        if (null != selectEntity) {
            if (insertDoctorLabelReqVo.getLabelName().equals(selectEntity.getLabelName())) {
                return BaseResponse.error((String)"\u8be5\u533b\u751f\u5df2\u7ecf\u5b58\u5728\u6b64\u6807\u7b7e\uff0c\u8bf7\u66f4\u6362\u6807\u7b7e");
            }
            DoctorLabelEntity updateEntity = new DoctorLabelEntity();
            updateEntity.setXId(selectEntity.getXId());
            updateEntity.setLabelName(insertDoctorLabelReqVo.getLabelName());
            Integer count = this.doctorLabelMapper.updateById((Object)updateEntity);
            if (count == 1) {
                log.info("\u5bf9\u533b\u751f\u6807\u7b7e\u8fdb\u884c\u4fee\u6539\uff1a{}" + updateEntity.toString());
                return BaseResponse.success((Object)"\u8be5\u533b\u751f\u6807\u7b7e\u5df2\u4fee\u6539\u5b8c\u6210\u3002");
            }
            return BaseResponse.error((String)"\u533b\u751f\u6807\u7b7e\u4fee\u6539\u5931\u8d25!");
        }
        DoctorLabelEntity doctorLabelEntity = new DoctorLabelEntity();
        doctorLabelEntity.setXId(UUIDUtil.getUUID());
        doctorLabelEntity.setXCreateTime(new Date());
        doctorLabelEntity.setXUpdateTime(new Date());
        doctorLabelEntity.setXVersion(Long.valueOf(0L));
        doctorLabelEntity.setAppCode(insertDoctorLabelReqVo.getAppCode());
        doctorLabelEntity.setDoctorId(insertDoctorLabelReqVo.getDoctorId());
        doctorLabelEntity.setLabelName(insertDoctorLabelReqVo.getLabelName());
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(insertDoctorLabelReqVo.getDoctorId());
        BaseResponse doctorDetailsVoBaseResponse = this.doctorClient.queryPersonnelInfo(queryPersonnelInfoReq);
        if (null == doctorDetailsVoBaseResponse || null == doctorDetailsVoBaseResponse.getData()) {
            return BaseResponse.error((String)"\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u533b\u751f\u51fa\u9519");
        }
        PersonnelInfo data = (PersonnelInfo)doctorDetailsVoBaseResponse.getData();
        doctorLabelEntity.setDoctorName(data.getDoctorName());
        doctorLabelEntity.setDeptId(data.getDeptId());
        doctorLabelEntity.setDeptName(data.getDeptName());
        doctorLabelEntity.setHospitalId(JSON.toJSONString((Object)data.getOrganId()));
        doctorLabelEntity.setHospitalName(data.getOrganName());
        doctorLabelEntity.setHospitalDeptName(insertDoctorLabelReqVo.getHospitalDeptName());
        doctorLabelEntity.setStatus(DoctorLabelEnum.NO_STICK.getValue());
        doctorLabelEntity.setDeptId(insertDoctorLabelReqVo.getDeptId());
        doctorLabelEntity.setDeptName(insertDoctorLabelReqVo.getDeptName());
        Integer count = this.doctorLabelMapper.insert((Object)doctorLabelEntity);
        if (count == 1) {
            return BaseResponse.success((Object)doctorLabelEntity.getXId());
        }
        return BaseResponse.error((String)"\u65b0\u589e\u533b\u751f\u6807\u7b7e\u5931\u8d25");
    }

    public IPage<DoctorLabelEntity> queryDoctorLabel(QueryDoctorLabelReqVo queryDoctorLabelReqVo) {
        log.info("\u67e5\u8be2\u533b\u751f\u6807\u7b7e\u63a5\u53e3\u5165\u53c2,queryDoctorLabel:{},", (Object)queryDoctorLabelReqVo.toString());
        Page page = new Page((long)queryDoctorLabelReqVo.getPageNum().intValue(), (long)queryDoctorLabelReqVo.getPageSize().intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        DoctorLabelEntity doctorLabelEntity = new DoctorLabelEntity();
        doctorLabelEntity.setHospitalId(queryDoctorLabelReqVo.getHospitalId());
        doctorLabelEntity.setAppCode(queryDoctorLabelReqVo.getAppCode());
        queryWrapper.setEntity((Object)doctorLabelEntity);
        return this.doctorLabelMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
    }
}

