/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctor.basedata.api.dto.UcUserEvaluationDTO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.model.EvaluationEntity;
import com.ebaiyihui.onlineoutpatient.core.service.AdmissionService;
import com.ebaiyihui.onlineoutpatient.core.service.EvaluationService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorUserEvaluationFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseEvaluationServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.utils.id.UUIDUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.AdmissionInfoParam;
import com.ebaiyihui.onlineoutpatient.core.vo.AdmissionInfoVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestEvaluationVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EvaluationServiceImpl
implements EvaluationService {
    private static final Logger log = LoggerFactory.getLogger(EvaluationServiceImpl.class);
    @Autowired
    private DoctorUserEvaluationFeignClient evaluationFeignClient;
    @Autowired
    private AdmissionService admissionService;
    @Autowired
    ProjProperties projProperties;
    @Autowired
    private IMInformService imInformService;
    @Autowired
    private BaseEvaluationServiceImpl baseEvaluationService;

    public BaseResponse addEvaluation(RequestEvaluationVo requestEvaluationVo) throws Exception {
        AdmissionInfoParam admissionInfoParam = new AdmissionInfoParam();
        admissionInfoParam.setAdmId(requestEvaluationVo.getAdmId());
        admissionInfoParam.setOrderId(requestEvaluationVo.getOrderId());
        AdmissionInfoVo admissionInfoVo = this.admissionService.findInfo(admissionInfoParam);
        log.info("admissionInfoVo:{}", (Object)JSON.toJSONString((Object)admissionInfoVo));
        if (null == admissionInfoVo) {
            return BaseResponse.error((String)"\u65b0\u589e\u8bc4\u4ef7\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
        }
        QueryWrapper evaluationWrapper = new QueryWrapper();
        EvaluationEntity evaluation = new EvaluationEntity();
        evaluation.setAdmId(admissionInfoVo.getAdmId());
        evaluation.setDisplay(new Integer(1).byteValue());
        evaluationWrapper.setEntity((Object)evaluation);
        List list = this.baseEvaluationService.list((Wrapper)evaluationWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            log.info("list{}", (Object)JSON.toJSONString((Object)list));
            return BaseResponse.success();
        }
        UcUserEvaluationDTO evaluationDTO = new UcUserEvaluationDTO();
        evaluationDTO.setAdmId(admissionInfoVo.getAdmId());
        evaluationDTO.setAppCode(admissionInfoVo.getAppCode());
        if (ServiceTypeEnum.NOS.getValue().equals(admissionInfoVo.getServType())) {
            evaluationDTO.setServCode(ServiceTypeEnum.NOS.getCode());
        } else {
            evaluationDTO.setServCode(ServiceTypeEnum.HOS.getCode());
        }
        evaluationDTO.setRemark(requestEvaluationVo.getRemark());
        evaluationDTO.setOrganId(admissionInfoVo.getOrganId());
        evaluationDTO.setDoctorId(admissionInfoVo.getDoctorId());
        evaluationDTO.setDoctorName(admissionInfoVo.getDoctorName());
        evaluationDTO.setEvalType(Byte.valueOf(admissionInfoVo.getDoctorType().byteValue()));
        evaluationDTO.setPatientName(admissionInfoVo.getPatientName());
        evaluationDTO.setPaitientId(admissionInfoVo.getPatientId());
        BeanUtils.copyProperties((Object)requestEvaluationVo, (Object)evaluationDTO);
        ArrayList<UcUserEvaluationDTO> ucUserEvaluationDtoS = new ArrayList<UcUserEvaluationDTO>();
        ucUserEvaluationDtoS.add(evaluationDTO);
        log.info("\u8bc4\u4ef7\u540c\u6b65\u5165\u53c2:{}", (Object)JSON.toJSONString(ucUserEvaluationDtoS));
        BaseResponse result = this.evaluationFeignClient.saveEvaluationMsg(ucUserEvaluationDtoS);
        log.info("\u540c\u6b65\u8bc4\u4ef7\u5230\u4e91\u4e0a\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)result));
        if (!result.isSuccess()) {
            log.error("\u540c\u6b65\u8bc4\u4ef7\u5230\u4e91\u4e0a\u5931\u8d25");
            return BaseResponse.error((String)"\u8bc4\u4ef7\u5931\u8d25");
        }
        EvaluationEntity evaluationEntity = new EvaluationEntity();
        BeanUtils.copyProperties((Object)evaluationDTO, (Object)evaluationEntity);
        evaluationEntity.setId(UUIDUtil.generateViewId());
        evaluationEntity.setDisplay(new Integer(1).byteValue());
        log.info("evaluationEntity{}", (Object)evaluationEntity.toString());
        this.baseEvaluationService.save((Object)evaluationEntity);
        Boolean flag = this.imInformService.pushEvaluationMessage(evaluationDTO);
        if (!flag.booleanValue()) {
            return BaseResponse.error((String)"\u8bc4\u4ef7\u5931\u8d25");
        }
        return BaseResponse.success();
    }
}

