/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsRes;
import com.ebaiyihui.onlineoutpatient.common.vo.GetPayRecordDetailReq;
import com.ebaiyihui.onlineoutpatient.common.vo.GetPayRecordDetailRes;
import com.ebaiyihui.onlineoutpatient.common.vo.RegisteredRecordResVo;
import com.ebaiyihui.onlineoutpatient.common.vo.ReportReq;
import com.ebaiyihui.onlineoutpatient.common.vo.ReportRes;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.utils.IDCardUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.AdmissionOrCancellationReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.AdmissionOrCancellationResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.HisDeptAndDocCodeVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RegisteredRecordReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.UnregisterPayMethodReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.UnregisterPayMethodResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.CardVerificationAndInfoReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.CardVerificationAndInfoResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.GetHangRecordDisposalReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.GetHangRecordDisposalResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.GetHangRecordReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.HangUpItemVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.PreSettlementReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.PreSettlementResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.RegisteredSaveResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.RegistrationConfirmReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.RegistrationConfirmResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.UnregisterReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.UnregisterResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.recommService.GetAppointMentReqVO;
import com.ebaiyihui.onlineoutpatient.core.vo.recommService.GetAppointMentResVO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HisTemplateServiceImpl
implements HisTemplateService {
    private static final Logger log = LoggerFactory.getLogger(HisTemplateServiceImpl.class);
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;

    public List<RegisteredRecordResVo> getRegisteredRecord(String patientIdCard, String patientName, String deptName, String hisUrl, String deptId, String doctorId, String cardNo, String appCode) {
        log.info("his\u8bf7\u6c42url:" + hisUrl);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String edTime = format.format(new Date());
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        if ("MZJH".equals(appCode)) {
            c.add(2, -2);
        } else {
            c.add(2, -6);
        }
        Date m3 = c.getTime();
        String bgDate = format.format(m3);
        HisDeptAndDocCodeVo hisDeptAndDocCode = this.internetHospitalDetailInfoService.getHisDeptAndDocCode(deptId, doctorId);
        if (null == hisDeptAndDocCode) {
            log.info("\u533b\u751f\u670d\u52a1\u8c03\u7528\u5931\u8d25");
            return new ArrayList<RegisteredRecordResVo>();
        }
        log.info("hisDeptAndDocCode:" + JSON.toJSONString((Object)hisDeptAndDocCode));
        RegisteredRecordReqVo registeredRecordReqVo = new RegisteredRecordReqVo();
        registeredRecordReqVo.setDeptName(deptName);
        registeredRecordReqVo.setPatientIdCard(patientIdCard);
        registeredRecordReqVo.setPatientName(patientName);
        registeredRecordReqVo.setDoctorCode(hisDeptAndDocCode.getDoctorCode());
        registeredRecordReqVo.setDeptCode(hisDeptAndDocCode.getDeptCode());
        registeredRecordReqVo.setBgDate(bgDate);
        registeredRecordReqVo.setEdDate(edTime);
        registeredRecordReqVo.setCardNo(cardNo);
        registeredRecordReqVo.setDoctorName(hisDeptAndDocCode.getDoctorName());
        log.info("his\u67e5\u770b\u60a3\u8005\u662f\u5426\u590d\u8bca\u5165\u53c2{}:" + registeredRecordReqVo.toString());
        FrontRequest checkReqVoFrontRequest = new FrontRequest();
        checkReqVoFrontRequest.setBody((Object)registeredRecordReqVo);
        checkReqVoFrontRequest.setTransactionId(UUIDUtils.getUUID());
        try {
            String result = HttpKit.jsonPost((String)hisUrl, (String)JSON.toJSONString((Object)checkReqVoFrontRequest));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("his\u8fd4\u56defontResponse:{}", (Object)JSON.toJSONString((Object)frontResponse));
            if (null == frontResponse || "0".equals(frontResponse.getCode())) {
                return null;
            }
            List registeredRecordList = JSON.parseArray((String)JSON.toJSONString((Object)frontResponse.getBody()), RegisteredRecordResVo.class);
            log.info("registeredRecordList:{}", (Object)JSON.toJSONString((Object)registeredRecordList));
            for (RegisteredRecordResVo r : registeredRecordList) {
                String gender;
                log.info("---------regDate\u4e3a\u7a7a,admDate\u4e0d\u4e3a\u7a7a--------");
                if (StringUtils.isEmpty((String)r.getRegDate()) && StringUtils.isNotEmpty((String)r.getAdmDate())) {
                    log.info("---------regDate\u8d4b\u503c\u4e3aadmDate--------");
                    r.setRegDate(r.getAdmDate());
                }
                if (StringUtils.isEmpty((String)r.getDoctName()) && StringUtils.isNotEmpty((String)r.getDocName())) {
                    log.info("---------doctName\u8d4b\u503c\u4e3adocName--------");
                    r.setDoctName(r.getDocName());
                    if ("NDSFY".equals(appCode)) {
                        r.setDoctName(r.getDoctorName());
                    }
                }
                if (r.getRegDate().contains("/")) {
                    r.setRegToDate(DateUtils.stringToFullDateUtil((String)r.getRegDate()));
                } else {
                    r.setRegToDate(DateUtils.stringToFullDateUtil1((String)r.getRegDate()));
                }
                if (r.getRegDate().contains("/")) {
                    String date = r.getRegDate().replaceAll("/", "-");
                    log.info("date:" + date);
                    String dateTemp = DateUtils.getDate((String)date);
                    log.info("dateTemp:" + dateTemp);
                    r.setRegDate(dateTemp);
                }
                gender = (gender = IDCardUtil.getGender((String)patientIdCard)).equals("\u7537") ? "1" : "2";
                r.setName(patientName);
                r.setAge(IDCardUtil.getAge((String)patientIdCard).toString());
                r.setSex(gender);
            }
            log.info("his\u67e5\u770b\u60a3\u8005\u662f\u5426\u590d\u8bca\u51fa\u53c2\u8fd4\u56de\u503c:{}", (Object)JSON.toJSONString((Object)registeredRecordList));
            return registeredRecordList;
        }
        catch (Exception e) {
            log.error("his\u67e5\u770b\u60a3\u8005\u662f\u5426\u590d\u8bca" + e.getMessage());
            return null;
        }
    }

    public PreSettlementResVo preSettlement(PreSettlementReqVo preSettlementReqVo) {
        String url = this.projProperties.getPreSettlement();
        FrontRequest preSettlementReqFrontRequest = new FrontRequest();
        preSettlementReqFrontRequest.setBody((Object)preSettlementReqVo);
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)preSettlementReqFrontRequest));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("his\u9884\u7ed3\u7b97\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)frontResponse));
            PreSettlementResVo preSettlementRes = (PreSettlementResVo)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), PreSettlementResVo.class);
            log.info("his\u9884\u7ed3\u7b97\u51fa\u53c2:{}" + JSONObject.toJSONString((Object)preSettlementRes));
            return preSettlementRes;
        }
        catch (Exception e) {
            log.error("his\u9884\u7ed3\u7b97\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public RegistrationConfirmResVo registrationConfirmation(RegistrationConfirmReqVo registrationConfirmResVo) {
        String url = this.projProperties.getRegistrationConfirmation();
        FrontRequest registrationConfirmFrontRequest = new FrontRequest();
        registrationConfirmFrontRequest.setBody((Object)registrationConfirmResVo);
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)registrationConfirmFrontRequest));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("his\u786e\u8ba4\u6302\u53f7\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)frontResponse));
            RegistrationConfirmResVo registrationConfirmRes = (RegistrationConfirmResVo)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), RegistrationConfirmResVo.class);
            log.info("his\u786e\u8ba4\u6302\u53f7\u51fa\u53c2:{}" + JSONObject.toJSONString((Object)registrationConfirmRes));
            return registrationConfirmRes;
        }
        catch (Exception e) {
            log.error("his\u786e\u8ba4\u6302\u53f7\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public UnregisterResVo unregister(UnregisterReqVo unregisterReqVo) {
        String url = this.projProperties.getUnregister();
        FrontRequest unregisterReqRequest = new FrontRequest();
        unregisterReqRequest.setBody((Object)unregisterReqVo);
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)unregisterReqRequest));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("his\u9000\u53f7\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)frontResponse));
            UnregisterResVo unregisterResVo = (UnregisterResVo)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), UnregisterResVo.class);
            log.info("his\u9000\u53f7\u51fa\u53c2:{}" + JSONObject.toJSONString((Object)unregisterResVo));
            return unregisterResVo;
        }
        catch (Exception e) {
            log.error("his\u9000\u53f7\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public RegisteredSaveResVo registeredSave(PreSettlementReqVo registeredSaveReqVo) {
        String url = this.projProperties.getRegisteredSave();
        FrontRequest preSettlementRequest = new FrontRequest();
        preSettlementRequest.setBody((Object)registeredSaveReqVo);
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)preSettlementRequest));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("his\u6302\u53f7\u4fdd\u5b58\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)frontResponse));
            RegisteredSaveResVo registeredSaveResVo = (RegisteredSaveResVo)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), RegisteredSaveResVo.class);
            log.info("his\u6302\u53f7\u4fdd\u5b58\u51fa\u53c2:{}" + JSONObject.toJSONString((Object)registeredSaveResVo));
            return registeredSaveResVo;
        }
        catch (Exception e) {
            log.error("his\u6302\u53f7\u4fdd\u5b58\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public HangUpItemVo getHangRecord(GetHangRecordReqVo hangRecordReqVo) {
        String url = this.projProperties.getHangRecord();
        FrontRequest hangRecordRequest = new FrontRequest();
        hangRecordRequest.setBody((Object)hangRecordReqVo);
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)hangRecordRequest));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("his\u6302\u8d77\u67e5\u8be2\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)frontResponse));
            HangUpItemVo hangUpItemResVo = (HangUpItemVo)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), HangUpItemVo.class);
            log.info("his\u6302\u8d77\u67e5\u8be2\u51fa\u53c2:{}" + JSONObject.toJSONString((Object)hangUpItemResVo));
            return hangUpItemResVo;
        }
        catch (Exception e) {
            log.error("his\u6302\u8d77\u67e5\u8be2\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public GetHangRecordDisposalResVo getHangRecordDisposal(GetHangRecordDisposalReqVo hangRecordDisposalReqVo) {
        String url = this.projProperties.getHangRecordDisposal();
        FrontRequest hangRecordDisposalRequest = new FrontRequest();
        hangRecordDisposalRequest.setBody((Object)hangRecordDisposalReqVo);
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)hangRecordDisposalRequest));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("his\u6302\u8d77\u5904\u7f6e\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)frontResponse));
            GetHangRecordDisposalResVo hangRecordDisposalResVo = (GetHangRecordDisposalResVo)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), GetHangRecordDisposalResVo.class);
            log.info("his\u6302\u8d77\u5904\u7f6e\u51fa\u53c2:{}" + JSONObject.toJSONString((Object)hangRecordDisposalResVo));
            return hangRecordDisposalResVo;
        }
        catch (Exception e) {
            log.error("his\u6302\u8d77\u5904\u7f6e\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public CardVerificationAndInfoResVo getCardVerificationAndInfo(CardVerificationAndInfoReqVo cardVerificationAndInfoReqVo) {
        String url = this.projProperties.getCardVerificationAndInfo();
        FrontRequest cardVerificationAndInfoRequest = new FrontRequest();
        cardVerificationAndInfoRequest.setBody((Object)cardVerificationAndInfoReqVo);
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)cardVerificationAndInfoRequest));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("his\u5361\u8be6\u60c5\u548c\u6821\u9a8c\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)frontResponse));
            CardVerificationAndInfoResVo cardVerificationAndInfoResVo = (CardVerificationAndInfoResVo)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), CardVerificationAndInfoResVo.class);
            log.info("his\u5361\u8be6\u60c5\u548c\u6821\u9a8c\u51fa\u53c2:{}" + JSONObject.toJSONString((Object)cardVerificationAndInfoResVo));
            return cardVerificationAndInfoResVo;
        }
        catch (Exception e) {
            log.error("his\u5361\u8be6\u60c5\u548c\u6821\u9a8c\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public AdmissionOrCancellationResVo admissionOrCancellation(AdmissionOrCancellationReqVo admissionOrCancelRequest) {
        String url = this.projProperties.getHisUrl() + "onlineOutpatient/doctorReceiveCancel";
        FrontRequest admissionOrCancellationReqVoFrontRequest = new FrontRequest();
        admissionOrCancellationReqVoFrontRequest.setBody((Object)admissionOrCancelRequest);
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)admissionOrCancellationReqVoFrontRequest));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("his\u63a5\u8bca/\u53d6\u6d88\u63a5\u8bca\u8fd4\u56de\u503c:{}", (Object)JSONObject.toJSONString((Object)frontResponse));
            AdmissionOrCancellationResVo admissionOrCancellationResVo = (AdmissionOrCancellationResVo)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), AdmissionOrCancellationResVo.class);
            log.info("his\u63a5\u8bca/\u53d6\u6d88\u63a5\u8bca\u51fa\u53c2:{}", (Object)JSONObject.toJSONString((Object)admissionOrCancellationResVo));
            return admissionOrCancellationResVo;
        }
        catch (Exception e) {
            log.error("his\u63a5\u8bca/\u53d6\u6d88\u63a5\u8bca\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public UnregisterPayMethodResVo unregisterPayMethod(UnregisterPayMethodReqVo unregisterPayMethodRequest) {
        String url = this.projProperties.getUnregisterPayMethod();
        FrontRequest unregisterPayMethod = new FrontRequest();
        unregisterPayMethod.setBody((Object)unregisterPayMethodRequest);
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)unregisterPayMethod));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("\u9000\u53f7\u56de\u5199\u652f\u4ed8\u65b9\u5f0f\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)frontResponse));
            UnregisterPayMethodResVo unregisterPayMethodResVo = (UnregisterPayMethodResVo)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), UnregisterPayMethodResVo.class);
            log.info("\u9000\u53f7\u56de\u5199\u652f\u4ed8\u65b9\u5f0f\u51fa\u53c2:{}" + JSONObject.toJSONString((Object)unregisterPayMethodResVo));
            return unregisterPayMethodResVo;
        }
        catch (Exception e) {
            log.error("\u9000\u53f7\u56de\u5199\u652f\u4ed8\u65b9\u5f0f\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public ReportRes getReportList(ReportReq reportReq) {
        String url = this.projProperties.getLisAndPacsReport();
        FrontRequest reportReqFrontRequest = new FrontRequest();
        reportReqFrontRequest.setBody((Object)reportReq);
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)reportReqFrontRequest));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("\u68c0\u9a8c\u68c0\u67e5\u5408\u5e76\u62a5\u544a\u5217\u8868\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)frontResponse));
            ReportRes reportRes = (ReportRes)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), ReportRes.class);
            log.info("\u68c0\u9a8c\u68c0\u67e5\u5408\u5e76\u62a5\u544a\u5217\u8868\u51fa\u53c2:{}" + JSONObject.toJSONString((Object)reportRes));
            return reportRes;
        }
        catch (Exception e) {
            log.error("\u68c0\u9a8c\u68c0\u67e5\u5408\u5e76\u62a5\u544a\u5217\u8868\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public GetReportListsRes YcGetReportList(ReportReq reportReq) {
        String url = this.projProperties.getLisAndPacsReport();
        FrontRequest reportReqFrontRequest = new FrontRequest();
        reportReqFrontRequest.setBody((Object)reportReq);
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)reportReqFrontRequest));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("\u5b9c\u6625\u68c0\u9a8c\u68c0\u67e5\u5408\u5e76\u62a5\u544a\u5217\u8868\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)frontResponse));
            GetReportListsRes reportRes = (GetReportListsRes)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), GetReportListsRes.class);
            log.info("\u5b9c\u6625\u68c0\u9a8c\u68c0\u67e5\u5408\u5e76\u62a5\u544a\u5217\u8868\u51fa\u53c2:{}" + JSONObject.toJSONString((Object)reportRes));
            return reportRes;
        }
        catch (Exception e) {
            log.error("\u5b9c\u6625\u68c0\u9a8c\u68c0\u67e5\u5408\u5e76\u62a5\u544a\u5217\u8868\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public GetPayRecordDetailRes getReportAndDragList(GetPayRecordDetailReq getPayRecordDetailReq) {
        String url = this.projProperties.getReportAndDragList();
        FrontRequest reportReqFrontRequest = new FrontRequest();
        reportReqFrontRequest.setBody((Object)getPayRecordDetailReq);
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)reportReqFrontRequest));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("\u836f\u54c1\u548c\u68c0\u9a8c\u68c0\u67e5\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)frontResponse));
            GetPayRecordDetailRes payRecordDetailRes = (GetPayRecordDetailRes)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), GetPayRecordDetailRes.class);
            log.info("\u836f\u54c1\u548c\u68c0\u9a8c\u68c0\u67e5\u51fa\u53c2:{}" + JSONObject.toJSONString((Object)payRecordDetailRes));
            return payRecordDetailRes;
        }
        catch (Exception e) {
            log.error("\u836f\u54c1\u548c\u68c0\u9a8c\u68c0\u67e5\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public GetAppointMentResVO getAppointMent(GetAppointMentReqVO getAppointMentReqVO) {
        String url = this.projProperties.getAppointment();
        FrontRequest request = new FrontRequest();
        request.setBody((Object)getAppointMentReqVO);
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)request));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("\u67e5\u9884\u7ea6\u6302\u53f7\u53f7\u6e90\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)frontResponse));
            GetAppointMentResVO getAppointMentResVO = (GetAppointMentResVO)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), GetAppointMentResVO.class);
            log.info("\u67e5\u9884\u7ea6\u6302\u53f7\u53f7\u6e90\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)getAppointMentResVO));
            return getAppointMentResVO;
        }
        catch (Exception e) {
            log.error("\u67e5\u53f7\u6e90\u5931\u8d25" + e.getMessage());
            return null;
        }
    }
}

