/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.doctoruser.api.common.enums.DoctorTypeEnum;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.WorkInfoVo;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.dto.DoctorScheduleDTO;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.common.vo.DoctorScheduleDataVo;
import com.ebaiyihui.onlineoutpatient.common.vo.DoctorScheduleVo;
import com.ebaiyihui.onlineoutpatient.common.vo.DoctorScheduleWeekVo;
import com.ebaiyihui.onlineoutpatient.common.vo.ServiceConfigVo;
import com.ebaiyihui.onlineoutpatient.common.vo.schedulerecord.ScheduleVo;
import com.ebaiyihui.onlineoutpatient.common.vo.serviceconfig.DoctorInfoVo;
import com.ebaiyihui.onlineoutpatient.common.vo.serviceconfig.RequestGetDoctorOfficeStatus;
import com.ebaiyihui.onlineoutpatient.common.vo.serviceconfig.RequestOnlineOrOfflineVo;
import com.ebaiyihui.onlineoutpatient.common.vo.serviceconfig.RequestServiceConfigListNewVo;
import com.ebaiyihui.onlineoutpatient.common.vo.serviceconfig.RequestServiceConfigListVo;
import com.ebaiyihui.onlineoutpatient.common.vo.serviceconfig.RequestServiceConfigVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ScheduleRecordEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.DoctorPoolMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ScheduleRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.DoctorOfficeEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryServiceConfigEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ScheduleTimeIntervalEntity;
import com.ebaiyihui.onlineoutpatient.core.service.DoctorTemInfomService;
import com.ebaiyihui.onlineoutpatient.core.service.InquiryServiceConfigService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorUserEvaluationFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorWorkFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.JSGYInquiryServiceConfigClient;
import com.ebaiyihui.onlineoutpatient.core.service.doctor.DoctorService;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseDoctorOfficeServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryAdmissionServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryServiceConfigServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseScheduleTimeIntervalServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.id.UUIDUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.workservice.GetDocServiceConfigReq;
import com.ebaiyihui.onlineoutpatient.core.vo.workservice.UpdateNoticeVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class InquiryServiceConfigServiceImpl
implements InquiryServiceConfigService {
    private static final Logger log = LoggerFactory.getLogger(InquiryServiceConfigServiceImpl.class);
    @Resource
    private BaseInquiryServiceConfigServiceImpl baseService;
    @Resource
    private DoctorWorkFeignClient doctorWorkFeignClient;
    @Autowired
    private DoctorInfofeignClient doctorCilent;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private BaseInquiryAdmissionServiceImpl baseInquiryAdmissionService;
    @Autowired
    private DoctorUserEvaluationFeignClient doctorUserEvaluationFeignClient;
    @Autowired
    private BaseScheduleTimeIntervalServiceImpl timeIntervalService;
    @Autowired
    private BaseDoctorOfficeServiceImpl baseDoctorOfficeService;
    @Autowired
    private DoctorService doctorService;
    @Autowired
    private DoctorTemInfomService doctorTemInfomService;
    @Autowired
    private DoctorPoolMapper doctorPoolMapper;
    @Autowired
    private JSGYInquiryServiceConfigClient jsgyInquiryServiceConfigClient;
    private Integer IS_SCHEDULE1 = 2;
    private Integer IS_SCHEDULE2 = 3;

    public ResultData<ServiceConfigVo> getDoctorServiceInfo(GetDocServiceConfigReq req) {
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
        wrapperEntity.setDoctorId(req.getDoctorId());
        wrapperEntity.setOrganId(req.getOrganId());
        if (ServiceTypeEnum.NOS.getValue().equals(req.getServType())) {
            wrapperEntity.setDeptId(Long.valueOf(Long.parseLong(req.getDeptId())));
            wrapperEntity.setServiceCode(ServiceTypeEnum.NOS.getCode());
        }
        if (ServiceTypeEnum.HOS.getValue().equals(req.getServType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.HOS.getCode());
        }
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        InquiryServiceConfigEntity inquiryServiceConfigEntity = (InquiryServiceConfigEntity)this.baseService.getOne((Wrapper)queryWrapper);
        if (null == inquiryServiceConfigEntity) {
            return new ResultData().error("\u672a\u67e5\u8be2\u5230\u533b\u751f\u670d\u52a1\u914d\u7f6e\u4fe1\u606f");
        }
        ServiceConfigVo serviceConfigVo = new ServiceConfigVo();
        BeanUtils.copyProperties((Object)inquiryServiceConfigEntity, (Object)serviceConfigVo);
        return new ResultData().success((Object)serviceConfigVo);
    }

    private InquiryServiceConfigEntity getInquiryServiceConfig(RequestServiceConfigVo serviceConfigVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
        wrapperEntity.setDoctorId(serviceConfigVo.getDoctorId());
        wrapperEntity.setServiceCode(serviceConfigVo.getServiceCode());
        if (serviceConfigVo.getServiceCode().equals(ServiceTypeEnum.NOS.getCode())) {
            wrapperEntity.setDeptId(serviceConfigVo.getDeptId());
        }
        wrapperEntity.setOrganId(serviceConfigVo.getOrganId());
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        InquiryServiceConfigEntity inquiryServiceConfigEntity = (InquiryServiceConfigEntity)this.baseService.getOne((Wrapper)queryWrapper);
        return inquiryServiceConfigEntity;
    }

    private DoctorOfficeEntity getDoctorOffice(RequestServiceConfigVo serviceConfigVo) {
        QueryWrapper queryWrapperDoc = new QueryWrapper();
        DoctorOfficeEntity wrapperEntityDoc = new DoctorOfficeEntity();
        wrapperEntityDoc.setDoctorId(serviceConfigVo.getDoctorId());
        wrapperEntityDoc.setHospitalId(serviceConfigVo.getOrganId());
        wrapperEntityDoc.setAppCode(serviceConfigVo.getAppCode());
        queryWrapperDoc.setEntity((Object)wrapperEntityDoc);
        queryWrapperDoc.last("limit 1");
        DoctorOfficeEntity doctorOffice = (DoctorOfficeEntity)this.baseDoctorOfficeService.getOne((Wrapper)queryWrapperDoc);
        return doctorOffice;
    }

    public BaseResponse<Object> saveServiceInfo(RequestServiceConfigVo serviceConfigVo) {
        InquiryServiceConfigEntity inquiryServiceConfigEntity = this.getInquiryServiceConfig(serviceConfigVo);
        InquiryServiceConfigEntity entity = new InquiryServiceConfigEntity();
        if (null == inquiryServiceConfigEntity) {
            BeanUtils.copyProperties((Object)serviceConfigVo, (Object)entity);
            if (0 == serviceConfigVo.getNumLimit() || null == serviceConfigVo.getNumLimit() || -1 == serviceConfigVo.getNumLimit()) {
                entity.setNumLimit(Integer.valueOf(999));
            } else {
                entity.setNumLimit(serviceConfigVo.getNumLimit());
            }
            if (0 == serviceConfigVo.getServTime() || null == serviceConfigVo.getServTime() || -1 == serviceConfigVo.getServTime()) {
                entity.setServTime(Integer.valueOf(1440));
            } else {
                entity.setServTime(serviceConfigVo.getServTime());
            }
            if (0 == serviceConfigVo.getDailyLimit() || null == serviceConfigVo.getDailyLimit() || -1 == serviceConfigVo.getDailyLimit()) {
                entity.setDailyLimit(Integer.valueOf(120));
            } else {
                entity.setDailyLimit(serviceConfigVo.getDailyLimit());
            }
            if (0 == serviceConfigVo.getOrderTime() || null == serviceConfigVo.getOrderTime() || -1 == serviceConfigVo.getOrderTime()) {
                entity.setOrderTime(Integer.valueOf(1440));
            } else {
                entity.setOrderTime(serviceConfigVo.getOrderTime());
            }
            entity.setOfficeStatus(Integer.valueOf(1));
            entity.setXId(UUIDUtil.getUUID());
            log.info("\u6dfb\u52a0\u533b\u751f\u670d\u52a1\u4fe1\u606fentity: {}", (Object)entity);
            this.baseService.save((Object)entity);
            DoctorOfficeEntity doctorOffice = this.getDoctorOffice(serviceConfigVo);
            if (null == doctorOffice) {
                DoctorOfficeEntity doctorOfficeEntity = new DoctorOfficeEntity();
                doctorOfficeEntity.setAppCode(serviceConfigVo.getAppCode());
                doctorOfficeEntity.setDoctorId(serviceConfigVo.getDoctorId());
                doctorOfficeEntity.setHospitalId(serviceConfigVo.getOrganId());
                doctorOfficeEntity.setEndOfficeTime(serviceConfigVo.getEndOfficeTime());
                if (ServiceTypeEnum.NOS.getCode().equals(serviceConfigVo.getServiceCode())) {
                    doctorOfficeEntity.setServType(ServiceTypeEnum.NOS.getValue());
                }
                if (ServiceTypeEnum.HOS.getCode().equals(serviceConfigVo.getServiceCode())) {
                    doctorOfficeEntity.setServType(ServiceTypeEnum.HOS.getValue());
                }
                doctorOfficeEntity.setOfficeStatus(Integer.valueOf(1));
                doctorOfficeEntity.setStartOfficeTime(serviceConfigVo.getStartOfficeTime());
                doctorOfficeEntity.setId(UUIDUtil.getUUID());
                doctorOfficeEntity.setStatus(Integer.valueOf(1));
                this.baseDoctorOfficeService.save((Object)doctorOfficeEntity);
            }
            if (ServiceTypeEnum.QOS.getCode().equals(serviceConfigVo.getServiceCode())) {
                this.jsgyInquiryServiceConfigClient.saveServiceInfo(serviceConfigVo);
            }
            return BaseResponse.success((Object)"\u65b0\u589e\u533b\u751f\u670d\u52a1\u4fe1\u606f\u6210\u529f");
        }
        BeanUtils.copyProperties((Object)serviceConfigVo, (Object)entity);
        log.info("\u67e5\u8be2\u5230\u670d\u52a1\u4fe1\u606fid\uff1a" + inquiryServiceConfigEntity.getXId());
        entity.setXId(inquiryServiceConfigEntity.getXId());
        if (0 == serviceConfigVo.getNumLimit() || null == serviceConfigVo.getNumLimit() || -1 == serviceConfigVo.getNumLimit()) {
            entity.setNumLimit(Integer.valueOf(999));
        } else {
            entity.setNumLimit(serviceConfigVo.getNumLimit());
        }
        if (0 == serviceConfigVo.getServTime() || null == serviceConfigVo.getServTime() || -1 == serviceConfigVo.getServTime()) {
            entity.setServTime(Integer.valueOf(1440));
        } else {
            entity.setServTime(serviceConfigVo.getServTime());
        }
        if (0 == serviceConfigVo.getDailyLimit() || null == serviceConfigVo.getDailyLimit() || -1 == serviceConfigVo.getDailyLimit()) {
            entity.setDailyLimit(Integer.valueOf(120));
        } else {
            entity.setDailyLimit(serviceConfigVo.getDailyLimit());
        }
        if (0 == serviceConfigVo.getOrderTime() || null == serviceConfigVo.getOrderTime() || -1 == serviceConfigVo.getOrderTime()) {
            entity.setOrderTime(Integer.valueOf(1440));
        } else {
            entity.setOrderTime(serviceConfigVo.getOrderTime());
        }
        entity.setStatus(serviceConfigVo.getStatus());
        log.info("\u4fee\u6539\u533b\u751f\u670d\u52a1\u4fe1\u606fentity: {}", (Object)entity);
        this.baseService.update((Object)entity, (Wrapper)new UpdateWrapper().eq((Object)"x_id", (Object)inquiryServiceConfigEntity.getXId()));
        if (ServiceTypeEnum.QOS.getCode().equals(serviceConfigVo.getServiceCode())) {
            this.jsgyInquiryServiceConfigClient.saveServiceInfo(serviceConfigVo);
        }
        return BaseResponse.success((Object)"\u4fee\u6539\u533b\u751f\u670d\u52a1\u4fe1\u606f\u6210\u529f");
    }

    public BaseResponse<String> updateNoticeForDoctorApp(UpdateNoticeVo req) {
        return null;
    }

    private BaseResponse<Object> updateServiceInfo(InquiryServiceConfigEntity entity) {
        Boolean count;
        if (StringUtils.isEmpty((Object)entity.getXId())) {
            return BaseResponse.error((String)"x_id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InquiryServiceConfigEntity serviceEntity = (InquiryServiceConfigEntity)this.baseService.getById((Serializable)((Object)entity.getXId()));
        if (null == serviceEntity) {
            log.error("\u67e5\u8be2\u533b\u751f\u670d\u52a1\u5728\u7ebf\u54a8\u8be2/\u5728\u7ebf\u95e8\u8bca\u4e1a\u52a1\u4fe1\u606f\u5931\u8d25,\u53c2\u6570={}", (Object)entity.toString());
            return BaseResponse.error((String)"\u67e5\u8be2\u65e0\u4e1a\u52a1\u4fe1\u606f");
        }
        serviceEntity.setDailyLimit(entity.getDailyLimit() == null ? serviceEntity.getDailyLimit() : entity.getDailyLimit());
        if (null != entity.getPrice()) {
            serviceEntity.setPrice(entity.getPrice());
        }
        if (null != entity.getServTime()) {
            serviceEntity.setServTime(entity.getServTime());
        }
        if (null != entity.getNumLimit()) {
            serviceEntity.setNumLimit(entity.getNumLimit());
        }
        if (null != entity.getNotice()) {
            serviceEntity.setNotice(entity.getNotice());
        }
        if (!(count = Boolean.valueOf(this.baseService.updateById((Object)serviceEntity))).booleanValue()) {
            return BaseResponse.error((String)"\u4fee\u6539\u5931\u8d25");
        }
        return BaseResponse.success();
    }

    private List<InquiryServiceConfigEntity> getInquiryService(DoctorScheduleDTO req) {
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
        wrapperEntity.setDoctorId(req.getDoctorId());
        wrapperEntity.setOrganId(req.getOrganId());
        if (ServiceTypeEnum.NOS.getValue().equals(req.getType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.NOS.getCode());
        }
        if (ServiceTypeEnum.HOS.getValue().equals(req.getType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.HOS.getCode());
        }
        if (ServiceTypeEnum.BMMZ.getValue().equals(req.getType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.BMMZ.getCode());
        }
        queryWrapper.setEntity((Object)wrapperEntity);
        return this.baseService.list((Wrapper)queryWrapper);
    }

    private BaseResponse<PersonnelInfo> getDoctorInfo(DoctorScheduleDTO req) {
        DoctorScheduleVo doctorScheduleVo = new DoctorScheduleVo();
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(req.getDoctorId());
        BaseResponse doctorDetailsVoBaseResponse = this.doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
        return doctorDetailsVoBaseResponse;
    }

    public BaseResponse<DoctorScheduleVo> getDoctorSpread(DoctorScheduleDTO req) {
        DoctorScheduleVo doctorScheduleVo = new DoctorScheduleVo();
        BaseResponse doctorDetailsVoBaseResponse = this.getDoctorInfo(req);
        if (null == doctorDetailsVoBaseResponse || null == doctorDetailsVoBaseResponse.getData()) {
            log.error("\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u533b\u751f\u51fa\u9519{}", (Object)JSON.toJSONString((Object)doctorDetailsVoBaseResponse.toString()));
            return BaseResponse.error((String)"\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u533b\u751f\u51fa\u9519");
        }
        PersonnelInfo data = (PersonnelInfo)doctorDetailsVoBaseResponse.getData();
        if (null == data) {
            log.error("\u533b\u751f\u4fe1\u606f\u4e0d\u5b58\u5728");
            return BaseResponse.error((String)"\u533b\u751f\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        doctorScheduleVo.setXId(Long.valueOf(Long.parseLong(data.getDoctorId())));
        doctorScheduleVo.setDoctorName(data.getDoctorName());
        doctorScheduleVo.setOrganName(data.getOrganName());
        doctorScheduleVo.setOrganId(Long.valueOf(Long.parseLong(data.getOrganId().toString())));
        doctorScheduleVo.setPortrait(data.getPortrait());
        doctorScheduleVo.setIntroduction(data.getIntroduction());
        doctorScheduleVo.setProfession(data.getProfession());
        doctorScheduleVo.setTitleName(data.getTitle());
        doctorScheduleVo.setDeptName(data.getDeptName());
        doctorScheduleVo.setStdSecondDeptId(data.getStdSecondDeptId());
        doctorScheduleVo.setDeptId(Long.valueOf(data.getDeptId().longValue()));
        BaseResponse res = this.doctorWorkFeignClient.getDoctorAuthInfo(Long.valueOf(req.getDoctorId()));
        log.info("\u533b\u751f\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c{}\uff0corganCode={}", (Object)JSON.toJSONString((Object)res), (Object)((WorkInfoVo)res.getData()).getOrganCode());
        if (null == res.getData()) {
            log.error("getDoctorAuthInfo\u67e5\u8be2\u533b\u751f\u51fa\u9519{}", (Object)JSON.toJSONString((Object)res));
            return BaseResponse.error((String)"\u67e5\u8be2\u533b\u751f\u51fa\u9519");
        }
        List inquiryServiceConfigEntity = this.getInquiryService(req);
        if (CollectionUtils.isEmpty((Collection)inquiryServiceConfigEntity)) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8be5\u533b\u751f\u4e1a\u52a1\u8bbe\u7f6e\u4fe1\u606f!");
        }
        log.info("inquiryServiceConfigEntity{}", (Object)JSON.toJSONString((Object)inquiryServiceConfigEntity));
        for (InquiryServiceConfigEntity inquiryService : inquiryServiceConfigEntity) {
            if (!req.getDeptId().toString().equals(inquiryService.getDeptId().toString())) continue;
            ScheduleVo scheduleVo = new ScheduleVo();
            BeanUtils.copyProperties((Object)inquiryService, (Object)scheduleVo);
            scheduleVo.setIsSchedule(inquiryService.getIsSchedule().toString());
            log.info("\u533b\u751f\u7684\u670d\u52a1\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)inquiryServiceConfigEntity));
            doctorScheduleVo.setScheduleVo(scheduleVo);
        }
        BaseResponse docIsLearder = this.doctorTemInfomService.getDocIsLearder(req.getDoctorId(), req.getOrganId());
        List personTeamNew = this.doctorTemInfomService.getPersonTeamNew(req.getDoctorId());
        if (docIsLearder.isSuccess() && ((Boolean)docIsLearder.getData()).booleanValue() && personTeamNew != null) {
            doctorScheduleVo.setDoctorType(DoctorTypeEnum.TEAM.getValue());
        } else {
            doctorScheduleVo.setDoctorType(DoctorTypeEnum.PERSONAL.getValue());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
        wrapperEntity.setDoctorId(req.getDoctorId());
        wrapperEntity.setOrganId(req.getOrganId());
        if (ServiceTypeEnum.NOS.getValue().equals(req.getType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.NOS.getCode());
            wrapperEntity.setDeptId(Long.valueOf(req.getDeptId().longValue()));
        }
        if (ServiceTypeEnum.HOS.getValue().equals(req.getType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.HOS.getCode());
        }
        if (ServiceTypeEnum.BMMZ.getValue().equals(req.getType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.BMMZ.getCode());
            wrapperEntity.setDeptId(Long.valueOf(req.getDeptId().longValue()));
        }
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        InquiryServiceConfigEntity entity = (InquiryServiceConfigEntity)this.baseService.getOne((Wrapper)queryWrapper);
        log.info("entity:{}", (Object)entity.toString());
        doctorScheduleVo.setHaveSchedule(entity.getIsSchedule());
        RequestGetDoctorOfficeStatus requestGetDoctorOfficeStatus = new RequestGetDoctorOfficeStatus();
        requestGetDoctorOfficeStatus.setAppCode(((InquiryServiceConfigEntity)inquiryServiceConfigEntity.get(0)).getAppCode());
        requestGetDoctorOfficeStatus.setDoctorId(((InquiryServiceConfigEntity)inquiryServiceConfigEntity.get(0)).getDoctorId());
        requestGetDoctorOfficeStatus.setHospitalId(((InquiryServiceConfigEntity)inquiryServiceConfigEntity.get(0)).getOrganId());
        BaseResponse requestOnlineOrOfflineVo = this.getDoctorOfficeStatus(requestGetDoctorOfficeStatus);
        if (null != requestOnlineOrOfflineVo.getData()) {
            log.info("\u533b\u751f\u662f\u5426\u5728\u7ebf:{}", (Object)((RequestOnlineOrOfflineVo)requestOnlineOrOfflineVo.getData()).getOfficeStatus());
            if (ServiceTypeEnum.BMMZ.getValue().equals(req.getType()) && ((RequestOnlineOrOfflineVo)requestOnlineOrOfflineVo.getData()).getOfficeStatus() != 1) {
                return BaseResponse.error((String)"\u8be5\u533b\u751f\u4e0d\u5728\u7ebf\uff0c\u65e0\u6cd5\u8fdb\u884c\u670d\u52a1");
            }
            doctorScheduleVo.setOfficeStatus(((RequestOnlineOrOfflineVo)requestOnlineOrOfflineVo.getData()).getOfficeStatus());
        }
        doctorScheduleVo.setServTimes(this.getDoctorServTimes(req.getDoctorId()));
        BaseResponse doctorAverageScore = this.doctorUserEvaluationFeignClient.getDoctorAverageScore(req.getDoctorId());
        if (null == doctorAverageScore || !doctorAverageScore.isSuccess()) {
            doctorScheduleVo.setSatisfaction("5.0");
        } else {
            doctorScheduleVo.setSatisfaction("0.0".equals(doctorAverageScore.getData()) ? "5.0" : (String)doctorAverageScore.getData());
        }
        if (ServiceTypeEnum.NOS.getValue().equals(req.getType())) {
            return BaseResponse.success((Object)doctorScheduleVo);
        }
        return BaseResponse.success((Object)doctorScheduleVo);
    }

    public BaseResponse<String> saveConfigInfoList(RequestServiceConfigListVo vo) {
        if (vo.getOperationType().equals(1)) {
            ArrayList<InquiryServiceConfigEntity> list = new ArrayList<InquiryServiceConfigEntity>();
            ArrayList<DoctorOfficeEntity> doctorOfficeEntities = new ArrayList<DoctorOfficeEntity>();
            for (String doctorId : vo.getDoctorId()) {
                InquiryServiceConfigEntity entity = new InquiryServiceConfigEntity();
                entity.setDoctorId(doctorId);
                entity.setOrganId(vo.getHospitalId());
                entity.setNotice(vo.getNotice());
                entity.setDeptId(vo.getDeptId());
                if (0 == vo.getNumLimit() || null == vo.getNumLimit() || -1 == vo.getNumLimit()) {
                    entity.setNumLimit(Integer.valueOf(999));
                } else {
                    entity.setNumLimit(vo.getNumLimit());
                }
                if (0 == vo.getServTime() || null == vo.getServTime() || -1 == vo.getServTime()) {
                    entity.setServTime(Integer.valueOf(1440));
                } else {
                    entity.setServTime(vo.getServTime());
                }
                if (0 == vo.getDailyLimit() || null == vo.getDailyLimit() || -1 == vo.getDailyLimit()) {
                    entity.setDailyLimit(Integer.valueOf(120));
                } else {
                    entity.setDailyLimit(vo.getDailyLimit());
                }
                if (0 == vo.getOrderTime() || null == vo.getOrderTime() || -1 == vo.getOrderTime()) {
                    entity.setOrderTime(Integer.valueOf(1440));
                } else {
                    entity.setOrderTime(vo.getOrderTime());
                }
                entity.setStatus(vo.getStatus());
                entity.setPrice(vo.getPrice());
                entity.setIsSchedule(vo.getIsSchedule());
                entity.setAppCode(vo.getAppCode());
                entity.setTimeUnit(vo.getTimeUnit());
                entity.setOfficeStatus(Integer.valueOf(1));
                entity.setStartOfficeTime(vo.getStartOfficeTime());
                entity.setEndOfficeTime(vo.getEndOfficeTime());
                entity.setOrderTimeUnit(vo.getOrderTimeUnit());
                entity.setServiceCode(vo.getServiceCode());
                list.add(entity);
                QueryWrapper queryWrapperDoc = new QueryWrapper();
                DoctorOfficeEntity wrapperEntityDoc = new DoctorOfficeEntity();
                wrapperEntityDoc.setDoctorId(doctorId);
                wrapperEntityDoc.setHospitalId(vo.getHospitalId());
                wrapperEntityDoc.setAppCode(vo.getAppCode());
                queryWrapperDoc.setEntity((Object)wrapperEntityDoc);
                queryWrapperDoc.last("limit 1");
                DoctorOfficeEntity doctorOffice = (DoctorOfficeEntity)this.baseDoctorOfficeService.getOne((Wrapper)queryWrapperDoc);
                if (null != doctorOffice) continue;
                DoctorOfficeEntity doctorOfficeEntity = new DoctorOfficeEntity();
                doctorOfficeEntity.setAppCode(vo.getAppCode());
                doctorOfficeEntity.setDoctorId(doctorId);
                doctorOfficeEntity.setHospitalId(vo.getHospitalId());
                doctorOfficeEntity.setEndOfficeTime(vo.getEndOfficeTime());
                if (ServiceTypeEnum.NOS.getCode().equals(vo.getServiceCode())) {
                    doctorOfficeEntity.setServType(ServiceTypeEnum.NOS.getValue());
                }
                if (ServiceTypeEnum.HOS.getCode().equals(vo.getServiceCode())) {
                    doctorOfficeEntity.setServType(ServiceTypeEnum.HOS.getValue());
                }
                doctorOfficeEntity.setOfficeStatus(Integer.valueOf(1));
                doctorOfficeEntity.setStartOfficeTime(vo.getStartOfficeTime());
                doctorOfficeEntity.setId(UUIDUtil.getUUID());
                doctorOfficeEntity.setStatus(Integer.valueOf(1));
                doctorOfficeEntities.add(doctorOfficeEntity);
            }
            this.baseDoctorOfficeService.saveBatch(doctorOfficeEntities);
            Boolean result = this.baseService.saveBatch(list);
            if (result.booleanValue()) {
                return BaseResponse.success((Object)"\u6279\u91cf\u65b0\u589e\u533b\u751f\u670d\u52a1\u6210\u529f");
            }
        }
        if (vo.getOperationType().equals(2)) {
            this.configUpdate(vo);
        }
        return BaseResponse.success((Object)"\u6279\u91cf\u4fee\u6539\u533b\u751f\u670d\u52a1\u6210\u529f");
    }

    private void configUpdate(RequestServiceConfigListVo vo) {
        for (String doctorId : vo.getDoctorId()) {
            QueryWrapper queryWrapper = new QueryWrapper();
            InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
            wrapperEntity.setOrganId(vo.getHospitalId());
            wrapperEntity.setDoctorId(doctorId);
            wrapperEntity.setDeptId(vo.getDeptId());
            queryWrapper.setEntity((Object)wrapperEntity);
            InquiryServiceConfigEntity entity = new InquiryServiceConfigEntity();
            entity.setNotice(vo.getNotice());
            if (0 == vo.getNumLimit() || null == vo.getNumLimit() || -1 == vo.getNumLimit()) {
                entity.setNumLimit(Integer.valueOf(999));
            } else {
                entity.setNumLimit(vo.getNumLimit());
            }
            if (0 == vo.getServTime() || null == vo.getServTime() || -1 == vo.getServTime()) {
                entity.setServTime(Integer.valueOf(1440));
            } else {
                entity.setServTime(vo.getServTime());
            }
            if (0 == vo.getDailyLimit() || null == vo.getDailyLimit() || -1 == vo.getDailyLimit()) {
                entity.setDailyLimit(Integer.valueOf(120));
            } else {
                entity.setDailyLimit(vo.getDailyLimit());
            }
            if (0 == vo.getOrderTime() || null == vo.getOrderTime() || -1 == vo.getOrderTime()) {
                entity.setOrderTime(Integer.valueOf(1440));
            } else {
                entity.setOrderTime(vo.getOrderTime());
            }
            entity.setStatus(vo.getStatus());
            entity.setPrice(vo.getPrice());
            entity.setIsSchedule(vo.getIsSchedule());
            entity.setAppCode(vo.getAppCode());
            entity.setTimeUnit(vo.getTimeUnit());
            entity.setStartOfficeTime(vo.getStartOfficeTime());
            entity.setEndOfficeTime(vo.getEndOfficeTime());
            entity.setOrderTimeUnit(vo.getOrderTimeUnit());
            Boolean bl = this.baseService.update((Object)entity, (Wrapper)queryWrapper);
        }
    }

    public BaseResponse<String> saveConfigInfoListNew(RequestServiceConfigListNewVo vo) {
        if (CollectionUtils.isEmpty((Collection)vo.getDoctorInfo())) {
            return BaseResponse.success();
        }
        List doctors = vo.getDoctorInfo();
        ArrayList docs = new ArrayList();
        doctors.stream().forEach(doc -> docs.add(doc.getDoctorId()));
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryServiceConfigEntity inquiryServiceConfig = new InquiryServiceConfigEntity();
        inquiryServiceConfig.setServiceCode(vo.getServiceCode());
        inquiryServiceConfig.setOrganId(vo.getHospitalId());
        queryWrapper.setEntity((Object)inquiryServiceConfig);
        queryWrapper.in((Object)"doctor_id", docs);
        List dataList = this.baseService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            this.insertDoctorInfo(vo);
            return BaseResponse.success();
        }
        log.info("\u6570\u636e\u5e93\u6240\u542b\u5165\u53c2\u533b\u751f\u6570\u636e{}", (Object)JSON.toJSONString((Object)dataList));
        Map<String, List<InquiryServiceConfigEntity>> databaseMap = dataList.stream().collect(Collectors.groupingBy(item -> item.getDoctorId() + "" + item.getDeptId()));
        log.info("\u6570\u636e\u5e93\u4fe1\u606f\u5206\u7ec4{}", (Object)JSON.toJSONString(databaseMap));
        Map<Boolean, List<DoctorInfoVo>> collect = doctors.stream().collect(Collectors.partitioningBy(item -> databaseMap.containsKey(item.getDoctorId() + "" + item.getDeptId())));
        log.info("\u5224\u65ad\u662f\u5426\u548c\u5165\u53c2\u6709\u91cd\u590d{}", (Object)JSON.toJSONString(collect));
        for (Boolean b : collect.keySet()) {
            if (b.booleanValue()) {
                vo.setDoctorInfo(collect.get(b));
                log.info("list\u66f4\u65b0\u540e\u7684\u5165\u53c2{}", (Object)JSON.toJSONString((Object)vo));
                this.configUpdateNew(vo);
                continue;
            }
            vo.setDoctorInfo(collect.get(b));
            this.insertDoctorInfo(vo);
        }
        if (ServiceTypeEnum.QOS.getCode().equals(vo.getServiceCode())) {
            this.jsgyInquiryServiceConfigClient.saveConfigInfoListNew(vo);
        }
        return BaseResponse.success((Object)"\u6279\u91cf\u4fee\u6539\u533b\u751f\u670d\u52a1\u6210\u529f");
    }

    private boolean insertDoctorInfo(RequestServiceConfigListNewVo vo) {
        ArrayList<InquiryServiceConfigEntity> list = new ArrayList<InquiryServiceConfigEntity>();
        ArrayList<DoctorOfficeEntity> doctorOfficeEntities = new ArrayList<DoctorOfficeEntity>();
        for (DoctorInfoVo doctorInfo : vo.getDoctorInfo()) {
            InquiryServiceConfigEntity entity = new InquiryServiceConfigEntity();
            entity.setDoctorId(doctorInfo.getDoctorId());
            entity.setOrganId(vo.getHospitalId());
            entity.setNotice(vo.getNotice());
            entity.setDeptId(doctorInfo.getDeptId());
            if (0 == vo.getNumLimit() || null == vo.getNumLimit() || -1 == vo.getNumLimit()) {
                entity.setNumLimit(Integer.valueOf(999));
            } else {
                entity.setNumLimit(vo.getNumLimit());
            }
            if (0 == vo.getServTime() || null == vo.getServTime() || -1 == vo.getServTime()) {
                entity.setServTime(Integer.valueOf(1440));
            } else {
                entity.setServTime(vo.getServTime());
            }
            if (0 == vo.getDailyLimit() || null == vo.getDailyLimit() || -1 == vo.getDailyLimit()) {
                entity.setDailyLimit(Integer.valueOf(120));
            } else {
                entity.setDailyLimit(vo.getDailyLimit());
            }
            if (0 == vo.getOrderTime() || null == vo.getOrderTime() || -1 == vo.getOrderTime()) {
                entity.setOrderTime(Integer.valueOf(1440));
            } else {
                entity.setOrderTime(vo.getOrderTime());
            }
            entity.setStatus(vo.getStatus());
            entity.setPrice(vo.getPrice());
            entity.setIsSchedule(vo.getIsSchedule());
            entity.setAppCode(vo.getAppCode());
            entity.setTimeUnit(vo.getTimeUnit());
            entity.setOfficeStatus(Integer.valueOf(1));
            entity.setStartOfficeTime(vo.getStartOfficeTime());
            entity.setEndOfficeTime(vo.getEndOfficeTime());
            entity.setOrderTimeUnit(vo.getOrderTimeUnit());
            entity.setServiceCode(vo.getServiceCode());
            list.add(entity);
            QueryWrapper queryWrapperDoc = new QueryWrapper();
            DoctorOfficeEntity wrapperEntityDoc = new DoctorOfficeEntity();
            wrapperEntityDoc.setDoctorId(doctorInfo.getDoctorId());
            wrapperEntityDoc.setHospitalId(vo.getHospitalId());
            wrapperEntityDoc.setAppCode(vo.getAppCode());
            queryWrapperDoc.setEntity((Object)wrapperEntityDoc);
            queryWrapperDoc.last("limit 1");
            DoctorOfficeEntity doctorOffice = (DoctorOfficeEntity)this.baseDoctorOfficeService.getOne((Wrapper)queryWrapperDoc);
            if (null != doctorOffice) continue;
            DoctorOfficeEntity doctorOfficeEntity = new DoctorOfficeEntity();
            doctorOfficeEntity.setAppCode(vo.getAppCode());
            doctorOfficeEntity.setDoctorId(doctorInfo.getDoctorId());
            doctorOfficeEntity.setHospitalId(vo.getHospitalId());
            doctorOfficeEntity.setEndOfficeTime(vo.getEndOfficeTime());
            if (ServiceTypeEnum.NOS.getCode().equals(vo.getServiceCode())) {
                doctorOfficeEntity.setServType(ServiceTypeEnum.NOS.getValue());
            }
            if (ServiceTypeEnum.HOS.getCode().equals(vo.getServiceCode())) {
                doctorOfficeEntity.setServType(ServiceTypeEnum.HOS.getValue());
            }
            doctorOfficeEntity.setOfficeStatus(Integer.valueOf(1));
            doctorOfficeEntity.setStartOfficeTime(vo.getStartOfficeTime());
            doctorOfficeEntity.setId(UUIDUtil.getUUID());
            doctorOfficeEntity.setStatus(Integer.valueOf(1));
            doctorOfficeEntities.add(doctorOfficeEntity);
        }
        this.baseDoctorOfficeService.saveBatch(doctorOfficeEntities);
        Boolean result = this.baseService.saveBatch(list);
        return result != false;
    }

    private void configUpdateNew(RequestServiceConfigListNewVo vo) {
        for (DoctorInfoVo doctorInfo : vo.getDoctorInfo()) {
            QueryWrapper queryWrapper = new QueryWrapper();
            InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
            wrapperEntity.setOrganId(vo.getHospitalId());
            wrapperEntity.setDoctorId(doctorInfo.getDoctorId());
            wrapperEntity.setServiceCode(vo.getServiceCode());
            wrapperEntity.setDeptId(doctorInfo.getDeptId());
            queryWrapper.setEntity((Object)wrapperEntity);
            InquiryServiceConfigEntity entity = new InquiryServiceConfigEntity();
            entity.setNotice(vo.getNotice());
            if (0 == vo.getNumLimit() || null == vo.getNumLimit() || -1 == vo.getNumLimit()) {
                entity.setNumLimit(Integer.valueOf(999));
            } else {
                entity.setNumLimit(vo.getNumLimit());
            }
            if (0 == vo.getServTime() || null == vo.getServTime() || -1 == vo.getServTime()) {
                entity.setServTime(Integer.valueOf(1440));
            } else {
                entity.setServTime(vo.getServTime());
            }
            if (0 == vo.getDailyLimit() || null == vo.getDailyLimit() || -1 == vo.getDailyLimit()) {
                entity.setDailyLimit(Integer.valueOf(120));
            } else {
                entity.setDailyLimit(vo.getDailyLimit());
            }
            if (0 == vo.getOrderTime() || null == vo.getOrderTime() || -1 == vo.getOrderTime()) {
                entity.setOrderTime(Integer.valueOf(1440));
            } else {
                entity.setOrderTime(vo.getOrderTime());
            }
            entity.setStatus(vo.getStatus());
            entity.setPrice(vo.getPrice());
            entity.setIsSchedule(vo.getIsSchedule());
            entity.setAppCode(vo.getAppCode());
            entity.setTimeUnit(vo.getTimeUnit());
            entity.setStartOfficeTime(vo.getStartOfficeTime());
            entity.setEndOfficeTime(vo.getEndOfficeTime());
            entity.setOrderTimeUnit(vo.getOrderTimeUnit());
            Boolean bl = this.baseService.update((Object)entity, (Wrapper)queryWrapper);
        }
    }

    public BaseResponse<RequestOnlineOrOfflineVo> officeOnlineOrOffline(RequestOnlineOrOfflineVo requestOnlineOrOfflineVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        DoctorOfficeEntity wrapperEntity = new DoctorOfficeEntity();
        wrapperEntity.setDoctorId(requestOnlineOrOfflineVo.getDoctorId());
        wrapperEntity.setHospitalId(requestOnlineOrOfflineVo.getHospitalId());
        wrapperEntity.setAppCode(requestOnlineOrOfflineVo.getAppCode());
        wrapperEntity.setDoctorId(requestOnlineOrOfflineVo.getDoctorId());
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        DoctorOfficeEntity inquiryServiceConfigEntity = (DoctorOfficeEntity)this.baseDoctorOfficeService.getOne((Wrapper)queryWrapper);
        if (null == inquiryServiceConfigEntity) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8be5\u533b\u751f\u4e0a\u4e0b\u7ebf\u914d\u7f6e\u4fe1\u606f\uff01");
        }
        inquiryServiceConfigEntity.setOfficeStatus(requestOnlineOrOfflineVo.getOfficeStatus());
        Boolean flag = this.baseDoctorOfficeService.updateById((Object)inquiryServiceConfigEntity);
        if (!flag.booleanValue()) {
            if (requestOnlineOrOfflineVo.getOfficeStatus().equals(1)) {
                return BaseResponse.error((String)"\u4e0a\u7ebf\u5931\u8d25");
            }
            return BaseResponse.error((String)"\u4e0b\u7ebf\u5931\u8d25");
        }
        return BaseResponse.success((Object)requestOnlineOrOfflineVo);
    }

    public BaseResponse<RequestOnlineOrOfflineVo> getDoctorOfficeStatus(RequestGetDoctorOfficeStatus requestGetDoctorOfficeStatus) {
        QueryWrapper queryWrapper = new QueryWrapper();
        DoctorOfficeEntity wrapperEntity = new DoctorOfficeEntity();
        wrapperEntity.setHospitalId(requestGetDoctorOfficeStatus.getHospitalId());
        wrapperEntity.setAppCode(requestGetDoctorOfficeStatus.getAppCode());
        wrapperEntity.setDoctorId(requestGetDoctorOfficeStatus.getDoctorId());
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        DoctorOfficeEntity inquiryServiceConfigEntity = (DoctorOfficeEntity)this.baseDoctorOfficeService.getOne((Wrapper)queryWrapper);
        if (null == inquiryServiceConfigEntity) {
            return BaseResponse.error((String)"\u5f53\u524d\u533b\u751f\u672a\u5f00\u901a\u5728\u7ebf\u95ee\u8bca\u670d\u52a1\u6216\u6570\u636e\u4e0d\u540c\u6b65");
        }
        RequestOnlineOrOfflineVo requestOnlineOrOfflineVo = new RequestOnlineOrOfflineVo();
        requestOnlineOrOfflineVo.setAppCode(inquiryServiceConfigEntity.getAppCode());
        requestOnlineOrOfflineVo.setDoctorId(inquiryServiceConfigEntity.getDoctorId());
        requestOnlineOrOfflineVo.setHospitalId(inquiryServiceConfigEntity.getHospitalId());
        requestOnlineOrOfflineVo.setOfficeStatus(inquiryServiceConfigEntity.getOfficeStatus());
        return BaseResponse.success((Object)requestOnlineOrOfflineVo);
    }

    private List<DoctorScheduleDataVo> buildDoctorScheduleDataVoList(List<DoctorScheduleWeekVo> doctorScheduleWeekVoList, String organId) {
        ArrayList<DoctorScheduleDataVo> doctorScheduleDataVoList = new ArrayList<DoctorScheduleDataVo>();
        Map<String, List<DoctorScheduleWeekVo>> doctorScheduleWeekVoMap = doctorScheduleWeekVoList.stream().collect(Collectors.groupingBy(doctorScheduleWeekVo -> String.valueOf(doctorScheduleWeekVo.getScheduleDate())));
        QueryWrapper queryWrapper = new QueryWrapper();
        ScheduleTimeIntervalEntity wapperEntity = new ScheduleTimeIntervalEntity();
        wapperEntity.setHospitalId(Long.valueOf(organId));
        queryWrapper.setEntity((Object)wapperEntity);
        List timeIntervalEntitys = this.timeIntervalService.list((Wrapper)queryWrapper);
        for (String scheduleDate : doctorScheduleWeekVoMap.keySet()) {
            DoctorScheduleDataVo doctorScheduleDataVo = new DoctorScheduleDataVo();
            doctorScheduleDataVo.setScheduleDate(scheduleDate);
            List<DoctorScheduleWeekVo> dayDoctorScheduleWeekVoList = doctorScheduleWeekVoMap.get(scheduleDate);
            for (DoctorScheduleWeekVo doctorScheduleWeekVo2 : dayDoctorScheduleWeekVoList) {
                if (DateUtils.strToDateLong((String)DateUtils.getCurrentDateSimpleToString()) == DateUtils.strToDateLong((String)doctorScheduleWeekVo2.getScheduleDate())) {
                    String todayScheduleDate = doctorScheduleDataVo.getScheduleDate();
                    String morningStartTime = "";
                    String morningEndTime = "";
                    String afternoonStartTime = "";
                    String afternoonEndTime = "";
                    String nightStartTime = "";
                    String nightEndTime = "";
                    for (ScheduleTimeIntervalEntity scheduleTimeIntervalEntity : timeIntervalEntitys) {
                        if (scheduleTimeIntervalEntity.getScheduleRange().equals(ScheduleRecordEnum.MORNING.getValue())) {
                            morningStartTime = todayScheduleDate + " " + scheduleTimeIntervalEntity.getStartTime() + ":00";
                            morningEndTime = DateUtils.dateToFullString((Date)DateUtils.dateAddMinutes((Date)DateUtils.stringToFullDate((String)(todayScheduleDate + " " + scheduleTimeIntervalEntity.getEndTime() + ":00")), (int)-10));
                        }
                        if (scheduleTimeIntervalEntity.getScheduleRange().equals(ScheduleRecordEnum.AFTERNOON.getValue())) {
                            afternoonStartTime = todayScheduleDate + " " + scheduleTimeIntervalEntity.getStartTime() + ":00";
                            afternoonEndTime = DateUtils.dateToFullString((Date)DateUtils.dateAddMinutes((Date)DateUtils.stringToFullDate((String)(todayScheduleDate + " " + scheduleTimeIntervalEntity.getEndTime() + ":00")), (int)-10));
                        }
                        if (!scheduleTimeIntervalEntity.getScheduleRange().equals(ScheduleRecordEnum.EVENING.getValue())) continue;
                        nightStartTime = todayScheduleDate + " " + scheduleTimeIntervalEntity.getStartTime() + ":00";
                        nightEndTime = DateUtils.dateToFullString((Date)DateUtils.dateAddMinutes((Date)DateUtils.stringToFullDate((String)(todayScheduleDate + " " + scheduleTimeIntervalEntity.getEndTime() + ":00")), (int)-10));
                    }
                    try {
                        doctorScheduleDataVo = this.getScheduleRange(doctorScheduleDataVo, doctorScheduleWeekVo2, morningEndTime, afternoonEndTime, nightEndTime);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (doctorScheduleWeekVo2.getScheduleRange().equals(ScheduleRecordEnum.NORMAL.getValue())) {
                    doctorScheduleDataVo.setAmNum(doctorScheduleWeekVo2.getAvailableCount());
                }
                if (doctorScheduleWeekVo2.getScheduleRange().equals(ScheduleRecordEnum.AFTERNOON.getValue())) {
                    doctorScheduleDataVo.setPmNum(doctorScheduleWeekVo2.getAvailableCount());
                }
                if (!doctorScheduleWeekVo2.getScheduleRange().equals(ScheduleRecordEnum.EVENING.getValue())) continue;
                doctorScheduleDataVo.setNightNum(doctorScheduleWeekVo2.getAvailableCount());
            }
            doctorScheduleDataVoList.add(doctorScheduleDataVo);
        }
        return doctorScheduleDataVoList;
    }

    private DoctorScheduleDataVo getScheduleRange(DoctorScheduleDataVo doctorScheduleDataVo, DoctorScheduleWeekVo doctorScheduleWeekVo, String morningEndTime, String afternoonEndTime, String nightEndTime) {
        String currentDate = DateUtils.getCurrentDateToString();
        log.info("=====\u83b7\u53d6\u7528\u6237\u5f53\u524d\u65f6\u95f4:{}", (Object)currentDate);
        long currentTimeStamp = DateUtils.StringTolong((String)currentDate);
        if (currentTimeStamp <= DateUtils.StringTolong((String)morningEndTime)) {
            if (doctorScheduleWeekVo.getScheduleRange().equals(ScheduleRecordEnum.NORMAL.getValue())) {
                doctorScheduleDataVo.setAmNum(doctorScheduleWeekVo.getAvailableCount());
            }
            if (doctorScheduleWeekVo.getScheduleRange().equals(ScheduleRecordEnum.AFTERNOON.getValue())) {
                doctorScheduleDataVo.setPmNum(doctorScheduleWeekVo.getAvailableCount());
            }
            if (doctorScheduleWeekVo.getScheduleRange().equals(ScheduleRecordEnum.EVENING.getValue())) {
                doctorScheduleDataVo.setNightNum(doctorScheduleWeekVo.getAvailableCount());
            }
        }
        if (DateUtils.StringTolong((String)morningEndTime) < currentTimeStamp && currentTimeStamp <= DateUtils.StringTolong((String)afternoonEndTime)) {
            if (doctorScheduleWeekVo.getScheduleRange().equals(ScheduleRecordEnum.AFTERNOON.getValue())) {
                doctorScheduleDataVo.setPmNum(doctorScheduleWeekVo.getAvailableCount());
            }
            if (doctorScheduleWeekVo.getScheduleRange().equals(ScheduleRecordEnum.EVENING.getValue())) {
                doctorScheduleDataVo.setNightNum(doctorScheduleWeekVo.getAvailableCount());
            }
        }
        if (DateUtils.StringTolong((String)afternoonEndTime) < currentTimeStamp && currentTimeStamp <= DateUtils.StringTolong((String)nightEndTime) && doctorScheduleWeekVo.getScheduleRange().equals(ScheduleRecordEnum.EVENING.getValue())) {
            doctorScheduleDataVo.setNightNum(doctorScheduleWeekVo.getAvailableCount());
        }
        return doctorScheduleDataVo;
    }

    private Integer getDoctorServTimes(String docId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        AdmissionEntity admissionEntity = new AdmissionEntity();
        admissionEntity.setDoctorId(docId);
        queryWrapper.setEntity((Object)admissionEntity);
        return this.baseInquiryAdmissionService.count((Wrapper)queryWrapper);
    }
}

