/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.card.common.CardServiceApi;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.card.common.vo.RegisterCardReqVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.MobileBenefitPackageMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.MobileBenefitPackageEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.service.mobile.MobileBenefitPackageService;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.utils.Mobile.DESUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.Mobile.SignUtils;
import com.ebaiyihui.onlineoutpatient.core.vo.mobile.AccessTokenVo;
import com.ebaiyihui.onlineoutpatient.core.vo.mobile.MobileBenefitPackageVo;
import com.ebaiyihui.onlineoutpatient.core.vo.mobile.MobileBenefitResp;
import com.ebaiyihui.onlineoutpatient.core.vo.mobile.NotifyConsultDataVo;
import com.ebaiyihui.onlineoutpatient.core.vo.mobile.NotifyConsultDeductVo;
import com.ebaiyihui.onlineoutpatient.core.vo.mobile.RegistPatientVo;
import com.ebaiyihui.onlineoutpatient.core.vo.mobile.Result;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class MobileBenefitPackageServiceImpl
implements MobileBenefitPackageService {
    private static final Logger log = LoggerFactory.getLogger(MobileBenefitPackageServiceImpl.class);
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private MobileBenefitPackageMapper mobileBenefitPackageMapper;
    @Autowired
    private CardServiceApi cardServiceFeignClient;
    public static final String GRANT_TYPE = "client_credentials";
    public static final String DES_SECRET = "zk26rdgfsg23j42fewegfr234h23423g44323";
    public static final String SIGN_SECRET = "123456";
    public static final String SUPPLIER_CODE = "ZhongKang";

    public String getAssessToken() {
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put("grantType", GRANT_TYPE);
        param.put("clientId", this.projProperties.getMobileBenefitPackageClientId());
        param.put("clientSecret", this.projProperties.getMobileBenefitPackageClientSecret());
        try {
            String result = HttpKit.jsonPost((String)(this.projProperties.getMobileBenefitPackageUrl() + "/auth/v1.0.0/oauth/token"), (String)JSONObject.toJSONString(param));
            Result resultResp = (Result)JSONObject.parseObject((String)result, Result.class);
            if (resultResp.isSuccess()) {
                AccessTokenVo accessTokenVo = (AccessTokenVo)JSONObject.parseObject((String)String.valueOf(resultResp.getData()), AccessTokenVo.class);
                return accessTokenVo.getTokenType() + " " + accessTokenVo.getAccessToken();
            }
        }
        catch (Exception e) {
            log.error("\u9519\u8bef\u4fe1\u606f\uff1a{}", (Throwable)e);
        }
        return null;
    }

    public String refreshToken(String refreshToken) {
        try {
            String result = HttpKit.get((String)(this.projProperties.getMobileBenefitPackageUrl() + "/auth/v1.0.0/oauth/refresh" + "?refreshToken=" + refreshToken));
            Result resultResp = (Result)JSONObject.parseObject((String)result, Result.class);
            if (resultResp.isSuccess()) {
                AccessTokenVo accessTokenVo = (AccessTokenVo)JSONObject.parseObject((String)String.valueOf(resultResp.getData()), AccessTokenVo.class);
                return accessTokenVo.getTokenType() + " " + accessTokenVo.getAccessToken();
            }
        }
        catch (Exception e) {
            log.error("\u9519\u8bef\u4fe1\u606f\uff1a{}", (Throwable)e);
        }
        return null;
    }

    public Result<MobileBenefitResp> addBenefitPackage(List<MobileBenefitPackageVo> vos) {
        log.info("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f:{}", vos);
        try {
            vos.forEach(vo -> {
                MobileBenefitPackageEntity entity = new MobileBenefitPackageEntity();
                BeanUtils.copyProperties((Object)vo, (Object)entity);
                this.mobileBenefitPackageMapper.insert(entity);
            });
        }
        catch (Exception e) {
            return Result.error((Object)this.failed());
        }
        return Result.success((Object)this.success());
    }

    public BaseResponse<RegistPatientVo> regist(String token) {
        token = token.replace(" ", "+");
        Map map = (Map)JSONObject.parseObject((String)DESUtils.decrypt((String)token, (String)DES_SECRET), Map.class);
        log.info("\u89e3\u6790token\u7ed3\u679c\uff1a{}", (Object)map);
        MobileBenefitPackageEntity entity = this.mobileBenefitPackageMapper.queryByPhone((String)map.get("mobile"), (String)map.get("activateOrderId"));
        if (ObjectUtils.isEmpty((Object)entity)) {
            return BaseResponse.error((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u6709\u5173\u6743\u76ca");
        }
        RegisterCardReqVO registerCardReqVO = new RegisterCardReqVO();
        registerCardReqVO.setAppCode("NCZK");
        registerCardReqVO.setChannelCode("PATIENT_WX");
        registerCardReqVO.setChannelName("PATIENT_WX");
        registerCardReqVO.setPatientName((String)map.get("patientName"));
        registerCardReqVO.setCredNo((String)map.get("card_no"));
        registerCardReqVO.setCredTypeCode("01");
        registerCardReqVO.setCredTypeName("\u5c45\u6c11\u8eab\u4efd\u8bc1");
        registerCardReqVO.setCardTypeCode("1703");
        registerCardReqVO.setCardTypeName("\u865a\u62df\u5c31\u8bca\u5361");
        registerCardReqVO.setOrganCode("130188");
        registerCardReqVO.setOrganName("\u5357\u660c\u4f17\u5eb7\u533b\u9662");
        registerCardReqVO.setTel((String)map.get("mobile"));
        log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u8bf7\u6c42:{}", (Object)registerCardReqVO);
        BaseResponse response = this.cardServiceFeignClient.registerOrBindCard(registerCardReqVO);
        log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u7ed3\u679c:{}", (Object)response);
        if (!response.isSuccess() || StringUtils.isEmpty((Object)response)) {
            return BaseResponse.error((String)"\u6ce8\u518c\u5c31\u8bca\u5361\u5931\u8d25");
        }
        CardDetailsInfoRespVO data = (CardDetailsInfoRespVO)response.getData();
        RegistPatientVo registPatientVo = new RegistPatientVo();
        registPatientVo.setPatientInfo(data);
        registPatientVo.setActivateOrderId((String)map.get("activateOrderId"));
        if (!StringUtils.isEmpty(map.get("patient_id"))) {
            entity.setUserId((String)map.get("patient_id"));
            this.mobileBenefitPackageMapper.update(entity);
        }
        return BaseResponse.success((Object)registPatientVo);
    }

    public Result<MobileBenefitResp> notifyConsultData(NotifyConsultDataVo vo) {
        log.info("\u540c\u6b65\u8ba2\u5355\u5165\u53c2\uff1a{}", (Object)vo);
        vo.setSupplierCode(SUPPLIER_CODE);
        String param = JSONObject.toJSONString((Object)vo);
        log.info("\u63a8\u9001\u8ba2\u5355\u6570\u636e\uff1a{}", (Object)param);
        String assessToken = this.getAssessToken();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", assessToken);
        Map map = null;
        try {
            map = SignUtils.paramToMap((Object)vo);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u5931\u8d25\uff1a{}", (Throwable)e);
            return Result.error((Object)this.failed());
        }
        String sign = SignUtils.getSignatureToStr((Map)map, (String)SIGN_SECRET);
        header.put("sign", sign);
        header.put("timestamp", String.valueOf(new Date().getTime()));
        try {
            HttpKit.jsonPost((String)(this.projProperties.getMobileBenefitPackageUrl() + "/notify_consult/v1.0.1/data"), (String)param, header);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u5931\u8d25\uff1a{}", (Throwable)e);
            return Result.error((Object)this.failed());
        }
        return Result.success((Object)this.success());
    }

    public Result<MobileBenefitResp> notifyDeduct(NotifyConsultDeductVo vo) {
        log.info("\u6838\u9500\u8ba2\u5355\u5165\u53c2\uff1a{}", (Object)vo);
        vo.setSupplierCode(SUPPLIER_CODE);
        String param = JSONObject.toJSONString((Object)vo);
        log.info("\u6838\u9500\u8ba2\u5355\u6570\u636e\uff1a{}", (Object)param);
        String assessToken = this.getAssessToken();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", assessToken);
        Map map = null;
        try {
            map = SignUtils.paramToMap((Object)vo);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u5931\u8d25\uff1a{}", (Throwable)e);
            return Result.error((Object)this.failed());
        }
        String sign = SignUtils.getSignatureToStr((Map)map, (String)SIGN_SECRET);
        header.put("sign", sign);
        header.put("timestamp", String.valueOf(new Date().getTime()));
        try {
            HttpKit.jsonPost((String)(this.projProperties.getMobileBenefitPackageUrl() + "/notify_benefits_deduct/v1.0.1/data"), (String)param, header);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u5931\u8d25\uff1a{}", (Throwable)e);
            return Result.error((Object)this.failed());
        }
        return Result.success((Object)this.success());
    }

    public MobileBenefitPackageEntity queryByPhone(String phone, String activateOrderId) {
        return this.mobileBenefitPackageMapper.queryByPhone(phone, activateOrderId);
    }

    public void updateUsedEntity(MobileBenefitPackageEntity entity) {
        this.mobileBenefitPackageMapper.updateUsed(entity);
    }

    public ResultData<Object> refundBenefitService(OrderEntity orderEntity, String packageId) {
        MobileBenefitPackageEntity entity = this.mobileBenefitPackageMapper.queryByOrderId(packageId);
        log.info("\u9000\u6b3e\u7684\u6743\u76ca\u5305\u4fe1\u606f\uff1a{}", (Object)entity);
        entity.setUsed(Integer.valueOf(entity.getUsed() - 1));
        this.mobileBenefitPackageMapper.updateUsed(entity);
        NotifyConsultDeductVo notifyConsultDeductVo = new NotifyConsultDeductVo();
        notifyConsultDeductVo.setActivateOrderId(orderEntity.getXId());
        notifyConsultDeductVo.setProductId(entity.getProductId());
        notifyConsultDeductVo.setBizOrderId(orderEntity.getOrderSeq());
        notifyConsultDeductVo.setOperation("2");
        notifyConsultDeductVo.setNum(String.valueOf(entity.getTimeLimit()));
        notifyConsultDeductVo.setSurplusNum(String.valueOf(entity.getTimeLimit() - entity.getUsed()));
        notifyConsultDeductVo.setConsumeNum("1");
        Result result = this.notifyDeduct(notifyConsultDeductVo);
        if (!result.isSuccess()) {
            return new ResultData().error("\u9000\u56de\u79fb\u52a8\u6743\u76ca\u5305\u6b21\u6570\u5931\u8d25");
        }
        return new ResultData().success();
    }

    public void updateNotifyConsultData(AdmissionEntity admission, OrderEntity order) {
        NotifyConsultDataVo notifyConsultDataVo = new NotifyConsultDataVo();
        notifyConsultDataVo.setActivateOrderId(order.getXId());
        notifyConsultDataVo.setConsultOrderNo(admission.getXId());
        notifyConsultDataVo.setStatus(String.valueOf(admission.getStatus()));
        notifyConsultDataVo.setProductId(this.mobileBenefitPackageMapper.queryByOrderId(admission.getPackageId()).getProductId());
        this.notifyConsultData(notifyConsultDataVo);
    }

    public List<String> getPatientIdsByPhoneAndOrderId(String phone) {
        List list = this.mobileBenefitPackageMapper.getPatientIdsByPhoneAndOrderId(phone);
        return list.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private MobileBenefitResp success() {
        MobileBenefitResp resp = new MobileBenefitResp();
        resp.setOrderStatus("OOS");
        resp.setOrderDesc("\u6210\u529f");
        return resp;
    }

    private MobileBenefitResp failed() {
        MobileBenefitResp resp = new MobileBenefitResp();
        resp.setOrderStatus("OOF");
        resp.setOrderDesc("\u5931\u8d25");
        return resp;
    }
}

