/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctoruser.api.common.enums.DoctorTypeEnum;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.IMQueryTargetSdkAccountRspVO;
import com.ebaiyihui.onlineoutpatient.common.dto.FindPatientMedicalRecordDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.InsertPatientMedicalRecordDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.MedicineAdviceDto;
import com.ebaiyihui.onlineoutpatient.common.dto.QueryByAdmissionIdDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.QueryPatientMedicalRecordDetailsDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.QueryRecordsByTimeReq;
import com.ebaiyihui.onlineoutpatient.common.dto.manager.OrderIdAndDealSeqRes;
import com.ebaiyihui.onlineoutpatient.common.dto.reviews.CommentReviews;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.common.vo.AdmInfoAction;
import com.ebaiyihui.onlineoutpatient.common.vo.InsertPatientMedicalRecordVO;
import com.ebaiyihui.onlineoutpatient.common.vo.MedicalRecordVo;
import com.ebaiyihui.onlineoutpatient.common.vo.PatientInfoRes;
import com.ebaiyihui.onlineoutpatient.common.vo.PatientMedicalRecordDetailsVo;
import com.ebaiyihui.onlineoutpatient.common.vo.PatientMedicalRecordVo;
import com.ebaiyihui.onlineoutpatient.common.vo.QueryAdmissionVo;
import com.ebaiyihui.onlineoutpatient.common.vo.QueryPatientMedicalRecordDetailsVO;
import com.ebaiyihui.onlineoutpatient.common.vo.QueryRecordsByTimeRes;
import com.ebaiyihui.onlineoutpatient.common.vo.TeamImAccount;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.GenderEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.WhetherEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.AutoReplyMessagesMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.DoctorTeamMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.EvaluationMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ICDMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryMchCodeMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.MedicalAdmissionRefMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMedicalPictureMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMedicalRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMedicalTagsMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.TeamDoctorInfoMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.AutoReplyMessagesEntity;
import com.ebaiyihui.onlineoutpatient.core.model.EvaluationEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryServiceConfigEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientMedicalRecordEntity;
import com.ebaiyihui.onlineoutpatient.core.model.TeamDoctorInfoEntity;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.ImAccountService;
import com.ebaiyihui.onlineoutpatient.core.service.PatientMedicalPictureService;
import com.ebaiyihui.onlineoutpatient.core.service.PatientMedicalRecordService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorAppealFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryServiceConfigServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.manager.GnHisManagerService;
import com.ebaiyihui.onlineoutpatient.core.service.manager.ManagerOrderService;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.utils.IDCardUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.DrugOrderCartDto;
import com.ebaiyihui.onlineoutpatient.core.vo.DrugRecordDto;
import com.ebaiyihui.onlineoutpatient.core.vo.GetDoctorWebImPatientMedicalDetailVoReq;
import com.ebaiyihui.onlineoutpatient.core.vo.GetDoctorWebImPatientMedicalDetailVoRes;
import com.ebaiyihui.onlineoutpatient.core.vo.GetNumberOfDosesDTO;
import com.ebaiyihui.onlineoutpatient.core.vo.GetPersonTeamDetialResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.GetPersonTeamResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.PatientConfirmsCaseVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PatientMedicalRecordServiceImpl
implements PatientMedicalRecordService {
    private static final Logger log = LoggerFactory.getLogger(PatientMedicalRecordServiceImpl.class);
    @Resource
    private BaseInquiryServiceConfigServiceImpl baseService;
    @Resource
    private PatientMedicalRecordMapper patientMedicalRecordMapper;
    @Resource
    private PatientMedicalPictureMapper patientMedicalPictureMapper;
    @Autowired
    private BaseInquiryOrderServiceImpl baseInquiryOrderService;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Resource
    private PatientMapper patientMapper;
    @Resource
    private PatientMedicalPictureService pictureService;
    @Autowired
    private DoctorInfofeignClient doctorCilent;
    @Autowired
    private OrderMapper orderMapper;
    @Resource
    private ProjProperties projProperties;
    @Autowired
    private DoctorAppealFeignClient doctorAppealCilent;
    @Autowired
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;
    @Autowired
    private PatientMedicalTagsMapper patientMedicalTagsMapper;
    @Autowired
    private HisTemplateService hisTemplateService;
    @Autowired
    private InquiryMchCodeMapper inquiryMchCodeMapper;
    @Autowired
    private DoctorTeamMapper doctorTeamMapper;
    @Autowired
    private EvaluationMapper evaluationMapper;
    @Autowired
    private ICDMapper icdMapper;
    @Resource
    private ImAccountService imAccountService;
    @Autowired
    private TeamDoctorInfoMapper teamDoctorInfoMapper;
    @Autowired
    private MedicalAdmissionRefMapper medicalAdmissionRefMapper;
    @Autowired
    private GnHisManagerService gnHisManagerService;
    private static final String UNBIND = "unbind";
    private static final Logger logger = LoggerFactory.getLogger(PatientMedicalRecordServiceImpl.class);
    @Autowired
    private AutoReplyMessagesMapper autoReplyMessagesMapper;
    @Autowired
    private IMInformService imInformService;
    @Autowired
    private ManagerOrderService managerOrderService;

    @Transactional(rollbackFor={Exception.class})
    public ResultData<InsertPatientMedicalRecordVO> insertPatientMedicalRecord(InsertPatientMedicalRecordDTO dto) {
        ResultData resultData = new ResultData();
        Integer result = null;
        PatientMedicalRecordEntity patientMedicalRecord = this.buildNewPatientMedicalRecord(dto);
        log.info("\u75c5\u4f8b\u5165\u53c2{}", (Object)JSON.toJSONString((Object)patientMedicalRecord));
        if ("7".equals(dto.getServType())) {
            PatientDynamicMedicalEntityVo medicalInfoById = this.internetHospitalDetailInfoService.getMedicalInfoById(dto.getMedicalId());
            log.info("\u75c5\u4f8b\u4fe1\u606f===\u300b{}", (Object)JSON.toJSONString((Object)medicalInfoById));
            String medicalDetail = medicalInfoById.getMedicalDetail();
            if (StringUtils.isNotBlank((String)medicalDetail)) {
                JSONObject parseObject = JSONObject.parseObject((String)medicalDetail);
                patientMedicalRecord.setPharmaceuticalCompanyId(parseObject.getString("drugManufacturersId"));
                patientMedicalRecord.setPharmaceuticalCompanyName(parseObject.getString("drugManufacturers"));
                patientMedicalRecord.setStoreId(parseObject.getString("pharmacyId"));
                patientMedicalRecord.setStoreName(parseObject.getString("pharmacy"));
                String isMedicalInsLabel = parseObject.getString("isMedicalInsLabel");
                if ("\u533b\u4fdd\u652f\u4ed8".equals(isMedicalInsLabel)) {
                    patientMedicalRecord.setIsMedicalInsLabel(Integer.valueOf(1));
                } else {
                    patientMedicalRecord.setIsMedicalInsLabel(Integer.valueOf(2));
                }
                patientMedicalRecord.setCanEdit(Integer.valueOf(1));
            }
        }
        patientMedicalRecord.setXCreateTime(new Date());
        patientMedicalRecord.setXUpdateTime(new Date());
        patientMedicalRecord.setXVersion(Long.valueOf(0L));
        patientMedicalRecord.setServType(Integer.valueOf(dto.getServType()));
        patientMedicalRecord.setXId(dto.getMedicalId());
        patientMedicalRecord.setDoctorName(dto.getDoctorName());
        patientMedicalRecord.setDeptName(dto.getDeptName());
        log.info("======={}", (Object)patientMedicalRecord);
        result = this.patientMedicalRecordMapper.insertPatientMedicalRecord(patientMedicalRecord);
        if (result > 0) {
            List urls = dto.getMedicalPictureList();
            if (Optional.ofNullable(urls).isPresent() && !urls.isEmpty() && !this.pictureService.insertPatientMedicalPicture(urls, patientMedicalRecord.getXId())) {
                logger.error("\u6279\u91cf\u65b0\u5efa\u75c5\u5386\u56fe\u7247\u94fe\u63a5\u5931\u8d25");
                resultData.error("\u6279\u91cf\u65b0\u5efa\u75c5\u5386\u56fe\u7247\u94fe\u63a5\u5931\u8d25");
            }
            return resultData.success((Object)new InsertPatientMedicalRecordVO(patientMedicalRecord.getXId()));
        }
        return resultData.error("\u65b0\u589e\u75c5\u5386\u5931\u8d25");
    }

    private PatientMedicalRecordEntity buildNewPatientMedicalRecord(InsertPatientMedicalRecordDTO dto) {
        PatientMedicalRecordEntity patientMedicalRecordEntity = new PatientMedicalRecordEntity();
        BeanUtils.copyProperties((Object)dto, (Object)patientMedicalRecordEntity);
        patientMedicalRecordEntity.setTags(dto.getTags());
        return patientMedicalRecordEntity;
    }

    public ResultData<PatientMedicalRecordDetailsVo> findAdmissionByAdmissionId(QueryByAdmissionIdDTO reqVo) {
        ResultData result = new ResultData();
        String xId = reqVo.getAdmissionId();
        PatientMedicalRecordDetailsVo recordVo = this.admissionMapper.queryCountdowm(xId);
        OrderEntity orderE = new OrderEntity();
        orderE.setXId(recordVo.getOrderId());
        QueryWrapper queryW = new QueryWrapper();
        queryW.setEntity((Object)orderE);
        OrderEntity order = (OrderEntity)this.orderMapper.selectOne((Wrapper)queryW);
        log.info("recordVo:{}", (Object)JSON.toJSONString((Object)recordVo));
        if (null == recordVo) {
            return result.error("\u67e5\u8be2\u4fe1\u606f\u5931\u8d25");
        }
        Date receptionTime = recordVo.getReceptionTime();
        if (null != receptionTime) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String admTime = formatter.format(receptionTime);
            recordVo.setAdmTime(admTime);
            log.info("admTime:{}", (Object)admTime);
        }
        if (null != order) {
            log.info("order:" + order.toString());
            recordVo.setClinicCode(order.getClinicCode());
            if (("MZJH".equals(order.getAppCode()) || "YYHT".equals(order.getAppCode())) && ServiceTypeEnum.NOS.getValue().equals(order.getServType()) && StringUtils.isNotEmpty((String)order.getScheduleId()) && AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(recordVo.getStatus())) {
                recordVo.setIsPassNum("1");
            } else {
                recordVo.setIsPassNum("2");
            }
        }
        if (recordVo.getMedicalOpinion() != null) {
            recordVo.setMedicalNumber(Integer.valueOf(1));
        }
        log.info("admissionMapper.queryCountdowm,{}", (Object)JSON.toJSONString((Object)recordVo));
        MedicineAdviceDto medicineAdviceDto = new MedicineAdviceDto();
        medicineAdviceDto.setAdmissionId(xId);
        medicineAdviceDto.setOrderId(recordVo.getOrderId());
        String url = this.projProperties.getMedicineAdvice();
        BaseResponse response = null;
        try {
            String request = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)medicineAdviceDto));
            response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)request), BaseResponse.class);
            log.info("response:{}" + JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u836f\u54c1\u533b\u5631\u63a5\u53e3\u5931\u8d25" + e.getMessage());
        }
        Object data = response.getData();
        recordVo.setMedicineNumber(Integer.valueOf(data.toString()));
        OrderIdAndDealSeqRes orderIdAndDealSeqRes = this.admissionMapper.selectDealSeqByAdmId(xId);
        if (orderIdAndDealSeqRes == null) {
            return result.error("\u6839\u636e\u5c31\u8bcaid\u67e5\u8be2\u7684\u8ba2\u5355\u4e3a\u7a7a\uff0c\u5c31\u8bcaid\u4e3a:{}" + xId);
        }
        OrderEntity orderEntity = this.getOrderById(recordVo.getOrderId());
        recordVo.setDealSeq(orderEntity.getDealSeq());
        if (recordVo == null) {
            return result.error("\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
        recordVo.setPatientImageUrl("");
        recordVo.setPatientInfo(this.GetpatientInfo(orderEntity.getPatientId()));
        List medicalRecord = new ArrayList();
        if (Objects.nonNull(order.getKeepOrder())) {
            medicalRecord = this.admissionMapper.queryMedicalRecordByAdmId(xId);
            log.info("medicalRecord\u67e5\u8be2\u51fa\u53c2bg\uff1a" + medicalRecord);
            recordVo.setBgDiagnose(((MedicalRecordVo)medicalRecord.get(0)).getTagName());
            recordVo.setBgMainSuit(((MedicalRecordVo)medicalRecord.get(0)).getDescription());
        } else {
            log.info("medicalRecord\u67e5\u8be2\u5165\u53c2\uff1a" + recordVo.getDoctorId() + "-" + orderEntity.getHospitalId() + "-" + recordVo.getPatientId());
            medicalRecord = this.admissionMapper.queryMedicalRecord(recordVo.getDoctorId(), orderEntity.getHospitalId(), recordVo.getPatientId(), recordVo.getServType(), orderEntity.getDoctorType());
            log.info("medicalRecord\u67e5\u8be2\u51fa\u53c2\uff1a" + medicalRecord);
        }
        recordVo.setMedicalRecord(medicalRecord);
        for (MedicalRecordVo req : medicalRecord) {
            CommentReviews review = new CommentReviews();
            req.setStatusDesc(AdmissionStatusEnum.getDesc((Integer)req.getStatus()));
            req.setComment(review);
            req.setName(req.getTagName());
        }
        InquiryServiceConfigEntity inquiryServiceConfigEntity = this.getInquiryServiceConfigEntity(orderEntity);
        if (null == inquiryServiceConfigEntity) {
            return result.error("\u672a\u67e5\u8be2\u5230\u8be5\u533b\u751f\u4e1a\u52a1\u8bbe\u7f6e\u4fe1\u606f!");
        }
        log.info("\u533b\u751f\u7684\u670d\u52a1\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)inquiryServiceConfigEntity));
        Date date = this.getExpiredTime(orderEntity, inquiryServiceConfigEntity);
        recordVo.setExpiredTime(date);
        Date now = new Date();
        recordVo.setNowTime(now);
        Integer admStatus = recordVo.getStatus();
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(recordVo.getDoctorId());
        BaseResponse res = this.doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
        if (null != res && res.isSuccess()) {
            recordVo.setDoctorName(((PersonnelInfo)res.getData()).getDoctorName());
            recordVo.setDoctorPortrait(((PersonnelInfo)res.getData()).getPortrait());
        }
        boolean canAccept = true;
        boolean canEndAdm = true;
        boolean canRefuse = true;
        boolean canTalk = true;
        boolean canAppeal = false;
        boolean canReview = false;
        if (AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admStatus) || AdmissionStatusEnum.FINISH_APPLY.getValue().equals(admStatus) || AdmissionStatusEnum.FINISH_TIME_OUT.getValue().equals(admStatus)) {
            if (null == orderEntity.getScheduleDate()) {
                canReview = true;
            }
            canAppeal = true;
        }
        if (!AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admStatus) && !AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(recordVo.getStatus())) {
            canAccept = false;
            canEndAdm = false;
            canRefuse = false;
        }
        AdmInfoAction admInfoAction = new AdmInfoAction();
        admInfoAction.setCanAccept(Boolean.valueOf(canAccept));
        admInfoAction.setCanEndAdm(Boolean.valueOf(canEndAdm));
        admInfoAction.setCanRefuse(Boolean.valueOf(canRefuse));
        admInfoAction.setCanTalk(Boolean.valueOf(canTalk));
        admInfoAction.setCanAppeal(Boolean.valueOf(canAppeal));
        admInfoAction.setCanReview(Boolean.valueOf(canReview));
        admInfoAction.setCanDrug(Boolean.valueOf(true));
        admInfoAction.setCanPrescribe(Boolean.valueOf(true));
        recordVo.setAdmAction(admInfoAction);
        recordVo.setServType(recordVo.getServType());
        this.getDoctorTeam(reqVo, recordVo);
        if (this.getRefrerralDoctor(reqVo, recordVo, inquiryServiceConfigEntity)) {
            return result.error("\u6839\u636e\u5c31\u8bcaid\u67e5\u8be2\u7684\u8ba2\u5355\u4e3a\u7a7a\uff0c\u5c31\u8bcaid\u4e3a:{}" + xId);
        }
        log.info("findByIdDetails\u63a5\u53e3\uff0cIM\u804a\u5929\u754c\u9762\u8fd4\u56de\u7684\u5012\u8ba1\u65f6,{}", (Object)JSON.toJSONString((Object)recordVo.getExpiredTime().getTime()));
        PatientDynamicMedicalEntityVo entityVo = this.internetHospitalDetailInfoService.getMedicalInfoByAdmId(xId);
        if (null == entityVo) {
            log.info("\u75c5\u4f8b\u8be6\u60c5\u67e5\u4e3a\u7a7a,\u67e5\u8be2\u4e3a\u7a7a");
            recordVo.setIsMedicalRecord(WhetherEnum.FORBID.getValue());
        } else {
            recordVo.setIsMedicalRecord(WhetherEnum.ALLOW.getValue());
            if (StringUtils.isNotEmpty((String)entityVo.getPrimaryDiagno())) {
                recordVo.setIcdName(entityVo.getPrimaryDiagno());
                String[] names = entityVo.getPrimaryDiagno().split(";");
                List<String> namesList = Arrays.asList(names);
                log.info("namesList:{}", (Object)JSONObject.toJSONString(namesList));
                List codeList = this.icdMapper.selctCodeByName(namesList);
                log.info("codeList:{}", (Object)JSONObject.toJSONString((Object)codeList));
                String code = StringUtils.join((Collection)codeList, (String)";");
                recordVo.setIcdCode(code);
            }
        }
        log.info("\u7ec4\u88c5\u51fa\u53c2recordVo\uff1a" + recordVo);
        return result.success((Object)recordVo);
    }

    private boolean getRefrerralDoctor(QueryByAdmissionIdDTO reqVo, PatientMedicalRecordDetailsVo recordVo, InquiryServiceConfigEntity inquiryServiceConfigEntity) {
        OrderEntity orderEntity1 = this.orderMapper.findByAdmId(reqVo.getAdmissionId());
        if (null == orderEntity1) {
            return true;
        }
        log.info("orderEntity1:{}" + orderEntity1.toString());
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity entity = new OrderEntity();
        entity.setDealSeq(orderEntity1.getDealSeq());
        log.info("entity:{}" + entity.toString());
        queryWrapper.setEntity((Object)entity);
        List list = this.orderMapper.selectList((Wrapper)queryWrapper);
        log.info("list:{}" + list.toString());
        if (list.size() == 1) {
            recordVo.setIsReferred(WhetherEnum.FORBID.getValue());
        } else {
            log.info("======\u8f6c\u8bca\u8ba2\u5355\u7684\u5012\u8ba1\u65f6======");
            AdmissionEntity admissionEntity = this.admissionMapper.findById(reqVo.getAdmissionId());
            log.info("\u8f6c\u8bca\u7684AdmissionId:{}", (Object)reqVo.getAdmissionId());
            log.info("\u8f6c\u8bca\u7684admissionEntity\uff1a{}", (Object)JSON.toJSONString((Object)admissionEntity));
            int addMinutes = inquiryServiceConfigEntity.getOrderTime();
            Date date = DateUtils.dateAddMinutes((Date)admissionEntity.getXCreateTime(), (int)addMinutes);
            log.info("\u8f6c\u8bca\u7684\u5012\u8ba1\u65f6date:{}", (Object)date.getTime());
            recordVo.setExpiredTime(date);
            recordVo.setIsReferred(WhetherEnum.ALLOW.getValue());
        }
        return false;
    }

    private Date getExpiredTime(OrderEntity orderEntity, InquiryServiceConfigEntity inquiryServiceConfigEntity) {
        QueryWrapper admWrapper = new QueryWrapper();
        AdmissionEntity admissionEntity = new AdmissionEntity();
        admissionEntity.setOrderId(orderEntity.getXId());
        admWrapper.setEntity((Object)admissionEntity);
        AdmissionEntity admission = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)admWrapper);
        if (Objects.nonNull(orderEntity.getKeepOrder())) {
            log.info("\u4fdd\u4f9b\u8fc7\u671f\u65f6\u95f4");
            Date date = admission.getEndTime();
            return date;
        }
        if (null != inquiryServiceConfigEntity.getOrderTime()) {
            log.info("orderEntity:{}", (Object)JSON.toJSONString((Object)orderEntity));
            int addMinutes = inquiryServiceConfigEntity.getOrderTime();
            Date paymentTime = null;
            paymentTime = Objects.isNull(orderEntity.getPaymentTime()) ? admission.getXUpdateTime() : orderEntity.getPaymentTime();
            Date date = null;
            if (StringUtils.isNotEmpty((String)orderEntity.getScheduleId())) {
                String newDateTimeStr = DateUtils.dateToSimpleString((Date)orderEntity.getScheduleDate()) + " " + orderEntity.getScheduleEndTime() + ":00";
                date = DateUtils.stringToDate((String)newDateTimeStr, (String)"yyyy-MM-dd HH:mm:ss");
            } else {
                date = DateUtils.dateAddMinutes((Date)paymentTime, (int)addMinutes);
            }
            log.info("date:{}" + date);
            return date;
        }
        log.info("orderEntity.getPaymentTime():{}" + orderEntity.getPaymentTime());
        log.info("orderEntity.getPaymentTime().getTime():{}" + orderEntity.getPaymentTime().getTime());
        Date date = DateUtils.getDateAfter((Date)orderEntity.getPaymentTime(), (int)1);
        log.info("date:{}" + date);
        log.info("date.getTime:{}" + date.getTime());
        return date;
    }

    private void getDoctorTeam(QueryByAdmissionIdDTO reqVo, PatientMedicalRecordDetailsVo recordVo) {
        String doctor = reqVo.getDoctorId();
        List getPersonTeamResVoList = this.personTeam(reqVo.getAccessToken(), doctor);
        log.info("getPersonTeamResVoList:{}" + getPersonTeamResVoList.toString());
        ArrayList<Long> teamIds = new ArrayList<Long>();
        if (CollectionUtils.isEmpty((Collection)getPersonTeamResVoList)) {
            recordVo.setIsTeam(WhetherEnum.FORBID.getValue());
            recordVo.setTeamId(teamIds);
        } else {
            for (GetPersonTeamResVo getPersonTeamResVo : getPersonTeamResVoList) {
                List getPersonTeamDetialResVoList = getPersonTeamResVo.getTeamList();
                log.info("getPersonTeamDetialResVoList\uff1a" + getPersonTeamDetialResVoList.toString());
                getPersonTeamDetialResVoList = getPersonTeamDetialResVoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<GetPersonTeamDetialResVo>(Comparator.comparing(GetPersonTeamDetialResVo::getTeamId))), ArrayList::new));
                log.info("getPersonTeamDetialResVoList\uff1a" + getPersonTeamDetialResVoList.toString());
                for (GetPersonTeamDetialResVo getPersonTeamDetialResVo : getPersonTeamDetialResVoList) {
                    Long teamId = getPersonTeamDetialResVo.getTeamId();
                    teamIds.add(teamId);
                }
            }
            log.info("teamIds\uff1a" + ((Object)teamIds).toString());
            recordVo.setIsTeam(WhetherEnum.ALLOW.getValue());
            recordVo.setTeamId(teamIds);
        }
    }

    public List<GetPersonTeamResVo> personTeam(String accessToken, String doctor) {
        Long doctorId = Long.parseLong(doctor);
        String url = this.projProperties.getPersonTeam();
        String departmentUrl = url + "?accessToken=" + accessToken + "&doctorId=" + doctorId;
        log.info("departmentUrl :{}", (Object)JSON.toJSONString((Object)departmentUrl));
        try {
            String s = HttpKit.get((String)departmentUrl);
            log.info("s{}", (Object)JSON.toJSONString((Object)s));
            BaseResponse response = (BaseResponse)JSONObject.parseObject((String)s, BaseResponse.class);
            log.info("response: {}", (Object)JSON.toJSONString((Object)response));
            if (null == response.getData()) {
                return new ArrayList<GetPersonTeamResVo>();
            }
            List getPersonTeamResVoList = JSON.parseArray((String)JSON.toJSONString((Object)response.getData()), GetPersonTeamResVo.class);
            log.info("getPersonTeamResVoList:{}" + getPersonTeamResVoList.toString());
            return getPersonTeamResVoList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private PatientInfoRes GetpatientInfo(String patientId) {
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        PatientInfoRes patientInfo = new PatientInfoRes();
        patientInfo.setPatientId(patientEntity.getXId());
        patientInfo.setIdcard(patientEntity.getIdcard());
        patientInfo.setPatientName(patientEntity.getPatientName());
        patientInfo.setPortrait(patientEntity.getPortrait());
        patientInfo.setCardNo(patientEntity.getCardNo());
        patientInfo.setIdcard(patientEntity.getIdcard());
        patientInfo.setCredTypeCode(patientEntity.getCredTypeCode());
        patientInfo.setPatientUserId(null != patientEntity.getUserId() && !UNBIND.equals(patientEntity.getUserId()) ? patientEntity.getUserId() : null);
        Integer age = IDCardUtil.getAge((String)patientEntity.getIdcard());
        patientInfo.setAge(age);
        patientInfo.setTelphone(patientEntity.getTelphone());
        try {
            String genderStr = IDCardUtil.getGender((String)patientEntity.getIdcard());
            if (null != genderStr) {
                Integer gender = GenderEnum.FEMALE.getDesc().equals(genderStr) ? GenderEnum.FEMALE.getValue() : GenderEnum.MALE.getValue();
                patientInfo.setGender(gender);
            }
        }
        catch (Exception e) {
            logger.error("\u8eab\u4efd\u8bc1\u53f7\u83b7\u53d6\u60a3\u8005\u6027\u522b\u5931\u8d25\uff0c\u8eab\u4efd\u8bc1\u53f7\u7801={}", (Object)patientEntity.getIdcard(), (Object)e);
        }
        return patientInfo;
    }

    public ResultData<List<PatientMedicalRecordVo>> findPatientMedicalRecord(FindPatientMedicalRecordDTO dto) {
        List entities;
        List patientMedicalRecordVos = null;
        if (Optional.ofNullable(dto).isPresent() && Optional.ofNullable(entities = this.patientMedicalRecordMapper.findByPatientIdAllPatientMedicalRecord(dto.getPatientId(), dto.getServType())).isPresent()) {
            patientMedicalRecordVos = entities.stream().map(e -> new PatientMedicalRecordVo(e.getXId(), e.getTags(), e.getXCreateTime(), e.getDoctorName(), e.getDeptName())).collect(Collectors.toList());
            return new ResultData().success(patientMedicalRecordVos);
        }
        return new ResultData().error("\u67e5\u8be2\u5931\u8d25\u6216\u6ca1\u6709\u75c5\u5386\u4fe1\u606f");
    }

    public ResultData<QueryAdmissionVo> findAdmission(QueryByAdmissionIdDTO reqVo) {
        ResultData result = new ResultData();
        OrderEntity orderEntity = this.orderMapper.findByAdmId(reqVo.getAdmissionId());
        if (null == orderEntity) {
            return result.error("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff01");
        }
        CommentReviews review = new CommentReviews();
        QueryAdmissionVo recordVo = new QueryAdmissionVo();
        String xId = reqVo.getAdmissionId();
        PatientMedicalRecordDetailsVo countdownVo = this.admissionMapper.queryCountdowm(xId);
        if (countdownVo == null) {
            return result.error("\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
        log.info("admissionMapper.queryCountdowm," + countdownVo.toString());
        if (countdownVo.getScheduleDate() != null) {
            recordVo.setScheduleDate(countdownVo.getScheduleDate());
            recordVo.setScheduleRange(countdownVo.getScheduleRange());
            recordVo.setScheduleTimeStart(DateUtils.dateToString((Date)countdownVo.getScheduleDate(), (String)"yyyy-MM-dd") + " " + countdownVo.getScheduleStartTime() + ":00");
            recordVo.setScheduleTimeEnd(DateUtils.dateToString((Date)countdownVo.getScheduleDate(), (String)"yyyy-MM-dd") + " " + countdownVo.getScheduleEndTime() + ":00");
        }
        recordVo.setPatientId(countdownVo.getPatientId());
        recordVo.setOrganId(countdownVo.getOrganId());
        recordVo.setDoctorId(countdownVo.getDoctorId());
        recordVo.setDeptId(countdownVo.getDeptId());
        recordVo.setOrderId(countdownVo.getOrderId());
        recordVo.setUserId(countdownVo.getUserId());
        recordVo.setPauseTime(Long.valueOf(countdownVo.getPauseTime() == null ? 0L : countdownVo.getPauseTime()));
        recordVo.setStartTime(null != countdownVo.getStartTime() ? new Date(countdownVo.getStartTime().getTime()) : null);
        recordVo.setEndTime(countdownVo.getEndTime());
        recordVo.setPatientName(countdownVo.getPatientName());
        recordVo.setOrganCode(countdownVo.getOrganCode());
        recordVo.setCurrentNum(countdownVo.getCurrentNum());
        recordVo.setTotalNum(countdownVo.getTotalNum());
        recordVo.setPayAmount(countdownVo.getPayAmount());
        recordVo.setConsultationStatus(countdownVo.getConsultationStatus());
        recordVo.setFundType(orderEntity.getFundType());
        if (countdownVo.getOrderStatus().equals(OrderStatusEnum.CANCEL.getValue())) {
            recordVo.setVStatus(OrderStatusEnum.CANCEL.getValue());
            recordVo.setVStatusDesc(OrderStatusEnum.CANCEL.getDesc());
        } else if (countdownVo.getOrderStatus().equals(OrderStatusEnum.EXPIRED.getValue())) {
            recordVo.setVStatus(AdmissionStatusEnum.EXPIRED.getValue());
            recordVo.setVStatusDesc(AdmissionStatusEnum.EXPIRED.getDesc());
        } else {
            QueryWrapper evaluationWrapper = new QueryWrapper();
            EvaluationEntity evaluationEntity = new EvaluationEntity();
            evaluationEntity.setAdmId(countdownVo.getAdmId());
            evaluationEntity.setDisplay(new Integer(1).byteValue());
            evaluationWrapper.setEntity((Object)evaluationEntity);
            EvaluationEntity one = (EvaluationEntity)this.evaluationMapper.selectOne((Wrapper)evaluationWrapper);
            if (null != one) {
                log.info("one{}", (Object)JSON.toJSONString((Object)one));
                recordVo.setVStatus(AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue());
                recordVo.setVStatusDesc(AdmissionStatusEnum.getDesc((Integer)AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue()));
            } else {
                recordVo.setVStatus(countdownVo.getStatus());
                recordVo.setVStatusDesc(AdmissionStatusEnum.getDesc((Integer)countdownVo.getStatus()));
            }
            if (Objects.equals(countdownVo.getStatus(), AdmissionStatusEnum.ADMIN_REFUNDED_ADMISSION.getValue())) {
                recordVo.setVStatus(AdmissionStatusEnum.ADMIN_REFUNDED.getValue());
                recordVo.setVStatusDesc(AdmissionStatusEnum.getDesc((Integer)countdownVo.getStatus()));
            }
        }
        Date now = new Date();
        recordVo.setNowTime(now);
        InquiryServiceConfigEntity inquiryServiceConfigEntity = this.getInquiryServiceConfigEntity(orderEntity);
        if (null == inquiryServiceConfigEntity) {
            return result.error("\u672a\u67e5\u8be2\u5230\u8be5\u533b\u751f\u4e1a\u52a1\u8bbe\u7f6e\u4fe1\u606f!");
        }
        log.info("\u533b\u751f\u7684\u670d\u52a1\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)inquiryServiceConfigEntity));
        recordVo.setReceptionTime(countdownVo.getDoctorReception());
        AdmissionEntity admEntity = this.admissionMapper.findByAdmId(reqVo.getAdmissionId());
        recordVo.setDoctorServeTime(admEntity.getServTime());
        if (StringUtils.isNotEmpty((String)orderEntity.getScheduleId()) && "2291".equals(orderEntity.getOrganId()) && ServiceTypeEnum.NOS.getValue().equals(orderEntity.getServType()) && (AdmissionStatusEnum.WAIT_ADMISSION.getValue().equals(countdownVo.getStatus()) || AdmissionStatusEnum.EXPIRED.getValue().equals(countdownVo.getStatus()) || AdmissionStatusEnum.DOCTOR_CLOSED_WATING_SCHEDULE.getValue().equals(countdownVo.getStatus()) || AdmissionStatusEnum.RETIRED.getValue().equals(countdownVo.getStatus()))) {
            recordVo.setExpiredTime(orderEntity.getXUpdateTime());
        } else {
            Date date = this.getExpiredTime(orderEntity, inquiryServiceConfigEntity);
            recordVo.setExpiredTime(date);
        }
        if (this.getRefrerralPatient(reqVo, recordVo, inquiryServiceConfigEntity)) {
            return result.error("\u67e5\u8be2\u8ba2\u5355\u5931\u8d25!");
        }
        log.info("findAdmission\u63a5\u53e3ExpiredTime\u5012\u8ba1\u65f6,{}", (Object)recordVo.getExpiredTime().getTime());
        PatientInfoRes patientInfo = this.GetpatientInfo(countdownVo.getPatientId());
        recordVo.setPatientAge(patientInfo.getAge());
        recordVo.setPatientGender(patientInfo.getGender());
        log.info("\u60a3\u8005\u7aef\u67e5\u8be2\u75c5\u4f8b\u5217\u8868\u5165\u53c2\uff1a" + countdownVo.getDoctorId() + "-" + countdownVo.getOrganId() + "-" + countdownVo.getPatientId());
        List medicalRecord = this.admissionMapper.queryMedicalRecordPatient(countdownVo.getDoctorId(), countdownVo.getOrganId(), countdownVo.getPatientId(), countdownVo.getServType(), orderEntity.getDoctorType());
        log.info("\u60a3\u8005\u7aef\u67e5\u8be2\u75c5\u4f8b\u5217\u8868\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)medicalRecord));
        for (MedicalRecordVo req : medicalRecord) {
            req.setComment(review);
            req.setName(req.getTagName());
            if (req.getStatus().equals(AdmissionStatusEnum.REFUNDED_APPLY.getValue()) || req.getStatus().equals(AdmissionStatusEnum.REFUNDED_REFUSE.getValue())) {
                req.setStatusDesc(AdmissionStatusEnum.RETIRED.getDesc());
                continue;
            }
            if (req.getStatus().equals(AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue())) {
                req.setStatusDesc(AdmissionStatusEnum.EXPIRED.getDesc());
                continue;
            }
            req.setStatusDesc(AdmissionStatusEnum.getDesc((Integer)req.getStatus()));
        }
        recordVo.setMedicalRecord(medicalRecord);
        recordVo.setDocType(countdownVo.getDocType());
        recordVo.setServType(countdownVo.getServType());
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(countdownVo.getDoctorId());
        BaseResponse doctorInfo = this.doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
        if (doctorInfo == null || !doctorInfo.isSuccess()) {
            return result.error("\u533b\u751f\u59d3\u540d\u83b7\u53d6\u5931\u8d25");
        }
        PersonnelInfo infoVo = (PersonnelInfo)doctorInfo.getData();
        recordVo.setDoctorName(infoVo.getDoctorName());
        recordVo.setPortrait(infoVo.getPortrait());
        recordVo.setDoctorTitle(infoVo.getTitle());
        recordVo.setDeptName(orderEntity.getDeptName());
        recordVo.setOrganName(orderEntity.getHospitalName());
        recordVo.setMedicalRecordId(orderEntity.getMedicalRecordId());
        if (DoctorTypeEnum.TEAM.getValue().equals(orderEntity.getDoctorType())) {
            List teamDoctorInfoEntityList = this.teamDoctorInfoMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(TeamDoctorInfoEntity::getAdmId, (Object)reqVo.getAdmissionId()));
            ArrayList<TeamImAccount> teamImAccounts = new ArrayList<TeamImAccount>();
            if (!CollectionUtils.isEmpty((Collection)teamDoctorInfoEntityList)) {
                for (TeamDoctorInfoEntity teamDoctorInfoEntity : teamDoctorInfoEntityList) {
                    TeamImAccount teamImAccount = new TeamImAccount();
                    IMQueryTargetSdkAccountRspVO imAccountRes = this.imAccountService.queryImAccount(reqVo.getAdmissionId(), "EHOS_DOCTOR", teamDoctorInfoEntity.getDoctorId());
                    teamImAccount.setImAccount(imAccountRes.getSdkAccount());
                    teamImAccount.setDoctorName(teamDoctorInfoEntity.getDoctorName());
                    teamImAccount.setPortrait(teamDoctorInfoEntity.getPortrait());
                    teamImAccount.setTitle(teamDoctorInfoEntity.getTitle());
                    teamImAccounts.add(teamImAccount);
                }
            }
            recordVo.setTeamImAccount(teamImAccounts);
        }
        return result.success((Object)recordVo);
    }

    private boolean getRefrerralPatient(QueryByAdmissionIdDTO reqVo, QueryAdmissionVo recordVo, InquiryServiceConfigEntity inquiryServiceConfigEntity) {
        OrderEntity orderEntity1 = this.orderMapper.findByAdmId(reqVo.getAdmissionId());
        if (null == orderEntity1) {
            log.info("\u6839\u636e\u5c31\u8bcaid\u67e5\u8be2\u7684\u8ba2\u5355\u4e3a\u7a7a,\u5c31\u8bcaid\u4e3a:{}", (Object)reqVo.getAdmissionId());
            return true;
        }
        log.info("orderEntity1:{}" + JSON.toJSONString((Object)orderEntity1));
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity entity = new OrderEntity();
        entity.setDealSeq(orderEntity1.getDealSeq());
        log.info("entity:{}" + entity.toString());
        queryWrapper.setEntity((Object)entity);
        List list = this.orderMapper.selectList((Wrapper)queryWrapper);
        log.info("list:{}" + list.toString());
        if (list.size() > 1) {
            log.info("\u662f\u8f6c\u8bca\u7684\u8ba2\u5355");
            AdmissionEntity admissionEntity = this.admissionMapper.findById(reqVo.getAdmissionId());
            log.info("\u8f6c\u8bca\u7684AdmId:{}", (Object)reqVo.getAdmissionId());
            log.info("\u8f6c\u8bca\u7684admissionEntity\uff1a{}", (Object)JSON.toJSONString((Object)admissionEntity));
            int addMinutes = inquiryServiceConfigEntity.getOrderTime();
            Date date = DateUtils.dateAddMinutes((Date)admissionEntity.getXCreateTime(), (int)addMinutes);
            log.info("\u8f6c\u8bca\u7684\u5012\u8ba1\u65f6date:{}", (Object)date.getTime());
            recordVo.setExpiredTime(date);
        }
        return false;
    }

    private InquiryServiceConfigEntity getInquiryServiceConfigEntity(OrderEntity orderEntity) {
        InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
        wrapperEntity.setDoctorId(orderEntity.getDoctorId());
        wrapperEntity.setOrganId(String.valueOf(orderEntity.getOrganId()));
        if (ServiceTypeEnum.NOS.getValue().equals(orderEntity.getServType())) {
            wrapperEntity.setDeptId(orderEntity.getDeptId());
            wrapperEntity.setServiceCode(ServiceTypeEnum.NOS.getCode());
        }
        if (ServiceTypeEnum.HOS.getValue().equals(orderEntity.getServType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.HOS.getCode());
        }
        if (ServiceTypeEnum.BMMZ.getValue().equals(orderEntity.getServType())) {
            wrapperEntity.setDeptId(orderEntity.getDeptId());
            wrapperEntity.setServiceCode(ServiceTypeEnum.BMMZ.getCode());
        }
        log.info("wrapperEntity:{}", (Object)JSON.toJSONString((Object)wrapperEntity));
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.setEntity((Object)wrapperEntity);
        queryWrapper1.last("limit 1");
        return (InquiryServiceConfigEntity)this.baseService.getOne((Wrapper)queryWrapper1);
    }

    private QueryAdmissionVo getReferral(QueryByAdmissionIdDTO reqVo, InquiryServiceConfigEntity inquiryServiceConfigEntity) {
        QueryAdmissionVo queryAdmissionVo = new QueryAdmissionVo();
        OrderEntity orderEntity1 = this.orderMapper.findByAdmId(reqVo.getAdmissionId());
        if (null == orderEntity1) {
            return queryAdmissionVo;
        }
        log.info("orderEntity1:{}" + orderEntity1.toString());
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity entity = new OrderEntity();
        entity.setDealSeq(orderEntity1.getDealSeq());
        log.info("entity:{}" + entity.toString());
        queryWrapper.setEntity((Object)entity);
        List list = this.orderMapper.selectList((Wrapper)queryWrapper);
        log.info("list:{}" + list.toString());
        if (list.size() == 1) {
            queryAdmissionVo.setIsReferred(WhetherEnum.FORBID.getValue());
        }
        if (list.size() > 1) {
            log.info("======\u8f6c\u8bca\u8ba2\u5355\u7684\u5012\u8ba1\u65f6======");
            AdmissionEntity admissionEntity = this.admissionMapper.findById(reqVo.getAdmissionId());
            log.info("\u8f6c\u8bca\u7684AdmissionId:{}", (Object)reqVo.getAdmissionId());
            log.info("\u8f6c\u8bca\u7684admissionEntity\uff1a{}", (Object)JSON.toJSONString((Object)admissionEntity));
            int addMinutes = inquiryServiceConfigEntity.getOrderTime();
            Date date = DateUtils.dateAddMinutes((Date)admissionEntity.getXCreateTime(), (int)addMinutes);
            log.info("\u8f6c\u8bca\u7684\u5012\u8ba1\u65f6date:{}", (Object)date.getTime());
            queryAdmissionVo.setExpiredTime(date);
            queryAdmissionVo.setIsReferred(WhetherEnum.ALLOW.getValue());
        }
        log.info("queryAdmissionVo:{}" + JSON.toJSONString((Object)queryAdmissionVo));
        return queryAdmissionVo;
    }

    public ResultData<List<QueryRecordsByTimeRes>> queryRecentRecords(QueryRecordsByTimeReq param) {
        ResultData result = new ResultData();
        AdmissionEntity admission = this.admissionMapper.findById(param.getAdmissionId());
        if (admission == null) {
            return result.error("\u627e\u4e0d\u5230\u6b64\u6761\u54a8\u8be2\u8bb0\u5f55-admissionId:" + param.getAdmissionId());
        }
        this.perfectParams(param, admission);
        List records = this.patientMedicalRecordMapper.queryRecordsByTime(param);
        for (QueryRecordsByTimeRes record : records) {
            record.setStatusDesc(AdmissionStatusEnum.getDesc((Integer)record.getStatus()));
            record.setRecordName(record.getTags());
        }
        return result.success((Object)records);
    }

    private void perfectParams(QueryRecordsByTimeReq param, AdmissionEntity admission) {
        param.setOrganId(admission.getOrganId());
        param.setPatientId(admission.getPatientId());
        param.setEndTime(null);
        Date threeAgo = DateUtils.getDateBefore((Date)new Date(), (int)3);
        String simpleString = DateUtils.dateToSimpleString((Date)threeAgo);
        param.setStartTime(simpleString);
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(AdmissionStatusEnum.IN_CONSULTATION.getValue());
        statusList.add(AdmissionStatusEnum.FINISH_APPLY.getValue());
        statusList.add(AdmissionStatusEnum.FINISH_TIME_OUT.getValue());
        param.setStatusList(statusList);
    }

    public ResultData<QueryPatientMedicalRecordDetailsVO> queryRecordDetails(QueryPatientMedicalRecordDetailsDTO param) {
        ResultData result = new ResultData();
        PatientMedicalRecordEntity patientMedicalRecordEntity = this.patientMedicalRecordMapper.findById(param.getRecordId());
        if (patientMedicalRecordEntity == null) {
            return result.error("\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
        QueryPatientMedicalRecordDetailsVO data = new QueryPatientMedicalRecordDetailsVO();
        BeanUtils.copyProperties((Object)patientMedicalRecordEntity, (Object)data);
        data.setMedicalPictureList(this.patientMedicalPictureMapper.queryRecordPictures(param.getRecordId()));
        data.setLastDeptName(patientMedicalRecordEntity.getDeptName());
        data.setLastDoctorName(patientMedicalRecordEntity.getDoctorName());
        return result.success((Object)data);
    }

    public BaseResponse<GetDoctorWebImPatientMedicalDetailVoRes> getDoctorWebImPatientMedicalDetail(GetDoctorWebImPatientMedicalDetailVoReq getDoctorWebImPatientMedicalDetailVoReq) {
        GetDoctorWebImPatientMedicalDetailVoRes getDoctorWebImPatientMedicalDetailVoRes = new GetDoctorWebImPatientMedicalDetailVoRes();
        AdmissionEntity admissionEntity = this.admissionMapper.findById(getDoctorWebImPatientMedicalDetailVoReq.getAdmId());
        log.info("\u6839\u636eid\u83b7\u53d6\u7684\u95ee\u8bca\u8bb0\u5f55\u4e3a" + admissionEntity.toString());
        if (null == admissionEntity) {
            return BaseResponse.error((String)("\u83b7\u53d6\u7684\u95ee\u8bca\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u4f20\u5165\u7684\u53c2\u6570\u4e3a" + getDoctorWebImPatientMedicalDetailVoReq.getAdmId()));
        }
        PatientDynamicMedicalEntityVo patientDynamicMedicalEntityVo = this.internetHospitalDetailInfoService.getMedicalInfoById(admissionEntity.getMedicalRecordId());
        if (Objects.nonNull(patientDynamicMedicalEntityVo)) {
            log.info("\u6839\u636e\u75c5\u5386id\u67e5\u8be2\u75c5\u5386\u8bb0\u5f55\u4e3a\uff1a" + patientDynamicMedicalEntityVo.toString());
            List listBaseResponse = this.internetHospitalDetailInfoService.getMedicalUserFills(patientDynamicMedicalEntityVo.getServType(), patientDynamicMedicalEntityVo.getMedicalDetail(), patientDynamicMedicalEntityVo.getHospitalId(), patientDynamicMedicalEntityVo.getDeptId());
            if (CollectionUtils.isEmpty((Collection)listBaseResponse)) {
                return BaseResponse.error((String)"\u75c5\u4f8b\u89e3\u6790\u9519\u8bef");
            }
            getDoctorWebImPatientMedicalDetailVoRes.setMedicalUserFills(listBaseResponse);
        }
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(admissionEntity.getPatientId());
        getDoctorWebImPatientMedicalDetailVoRes.setPatientName(patientEntity.getPatientName());
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionEntity.getXId());
        log.info("==========\u83b7\u53d6\u7684\u8ba2\u5355\u8bb0\u5f55\u4e3a\uff1a=========" + orderEntity.toString());
        if (null == orderEntity) {
            return BaseResponse.success((Object)getDoctorWebImPatientMedicalDetailVoRes);
        }
        if (null != orderEntity.getScheduleDate()) {
            getDoctorWebImPatientMedicalDetailVoRes.setScheduleDate(DateUtils.dateToSimpleString((Date)orderEntity.getScheduleDate()));
        }
        return BaseResponse.success((Object)getDoctorWebImPatientMedicalDetailVoRes);
    }

    private OrderEntity getOrderById(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity wrapperEntity = new OrderEntity();
        wrapperEntity.setXId(id);
        queryWrapper.setEntity((Object)wrapperEntity);
        OrderEntity orderEntity = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapper);
        if (null == orderEntity) {
            return null;
        }
        return orderEntity;
    }

    public BaseResponse<List<PatientEntity>> getPatientInfo(PatientEntity pojo) {
        ArrayList collect = this.patientMapper.select(pojo).stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PatientEntity>(Comparator.comparing(PatientEntity::getIdcard))), ArrayList::new));
        return BaseResponse.success((Object)collect);
    }

    public BaseResponse<String> patientConfirmsCase(PatientConfirmsCaseVo vo) {
        AdmissionEntity admission = this.admissionMapper.findById(vo.getAdmId());
        if (admission == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u5c31\u8bca\u4fe1\u606f");
        }
        Integer updated = this.patientMedicalRecordMapper.updateCanEditByMedicalId(Integer.valueOf(2), admission.getMedicalRecordId());
        if (updated > 0) {
            OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)admission.getOrderId()));
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(AutoReplyMessagesEntity::getAppcode, (Object)orderEntity.getAppCode());
            queryWrapper.in(AutoReplyMessagesEntity::getSortOrder, new Object[]{1, 2});
            queryWrapper.orderByAsc(AutoReplyMessagesEntity::getSortOrder);
            queryWrapper.last("limit 2");
            List autoReplyMessagesEntities = this.autoReplyMessagesMapper.selectList((Wrapper)queryWrapper);
            autoReplyMessagesEntities.forEach(entity -> this.imInformService.bmAutoSendIm(vo.getAdmId(), entity.getMessage(), admission.getDoctorName(), "TEXT"));
            AdmissionEntity upDateAdmission = new AdmissionEntity();
            upDateAdmission.setXId(vo.getAdmId());
            upDateAdmission.setMsgTimes(Integer.valueOf(2));
            upDateAdmission.setIsContinue(Boolean.valueOf(true));
            this.admissionMapper.update(upDateAdmission);
            return BaseResponse.success((Object)"\u786e\u8ba4\u6210\u529f");
        }
        return BaseResponse.error((String)"\u786e\u8ba4\u5931\u8d25");
    }

    @Transactional
    public BaseResponse<String> updateCase(InsertPatientMedicalRecordDTO vo) {
        List urls;
        PatientMedicalRecordEntity patientMedicalRecord = this.buildNewPatientMedicalRecord(vo);
        log.info("\u66f4\u65b0\u75c5\u4f8b\u5165\u53c2{}", (Object)JSON.toJSONString((Object)patientMedicalRecord));
        OrderEntity orderEntity = this.orderMapper.getByMedicalRecordId(vo.getMedicalId());
        if ("7".equals(vo.getServType())) {
            PatientDynamicMedicalEntityVo medicalInfoById = this.internetHospitalDetailInfoService.getMedicalInfoById(vo.getMedicalId());
            log.info("\u67e5\u8be2sys\u75c5\u4f8b\u4fe1\u606f===\u300b{}", (Object)JSON.toJSONString((Object)medicalInfoById));
            String medicalDetail = medicalInfoById.getMedicalDetail();
            if (StringUtils.isNotBlank((String)medicalDetail)) {
                JSONObject parseObject = JSONObject.parseObject((String)medicalDetail);
                patientMedicalRecord.setPharmaceuticalCompanyId(parseObject.getString("drugManufacturersId"));
                patientMedicalRecord.setPharmaceuticalCompanyName(parseObject.getString("drugManufacturers"));
                patientMedicalRecord.setStoreId(parseObject.getString("pharmacyId"));
                patientMedicalRecord.setStoreName(parseObject.getString("pharmacy"));
                String isMedicalInsLabel = parseObject.getString("isMedicalInsLabel");
                if ("\u533b\u4fdd\u652f\u4ed8".equals(isMedicalInsLabel)) {
                    patientMedicalRecord.setIsMedicalInsLabel(Integer.valueOf(1));
                } else {
                    patientMedicalRecord.setIsMedicalInsLabel(Integer.valueOf(2));
                }
                patientMedicalRecord.setCanEdit(Integer.valueOf(2));
            }
            log.info("=====\u4fbf\u6c11\u60a3\u8005\u66f4\u65b0\u75c5\u5386\u3001\u91cd\u65b0\u6dfb\u52a0\u836f\u54c1\u5230\u533b\u836f\u4e91=====");
            CompletableFuture.runAsync(() -> {
                JSONObject parseObject = JSONObject.parseObject((String)medicalDetail);
                String historyMedicationInfo = parseObject.getString("historyMedication");
                log.info("\u8f6c\u6362\u524d\u836f\u54c1\u4fe1\u606f===\u300b{}", (Object)JSON.toJSONString((Object)historyMedicationInfo));
                List dtoList = JSONObject.parseArray((String)historyMedicationInfo, DrugRecordDto.class);
                log.info("\u8f6c\u6362\u540e\u836f\u54c1\u4fe1\u606f===\u300b{}", (Object)JSON.toJSONString((Object)dtoList));
                if (Optional.ofNullable(dtoList).isPresent() && !dtoList.isEmpty()) {
                    dtoList.forEach(d -> {
                        Integer type = d.getType();
                        d.setDrugType(Integer.valueOf(type == 1 ? 4 : type));
                        d.setType(Integer.valueOf(type == 1 ? 4 : type));
                        if (d.getType() == 4) {
                            d.setDrugDosage(d.getDrugQuantity());
                            d.setRemark(d.getRemark());
                        } else {
                            d.setDrugDosage(d.getDrugQuantity());
                            d.setSingleDoes(d.getDrugQuantity());
                            d.setRemark(d.getRemark());
                        }
                        DrugOrderCartDto drugOrderCartDto = new DrugOrderCartDto();
                        drugOrderCartDto.setOrderNumber(orderEntity.getXId());
                        drugOrderCartDto.setAppCode(orderEntity.getAppCode());
                        drugOrderCartDto.setDrugRecordDto(d);
                        this.managerOrderService.saveDrugRecord(drugOrderCartDto);
                    });
                }
            });
        }
        patientMedicalRecord.setXUpdateTime(new Date());
        patientMedicalRecord.setXVersion(Long.valueOf(0L));
        patientMedicalRecord.setServType(Integer.valueOf(vo.getServType()));
        patientMedicalRecord.setXId(vo.getMedicalId());
        patientMedicalRecord.setDoctorName(vo.getDoctorName());
        patientMedicalRecord.setDeptName(vo.getDeptName());
        log.info("\u66f4\u65b0\u75c5\u4f8b\u6784\u5efa\u5b8c\u540e\u7684\u5165\u53c2{}", (Object)JSON.toJSONString((Object)patientMedicalRecord));
        Integer result = this.patientMedicalRecordMapper.updatePatientMedicalRecord(patientMedicalRecord);
        if (result > 0 && Optional.ofNullable(urls = vo.getMedicalPictureList()).isPresent() && !urls.isEmpty() && !this.pictureService.updatePatientMedicalPicture(urls, patientMedicalRecord.getXId())) {
            log.info("\u6279\u91cf\u66f4\u65b0\u75c5\u5386\u56fe\u7247\u94fe\u63a5\u5931\u8d25");
            return BaseResponse.error((String)"\u6279\u91cf\u66f4\u65b0\u75c5\u5386\u56fe\u7247\u94fe\u63a5\u5931\u8d25");
        }
        AdmissionEntity admissionEntity = this.admissionMapper.findByMedicalRecordId(vo.getMedicalId());
        log.info("\u66f4\u65b0\u5b8c\u75c5\u4f8b\u91cd\u65b0\u63a8\u9001\u75c5\u4f8b\u5361\u7247\u5165\u53c2{}", (Object)JSON.toJSONString((Object)admissionEntity));
        this.imInformService.rePushCaseCards(admissionEntity.getXId());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(AutoReplyMessagesEntity::getAppcode, (Object)orderEntity.getAppCode());
        queryWrapper.in(AutoReplyMessagesEntity::getSortOrder, new Object[]{1, 2});
        queryWrapper.orderByAsc(AutoReplyMessagesEntity::getSortOrder);
        queryWrapper.last("limit 2");
        List autoReplyMessagesEntities = this.autoReplyMessagesMapper.selectList((Wrapper)queryWrapper);
        autoReplyMessagesEntities.forEach(entity -> this.imInformService.bmAutoSendIm(admissionEntity.getXId(), entity.getMessage(), admissionEntity.getDoctorName(), "TEXT"));
        AdmissionEntity upDateAdmission = new AdmissionEntity();
        upDateAdmission.setXId(admissionEntity.getXId());
        upDateAdmission.setMsgTimes(Integer.valueOf(2));
        upDateAdmission.setIsContinue(Boolean.valueOf(true));
        this.admissionMapper.update(upDateAdmission);
        return BaseResponse.success((Object)"\u66f4\u65b0\u6210\u529f");
    }

    public BaseResponse<Integer> getNumberOfDoses(GetNumberOfDosesDTO dto) {
        JSONObject parseObject;
        String presNum;
        log.info("\u83b7\u53d6\u60a3\u8005\u586b\u5199\u7684\u4e2d\u836f\u5242\u6570\u5165\u53c2{}", (Object)JSON.toJSONString((Object)dto));
        OrderEntity orderEntity = this.orderMapper.findById(dto.getOrderNumber());
        if (orderEntity == null) {
            return BaseResponse.success((Object)1);
        }
        PatientDynamicMedicalEntityVo medicalInfoById = this.internetHospitalDetailInfoService.getMedicalInfoById(orderEntity.getMedicalRecordId());
        log.info("\u67e5\u8be2\u5230\u7684\u75c5\u4f8b\u4fe1\u606f===\u300b{}", (Object)JSON.toJSONString((Object)medicalInfoById));
        String medicalDetail = medicalInfoById.getMedicalDetail();
        if (StringUtils.isNotBlank((String)medicalDetail) && StringUtils.isNotBlank((String)(presNum = (parseObject = JSONObject.parseObject((String)medicalDetail)).getString("presNum")))) {
            return BaseResponse.success((Object)Integer.valueOf(presNum));
        }
        return BaseResponse.success((Object)1);
    }
}

