/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctoruser.api.common.enums.DoctorTypeEnum;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.doctoruser.api.pojo.vo.account.DoctorIdReqVO;
import com.doctoruser.api.pojo.vo.account.DoctorInfoRespVO;
import com.ebaiyihui.common.pojo.vo.UserLastLoginDeviceReqVo;
import com.ebaiyihui.common.pojo.vo.UserLastLoginDeviceRespVo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.PatientNoResponseReqVo;
import com.ebaiyihui.onlineoutpatient.common.vo.serviceconfig.RequestGetDoctorOfficeStatus;
import com.ebaiyihui.onlineoutpatient.common.vo.serviceconfig.RequestOnlineOrOfflineVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ChannelCodeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.DoctorTeamMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.TeamDoctorInfoMapper;
import com.ebaiyihui.onlineoutpatient.core.exception.AdmissionException;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.DoctorTeamEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.TeamDoctorInfoEntity;
import com.ebaiyihui.onlineoutpatient.core.service.InquiryServiceConfigService;
import com.ebaiyihui.onlineoutpatient.core.service.UmAppPushService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.utils.PushUtils;
import com.ebaiyihui.onlineoutpatient.core.vo.PushConfigurationDetailVO;
import com.ebaiyihui.onlineoutpatient.core.vo.UmPushMsgAndroidReqVO;
import com.ebaiyihui.onlineoutpatient.core.vo.UmPushMsgIOSReqVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import com.ebaiyihui.usercenter.client.UserClient;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmAppPushServiceImpl
implements UmAppPushService {
    private static final Logger log = LoggerFactory.getLogger(UmAppPushServiceImpl.class);
    @Autowired
    private UserClient userClient;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private PushUtils pushUtils;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private InquiryServiceConfigService inquiryServiceConfigService;
    @Autowired
    private DoctorTeamMapper doctorTeamMapper;
    @Autowired
    private DoctorInfofeignClient doctorClient;
    @Autowired
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;
    @Autowired
    private TeamDoctorInfoMapper teamDoctorInfoMapper;

    public void onlineVisitsReceivePush(String docName, String patientId, String admissionId) {
        log.info("========\u533b\u751f\u63a5\u8bcaapp\u63a8\u9001=========");
        String userId = this.getUserIdByPatient(patientId, admissionId);
        if (StringUtils.isEmpty((String)userId)) {
            log.error("========\u83b7\u53d6userId\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.getpatUserDeviceToken(userId, new Short("0"));
        if (null == userLastLoginDeviceRespVo) {
            log.error("========\u83b7\u53d6\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u6e20\u9053\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        if (StringUtils.isEmpty((String)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("=======\u83b7\u53d6\u7528\u6237\u7684\u8bbe\u5907\u6807\u8bc6=======");
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.buildReceiveAndroidPushMsgTemplate(docName, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId);
            this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.buildReceiveIOSPushMsgTemplate(docName, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId);
            this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
            return;
        }
    }

    public void onlineVisitsAdmidDatePush(String docName, String patientId, String admissionId) {
        log.info("========\u5c31\u8bca\u5f53\u65e5app\u63a8\u9001=========");
        String userId = this.getUserIdByPatient(patientId, admissionId);
        if (StringUtils.isEmpty((String)userId)) {
            log.error("========\u83b7\u53d6userId\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.getpatUserDeviceToken(userId, new Short("0"));
        if (null == userLastLoginDeviceRespVo) {
            log.error("========\u83b7\u53d6\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u6e20\u9053\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        if (StringUtils.isEmpty((String)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("=======\u83b7\u53d6\u7528\u6237\u7684\u8bbe\u5907\u6807\u8bc6=======");
            return;
        }
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        if (null == orderEntity) {
            log.error("=======\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25===========");
            return;
        }
        String scheduleStartTime = orderEntity.getScheduleStartTime();
        String scheduleEndTime = orderEntity.getScheduleEndTime();
        if (orderEntity.getServType().equals(ServiceTypeEnum.HOS.getValue())) {
            if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
                UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.buildAdmidDateAndroidPushMsgTemplate(docName, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId, scheduleStartTime, scheduleEndTime);
                this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
                return;
            }
            if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
                UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.buildAdmidDateIOSPushMsgTemplate(docName, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId, scheduleStartTime, scheduleEndTime);
                this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
                return;
            }
        } else if (orderEntity.getServType().equals(ServiceTypeEnum.NOS.getValue())) {
            if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
                UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.buildAdmidDateAndroidPushMsgTemplateNOS(docName, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId, scheduleStartTime, scheduleEndTime);
                this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
                return;
            }
            if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
                UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.buildAdmidDateIOSPushMsgTemplateNOS(docName, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId, scheduleStartTime, scheduleEndTime);
                this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
                return;
            }
        }
    }

    public void onlineVisitDocSendVideoPush(String admissionId) {
        log.info("========\u53d1\u8d77\u89c6\u9891app\u63a8\u9001=========");
        AdmissionEntity admissionInfo = this.getAdmissionInfo(admissionId);
        if (null == admissionInfo) {
            log.error("========\u83b7\u53d6\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionId);
            return;
        }
        String userId = this.getUserIdByPatient(admissionInfo.getPatientId(), admissionId);
        if (StringUtils.isEmpty((String)userId)) {
            log.error("========\u83b7\u53d6userId\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.getpatUserDeviceToken(userId, new Short("0"));
        if (null == userLastLoginDeviceRespVo) {
            log.error("========\u83b7\u53d6\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u6e20\u9053\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        if (StringUtils.isEmpty((String)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("=======\u83b7\u53d6\u7528\u6237\u7684\u8bbe\u5907\u6807\u8bc6=======");
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.buildDocSendVideoAndroidPushMsgTemplate(admissionInfo.getDoctorName(), userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId);
            this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.buildDocSendVideoIOSPushMsgTemplate(admissionInfo.getDoctorName(), userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId);
            this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
            return;
        }
    }

    public void doctorOnlineVisitsApplicationSuccessfulAppPush(String patientId, String doctorId, String hospitalId, String admissionId, String appCode) {
        log.info("========\u60a3\u8005\u4e0b\u5355   \u533b\u751fapp\u63a8\u9001=========");
        AdmissionEntity admissionInfo = this.getAdmissionInfo(admissionId);
        if (null == admissionInfo) {
            log.error("========\u83b7\u53d6\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionId);
            return;
        }
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == patientEntity) {
            log.error("========\u83b7\u53d6\u60a3\u8005\u59d3\u540d\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + patientId);
            return;
        }
        String patientName = patientEntity.getPatientName();
        String userId = this.getUserIdByDoctorIdAndHospitalId(doctorId, hospitalId);
        ArrayList<String> userIds = new ArrayList<String>();
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType())) {
            List teamDoctorInfoEntityList = this.teamDoctorInfoMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(TeamDoctorInfoEntity::getAdmId, (Object)admissionId));
            if (!CollectionUtils.isEmpty((Collection)teamDoctorInfoEntityList)) {
                teamDoctorInfoEntityList.forEach(entity -> userIds.add(entity.getUesrId()));
            }
        } else {
            userIds.add(userId);
        }
        log.info("\u533b\u751f\u56e2\u961fuserId:{}", userIds);
        for (String id : userIds) {
            UmPushMsgIOSReqVo umPushMsgIOSReqVo;
            UmPushMsgAndroidReqVO umPushMsgAndroidReqVO;
            if (StringUtils.isEmpty((String)id)) {
                log.error("========\u83b7\u53d6userId\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========", (Object)id);
                continue;
            }
            UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.getDocUserDeviceToken(id, new Short("1"));
            if (null == userLastLoginDeviceRespVo) {
                log.error("========\u83b7\u53d6\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u6e20\u9053\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========", (Object)id);
                continue;
            }
            if (StringUtils.isEmpty((String)userLastLoginDeviceRespVo.getDeviceType())) {
                log.info("=======\u83b7\u53d6\u7528\u6237\u7684\u8bbe\u5907\u6807\u8bc6=======", (Object)id);
                continue;
            }
            RequestGetDoctorOfficeStatus requestGetDoctorOfficeStatus = new RequestGetDoctorOfficeStatus();
            requestGetDoctorOfficeStatus.setAppCode(appCode);
            requestGetDoctorOfficeStatus.setDoctorId(doctorId);
            requestGetDoctorOfficeStatus.setHospitalId(hospitalId);
            log.info("requestGetDoctorOfficeStatus:" + JSON.toJSONString((Object)requestGetDoctorOfficeStatus));
            BaseResponse requestOnlineOrOfflineVo = this.inquiryServiceConfigService.getDoctorOfficeStatus(requestGetDoctorOfficeStatus);
            log.info("requestOnlineOrOfflineVo:" + JSON.toJSONString((Object)requestOnlineOrOfflineVo.getData()));
            if (null == requestOnlineOrOfflineVo.getData()) {
                log.info("=======\u533b\u751f\u4e0a\u4e0b\u7ebf\u72b6\u6001\u4e3anull=======", (Object)id);
                continue;
            }
            if (((RequestOnlineOrOfflineVo)requestOnlineOrOfflineVo.getData()).getOfficeStatus().equals(-1)) {
                log.info("=======\u533b\u751f\u4e0b\u7ebf,\u4e0d\u63a8\u9001=======", (Object)id);
                continue;
            }
            if (admissionInfo.getServType().equals(ServiceTypeEnum.HOS.getValue())) {
                if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
                    umPushMsgAndroidReqVO = this.buildCreateOrderDocAndroidPushMsgTemplate(patientName, userLastLoginDeviceRespVo.getDeviceNumber(), id, admissionId);
                    this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
                    continue;
                }
                if (!userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) continue;
                umPushMsgIOSReqVo = this.buildCreateOrderDocIOSPushMsgTemplate(patientName, userLastLoginDeviceRespVo.getDeviceNumber(), id, admissionId);
                this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
                continue;
            }
            if (admissionInfo.getServType().equals(ServiceTypeEnum.NOS.getValue())) {
                if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
                    umPushMsgAndroidReqVO = this.buildCreateOrderDocAndroidPushMsgTemplateNOS(patientName, userLastLoginDeviceRespVo.getDeviceNumber(), id, admissionId);
                    this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
                    continue;
                }
                if (!userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) continue;
                umPushMsgIOSReqVo = this.buildCreateOrderDocIOSPushMsgTemplateNOS(patientName, userLastLoginDeviceRespVo.getDeviceNumber(), id, admissionId);
                this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
                continue;
            }
            if (!admissionInfo.getServType().equals(ServiceTypeEnum.BMMZ.getValue())) continue;
            if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
                umPushMsgAndroidReqVO = this.buildCreateOrderDocAndroidPushMsgTemplateBMMZ(patientName, userLastLoginDeviceRespVo.getDeviceNumber(), id, admissionId);
                this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
                continue;
            }
            if (!userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) continue;
            umPushMsgIOSReqVo = this.buildCreateOrderDocIOSPushMsgTemplateBMMZ(patientName, userLastLoginDeviceRespVo.getDeviceNumber(), id, admissionId);
            this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
        }
    }

    private UmPushMsgIOSReqVo buildCreateOrderDocIOSPushMsgTemplateBMMZ(String patientName, String deviceToken, String userId, String admId) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getSuccessfulOVAppPushBusiCode());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("doctor", "IOS", admId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceToken);
        String body = MessageFormat.format("{0}\u60a3\u8005\u5411\u60a8\u7533\u8bf7\u4fbf\u6c11\u95e8\u8bca\uff0c\u70b9\u51fb\u54a8\u8be2\u4e0e\u590d\u8bca\u63a5\u5f85\u60a3\u8005\u3002", patientName);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle("\u4fbf\u6c11\u95e8\u8bca\u7533\u8bf7\u63d0\u9192");
        umPushMsgIOSReqVo.setSubTitle("\u4fbf\u6c11\u95e8\u8bca\u7533\u8bf7\u63d0\u9192");
        umPushMsgIOSReqVo.setDescription("\u4fbf\u6c11\u95e8\u8bca\u7533\u8bf7\u63d0\u9192");
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", "426");
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(5, 9));
        parameter.put("admId", admId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgAndroidReqVO buildCreateOrderDocAndroidPushMsgTemplateBMMZ(String patientName, String deviceToken, String userId, String admId) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getSuccessfulOVAppPushBusiCode());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("doctor", "Android", admId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceToken);
        String text = MessageFormat.format("{0}\u60a3\u8005\u5411\u60a8\u7533\u8bf7\u4fbf\u6c11\u95e8\u8bca\uff0c\u70b9\u51fb\u54a8\u8be2\u4e0e\u590d\u8bca\u63a5\u5f85\u60a3\u8005\u3002", patientName);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle("\u4fbf\u6c11\u95e8\u8bca\u7533\u8bf7\u63d0\u9192");
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", "426");
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(5, 9));
        parameter.put("admId", admId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        umPushMsgAndroidReqVO.setDescription("\u4fbf\u6c11\u95e8\u8bca\u7533\u8bf7\u63d0\u9192");
        HashMap<String, String> customParameter = new HashMap<String, String>(2);
        customParameter.put("pushCode", "426");
        customParameter.put("content", text);
        umPushMsgAndroidReqVO.setCustom(JSON.toJSONString(customParameter));
        return umPushMsgAndroidReqVO;
    }

    public void doctorOnlineVisitNoReplyInTenMinutesAppPush(String admissionId, String patientId, String doctorId, String hospitalId) {
        log.info("========\u60a3\u800510\u5206\u949f\u672a\u56de\u590d\u63a8\u9001=========");
        AdmissionEntity admissionInfo = this.getAdmissionInfo(admissionId);
        if (null == admissionInfo) {
            log.error("========\u83b7\u53d6\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionId);
            return;
        }
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == patientEntity) {
            log.error("========\u83b7\u53d6\u60a3\u8005\u59d3\u540d\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + patientId);
            return;
        }
        String patientName = patientEntity.getPatientName();
        String userId = this.getUserIdByDoctorIdAndHospitalId(doctorId, hospitalId);
        if (StringUtils.isEmpty((String)userId)) {
            log.error("========\u83b7\u53d6userId\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.getDocUserDeviceToken(userId, new Short("1"));
        if (null == userLastLoginDeviceRespVo) {
            log.error("========\u83b7\u53d6\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u6e20\u9053\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        if (StringUtils.isEmpty((String)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("=======\u83b7\u53d6\u7528\u6237\u7684\u8bbe\u5907\u6807\u8bc6=======");
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.buildNoReplyTenMinutesDocAndroidPushMsgTemplate(patientName, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId);
            this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.buildNoReplyTenMinutesDocIOSPushMsgTemplate(patientName, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId);
            this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
            return;
        }
    }

    public void doctorOnlineVisitNoReplyInTwoHoursAppPush(String admissionId, String patientId, String doctorId, String hospitalId) {
        log.info("========\u60a3\u80052\u5c0f\u65f6\u672a\u56de\u590d\u63a8\u9001=========");
        AdmissionEntity admissionInfo = this.getAdmissionInfo(admissionId);
        if (null == admissionInfo) {
            log.error("========\u83b7\u53d6\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionId);
            return;
        }
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == patientEntity) {
            log.error("========\u83b7\u53d6\u60a3\u8005\u59d3\u540d\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + patientId);
            return;
        }
        String patientName = patientEntity.getPatientName();
        String userId = this.getUserIdByDoctorIdAndHospitalId(doctorId, hospitalId);
        if (StringUtils.isEmpty((String)userId)) {
            log.error("========\u83b7\u53d6userId\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.getDocUserDeviceToken(userId, new Short("1"));
        if (null == userLastLoginDeviceRespVo) {
            log.error("========\u83b7\u53d6\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u6e20\u9053\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        if (StringUtils.isEmpty((String)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("=======\u83b7\u53d6\u7528\u6237\u7684\u8bbe\u5907\u6807\u8bc6=======");
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.buildNoReplyInTwoHoursDocAndroidPushMsgTemplate(patientName, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId);
            this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.buildNoReplyInTwoHoursDocIOSPushMsgTemplate(patientName, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId);
            this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
            return;
        }
    }

    public void doctorReplyNotify(String admissionId) {
        log.info("========\u533b\u751f\u7ed9\u60a3\u8005\u56de\u590d\u63a8\u9001=========");
        AdmissionEntity admissionInfo = this.getAdmissionInfo(admissionId);
        if (null == admissionInfo) {
            log.error("========\u83b7\u53d6\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionId);
            return;
        }
        String userId = this.getUserIdByPatient(admissionInfo.getPatientId(), admissionId);
        if (StringUtils.isEmpty((String)userId)) {
            log.error("========\u83b7\u53d6userId\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.getpatUserDeviceToken(userId, new Short("0"));
        if (null == userLastLoginDeviceRespVo) {
            log.error("========\u83b7\u53d6\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u6e20\u9053\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        if (StringUtils.isEmpty((String)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("=======\u83b7\u53d6\u7528\u6237\u7684\u8bbe\u5907\u6807\u8bc6=======");
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.buildDocReplyAndroidPushMsgTemplate(admissionInfo.getDoctorName(), userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId);
            this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.buildDocReplyIOSPushMsgTemplate(admissionInfo.getDoctorName(), userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId);
            this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
            return;
        }
    }

    public void doctorOnlineVisitNoReplyAppPush(PatientNoResponseReqVo patientNoResponseReqVo) throws AdmissionException {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(patientNoResponseReqVo.getAdmId());
        if (null == orderEntity) {
            log.error("========\u83b7\u53d6\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + patientNoResponseReqVo.getAdmId());
            return;
        }
        AdmissionEntity admissionEntity = this.admissionMapper.findById(patientNoResponseReqVo.getAdmId());
        if (null == admissionEntity) {
            return;
        }
        if (!AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admissionEntity.getStatus())) {
            log.info("=====\u5c31\u8bca\u72b6\u6001\u4e0d\u662f\u95ee\u8bca\u4e2d\u7684\u72b6\u6001\uff0c\u4e0d\u4f1a\u63a8\u9001APP\u63a8\u9001=====");
            return;
        }
        RequestGetDoctorOfficeStatus requestGetDoctorOfficeStatus = new RequestGetDoctorOfficeStatus();
        requestGetDoctorOfficeStatus.setAppCode(orderEntity.getAppCode());
        requestGetDoctorOfficeStatus.setDoctorId(orderEntity.getDoctorId());
        requestGetDoctorOfficeStatus.setHospitalId(orderEntity.getHospitalId());
        BaseResponse requestOnlineOrOfflineVo = this.inquiryServiceConfigService.getDoctorOfficeStatus(requestGetDoctorOfficeStatus);
        if (null == requestOnlineOrOfflineVo.getData()) {
            log.info("=======\u533b\u751f\u4e0a\u4e0b\u7ebf\u72b6\u6001\u4e3anull=======");
            return;
        }
        if (((RequestOnlineOrOfflineVo)requestOnlineOrOfflineVo.getData()).getOfficeStatus().equals(-1)) {
            log.info("=======\u533b\u751f\u4e0b\u7ebf,\u4e0d\u63a8\u9001=======");
            return;
        }
        String doctorId = orderEntity.getDoctorId();
        String patientId = orderEntity.getPatientId();
        String hospitalId = orderEntity.getHospitalId();
        String admissionId = patientNoResponseReqVo.getAdmId();
        if ("1".equals(patientNoResponseReqVo.getType())) {
            this.doctorOnlineVisitNoReplyInTenMinutesAppPush(admissionId, patientId, doctorId, hospitalId);
        } else if ("2".equals(patientNoResponseReqVo.getType())) {
            this.doctorOnlineVisitNoReplyInTwoHoursAppPush(admissionId, patientId, doctorId, hospitalId);
        }
    }

    private UmPushMsgAndroidReqVO buildDocReplyAndroidPushMsgTemplate(String docName, String deviceToken, String userId, String admId) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getDocReplyAppPushBusiCode());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("patient", "Android", admId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceToken);
        String text = MessageFormat.format("{0}\u533b\u751f\u5df2\u56de\u590d\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b\u8be6\u60c5\u5e76\u7ee7\u7eed\u8fdb\u884c\u4ea4\u6d41\u3002", docName);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle(this.projProperties.getProductInfo());
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getSendVideoAppPushBusiCode());
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", "fqsp");
        parameter.put("admId", admId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        umPushMsgAndroidReqVO.setDescription(this.projProperties.getProductInfo());
        HashMap<String, String> customParameter = new HashMap<String, String>(2);
        customParameter.put("pushCode", this.projProperties.getSendVideoAppPushBusiCode());
        customParameter.put("content", text);
        umPushMsgAndroidReqVO.setCustom(JSON.toJSONString(customParameter));
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgIOSReqVo buildDocReplyIOSPushMsgTemplate(String docName, String deviceToken, String userId, String admId) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getDocReplyAppPushBusiCode());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("patient", "IOS", admId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceToken);
        String body = MessageFormat.format("{0}\u533b\u751f\u5df2\u56de\u590d\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b\u8be6\u60c5\u5e76\u7ee7\u7eed\u8fdb\u884c\u4ea4\u6d41\u3002", docName);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle(this.projProperties.getProductInfo());
        umPushMsgIOSReqVo.setSubTitle(this.projProperties.getProductInfo());
        umPushMsgIOSReqVo.setDescription(this.projProperties.getProductInfo());
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getSendVideoAppPushBusiCode());
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", "fqsp");
        parameter.put("admId", admId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    public void inquiryEndPreAppPush(String admId) {
        log.info("\u95ee\u8bca\u7ed3\u675f\u524d3\u5206\u949f\uff0c\u533b\u751f\u7aefAPP\u63a8\u9001");
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (null == orderEntity) {
            log.error("========\u83b7\u53d6\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admId);
            return;
        }
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(orderEntity.getPatientId());
        if (null == patientEntity) {
            log.error("========\u83b7\u53d6\u60a3\u8005\u59d3\u540d\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + orderEntity.getPatientId());
            return;
        }
        String patientName = patientEntity.getPatientName();
        AdmissionEntity admissionInfo = this.getAdmissionInfo(admId);
        if (null == admissionInfo) {
            log.error("========\u83b7\u53d6\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admId);
            return;
        }
        String userId = this.getUserIdByDoctorIdAndHospitalId(orderEntity.getDoctorId(), orderEntity.getHospitalId());
        if (StringUtils.isEmpty((String)userId)) {
            log.error("========\u83b7\u53d6userId\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.getDocUserDeviceToken(userId, new Short("1"));
        if (null == userLastLoginDeviceRespVo) {
            log.error("========\u83b7\u53d6\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u6e20\u9053\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        if (StringUtils.isEmpty((String)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("=======\u83b7\u53d6\u7528\u6237\u7684\u8bbe\u5907\u6807\u8bc6=======");
            return;
        }
        RequestGetDoctorOfficeStatus requestGetDoctorOfficeStatus = new RequestGetDoctorOfficeStatus();
        requestGetDoctorOfficeStatus.setAppCode(orderEntity.getAppCode());
        requestGetDoctorOfficeStatus.setDoctorId(orderEntity.getDoctorId());
        requestGetDoctorOfficeStatus.setHospitalId(orderEntity.getHospitalId());
        BaseResponse requestOnlineOrOfflineVo = this.inquiryServiceConfigService.getDoctorOfficeStatus(requestGetDoctorOfficeStatus);
        if (null == requestOnlineOrOfflineVo.getData()) {
            log.info("=======\u533b\u751f\u4e0a\u4e0b\u7ebf\u72b6\u6001\u4e3anull=======");
            return;
        }
        if (((RequestOnlineOrOfflineVo)requestOnlineOrOfflineVo.getData()).getOfficeStatus().equals(-1)) {
            log.info("=======\u533b\u751f\u4e0b\u7ebf,\u4e0d\u63a8\u9001=======");
            return;
        }
        String serType = null;
        serType = admissionInfo.getServType().equals(ServiceTypeEnum.HOS.getValue()) ? "\u54a8\u8be2" : "\u590d\u8bca";
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.buildDoctorAndroidPre(patientName, serType, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admId);
            log.info("+++++++++\u95ee\u8bca\u7ed3\u675f\u524d3\u5206\u949f\u6216\u5269\u4f59\u6761\u6570\u7b49\u4e8e3\uff0c\u5b89\u5353\u63a8\u9001+++++++++");
            this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.buildDoctorIosPre(patientName, serType, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admId);
            log.info("+++++++++\u95ee\u8bca\u7ed3\u675f\u524d3\u5206\u949f\u6216\u5269\u4f59\u6761\u6570\u7b49\u4e8e3\uff0cios\u63a8\u9001+++++++++");
            this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
            return;
        }
    }

    public void doctorReferralAppPush(String admissionId, Integer servType) {
        log.info("========\u533b\u751f\u8f6c\u8bcaApp\u63a8\u9001=========");
        AdmissionEntity admissionInfo = this.getAdmissionInfo(admissionId);
        if (null == admissionInfo) {
            log.error("========\u83b7\u53d6\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionId);
            return;
        }
        log.info("admissionInfo:{}" + admissionInfo.toString());
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(admissionInfo.getPatientId());
        if (null == patientEntity) {
            log.error("========\u83b7\u53d6\u60a3\u8005\u59d3\u540d\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionInfo.getPatientId());
            return;
        }
        log.info("patientEntity:{}" + patientEntity.toString());
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        if (null == orderEntity) {
            log.error("========\u83b7\u53d6\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionInfo.getPatientId());
            return;
        }
        log.info("orderEntity:{}" + orderEntity.toString());
        String patientName = patientEntity.getPatientName();
        QueryWrapper queryWrapper = new QueryWrapper();
        DoctorTeamEntity entity = new DoctorTeamEntity();
        entity.setAdmissionId(admissionId);
        queryWrapper.setEntity((Object)entity);
        DoctorTeamEntity doctorTeamEntity = (DoctorTeamEntity)this.doctorTeamMapper.selectOne((Wrapper)queryWrapper);
        AdmissionEntity admissionEntityNew = this.admissionMapper.findByAdmId(doctorTeamEntity.getAdmissionIdNew());
        String userId = this.getUserIdByDoctorIdAndHospitalId(admissionEntityNew.getDoctorId(), orderEntity.getHospitalId());
        if (StringUtils.isEmpty((String)userId)) {
            log.error("========\u83b7\u53d6userId\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        String doctorName = orderEntity.getDoctorName();
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.getDocUserDeviceToken(userId, new Short("1"));
        if (null == userLastLoginDeviceRespVo) {
            log.error("========\u83b7\u53d6\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u6e20\u9053\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        log.info("userLastLoginDeviceRespVo:{}" + userLastLoginDeviceRespVo.toString());
        if (StringUtils.isEmpty((String)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("=======\u83b7\u53d6\u7528\u6237\u7684\u8bbe\u5907\u6807\u8bc6=======");
            return;
        }
        if (servType.intValue() == ServiceTypeEnum.HOS.getValue().intValue()) {
            if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
                UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.buildDoctorReferralAndroidPushMsgTemplate(patientName, doctorName, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId);
                this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
                return;
            }
            if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
                UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.buildDoctorReferralIOSPushMsgTemplate(patientName, doctorName, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId);
                this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
                return;
            }
        }
        if (servType.intValue() == ServiceTypeEnum.NOS.getValue().intValue()) {
            if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
                UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.buildDoctorReferralAndroidPushMsgTemplate1(patientName, doctorName, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId);
                this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
                return;
            }
            if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
                UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.buildDoctorReferralIOSPushMsgTemplate1(patientName, doctorName, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId);
                this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
                return;
            }
        }
    }

    public void patientDoctorReceiveAppPush(String admissionId) {
        log.info("\u533b\u751f\u63a5\u8bca\uff0c\u60a3\u8005\u7aefapp\u63a8\u9001");
        AdmissionEntity admissionInfo = this.getAdmissionInfo(admissionId);
        if (null == admissionInfo) {
            log.error("========\u83b7\u53d6\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionId);
            return;
        }
        log.info("admissionInfo:{}" + JSON.toJSONString((Object)admissionInfo));
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(admissionInfo.getPatientId());
        if (null == patientEntity) {
            log.error("========\u83b7\u53d6\u60a3\u8005\u59d3\u540d\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionInfo.getPatientId());
            return;
        }
        log.info("patientEntity:{}" + JSON.toJSONString((Object)patientEntity));
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        if (null == orderEntity) {
            log.error("========\u83b7\u53d6\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionInfo.getPatientId());
            return;
        }
        log.info("orderEntity:{}" + JSON.toJSONString((Object)orderEntity));
        String doctorName = orderEntity.getDoctorName();
        String userId = this.getUserIdByPatient(admissionInfo.getPatientId(), admissionId);
        if (StringUtils.isEmpty((String)userId)) {
            log.error("========\u83b7\u53d6userId\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.getpatUserDeviceToken(userId, new Short("0"));
        if (null == userLastLoginDeviceRespVo) {
            log.error("========\u83b7\u53d6\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u6e20\u9053\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        String deviceTokens = userLastLoginDeviceRespVo.getDeviceNumber();
        log.info("deviceTokens,{}" + deviceTokens);
        if (StringUtils.isEmpty((String)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("=======\u83b7\u53d6\u7528\u6237\u7684\u8bbe\u5907\u6807\u8bc6=======");
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.getPatientDoctorReceiveAndroid(admissionId, doctorName, userId, deviceTokens);
            log.info("+++++++++\u533b\u751f\u63a5\u8bca\uff0c\u60a3\u8005\u7aef\u5b89\u5353\u63a8\u9001+++++++++");
            this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.getPatientDoctorReceiveIos(admissionId, doctorName, userId, deviceTokens);
            log.info("+++++++++\u533b\u751f\u63a5\u8bca\uff0c\u60a3\u8005\u7aefios\u63a8\u9001+++++++++");
            this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
            return;
        }
    }

    public void patientDoctorOvertimeAppPush(String admissionId) {
        log.info("\u533b\u751f\u8d85\u65f6\u672a\u63a5\u5f85\uff0c\u60a3\u8005\u7aefapp\u63a8\u9001");
        AdmissionEntity admissionInfo = this.getAdmissionInfo(admissionId);
        if (null == admissionInfo) {
            log.error("========\u83b7\u53d6\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionId);
            return;
        }
        log.info("admissionInfo:{}" + JSON.toJSONString((Object)admissionInfo));
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(admissionInfo.getPatientId());
        if (null == patientEntity) {
            log.error("========\u83b7\u53d6\u60a3\u8005\u59d3\u540d\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionInfo.getPatientId());
            return;
        }
        log.info("patientEntity:{}" + JSON.toJSONString((Object)patientEntity));
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        if (null == orderEntity) {
            log.error("========\u83b7\u53d6\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionInfo.getPatientId());
            return;
        }
        log.info("orderEntity:{}" + JSON.toJSONString((Object)orderEntity));
        String doctorName = orderEntity.getDoctorName();
        String userId = this.getUserIdByPatient(admissionInfo.getPatientId(), admissionId);
        if (StringUtils.isEmpty((String)userId)) {
            log.error("========\u83b7\u53d6userId\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.getpatUserDeviceToken(userId, new Short("0"));
        if (null == userLastLoginDeviceRespVo) {
            log.error("========\u83b7\u53d6\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u6e20\u9053\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        String deviceTokens = userLastLoginDeviceRespVo.getDeviceNumber();
        log.info("deviceTokens,{}" + deviceTokens);
        if (StringUtils.isEmpty((String)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("=======\u83b7\u53d6\u7528\u6237\u7684\u8bbe\u5907\u6807\u8bc6=======");
            return;
        }
        String serType = null;
        serType = admissionInfo.getServType().equals(ServiceTypeEnum.HOS.getValue()) ? "\u54a8\u8be2" : "\u590d\u8bca";
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.getPatientDoctorOvertimeAndroid(admissionId, doctorName, userId, deviceTokens, serType);
            log.info("+++++++++\u533b\u751f\u8d85\u65f6\u672a\u63a5\u5f85\uff0c\u60a3\u8005\u7aef\u5b89\u5353\u63a8\u9001+++++++++");
            this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.getPatientDoctorOvertimeIos(admissionId, doctorName, userId, deviceTokens, serType);
            log.info("+++++++++\u533b\u751f\u8d85\u65f6\u672a\u63a5\u5f85\uff0c\u60a3\u8005\u7aefios\u63a8\u9001+++++++++");
            this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
            return;
        }
    }

    public void patientWaiteRemindAppPush(String admissionId) {
        log.info("app\u60a3\u8005\u5019\u8bca\u63d0\u9192,\u63a8\u9001\u65f6\u95f4\u5728\u9884\u7ea6\u65f6\u95f4\u524d1\u4e2a\u5c0f\u65f6\u63d0\u9192");
        AdmissionEntity admissionInfo = this.getAdmissionInfo(admissionId);
        if (null == admissionInfo) {
            log.error("========\u83b7\u53d6\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionId);
            return;
        }
        log.info("admissionInfo:{}" + JSON.toJSONString((Object)admissionInfo));
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(admissionInfo.getPatientId());
        if (null == patientEntity) {
            log.error("========\u83b7\u53d6\u60a3\u8005\u59d3\u540d\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionInfo.getPatientId());
            return;
        }
        log.info("patientEntity:{}" + JSON.toJSONString((Object)patientEntity));
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        if (null == orderEntity) {
            log.error("========\u83b7\u53d6\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionInfo.getPatientId());
            return;
        }
        log.info("orderEntity:{}" + JSON.toJSONString((Object)orderEntity));
        String scheduleStartTime = orderEntity.getScheduleStartTime();
        String scheduleEndTime = orderEntity.getScheduleEndTime();
        String userId = this.getUserIdByPatient(admissionInfo.getPatientId(), admissionId);
        if (StringUtils.isEmpty((String)userId)) {
            log.error("========\u83b7\u53d6userId\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.getpatUserDeviceToken(userId, new Short("0"));
        if (null == userLastLoginDeviceRespVo) {
            log.error("========\u83b7\u53d6\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u6e20\u9053\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        String deviceTokens = userLastLoginDeviceRespVo.getDeviceNumber();
        log.info("deviceTokens,{}" + deviceTokens);
        if (StringUtils.isEmpty((String)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("=======\u83b7\u53d6\u7528\u6237\u7684\u8bbe\u5907\u6807\u8bc6=======");
            return;
        }
        String serType = null;
        serType = admissionInfo.getServType().equals(ServiceTypeEnum.HOS.getValue()) ? "\u54a8\u8be2" : "\u590d\u8bca";
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.getPatientWaiteRemindAndroid(admissionId, userId, deviceTokens, serType, scheduleStartTime, scheduleEndTime);
            log.info("+++++++++\u60a3\u8005\u5019\u8bca\uff0c\u60a3\u8005\u7aef\u5b89\u5353\u63a8\u9001+++++++++");
            this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.getPatientWaiteRemindIos(admissionId, userId, deviceTokens, serType, scheduleStartTime, scheduleEndTime);
            log.info("+++++++++\u60a3\u8005\u5019\u8bca\uff0c\u60a3\u8005\u7aefios\u63a8\u9001+++++++++");
            this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
            return;
        }
    }

    public void patientVideoInquiryAppPush(String admissionId) {
        log.info("\u533b\u751f\u53d1\u8d77\u89c6\u9891\u95ee\u8bca\uff0c\u60a3\u8005\u7aefAPP\u63a8\u9001");
        AdmissionEntity admissionInfo = this.getAdmissionInfo(admissionId);
        if (null == admissionInfo) {
            log.error("========\u83b7\u53d6\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionId);
            return;
        }
        log.info("admissionInfo:{}" + JSON.toJSONString((Object)admissionInfo));
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(admissionInfo.getPatientId());
        if (null == patientEntity) {
            log.error("========\u83b7\u53d6\u60a3\u8005\u59d3\u540d\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionInfo.getPatientId());
            return;
        }
        log.info("patientEntity:{}" + JSON.toJSONString((Object)patientEntity));
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        if (null == orderEntity) {
            log.error("========\u83b7\u53d6\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionInfo.getPatientId());
            return;
        }
        log.info("orderEntity:{}" + JSON.toJSONString((Object)orderEntity));
        String doctorName = orderEntity.getDoctorName();
        String userId = this.getUserIdByPatient(admissionInfo.getPatientId(), admissionId);
        if (StringUtils.isEmpty((String)userId)) {
            log.error("========\u83b7\u53d6userId\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.getpatUserDeviceToken(userId, new Short("0"));
        if (null == userLastLoginDeviceRespVo) {
            log.error("========\u83b7\u53d6\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u6e20\u9053\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        String deviceTokens = userLastLoginDeviceRespVo.getDeviceNumber();
        log.info("deviceTokens,{}" + deviceTokens);
        if (StringUtils.isEmpty((String)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("=======\u83b7\u53d6\u7528\u6237\u7684\u8bbe\u5907\u6807\u8bc6=======");
            return;
        }
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(orderEntity.getDoctorId());
        BaseResponse doctorDetailsVoBaseResponse = this.doctorClient.queryPersonnelInfo(queryPersonnelInfoReq);
        if (null == doctorDetailsVoBaseResponse || null == doctorDetailsVoBaseResponse.getData()) {
            log.info("=======\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u5931\u8d25========");
            return;
        }
        PersonnelInfo personnelInfo = (PersonnelInfo)doctorDetailsVoBaseResponse.getData();
        log.info("personnelInfo:{}" + JSON.toJSONString((Object)personnelInfo));
        String portrait = personnelInfo.getPortrait();
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.getPatientVideoInquiryAndroid(admissionId, doctorName, userId, deviceTokens, portrait);
            log.info("+++++++++\u533b\u751f\u7aef\u53d1\u8d77\u89c6\u9891\u95ee\u8bca\uff0c\u60a3\u8005\u7aef\u5b89\u5353\u63a8\u9001+++++++++");
            this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.getPatientVideoInquiryIos(admissionId, doctorName, userId, deviceTokens, portrait);
            log.info("+++++++++\u533b\u751f\u7aef\u53d1\u8d77\u89c6\u9891\u95ee\u8bca\uff0c\u60a3\u8005\u7aefios\u63a8\u9001+++++++++");
            this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
            return;
        }
    }

    public void patientDoctorRefuseAppPush(String admissionId) {
        log.info("\u533b\u751f\u62d2\u7edd\u95ee\u8bca\uff0c\u60a3\u8005\u7aefAPP\u63a8\u9001");
        AdmissionEntity admissionInfo = this.getAdmissionInfo(admissionId);
        if (null == admissionInfo) {
            log.error("========\u83b7\u53d6\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionId);
            return;
        }
        log.info("admissionInfo:{}" + JSON.toJSONString((Object)admissionInfo));
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(admissionInfo.getPatientId());
        if (null == patientEntity) {
            log.error("========\u83b7\u53d6\u60a3\u8005\u59d3\u540d\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionInfo.getPatientId());
            return;
        }
        log.info("patientEntity:{}" + JSON.toJSONString((Object)patientEntity));
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        if (null == orderEntity) {
            log.error("========\u83b7\u53d6\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionInfo.getPatientId());
            return;
        }
        log.info("orderEntity:{}" + JSON.toJSONString((Object)orderEntity));
        String doctorName = orderEntity.getDoctorName();
        String userId = this.getUserIdByPatient(admissionInfo.getPatientId(), admissionId);
        if (StringUtils.isEmpty((String)userId)) {
            log.error("========\u83b7\u53d6userId\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.getpatUserDeviceToken(userId, new Short("0"));
        if (null == userLastLoginDeviceRespVo) {
            log.error("========\u83b7\u53d6\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u6e20\u9053\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        String deviceTokens = userLastLoginDeviceRespVo.getDeviceNumber();
        log.info("deviceTokens,{}" + deviceTokens);
        if (StringUtils.isEmpty((String)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("=======\u83b7\u53d6\u7528\u6237\u7684\u8bbe\u5907\u6807\u8bc6=======");
            return;
        }
        String serType = null;
        serType = admissionInfo.getServType().equals(ServiceTypeEnum.HOS.getValue()) ? "\u54a8\u8be2" : "\u590d\u8bca";
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.getPatientDoctorRefuseAndroid(admissionId, doctorName, userId, deviceTokens, serType);
            log.info("+++++++++\u533b\u751f\u62d2\u7edd\u95ee\u8bca\uff0c\u60a3\u8005\u7aef\u5b89\u5353\u63a8\u9001+++++++++");
            this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.getPatientDoctorRefuseIos(admissionId, doctorName, userId, deviceTokens, serType);
            log.info("+++++++++\u533b\u751f\u62d2\u7edd\u95ee\u8bca\uff0c\u60a3\u8005\u7aefios\u63a8\u9001+++++++++");
            this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
            return;
        }
    }

    public void onlineReferralAppPush(String referralId, Integer servType) {
        log.info("\u60a3\u8005\u7aefapp\u63a8\u9001\uff0c\u533b\u751f\u8f6c\u8bca");
        log.info("referralId:{}" + referralId);
        QueryWrapper queryWrapper = new QueryWrapper();
        DoctorTeamEntity entity = new DoctorTeamEntity();
        entity.setXId(referralId);
        queryWrapper.setEntity((Object)entity);
        DoctorTeamEntity doctorTeamEntity = (DoctorTeamEntity)this.doctorTeamMapper.selectOne((Wrapper)queryWrapper);
        if (null == doctorTeamEntity) {
            log.info("========\u672a\u67e5\u8be2\u5230\u8f6c\u8bca\u8ba2\u5355=========");
            return;
        }
        log.info("doctorTeamEntity:{}" + JSON.toJSONString((Object)doctorTeamEntity));
        String patientId = doctorTeamEntity.getPatientId();
        String doctorName = doctorTeamEntity.getReferralDoctorName();
        String doctorNewName = doctorTeamEntity.getAdmissionDoctorName();
        String admissionIdNew = doctorTeamEntity.getAdmissionId();
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        String userId = patientEntity.getUserId();
        if (StringUtils.isEmpty((String)userId)) {
            log.error("========\u83b7\u53d6userId\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.getpatUserDeviceToken(userId, new Short("0"));
        if (null == userLastLoginDeviceRespVo) {
            log.error("========\u83b7\u53d6\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u6e20\u9053\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        String deviceTokens = userLastLoginDeviceRespVo.getDeviceNumber();
        log.info("deviceTokens,{}" + deviceTokens);
        if (StringUtils.isEmpty((String)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("=======\u83b7\u53d6\u7528\u6237\u7684\u8bbe\u5907\u6807\u8bc6=======");
            return;
        }
        String serviceType = null;
        serviceType = servType.equals(ServiceTypeEnum.HOS.getValue()) ? "\u54a8\u8be2" : "\u590d\u8bca";
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.getUmPushReferralAndroid(serviceType, doctorName, doctorNewName, admissionIdNew, userId, deviceTokens);
            log.info("+++++++++\u533b\u751f\u8f6c\u8bca\uff0c\u60a3\u8005\u7aef\u5b89\u5353\u63a8\u9001+++++++++");
            this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            log.info("+++++++++\u533b\u751f\u8f6c\u8bca\uff0c\u60a3\u8005\u7aefios\u63a8\u9001+++++++++");
            UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.getUmPushReferralIOS(serviceType, doctorName, doctorNewName, admissionIdNew, userId, deviceTokens);
            this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
            return;
        }
    }

    private UmPushMsgIOSReqVo getUmPushReferralIOS(String serviceType, String doctorName, String doctorNewName, String admissionIdNew, String userId, String deviceTokens) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getReferralAppPush());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("patient", "IOS", admissionIdNew));
        umPushMsgIOSReqVo.setDeviceTokens(deviceTokens);
        String body = MessageFormat.format("{0}\u533b\u751f\u5df2\u5c06\u60a8\u7684{1}\u8f6c\u8bca\u7ed9{2}\u533b\u751f,\u70b9\u51fb\u67e5\u770b\u8be6\u60c5", doctorName, serviceType, doctorNewName);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle("\u533b\u751f\u8f6c\u8bca\u901a\u77e5");
        umPushMsgIOSReqVo.setSubTitle("\u533b\u751f\u8f6c\u8bca\u901a\u77e5");
        umPushMsgIOSReqVo.setDescription("\u533b\u751f\u8f6c\u8bca\u901a\u77e5");
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getReferralAppPush());
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getReferralAppPush().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getReferralAppPush().substring(6, 12));
        parameter.put("admissionIdNew", admissionIdNew);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgAndroidReqVO getUmPushReferralAndroid(String serviceType, String doctorName, String doctorNewName, String admissionIdNew, String userId, String deviceTokens) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getReferralAppPush());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("patient", "Android", admissionIdNew));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceTokens);
        String text = MessageFormat.format("{0}\u533b\u751f\u5df2\u5c06\u60a8\u7684{1}\u8f6c\u8bca\u7ed9{2}\u533b\u751f,\u70b9\u51fb\u67e5\u770b\u8be6\u60c5", doctorName, serviceType, doctorNewName);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle("\u533b\u751f\u8f6c\u8bca\u901a\u77e5");
        umPushMsgAndroidReqVO.setDescription("\u533b\u751f\u8f6c\u8bca\u901a\u77e5");
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getReferralAppPush());
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getReferralAppPush().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getReferralAppPush().substring(6, 12));
        parameter.put("admissionId", admissionIdNew);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        return umPushMsgAndroidReqVO;
    }

    public void doctorCloseScheduleAppPush(String admissionId) {
        log.info("\u60a3\u8005\u7aefapp\u63a8\u9001\uff0c\u533b\u751f\u505c\u8bca");
        AdmissionEntity admissionInfo = this.getAdmissionInfo(admissionId);
        if (null == admissionInfo) {
            log.error("========\u83b7\u53d6\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionId);
            return;
        }
        log.info("admissionInfo:{}" + JSON.toJSONString((Object)admissionInfo));
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(admissionInfo.getPatientId());
        if (null == patientEntity) {
            log.error("========\u83b7\u53d6\u60a3\u8005\u59d3\u540d\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionInfo.getPatientId());
            return;
        }
        log.info("patientEntity:{}" + JSON.toJSONString((Object)patientEntity));
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        if (null == orderEntity) {
            log.error("========\u83b7\u53d6\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionInfo.getPatientId());
            return;
        }
        log.info("orderEntity:{}" + JSON.toJSONString((Object)orderEntity));
        String doctorName = orderEntity.getDoctorName();
        String userId = this.getUserIdByPatient(admissionInfo.getPatientId(), admissionId);
        if (StringUtils.isEmpty((String)userId)) {
            log.error("========\u83b7\u53d6userId\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.getpatUserDeviceToken(userId, new Short("0"));
        if (null == userLastLoginDeviceRespVo) {
            log.error("========\u83b7\u53d6\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u6e20\u9053\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        String deviceTokens = userLastLoginDeviceRespVo.getDeviceNumber();
        log.info("deviceTokens,{}" + deviceTokens);
        if (StringUtils.isEmpty((String)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("=======\u83b7\u53d6\u7528\u6237\u7684\u8bbe\u5907\u6807\u8bc6=======");
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.getdoctorCloseScheduleAppPushAndroid(admissionId, doctorName, userId, deviceTokens);
            log.info("+++++++++\u533b\u751f\u505c\u8bca\uff0c\u60a3\u8005\u5b89\u5353App\u63a8\u9001+++++++++");
            this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.getdoctorCloseScheduleAppPushIOS(admissionId, doctorName, userId, deviceTokens);
            log.info("+++++++++\u533b\u751f\u505c\u8bca\uff0c\u60a3\u8005\u5b89\u5353IOS\u63a8\u9001+++++++++");
            this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
            return;
        }
    }

    public void onlineCompletionAppPush(String admissionId) {
        log.info("\u60a3\u8005\u7aefapp\u63a8\u9001\uff0c\u8ba2\u5355\u5b8c\u6210\u901a\u77e5");
        AdmissionEntity admissionInfo = this.getAdmissionInfo(admissionId);
        if (null == admissionInfo) {
            log.error("========\u83b7\u53d6\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionId);
            return;
        }
        log.info("admissionInfo:{}" + JSON.toJSONString((Object)admissionInfo));
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(admissionInfo.getPatientId());
        if (null == patientEntity) {
            log.error("========\u83b7\u53d6\u60a3\u8005\u59d3\u540d\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionInfo.getPatientId());
            return;
        }
        log.info("patientEntity:{}" + JSON.toJSONString((Object)patientEntity));
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        if (null == orderEntity) {
            log.error("========\u83b7\u53d6\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionInfo.getPatientId());
            return;
        }
        log.info("orderEntity:{}" + JSON.toJSONString((Object)orderEntity));
        String doctorName = orderEntity.getDoctorName();
        String userId = this.getUserIdByPatient(admissionInfo.getPatientId(), admissionId);
        if (StringUtils.isEmpty((String)userId)) {
            log.error("========\u83b7\u53d6userId\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.getpatUserDeviceToken(userId, new Short("0"));
        if (null == userLastLoginDeviceRespVo) {
            log.error("========\u83b7\u53d6\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u6e20\u9053\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        String deviceTokens = userLastLoginDeviceRespVo.getDeviceNumber();
        log.info("deviceTokens,{}" + deviceTokens);
        if (StringUtils.isEmpty((String)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("=======\u83b7\u53d6\u7528\u6237\u7684\u8bbe\u5907\u6807\u8bc6=======");
            return;
        }
        String serType = null;
        serType = admissionInfo.getServType().equals(ServiceTypeEnum.HOS.getValue()) ? "\u54a8\u8be2" : "\u590d\u8bca";
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.getdoctorCompletionAppPushAndroid(admissionId, doctorName, userId, deviceTokens, serType);
            log.info("+++++++++\u8ba2\u5355\u5b8c\u6210\uff0c\u60a3\u8005\u5b89\u5353App\u63a8\u9001+++++++++");
            this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.getdoctorCompletionAppPushIOS(admissionId, doctorName, userId, deviceTokens, serType);
            log.info("+++++++++\u8ba2\u5355\u5b8c\u6210\uff0c\u60a3\u8005\u5b89\u5353IOS\u63a8\u9001+++++++++");
            this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
            return;
        }
    }

    public void noFollowUpCaseAppPush(String admissionId) {
        log.info("========\u533b\u751f\u8ddd\u79bb\u7ed3\u675f10\u5206\u949f\u672a\u5f00\u5177\u590d\u8bca\u75c5\u4f8b=========");
        AdmissionEntity admissionInfo = this.getAdmissionInfo(admissionId);
        if (null == admissionInfo) {
            log.error("========\u83b7\u53d6\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionId);
            return;
        }
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(admissionInfo.getPatientId());
        if (null == patientEntity) {
            log.error("========\u83b7\u53d6\u60a3\u8005\u59d3\u540d\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionInfo.getPatientId());
            return;
        }
        String patientName = patientEntity.getPatientName();
        String userId = this.getUserIdByDoctorIdAndHospitalId(admissionInfo.getDoctorId(), admissionInfo.getOrganId());
        if (StringUtils.isEmpty((String)userId)) {
            log.error("========\u83b7\u53d6userId\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.getDocUserDeviceToken(userId, new Short("1"));
        if (null == userLastLoginDeviceRespVo) {
            log.error("========\u83b7\u53d6\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u6e20\u9053\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        if (StringUtils.isEmpty((String)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("=======\u83b7\u53d6\u7528\u6237\u7684\u8bbe\u5907\u6807\u8bc6=======");
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.buildNoFollowUpCaseAndroidPushMsgTemplate(patientName, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId);
            this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.buildNoFollowUpCaseIOSPushMsgTemplate(patientName, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId);
            this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
            return;
        }
    }

    public void noMedicalOpinionAppPush(String admissionId) {
        log.info("========\u533b\u751f\u8ddd\u79bb\u7ed3\u675f10\u5206\u949f\u672a\u5f00\u5177\u8bca\u7597\u610f\u89c1=========");
        AdmissionEntity admissionInfo = this.getAdmissionInfo(admissionId);
        if (null == admissionInfo) {
            log.error("========\u83b7\u53d6\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionId);
            return;
        }
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(admissionInfo.getPatientId());
        if (null == patientEntity) {
            log.error("========\u83b7\u53d6\u60a3\u8005\u59d3\u540d\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionInfo.getPatientId());
            return;
        }
        String patientName = patientEntity.getPatientName();
        String userId = this.getUserIdByDoctorIdAndHospitalId(admissionInfo.getDoctorId(), admissionInfo.getOrganId());
        if (StringUtils.isEmpty((String)userId)) {
            log.error("========\u83b7\u53d6userId\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.getDocUserDeviceToken(userId, new Short("1"));
        if (null == userLastLoginDeviceRespVo) {
            log.error("========\u83b7\u53d6\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u6e20\u9053\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        if (StringUtils.isEmpty((String)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("=======\u83b7\u53d6\u7528\u6237\u7684\u8bbe\u5907\u6807\u8bc6=======");
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.buildNoMedicalOpinionAndroidPushMsgTemplate(patientName, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId);
            this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.buildNoMedicalOpinionIOSPushMsgTemplate(patientName, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId);
            this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
            return;
        }
    }

    public void noMedicalOpinionFollowUpCaseAppPush(String admissionId) {
        AdmissionEntity admissionEntity = this.admissionMapper.findById(admissionId);
        if (ServiceTypeEnum.HOS.getValue().equals(admissionEntity.getServType())) {
            if (!StringUtils.isEmpty((String)admissionEntity.getMedicalOpinion())) {
                log.info("\u533b\u751f\u5df2\u7ecf\u5f00\u5177\u8bca\u7597\u610f\u89c1\u4e0d\u63a8\u9001,\u5c31\u8bcaid\u4e3a\uff1a{}", (Object)admissionEntity.getXId());
                return;
            }
            this.noMedicalOpinionAppPush(admissionId);
            log.info("======\u533b\u751f\u8ddd\u79bb\u7ed3\u675f10\u5206\u949f\u672a\u5f00\u5177\u8bca\u7597\u610f\u89c1\u63a8\u9001\u5b8c\u6210=======");
        } else if (ServiceTypeEnum.NOS.getValue().equals(admissionEntity.getServType())) {
            PatientDynamicMedicalEntityVo entityVo = this.internetHospitalDetailInfoService.getMedicalInfoByAdmId(admissionEntity.getXId());
            if (null != entityVo) {
                log.info("\u533b\u751f\u5df2\u7ecf\u5f00\u5177\u60a3\u8005\u590d\u8bca\u75c5\u4f8b\u4e0d\u63a8\u9001,\u5c31\u8bcaid\u4e3a:{}", (Object)admissionEntity.getXId());
                return;
            }
            log.info("entityVo:{}", (Object)JSON.toJSONString((Object)entityVo));
            this.noFollowUpCaseAppPush(admissionId);
            log.info("======\u533b\u751f\u8ddd\u79bb\u7ed3\u675f10\u5206\u949f\u672a\u5f00\u5177\u590d\u8bca\u75c5\u5386\u63a8\u9001\u5b8c\u6210=======");
        }
    }

    private UmPushMsgIOSReqVo getPatientDoctorRefuseIos(String admissionId, String doctorName, String userId, String deviceTokens, String serType) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getDoctorRefuse());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("patient", "IOS", admissionId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceTokens);
        String body = MessageFormat.format("{0}\u533b\u751f\u62d2\u7edd\u4e86\u60a8\u7684{1},\u70b9\u51fb\u67e5\u770b\u539f\u56e0", doctorName, serType);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle("\u533b\u751f\u62d2\u7edd\u95ee\u8bca");
        umPushMsgIOSReqVo.setSubTitle("\u533b\u751f\u62d2\u7edd\u95ee\u8bca");
        umPushMsgIOSReqVo.setDescription("\u533b\u751f\u62d2\u7edd\u95ee\u8bca");
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getDoctorRefuse());
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getDoctorRefuse().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getDoctorRefuse().substring(6, 10));
        parameter.put("admissionId", admissionId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgAndroidReqVO getPatientDoctorRefuseAndroid(String admissionId, String doctorName, String userId, String deviceTokens, String serType) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getDoctorRefuse());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("patient", "Android", admissionId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceTokens);
        String text = MessageFormat.format("{0}\u533b\u751f\u62d2\u7edd\u4e86\u60a8\u7684{1},\u70b9\u51fb\u67e5\u770b\u539f\u56e0", doctorName, serType);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle("\u533b\u751f\u62d2\u7edd\u95ee\u8bca");
        umPushMsgAndroidReqVO.setDescription("\u533b\u751f\u62d2\u7edd\u95ee\u8bca");
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getDoctorRefuse());
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getDoctorRefuse().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getDoctorRefuse().substring(6, 10));
        parameter.put("admissionId", admissionId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgIOSReqVo getPatientVideoInquiryIos(String admissionId, String doctorName, String userId, String deviceTokens, String portrait) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getVideoInquiry());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("patient", "IOS", admissionId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceTokens);
        String body = MessageFormat.format("{0}\u533b\u751f\u6b63\u5411\u60a8\u53d1\u8d77\u89c6\u9891\u901a\u8bdd\u7533\u8bf7\uff0c\u70b9\u51fb\u8fdb\u5165app\u63a5\u6536\u89c6\u9891\u9080\u8bf7", doctorName);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle("\u533b\u751f\u9080\u8bf7\u60a8\u89c6\u9891\u95ee\u8bca");
        umPushMsgIOSReqVo.setSubTitle("\u533b\u751f\u9080\u8bf7\u60a8\u89c6\u9891\u95ee\u8bca");
        umPushMsgIOSReqVo.setDescription("\u533b\u751f\u9080\u8bf7\u60a8\u89c6\u9891\u95ee\u8bca");
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getVideoInquiry());
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getVideoInquiry().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getVideoInquiry().substring(6, 10));
        parameter.put("admissionId", admissionId);
        parameter.put("portrait", portrait);
        parameter.put("doctorName", doctorName);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgAndroidReqVO getPatientVideoInquiryAndroid(String admissionId, String doctorName, String userId, String deviceTokens, String portrait) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getVideoInquiry());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("patient", "Android", admissionId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceTokens);
        String text = MessageFormat.format("{0}\u533b\u751f\u6b63\u5411\u60a8\u53d1\u8d77\u89c6\u9891\u901a\u8bdd\u7533\u8bf7\uff0c\u70b9\u51fb\u8fdb\u5165app\u63a5\u6536\u89c6\u9891\u9080\u8bf7", doctorName);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle("\u533b\u751f\u9080\u8bf7\u60a8\u89c6\u9891\u95ee\u8bca");
        umPushMsgAndroidReqVO.setDescription("\u533b\u751f\u9080\u8bf7\u60a8\u89c6\u9891\u95ee\u8bca");
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getVideoInquiry());
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getVideoInquiry().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getVideoInquiry().substring(6, 10));
        parameter.put("admissionId", admissionId);
        parameter.put("portrait", portrait);
        parameter.put("doctorName", doctorName);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgIOSReqVo getPatientWaiteRemindIos(String admissionId, String userId, String deviceTokens, String serType, String scheduleStartTime, String scheduleEndTime) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getWaiteRemind());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("patient", "IOS", admissionId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceTokens);
        String waiteTime = scheduleStartTime + "-" + scheduleEndTime;
        String body = MessageFormat.format("\u60a8\u4eca\u5929\u6709\u5728\u7ebf{0}\u8ba2\u5355\uff0c\u8bf7\u4e8e\u9884\u7ea6\u65f6\u95f4{1}\u5019\u8bca", serType, waiteTime);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle("\u5019\u8bca\u63d0\u9192");
        umPushMsgIOSReqVo.setSubTitle("\u5019\u8bca\u63d0\u9192");
        umPushMsgIOSReqVo.setDescription("\u5019\u8bca\u63d0\u9192");
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getWaiteRemind());
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getWaiteRemind().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getWaiteRemind().substring(6, 10));
        parameter.put("admissionId", admissionId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgAndroidReqVO getPatientWaiteRemindAndroid(String admissionId, String userId, String deviceTokens, String serType, String scheduleStartTime, String scheduleEndTime) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getWaiteRemind());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("patient", "Android", admissionId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceTokens);
        String waiteTime = scheduleStartTime + "-" + scheduleEndTime;
        String text = MessageFormat.format("\u60a8\u4eca\u5929\u6709\u5728\u7ebf{0}\u8ba2\u5355\uff0c\u8bf7\u4e8e\u9884\u7ea6\u65f6\u95f4{1}\u5019\u8bca", serType, waiteTime);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle("\u5019\u8bca\u63d0\u9192");
        umPushMsgAndroidReqVO.setDescription("\u5019\u8bca\u63d0\u9192");
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getWaiteRemind());
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getWaiteRemind().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getWaiteRemind().substring(6, 10));
        parameter.put("admissionId", admissionId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgIOSReqVo getPatientDoctorOvertimeIos(String admissionId, String doctorName, String userId, String deviceTokens, String serType) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getDoctorOvertime());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("patient", "IOS", admissionId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceTokens);
        String body = MessageFormat.format("{0}\u533b\u751f\u8d85\u65f6\u672a\u63a5\u5f85\uff0c\u672c\u6b21{1}\u5df2\u4e3a\u60a8\u81ea\u52a8\u53d6\u6d88", doctorName, serType);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle("\u533b\u751f\u8d85\u65f6\u672a\u63a5\u5f85");
        umPushMsgIOSReqVo.setSubTitle("\u533b\u751f\u8d85\u65f6\u672a\u63a5\u5f85");
        umPushMsgIOSReqVo.setDescription("\u533b\u751f\u8d85\u65f6\u672a\u63a5\u5f85");
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getDoctorOvertime());
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getDoctorOvertime().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getDoctorOvertime().substring(6, 11));
        parameter.put("admissionId", admissionId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgAndroidReqVO getPatientDoctorOvertimeAndroid(String admissionId, String doctorName, String userId, String deviceTokens, String serType) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getDoctorOvertime());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("patient", "Android", admissionId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceTokens);
        String text = MessageFormat.format("{0}\u533b\u751f\u8d85\u65f6\u672a\u63a5\u5f85\uff0c\u672c\u6b21{1}\u5df2\u4e3a\u60a8\u81ea\u52a8\u53d6\u6d88", doctorName, serType);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle("\u533b\u751f\u8d85\u65f6\u672a\u63a5\u5f85");
        umPushMsgAndroidReqVO.setDescription("\u533b\u751f\u8d85\u65f6\u672a\u63a5\u5f85");
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getDoctorOvertime());
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getDoctorOvertime().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getDoctorOvertime().substring(6, 11));
        parameter.put("admissionId", admissionId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgIOSReqVo getPatientDoctorReceiveIos(String admissionId, String doctorName, String userId, String deviceTokens) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getDoctorReceive());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("patient", "IOS", admissionId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceTokens);
        String body = MessageFormat.format("{0}\u533b\u751f\u5df2\u4e3a\u60a8\u63a5\u8bca\uff0c\u70b9\u6211\u53bb\u95ee\u8bca", doctorName);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle("\u533b\u751f\u5df2\u63a5\u8bca");
        umPushMsgIOSReqVo.setSubTitle("\u533b\u751f\u5df2\u63a5\u8bca");
        umPushMsgIOSReqVo.setDescription("\u533b\u751f\u5df2\u63a5\u8bca");
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getDoctorReceive());
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getDoctorReceive().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getDoctorReceive().substring(6, 11));
        parameter.put("admissionId", admissionId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgAndroidReqVO getPatientDoctorReceiveAndroid(String admissionId, String doctorName, String userId, String deviceTokens) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getDoctorReceive());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("patient", "Android", admissionId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceTokens);
        String text = MessageFormat.format("{0}\u533b\u751f\u5df2\u4e3a\u60a8\u63a5\u8bca\uff0c\u70b9\u6211\u53bb\u95ee\u8bca", doctorName);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle("\u533b\u751f\u5df2\u63a5\u8bca");
        umPushMsgAndroidReqVO.setDescription("\u533b\u751f\u5df2\u63a5\u8bca");
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getDoctorReceive());
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getDoctorReceive().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getDoctorReceive().substring(6, 11));
        parameter.put("admissionId", admissionId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgAndroidReqVO buildDoctorAndroidPre(String patientName, String serType, String deviceToken, String userId, String admId) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getInquiryEndPrePush());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("doctor", "Android", admId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceToken);
        log.info("==============\u5b89\u5353\u63a8\u9001==============");
        String text = MessageFormat.format("\u60a8\u4e0e{0}\u60a3\u8005\u7684{1}\u5373\u5c06\u7ed3\u675f\uff0c\u5982\u9700\u5ef6\u957f{2}\u8bf7\u4f7f\u7528\u804a\u5929\u754c\u9762\u5de6\u4e0a\u89d2\u5ef6\u65f6\u529f\u80fd", patientName, serType, serType);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle("\u5ef6\u65f6\u63d0\u9192");
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("content", text);
        parameter.put("admId", admId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        umPushMsgAndroidReqVO.setDescription("\u5ef6\u65f6\u63d0\u9192");
        HashMap<String, String> customParameter = new HashMap<String, String>(2);
        customParameter.put("pushCode", "zl_ystx");
        customParameter.put("content", text);
        umPushMsgAndroidReqVO.setCustom(JSON.toJSONString(customParameter));
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgIOSReqVo buildDoctorIosPre(String patientName, String serType, String deviceToken, String userId, String admId) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getInquiryEndPrePush());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("doctor", "IOS", admId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceToken);
        log.info("=============ios\u63a8\u9001=============");
        String text = MessageFormat.format("\u60a8\u4e0e{0}\u60a3\u8005\u7684{1}\u5373\u5c06\u7ed3\u675f\uff0c\u5982\u9700\u5ef6\u957f{2}\u8bf7\u4f7f\u7528\u804a\u5929\u754c\u9762\u5de6\u4e0a\u89d2\u5ef6\u65f6\u529f\u80fd", patientName, serType, serType);
        umPushMsgIOSReqVo.setBody(text);
        umPushMsgIOSReqVo.setTitle("\u5ef6\u65f6\u63d0\u9192");
        umPushMsgIOSReqVo.setSubTitle("\u5ef6\u65f6\u63d0\u9192");
        umPushMsgIOSReqVo.setDescription("\u5ef6\u65f6\u63d0\u9192");
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(3);
        parameter.put("pushCode", "zl_ystx");
        parameter.put("content", text);
        parameter.put("admId", admId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(text);
        return umPushMsgIOSReqVo;
    }

    private UserLastLoginDeviceRespVo getpatUserDeviceToken(String userId, Short userType) {
        UserLastLoginDeviceReqVo userLastLoginDeviceReqVo = new UserLastLoginDeviceReqVo();
        userLastLoginDeviceReqVo.setUserId(userId);
        userLastLoginDeviceReqVo.setUserType(userType);
        log.info("\u83b7\u53d6\u60a3\u8005\u79fb\u52a8\u8bbe\u5907\u53f7\u5165\u53c2userLastLoginDeviceReqVo:" + userLastLoginDeviceReqVo.toString());
        BaseResponse userLastLoginDevice = this.userClient.getUserLastLoginDevice(userLastLoginDeviceReqVo);
        if (null == userLastLoginDevice.getData()) {
            return null;
        }
        log.info("\u83b7\u53d6\u60a3\u8005\u79fb\u52a8\u8bbe\u5907\u53f7\u8fd4\u56de\u503cuserLastLoginDevice" + ((UserLastLoginDeviceRespVo)userLastLoginDevice.getData()).toString());
        return (UserLastLoginDeviceRespVo)userLastLoginDevice.getData();
    }

    private UserLastLoginDeviceRespVo getDocUserDeviceToken(String userId, Short userType) {
        UserLastLoginDeviceReqVo userLastLoginDeviceReqVo = new UserLastLoginDeviceReqVo();
        userLastLoginDeviceReqVo.setUserId(userId);
        userLastLoginDeviceReqVo.setUserType(userType);
        String url = this.projProperties.getDocLastLoginDeviceUrl();
        BaseResponse response = null;
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)userLastLoginDeviceReqVo));
            response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), BaseResponse.class);
            log.info("response:{}" + JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u83b7\u53d6\u533b\u751f\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u8bbe\u5907\u53f7\u63a5\u53e3\u5931\u8d25" + e.getMessage());
        }
        if (null == response.getData()) {
            log.info("\u5f97\u5230\u533b\u751f\u8bbe\u5907\u7f16\u53f7 \u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)response));
            return null;
        }
        log.info("\u5f97\u5230\u533b\u751f\u8bbe\u5907\u7f16\u53f7 \u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)response));
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = (UserLastLoginDeviceRespVo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), UserLastLoginDeviceRespVo.class);
        if (null == userLastLoginDeviceRespVo) {
            log.info("\u5f97\u5230\u533b\u751f\u8bbe\u5907\u7f16\u53f7 \u8fd4\u56de\u770bjson\u89e3\u6790: {}", (Object)JSON.toJSONString((Object)userLastLoginDeviceRespVo));
            return null;
        }
        log.info("\u5f97\u5230\u533b\u751f\u8bbe\u5907\u7f16\u53f7 \u8fd4\u56de\u770bjson\u89e3\u6790: {}", (Object)JSON.toJSONString((Object)userLastLoginDeviceRespVo));
        return userLastLoginDeviceRespVo;
    }

    private String getUserIdByPatient(String patientId, String admissionId) {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientId);
        if (null == orderEntity) {
            return null;
        }
        if (StringUtils.isNotEmpty((String)orderEntity.getPatientUserId())) {
            log.info("order\u4e2d\u7684userId:{}" + orderEntity.getPatientUserId());
            return orderEntity.getPatientUserId();
        }
        if (null == patientEntity || StringUtils.isEmpty((String)patientEntity.getUserId())) {
            return null;
        }
        log.info("userId:{}" + patientEntity.getUserId());
        return patientEntity.getUserId();
    }

    private AdmissionEntity getAdmissionInfo(String admissionId) {
        AdmissionEntity admissionEntity = this.admissionMapper.findById(admissionId);
        if (null == admissionEntity) {
            return null;
        }
        return admissionEntity;
    }

    private UmPushMsgIOSReqVo buildReceiveIOSPushMsgTemplate(String docName, String deviceToken, String userId, String admId) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getAcceptsOVAppPushBusiCode());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("patient", "IOS", admId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceToken);
        String body = MessageFormat.format("{0}\u533b\u2f63\u5df2\u4e3a\u60a8\u63a5\u8bca\uff0c\u70b9\u6211\u53bb\u95ee\u8bca", docName);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle(this.projProperties.getProductInfo());
        umPushMsgIOSReqVo.setSubTitle(this.projProperties.getProductInfo());
        umPushMsgIOSReqVo.setDescription(this.projProperties.getProductInfo());
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getAcceptsOVAppPushBusiCode());
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", "ysjz");
        parameter.put("admId", admId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgAndroidReqVO buildReceiveAndroidPushMsgTemplate(String docName, String deviceToken, String userId, String admId) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getAcceptsOVAppPushBusiCode());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("patient", "Android", admId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceToken);
        String text = MessageFormat.format("{0}\u533b\u2f63\u5df2\u4e3a\u60a8\u63a5\u8bca\uff0c\u70b9\u6211\u53bb\u95ee\u8bca", docName);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle(this.projProperties.getProductInfo());
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getAcceptsOVAppPushBusiCode());
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", "ysjz");
        parameter.put("admId", admId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        umPushMsgAndroidReqVO.setDescription(this.projProperties.getProductInfo());
        HashMap<String, String> customParameter = new HashMap<String, String>(2);
        customParameter.put("pushCode", this.projProperties.getAcceptsOVAppPushBusiCode());
        customParameter.put("content", text);
        umPushMsgAndroidReqVO.setCustom(JSON.toJSONString(customParameter));
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgIOSReqVo buildAdmidDateIOSPushMsgTemplate(String docName, String deviceToken, String userId, String admId, String scheduleStartTime, String scheduleEndTime) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getSuccessfulOVAppPushBusiCode());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("patient", "IOS", admId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceToken);
        String body = "\u60a8\u4eca\u5929\u6709\u5728\u7ebf\u54a8\u8be2\u8ba2\u5355\uff0c\u8bf7\u4e8e\u9884\u7ea6\u65f6\u95f4" + scheduleStartTime + "-" + scheduleEndTime + "\u5019\u8bca";
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle(this.projProperties.getProductInfo());
        umPushMsgIOSReqVo.setSubTitle(this.projProperties.getProductInfo());
        umPushMsgIOSReqVo.setDescription(this.projProperties.getProductInfo());
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getSuccessfulOVAppPushBusiCode());
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", "hzbd");
        parameter.put("admId", admId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgIOSReqVo buildAdmidDateIOSPushMsgTemplateNOS(String docName, String deviceToken, String userId, String admId, String scheduleStartTime, String scheduleEndTime) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getSuccessfulOVAppPushBusiCode());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("patient", "IOS", admId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceToken);
        String body = "\u60a8\u4eca\u5929\u6709\u5728\u7ebf\u590d\u8bca\u8ba2\u5355\uff0c\u8bf7\u4e8e\u9884\u7ea6\u65f6\u95f4" + scheduleStartTime + "-" + scheduleEndTime + "\u5019\u8bca";
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle(this.projProperties.getProductInfo());
        umPushMsgIOSReqVo.setSubTitle(this.projProperties.getProductInfo());
        umPushMsgIOSReqVo.setDescription(this.projProperties.getProductInfo());
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getSuccessfulOVAppPushBusiCode());
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", "hzbd");
        parameter.put("admId", admId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgAndroidReqVO buildAdmidDateAndroidPushMsgTemplate(String docName, String deviceToken, String userId, String admId, String scheduleStartTime, String scheduleEndTime) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getSuccessfulOVAppPushBusiCode());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("patient", "Android", admId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceToken);
        String text = "\u60a8\u4eca\u5929\u6709\u5728\u7ebf\u54a8\u8be2\u8ba2\u5355\uff0c\u8bf7\u4e8e\u9884\u7ea6\u65f6\u95f4" + scheduleStartTime + "-" + scheduleEndTime + "\u5019\u8bca";
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle(this.projProperties.getProductInfo());
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getSuccessfulOVAppPushBusiCode());
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", "hzbd");
        parameter.put("admId", admId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        umPushMsgAndroidReqVO.setDescription(this.projProperties.getProductInfo());
        HashMap<String, String> customParameter = new HashMap<String, String>(2);
        customParameter.put("pushCode", this.projProperties.getSuccessfulOVAppPushBusiCode());
        customParameter.put("content", text);
        umPushMsgAndroidReqVO.setCustom(JSON.toJSONString(customParameter));
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgAndroidReqVO buildAdmidDateAndroidPushMsgTemplateNOS(String docName, String deviceToken, String userId, String admId, String scheduleStartTime, String scheduleEndTime) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getSuccessfulOVAppPushBusiCode());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("patient", "Android", admId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceToken);
        String text = "\u60a8\u4eca\u5929\u6709\u5728\u7ebf\u590d\u8bca\u8ba2\u5355\uff0c\u8bf7\u4e8e\u9884\u7ea6\u65f6\u95f4" + scheduleStartTime + "-" + scheduleEndTime + "\u5019\u8bca";
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle(this.projProperties.getProductInfo());
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getSuccessfulOVAppPushBusiCode());
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", "hzbd");
        parameter.put("admId", admId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        umPushMsgAndroidReqVO.setDescription(this.projProperties.getProductInfo());
        HashMap<String, String> customParameter = new HashMap<String, String>(2);
        customParameter.put("pushCode", this.projProperties.getSuccessfulOVAppPushBusiCode());
        customParameter.put("content", text);
        umPushMsgAndroidReqVO.setCustom(JSON.toJSONString(customParameter));
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgIOSReqVo buildDocSendVideoIOSPushMsgTemplate(String docName, String deviceToken, String userId, String admId) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getSendVideoAppPushBusiCode());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("patient", "IOS", admId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceToken);
        String body = MessageFormat.format("{0}\u533b\u751f\u6b63\u5411\u60a8\u53d1\u8d77\u89c6\u9891\u901a\u8bdd\u7533\u8bf7\uff0c\u8bf7\u5c3d\u5feb\u8fdb\u5165app\uff0c\u63a5\u53d7\u89c6\u9891\u9080\u8bf7\u3002", docName);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle(this.projProperties.getProductInfo());
        umPushMsgIOSReqVo.setSubTitle(this.projProperties.getProductInfo());
        umPushMsgIOSReqVo.setDescription(this.projProperties.getProductInfo());
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getSendVideoAppPushBusiCode());
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", "fqsp");
        parameter.put("admId", admId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgAndroidReqVO buildDocSendVideoAndroidPushMsgTemplate(String docName, String deviceToken, String userId, String admId) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getSendVideoAppPushBusiCode());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("patient", "Android", admId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceToken);
        String text = MessageFormat.format("{0}\u533b\u751f\u6b63\u5411\u60a8\u53d1\u8d77\u89c6\u9891\u901a\u8bdd\u7533\u8bf7\uff0c\u8bf7\u5c3d\u5feb\u8fdb\u5165app\uff0c\u63a5\u53d7\u89c6\u9891\u9080\u8bf7\u3002", docName);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle(this.projProperties.getProductInfo());
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getSendVideoAppPushBusiCode());
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", "fqsp");
        parameter.put("admId", admId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        umPushMsgAndroidReqVO.setDescription(this.projProperties.getProductInfo());
        HashMap<String, String> customParameter = new HashMap<String, String>(2);
        customParameter.put("pushCode", this.projProperties.getSendVideoAppPushBusiCode());
        customParameter.put("content", text);
        umPushMsgAndroidReqVO.setCustom(JSON.toJSONString(customParameter));
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgIOSReqVo buildCreateOrderDocIOSPushMsgTemplate(String patientName, String deviceToken, String userId, String admId) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getSuccessfulOVAppPushBusiCode());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("doctor", "IOS", admId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceToken);
        String body = MessageFormat.format("{0}\u60a3\u8005\u5411\u60a8\u7533\u8bf7\u54a8\u8be2\uff0c\u70b9\u51fb\u5728\u7ebf\u54a8\u8be2\u63a5\u5f85\u60a3\u8005\u3002", patientName);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle("\u54a8\u8be2\u7533\u8bf7\u63d0\u9192");
        umPushMsgIOSReqVo.setSubTitle("\u54a8\u8be2\u7533\u8bf7\u63d0\u9192");
        umPushMsgIOSReqVo.setDescription("\u54a8\u8be2\u7533\u8bf7\u63d0\u9192");
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", "426");
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(5, 9));
        parameter.put("admId", admId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        log.info("umPushMsgIOSReqVo:{}" + umPushMsgIOSReqVo.toString());
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgIOSReqVo buildCreateOrderDocIOSPushMsgTemplateNOS(String patientName, String deviceToken, String userId, String admId) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getSuccessfulOVAppPushBusiCode());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("doctor", "IOS", admId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceToken);
        String body = MessageFormat.format("{0}\u60a3\u8005\u5411\u60a8\u7533\u8bf7\u590d\u8bca\uff0c\u70b9\u51fb\u5728\u7ebf\u590d\u8bca\u63a5\u5f85\u60a3\u8005\u3002", patientName);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle("\u590d\u8bca\u7533\u8bf7\u63d0\u9192");
        umPushMsgIOSReqVo.setSubTitle("\u590d\u8bca\u7533\u8bf7\u63d0\u9192");
        umPushMsgIOSReqVo.setDescription("\u590d\u8bca\u7533\u8bf7\u63d0\u9192");
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", "426");
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(5, 9));
        parameter.put("admId", admId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgAndroidReqVO buildCreateOrderDocAndroidPushMsgTemplate(String patientName, String deviceToken, String userId, String admId) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getSuccessfulOVAppPushBusiCode());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("doctor", "Android", admId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceToken);
        String text = MessageFormat.format("{0}\u60a3\u8005\u5411\u60a8\u7533\u8bf7\u54a8\u8be2\uff0c\u70b9\u51fb\u5728\u7ebf\u54a8\u8be2\u63a5\u5f85\u60a3\u8005\u3002", patientName);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle("\u54a8\u8be2\u7533\u8bf7\u63d0\u9192");
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", "426");
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(5, 9));
        parameter.put("admId", admId);
        log.info("parameter:{}" + ((Object)parameter).toString());
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        umPushMsgAndroidReqVO.setDescription("\u54a8\u8be2\u7533\u8bf7\u63d0\u9192");
        HashMap<String, String> customParameter = new HashMap<String, String>(2);
        customParameter.put("pushCode", "426");
        customParameter.put("content", text);
        umPushMsgAndroidReqVO.setCustom(JSON.toJSONString(customParameter));
        log.info("umPushMsgAndroidReqVO:{}" + umPushMsgAndroidReqVO.toString());
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgAndroidReqVO buildCreateOrderDocAndroidPushMsgTemplateNOS(String patientName, String deviceToken, String userId, String admId) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getSuccessfulOVAppPushBusiCode());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("doctor", "Android", admId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceToken);
        String text = MessageFormat.format("{0}\u60a3\u8005\u5411\u60a8\u7533\u8bf7\u590d\u8bca\uff0c\u70b9\u51fb\u5728\u7ebf\u590d\u8bca\u63a5\u5f85\u60a3\u8005\u3002", patientName);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle("\u590d\u8bca\u7533\u8bf7\u63d0\u9192");
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", "426");
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(5, 9));
        parameter.put("admId", admId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        umPushMsgAndroidReqVO.setDescription("\u54a8\u8be2\u7533\u8bf7\u63d0\u9192");
        HashMap<String, String> customParameter = new HashMap<String, String>(2);
        customParameter.put("pushCode", "426");
        customParameter.put("content", text);
        umPushMsgAndroidReqVO.setCustom(JSON.toJSONString(customParameter));
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgAndroidReqVO buildNoReplyInTwoHoursDocAndroidPushMsgTemplate(String patientName, String deviceToken, String userId, String admId) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getNoReplyInTwoHoursDocAppPushBusiCode());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("doctor", "Android", admId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceToken);
        String text = MessageFormat.format("{0}\u60a3\u8005\u5df2\u7ecf\u7b49\u5f85\u60a8\u7684\u56de\u590d\u8d85\u8fc7\u4e24\u5c0f\u65f6\uff0c\u8bf7\u60a8\u5c3d\u5feb\u8fdb\u884c\u56de\u590d\u3002", patientName);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle(this.projProperties.getTitle());
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getNoReplyInTwoHoursDocAppPushBusiCode());
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", this.projProperties.getNoReplyInTwoHoursDocAppPushBusiCode().substring(6, 14));
        parameter.put("admId", admId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        umPushMsgAndroidReqVO.setDescription("\u54a8\u8be2\u7533\u8bf7\u63d0\u9192");
        HashMap<String, String> customParameter = new HashMap<String, String>(2);
        customParameter.put("pushCode", "426");
        customParameter.put("content", text);
        umPushMsgAndroidReqVO.setCustom(JSON.toJSONString(customParameter));
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgIOSReqVo buildNoReplyInTwoHoursDocIOSPushMsgTemplate(String patientName, String deviceToken, String userId, String admId) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getNoReplyInTwoHoursDocAppPushBusiCode());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("doctor", "IOS", admId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceToken);
        String body = MessageFormat.format("{0}\u60a3\u8005\u5df2\u7ecf\u7b49\u5f85\u60a8\u7684\u56de\u590d\u8d85\u8fc7\u4e24\u5c0f\u65f6\uff0c\u8bf7\u60a8\u5c3d\u5feb\u8fdb\u884c\u56de\u590d\u3002", patientName);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle(this.projProperties.getTitle());
        umPushMsgIOSReqVo.setSubTitle(this.projProperties.getTitle());
        umPushMsgIOSReqVo.setDescription(this.projProperties.getTitle());
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getNoReplyInTwoHoursDocAppPushBusiCode());
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", this.projProperties.getNoReplyInTwoHoursDocAppPushBusiCode().substring(6, 14));
        parameter.put("admId", admId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgAndroidReqVO buildNoReplyTenMinutesDocAndroidPushMsgTemplate(String patientName, String deviceToken, String userId, String admId) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getNoReplyInInTenMinutesDocAppPushBusiCode());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("doctor", "Android", admId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceToken);
        String text = MessageFormat.format("{0}\u60a3\u8005\u5df2\u7ecf\u7b49\u5f85\u60a8\u7684\u56de\u590d\u8d85\u8fc710\u5206\u949f\uff0c\u8bf7\u60a8\u5c3d\u5feb\u8fdb\u884c\u56de\u590d\u3002", patientName);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle(this.projProperties.getTitle());
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getNoReplyInInTenMinutesDocAppPushBusiCode());
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", this.projProperties.getNoReplyInInTenMinutesDocAppPushBusiCode().substring(6, 14));
        parameter.put("admId", admId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        umPushMsgAndroidReqVO.setDescription("\u54a8\u8be2\u7533\u8bf7\u63d0\u9192");
        HashMap<String, String> customParameter = new HashMap<String, String>(2);
        customParameter.put("pushCode", "426");
        customParameter.put("content", text);
        umPushMsgAndroidReqVO.setCustom(JSON.toJSONString(customParameter));
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgIOSReqVo buildNoReplyTenMinutesDocIOSPushMsgTemplate(String patientName, String deviceToken, String userId, String admId) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getNoReplyInInTenMinutesDocAppPushBusiCode());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("doctor", "IOS", admId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceToken);
        String body = MessageFormat.format("{0}\u60a3\u8005\u5df2\u7ecf\u7b49\u5f85\u60a8\u7684\u56de\u590d\u8d85\u8fc710\u5206\u949f\uff0c\u8bf7\u60a8\u5c3d\u5feb\u8fdb\u884c\u56de\u590d\u3002", patientName);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle(this.projProperties.getTitle());
        umPushMsgIOSReqVo.setSubTitle(this.projProperties.getTitle());
        umPushMsgIOSReqVo.setDescription(this.projProperties.getTitle());
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getNoReplyInInTenMinutesDocAppPushBusiCode());
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getSuccessfulOVAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", this.projProperties.getNoReplyInInTenMinutesDocAppPushBusiCode().substring(6, 14));
        parameter.put("admId", admId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgAndroidReqVO buildDoctorReferralAndroidPushMsgTemplate(String patientName, String doctorName, String deviceToken, String userId, String admId) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getDoctorReferralAppPushBusiCode());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("doctor", "Android", admId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceToken);
        String text = MessageFormat.format("{0}\u533b\u751f\u5df2\u5c06{1}\u60a3\u8005\u7684\u54a8\u8be2\u8f6c\u8ba9\u7ed9\u60a8\uff0c\u8bf7\u60a8\u5c3d\u5feb\u5904\u7406\u672c\u6b21\u54a8\u8be2\u3002", doctorName, patientName);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle(this.projProperties.getReferralTitle());
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getDoctorReferralAppPushBusiCode());
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getDoctorReferralAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", this.projProperties.getDoctorReferralAppPushBusiCode().substring(6, 12));
        parameter.put("admId", admId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        umPushMsgAndroidReqVO.setDescription("\u54a8\u8be2\u7533\u8bf7\u63d0\u9192");
        HashMap<String, String> customParameter = new HashMap<String, String>(2);
        customParameter.put("pushCode", "426");
        customParameter.put("content", text);
        umPushMsgAndroidReqVO.setCustom(JSON.toJSONString(customParameter));
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgAndroidReqVO buildDoctorReferralAndroidPushMsgTemplate1(String patientName, String doctorName, String deviceToken, String userId, String admId) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getDoctorReferralAppPushBusiCode());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("doctor", "Android", admId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceToken);
        String text = MessageFormat.format("{0}\u533b\u751f\u5df2\u5c06{1}\u60a3\u8005\u7684\u590d\u8bca\u8f6c\u8ba9\u7ed9\u60a8\uff0c\u8bf7\u60a8\u5c3d\u5feb\u5904\u7406\u672c\u6b21\u590d\u8bca\u3002", doctorName, patientName);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle(this.projProperties.getReferralTitle());
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getDoctorReferralAppPushBusiCode());
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getDoctorReferralAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", this.projProperties.getDoctorReferralAppPushBusiCode().substring(6, 12));
        parameter.put("admId", admId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        umPushMsgAndroidReqVO.setDescription("\u54a8\u8be2\u7533\u8bf7\u63d0\u9192");
        HashMap<String, String> customParameter = new HashMap<String, String>(2);
        customParameter.put("pushCode", "426");
        customParameter.put("content", text);
        umPushMsgAndroidReqVO.setCustom(JSON.toJSONString(customParameter));
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgIOSReqVo buildDoctorReferralIOSPushMsgTemplate(String patientName, String doctorName, String deviceToken, String userId, String admId) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getDoctorReferralAppPushBusiCode());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("doctor", "IOS", admId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceToken);
        String body = MessageFormat.format("{0}\u533b\u751f\u5df2\u5c06{1}\u60a3\u8005\u7684\u54a8\u8be2\u8f6c\u8ba9\u7ed9\u60a8\uff0c\u8bf7\u60a8\u5c3d\u5feb\u5904\u7406\u672c\u6b21\u54a8\u8be2\u3002", doctorName, patientName);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle(this.projProperties.getReferralTitle());
        umPushMsgIOSReqVo.setSubTitle(this.projProperties.getReferralTitle());
        umPushMsgIOSReqVo.setDescription(this.projProperties.getReferralTitle());
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getDoctorReferralAppPushBusiCode());
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getDoctorReferralAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", this.projProperties.getDoctorReferralAppPushBusiCode().substring(6, 12));
        parameter.put("admId", admId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgIOSReqVo buildDoctorReferralIOSPushMsgTemplate1(String patientName, String doctorName, String deviceToken, String userId, String admId) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getDoctorReferralAppPushBusiCode());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("doctor", "IOS", admId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceToken);
        String body = MessageFormat.format("{0}\u533b\u751f\u5df2\u5c06{1}\u60a3\u8005\u7684\u590d\u8bca\u8f6c\u8ba9\u7ed9\u60a8\uff0c\u8bf7\u60a8\u5c3d\u5feb\u5904\u7406\u672c\u6b21\u590d\u8bca\u3002", doctorName, patientName);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle(this.projProperties.getReferralTitle());
        umPushMsgIOSReqVo.setSubTitle(this.projProperties.getReferralTitle());
        umPushMsgIOSReqVo.setDescription(this.projProperties.getReferralTitle());
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getDoctorReferralAppPushBusiCode());
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getDoctorReferralAppPushBusiCode().substring(0, 4));
        parameter.put("actionCode", this.projProperties.getDoctorReferralAppPushBusiCode().substring(6, 12));
        parameter.put("admId", admId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgAndroidReqVO getdoctorCloseScheduleAppPushAndroid(String admissionId, String doctorName, String userId, String deviceTokens) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getDoctorCloseSchedule());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("patient", "Android", admissionId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceTokens);
        String text = MessageFormat.format("\u62b1\u6b49\uff0c\u60a8\u9884\u7ea6\u7684{0}\u533b\u751f\u5df2\u505c\u8bca\uff0c\u5c06\u4e3a\u60a8\u8fdb\u884c\u9000\u6b3e", doctorName);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle("\u533b\u751f\u505c\u8bca\u901a\u77e5");
        umPushMsgAndroidReqVO.setDescription("\u533b\u751f\u505c\u8bca\u901a\u77e5");
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getDoctorCloseSchedule());
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getDoctorCloseSchedule().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getDoctorCloseSchedule().substring(6, 12));
        parameter.put("admissionId", admissionId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgIOSReqVo getdoctorCloseScheduleAppPushIOS(String admissionId, String doctorName, String userId, String deviceTokens) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getDoctorCloseSchedule());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("patient", "IOS", admissionId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceTokens);
        String body = MessageFormat.format("\u62b1\u6b49\uff0c\u60a8\u9884\u7ea6\u7684{0}\u533b\u751f\u5df2\u505c\u8bca\uff0c\u5c06\u4e3a\u60a8\u8fdb\u884c\u9000\u6b3e", doctorName);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle("\u533b\u751f\u505c\u8bca\u901a\u77e5");
        umPushMsgIOSReqVo.setSubTitle("\u533b\u751f\u505c\u8bca\u901a\u77e5");
        umPushMsgIOSReqVo.setDescription("\u533b\u751f\u505c\u8bca\u901a\u77e5");
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getDoctorCloseSchedule());
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getDoctorCloseSchedule().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getDoctorCloseSchedule().substring(6, 12));
        parameter.put("admissionId", admissionId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgAndroidReqVO getdoctorCompletionAppPushAndroid(String admissionId, String doctorName, String userId, String deviceTokens, String serType) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getCompletionAppPush());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("patient", "Android", admissionId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceTokens);
        String text = MessageFormat.format("\u60a8\u4e0e{0}\u533b\u751f\u7684{1}\u5df2\u7ed3\u675f\u3002", doctorName, serType);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle("\u8ba2\u5355\u5b8c\u6210\u901a\u77e5");
        umPushMsgAndroidReqVO.setDescription("\u8ba2\u5355\u5b8c\u6210\u901a\u77e5");
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getCompletionAppPush());
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getCompletionAppPush().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getCompletionAppPush().substring(6, 12));
        parameter.put("admissionId", admissionId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgIOSReqVo getdoctorCompletionAppPushIOS(String admissionId, String doctorName, String userId, String deviceTokens, String serType) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getCompletionAppPush());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("patient", "IOS", admissionId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceTokens);
        String body = MessageFormat.format("\u60a8\u4e0e{0}\u533b\u751f\u7684{1}\u5df2\u7ed3\u675f\u3002", doctorName, serType);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle("\u8ba2\u5355\u5b8c\u6210\u901a\u77e5");
        umPushMsgIOSReqVo.setSubTitle("\u8ba2\u5355\u5b8c\u6210\u901a\u77e5");
        umPushMsgIOSReqVo.setDescription("\u8ba2\u5355\u5b8c\u6210\u901a\u77e5");
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getCompletionAppPush());
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getCompletionAppPush().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getCompletionAppPush().substring(6, 12));
        parameter.put("admissionId", admissionId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgAndroidReqVO buildNoFollowUpCaseAndroidPushMsgTemplate(String patientName, String deviceToken, String userId, String admId) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getNoFollowUpCaseAppPush());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("doctor", "Android", admId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceToken);
        String text = MessageFormat.format("\u60a8\u4e0e{0}\u60a3\u8005\u7684\u590d\u8bca\u5373\u5c06\u7ed3\u675f\uff0c\u8bf7\u53ca\u65f6\u4e3a\u60a3\u8005\u5f00\u5177\u590d\u8bca\u75c5\u5386\u3002", patientName);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle("\u5f00\u5177\u590d\u8bca\u75c5\u5386\u63d0\u9192");
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getNoFollowUpCaseAppPush());
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getNoFollowUpCaseAppPush().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getNoFollowUpCaseAppPush().substring(6, 14));
        parameter.put("admId", admId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        umPushMsgAndroidReqVO.setDescription("\u5f00\u5177\u590d\u8bca\u75c5\u5386\u63d0\u9192");
        HashMap<String, String> customParameter = new HashMap<String, String>(2);
        customParameter.put("pushCode", "426");
        customParameter.put("content", text);
        umPushMsgAndroidReqVO.setCustom(JSON.toJSONString(customParameter));
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgIOSReqVo buildNoFollowUpCaseIOSPushMsgTemplate(String patientName, String deviceToken, String userId, String admId) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getNoFollowUpCaseAppPush());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("doctor", "IOS", admId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceToken);
        String body = MessageFormat.format("\u60a8\u4e0e{0}\u60a3\u8005\u7684\u590d\u8bca\u5373\u5c06\u7ed3\u675f\uff0c\u8bf7\u53ca\u65f6\u4e3a\u60a3\u8005\u5f00\u5177\u590d\u8bca\u75c5\u5386\u3002", patientName);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle("\u5f00\u5177\u590d\u8bca\u75c5\u5386\u63d0\u9192");
        umPushMsgIOSReqVo.setSubTitle("\u5f00\u5177\u590d\u8bca\u75c5\u5386\u63d0\u9192");
        umPushMsgIOSReqVo.setDescription("\u5f00\u5177\u590d\u8bca\u75c5\u5386\u63d0\u9192");
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getNoFollowUpCaseAppPush());
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getNoFollowUpCaseAppPush().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getNoFollowUpCaseAppPush().substring(6, 14));
        parameter.put("admId", admId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgAndroidReqVO buildNoMedicalOpinionAndroidPushMsgTemplate(String patientName, String deviceToken, String userId, String admId) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getNoMedicalOpinionAppPush());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("doctor", "Android", admId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceToken);
        String text = MessageFormat.format("\u60a8\u4e0e{0}\u60a3\u8005\u7684\u54a8\u8be2\u5373\u5c06\u7ed3\u675f\uff0c\u8bf7\u53ca\u65f6\u4e3a\u60a3\u8005\u5f00\u5177\u8bca\u7597\u610f\u89c1\u3002", patientName);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle("\u5f00\u5177\u8bca\u7597\u610f\u89c1\u63d0\u9192");
        umPushMsgAndroidReqVO.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getNoMedicalOpinionAppPush());
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getNoMedicalOpinionAppPush().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getNoMedicalOpinionAppPush().substring(6, 14));
        parameter.put("admId", admId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        umPushMsgAndroidReqVO.setDescription("\u5f00\u5177\u8bca\u7597\u610f\u89c1\u63d0\u9192");
        HashMap<String, String> customParameter = new HashMap<String, String>(2);
        customParameter.put("pushCode", this.projProperties.getNoMedicalOpinionAppPush());
        customParameter.put("content", text);
        umPushMsgAndroidReqVO.setCustom(JSON.toJSONString(customParameter));
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgIOSReqVo buildNoMedicalOpinionIOSPushMsgTemplate(String patientName, String deviceToken, String userId, String admId) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getNoMedicalOpinionAppPush());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("doctor", "IOS", admId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceToken);
        String body = MessageFormat.format("\u60a8\u4e0e{0}\u60a3\u8005\u7684\u54a8\u8be2\u5373\u5c06\u7ed3\u675f\uff0c\u8bf7\u53ca\u65f6\u4e3a\u60a3\u8005\u5f00\u5177\u8bca\u7597\u610f\u89c1\u3002", patientName);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle("\u5f00\u5177\u8bca\u7597\u610f\u89c1\u63d0\u9192");
        umPushMsgIOSReqVo.setSubTitle("\u5f00\u5177\u8bca\u7597\u610f\u89c1\u63d0\u9192");
        umPushMsgIOSReqVo.setDescription("\u5f00\u5177\u8bca\u7597\u610f\u89c1\u63d0\u9192");
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", this.projProperties.getNoMedicalOpinionAppPush());
        parameter.put("content", body);
        parameter.put("businessCode", this.projProperties.getNoMedicalOpinionAppPush().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getNoMedicalOpinionAppPush().substring(6, 14));
        parameter.put("admId", admId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(body);
        return umPushMsgIOSReqVo;
    }

    private String getUserIdByDoctorIdAndHospitalId(String doctorId, String hospitalId) {
        DoctorIdReqVO doctorIdReqVO = new DoctorIdReqVO();
        doctorIdReqVO.setHospitalId(hospitalId);
        doctorIdReqVO.setDoctorId(doctorId);
        doctorIdReqVO.setChannelCode("CHDU-online");
        String url = this.projProperties.getUserIdByDoctorIdAndHospitalId();
        BaseResponse response = null;
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)doctorIdReqVO));
            response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), BaseResponse.class);
            log.info("response:{}" + JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u67e5\u8be2\u7528\u6237id\u5931\u8d25" + e.getMessage());
        }
        log.info("\u5f97\u5230\u533b\u751fuserId\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)response));
        DoctorInfoRespVO doctorInfoRespVO = (DoctorInfoRespVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), DoctorInfoRespVO.class);
        log.info("\u5f97\u5230\u533b\u751fuserId\u8fd4\u56de\u770bjson\u89e3\u6790: {}", (Object)JSON.toJSONString((Object)doctorInfoRespVO));
        if (null == doctorInfoRespVO) {
            return null;
        }
        return doctorInfoRespVO.getUserId();
    }

    private String getAppClientCode(String userType, String channelCode, String admId) {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            return null;
        }
        String appCode = orderEntity.getAppCode();
        PushConfigurationDetailVO pushConfig = this.pushUtils.getPushConfig(appCode, "youmengPush", userType, channelCode);
        if (null == pushConfig) {
            return null;
        }
        return pushConfig.getClientCode();
    }

    public void manageReferralAppPush(String admissionId) {
        log.info("=======\u7ba1\u7406\u7aef\u8f6c\u8bcaApp\u63a8\u9001=========");
        AdmissionEntity admissionInfo = this.getAdmissionInfo(admissionId);
        if (null == admissionInfo) {
            log.error("========\u83b7\u53d6\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionId);
            return;
        }
        log.info("admissionInfo:{}" + admissionInfo.toString());
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(admissionInfo.getPatientId());
        if (null == patientEntity) {
            log.error("========\u83b7\u53d6\u60a3\u8005\u59d3\u540d\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionInfo.getPatientId());
            return;
        }
        log.info("patientEntity:{}" + patientEntity.toString());
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        if (null == orderEntity) {
            log.error("========\u83b7\u53d6\u8ba2\u5355\u8bb0\u5f55\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========" + admissionInfo.getPatientId());
            return;
        }
        log.info("orderEntity:{}" + orderEntity.toString());
        String patientName = patientEntity.getPatientName();
        String userId = this.getUserIdByDoctorIdAndHospitalId(admissionInfo.getDoctorId(), orderEntity.getHospitalId());
        if (StringUtils.isEmpty((String)userId)) {
            log.error("========\u83b7\u53d6userId\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        String doctorName = orderEntity.getDoctorName();
        UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = this.getDocUserDeviceToken(userId, new Short("1"));
        if (null == userLastLoginDeviceRespVo) {
            log.error("========\u83b7\u53d6\u7528\u6237\u6700\u540e\u4e00\u6b21\u767b\u5f55\u6e20\u9053\u5931\u8d25\uff0c\u63a8\u9001\u5931\u8d25========");
            return;
        }
        log.info("userLastLoginDeviceRespVo:{}" + userLastLoginDeviceRespVo.toString());
        if (StringUtils.isEmpty((String)userLastLoginDeviceRespVo.getDeviceType())) {
            log.info("=======\u83b7\u53d6\u7528\u6237\u7684\u8bbe\u5907\u6807\u8bc6=======");
            return;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        DoctorTeamEntity entity = new DoctorTeamEntity();
        entity.setAdmissionId(admissionId);
        queryWrapper.setEntity((Object)entity);
        DoctorTeamEntity doctorTeamEntity = (DoctorTeamEntity)this.doctorTeamMapper.selectOne((Wrapper)queryWrapper);
        if (null == doctorTeamEntity) {
            return;
        }
        log.info("doctorTeamEntity:{}" + doctorTeamEntity.toString());
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.ANDROID.getValue())) {
            log.info("==============\u7ba1\u7406\u7aef\u8f6c\u8bcaAPP\u63a8\u9001\u5b89\u5353\u8fdb\u5165=============");
            UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.manageReferralAndroidPushMsgTemplate(patientName, doctorTeamEntity.getAdmissionDoctorName(), userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId, orderEntity.getServType());
            this.pushUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
            return;
        }
        if (userLastLoginDeviceRespVo.getDeviceType().equals(ChannelCodeEnum.IOS.getValue())) {
            log.info("==============\u7ba1\u7406\u7aef\u8f6c\u8bcaAPP\u63a8\u9001ios\u8fdb\u5165=============");
            UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.manageReferralIOSPushMsgTemplate(patientName, userLastLoginDeviceRespVo.getDeviceNumber(), userId, admissionId, orderEntity.getServType(), doctorTeamEntity.getAdmissionDoctorName());
            this.pushUtils.pushIOSMessage(umPushMsgIOSReqVo);
            return;
        }
    }

    private UmPushMsgAndroidReqVO manageReferralAndroidPushMsgTemplate(String patientName, String doctorName, String deviceToken, String userId, String admId, Integer servType) {
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode(this.projProperties.getManagerReferralAppPushBusiCode());
        umPushMsgAndroidReqVO.setClientCode(this.getAppClientCode("doctor", "Android", admId));
        umPushMsgAndroidReqVO.setDeviceTokens(deviceToken);
        String service = "";
        service = ServiceTypeEnum.HOS.getValue().equals(servType) ? "\u54a8\u8be2" : "\u590d\u8bca";
        String text = MessageFormat.format("\u7ba1\u7406\u5458\u5df2\u5c06{0}\u60a3\u8005\u7684{1}\u8f6c\u8bca\u7ed9{2}\u533b\u751f\uff0c\u672c\u6b21{3}\u5df2\u5b8c\u6210", patientName, service, doctorName, service);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle("\u60a3\u8005\u88ab\u8f6c\u8bca\u901a\u77e5");
        umPushMsgAndroidReqVO.setUserId(userId);
        umPushMsgAndroidReqVO.setDescription("\u60a3\u8005\u88ab\u8f6c\u8bca\u901a\u77e5");
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", "426");
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getManagerReferralAppPushBusiCode().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getManagerReferralAppPushBusiCode().substring(6, 13));
        parameter.put("admId", admId);
        umPushMsgAndroidReqVO.setExtra(parameter);
        umPushMsgAndroidReqVO.setBusiStyle(text);
        umPushMsgAndroidReqVO.setDescription("\u60a3\u8005\u88ab\u8f6c\u8bca\u901a\u77e5");
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgIOSReqVo manageReferralIOSPushMsgTemplate(String patientName, String deviceToken, String userId, String admId, Integer servType, String doctorName) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode(this.projProperties.getManagerReferralAppPushBusiCode());
        umPushMsgIOSReqVo.setClientCode(this.getAppClientCode("doctor", "IOS", admId));
        umPushMsgIOSReqVo.setDeviceTokens(deviceToken);
        String service = "";
        service = ServiceTypeEnum.HOS.getValue().equals(servType) ? "\u54a8\u8be2" : "\u590d\u8bca";
        String text = MessageFormat.format("\u7ba1\u7406\u5458\u5df2\u5c06{0}\u60a3\u8005\u7684{1}\u8f6c\u8bca\u7ed9{2}\u533b\u751f\uff0c\u672c\u6b21{3}\u5df2\u5b8c\u6210", patientName, service, doctorName, service);
        umPushMsgIOSReqVo.setBody(text);
        umPushMsgIOSReqVo.setTitle("\u60a3\u8005\u88ab\u8f6c\u8bca\u901a\u77e5");
        umPushMsgIOSReqVo.setSubTitle("\u60a3\u8005\u88ab\u8f6c\u8bca\u901a\u77e5");
        umPushMsgIOSReqVo.setDescription("\u60a3\u8005\u88ab\u8f6c\u8bca\u901a\u77e5");
        umPushMsgIOSReqVo.setUserId(userId);
        HashMap<String, String> parameter = new HashMap<String, String>(5);
        parameter.put("pushCode", "426");
        parameter.put("content", text);
        parameter.put("businessCode", this.projProperties.getManagerReferralAppPushBusiCode().substring(0, 5));
        parameter.put("actionCode", this.projProperties.getManagerReferralAppPushBusiCode().substring(6, 13));
        parameter.put("admId", admId);
        umPushMsgIOSReqVo.setExtra(parameter);
        umPushMsgIOSReqVo.setBusiStyle(text);
        umPushMsgIOSReqVo.setDescription("\u60a3\u8005\u88ab\u8f6c\u8bca\u901a\u77e5");
        return umPushMsgIOSReqVo;
    }
}

