/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.remotecall;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctor.basedata.api.vo.DepartmentDetailVo;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.exception.BusinessException;
import com.ebaiyihui.onlineoutpatient.core.service.client.DepartmentFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.vo.GetMainIdsReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.HisDeptAndDocCodeVo;
import com.ebaiyihui.onlineoutpatient.core.vo.InternetHospitalEntity;
import com.ebaiyihui.onlineoutpatient.core.vo.UpdateMedicalRecordReqVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.InsertMedicalTemplateTagsRecordReqVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.InsertTagsRecordVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.MedicalSortReqVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.MedicalSortVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.MedicalTemplateTagsEntityVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.MedicalTemplateTagsVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.MedicalTransformVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalIdByAdmIdVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalIdVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.SavePatientDynamicMedicalReqVo;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InternetHospitalDetailInfoService {
    private static final Logger log = LoggerFactory.getLogger(InternetHospitalDetailInfoService.class);
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private DepartmentFeignClient departmentInfoApi;
    @Autowired
    private DoctorInfofeignClient doctorCilent;

    public InternetHospitalEntity getInternetHospitalInfo(String organId, String internetHospitalUrl) {
        HashMap<String, String> map = new HashMap<String, String>(10);
        map.put("organId", organId);
        InternetHospitalEntity internetHospitalEntity = null;
        try {
            String result = HttpKit.jsonPost((String)internetHospitalUrl, (String)JSON.toJSONString(map));
            log.info("\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a, {}", (Object)result);
            internetHospitalEntity = (InternetHospitalEntity)JSONObject.toJavaObject((JSON)JSON.parseObject((String)result).getJSONObject("data"), InternetHospitalEntity.class);
            if (null == internetHospitalEntity) {
                log.info("\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\uff1a{HttpKit.jsonPost}");
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8c03\u7528\u4e91\u7aef\u63a5\u53e3\u5f02\u5e38");
        }
        log.info("\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)internetHospitalEntity.toString());
        return internetHospitalEntity;
    }

    public PatientDynamicMedicalEntityVo getMedicalInfoById(String medicalId) {
        log.info("\u6839\u636e\u75c5\u4f8bID\u67e5\u75c5\u4f8b\u8be6\u60c5\u5165\u53c2: " + medicalId);
        try {
            PatientDynamicMedicalIdVo patientDynamicMedicalIdVo = new PatientDynamicMedicalIdVo();
            patientDynamicMedicalIdVo.setId(medicalId);
            String body = HttpKit.jsonPost((String)this.projProperties.getGetMedicalInfoById(), (String)JSON.toJSONString((Object)patientDynamicMedicalIdVo));
            BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            PatientDynamicMedicalEntityVo patientDynamicMedicalEntityVo = (PatientDynamicMedicalEntityVo)JSON.parseObject((String)JSON.toJSONString((Object)baseResponse.getData()), PatientDynamicMedicalEntityVo.class);
            log.info("\u6839\u636e\u75c5\u4f8bID\u67e5\u75c5\u4f8b\u8be6\u60c5\u8fd4\u56de\u503c: " + patientDynamicMedicalEntityVo.toString());
            return patientDynamicMedicalEntityVo;
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u75c5\u4f8bID\u67e5\u75c5\u4f8b\u8be6\u60c5\u8c03\u7528\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public PatientDynamicMedicalEntityVo getMedicalInfoByAdmId(String admId) {
        log.info("\u6839\u636e\u5c31\u8bcaid\u67e5\u75c5\u4f8b\u8be6\u60c5\u5165\u53c2: " + admId);
        try {
            PatientDynamicMedicalIdByAdmIdVo patientDynamicMedicalIdByAdmIdVo = new PatientDynamicMedicalIdByAdmIdVo();
            patientDynamicMedicalIdByAdmIdVo.setAdmId(admId);
            String body = HttpKit.jsonPost((String)this.projProperties.getMedicalInfoByAdmId(), (String)JSON.toJSONString((Object)patientDynamicMedicalIdByAdmIdVo));
            BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            if (baseResponse.getData() == null) {
                return null;
            }
            PatientDynamicMedicalEntityVo patientDynamicMedicalEntityVo = (PatientDynamicMedicalEntityVo)JSON.parseObject((String)JSON.toJSONString((Object)baseResponse.getData()), PatientDynamicMedicalEntityVo.class);
            log.info("\u6839\u636e\u5c31\u8bcaid\u67e5\u75c5\u4f8b\u8be6\u60c5\u8fd4\u56de\u503c: " + patientDynamicMedicalEntityVo.toString());
            return patientDynamicMedicalEntityVo;
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u5c31\u8bcaid\u67e5\u75c5\u4f8b\u8be6\u60c5\u8c03\u7528\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public List<MedicalSortVo> getCardMedicalUserFills(Integer servType, String medicalDetail, String hospitalId, String deptId) {
        try {
            MedicalSortReqVo medicalSortReqVo = new MedicalSortReqVo();
            medicalSortReqVo.setMedicalUserFills(medicalDetail);
            medicalSortReqVo.setHospitalId(hospitalId);
            medicalSortReqVo.setServType(servType);
            if (servType == 5) {
                medicalSortReqVo.setDeptId(deptId);
            }
            log.info("\u75c5\u5386\u5361\u7247\u5165\u53c2: " + JSON.toJSONString((Object)medicalSortReqVo));
            String body = HttpKit.jsonPost((String)this.projProperties.getGetCardMedicalUserFills(), (String)JSON.toJSONString((Object)medicalSortReqVo));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            List medicalSortVos = JSON.parseArray((String)JSON.toJSONString((Object)baseResponse.getData()), MedicalSortVo.class);
            log.info("\u75c5\u5386\u5361\u7247\u8fd4\u56de\u503c: " + medicalSortVos.toString());
            return medicalSortVos;
        }
        catch (Exception e) {
            log.error("\u75c5\u5386\u5361\u7247\u8c03\u7528\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public String insertMedicalTemplateRecordTags(InsertMedicalTemplateTagsRecordReqVo recordEntity) {
        try {
            log.info("\u63d2\u5165\u75be\u75c5\u6807\u7b7e\u5165\u53c2: " + recordEntity);
            String body = HttpKit.jsonPost((String)this.projProperties.getInsertMedicalTemplateRecordTags(), (String)JSON.toJSONString((Object)recordEntity));
            String baseResponse = JSON.toJSONString((Object)body);
            log.info("\u63d2\u5165\u75be\u75c5\u6807\u7b7e\u8fd4\u56de\u503c: " + baseResponse);
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u63d2\u5165\u75be\u75c5\u6807\u7b7e\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public MedicalTemplateTagsEntityVo selectMedicalTemplateRecordTags(MedicalTemplateTagsVo tagsVo) {
        try {
            log.info("\u67e5\u627e\u75be\u75c5\u6807\u7b7e\u5165\u53c2: " + tagsVo);
            String body = HttpKit.jsonPost((String)this.projProperties.getSelectMedicalTemplateRecordTags(), (String)JSON.toJSONString((Object)tagsVo));
            BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            MedicalTemplateTagsEntityVo medicalTemplateTagsEntityVo = (MedicalTemplateTagsEntityVo)JSON.parseObject((String)JSON.toJSONString((Object)baseResponse.getData()), MedicalTemplateTagsEntityVo.class);
            log.info("\u67e5\u627e\u75be\u75c5\u6807\u7b7e\u8fd4\u56de\u503c: " + medicalTemplateTagsEntityVo.toString());
            return medicalTemplateTagsEntityVo;
        }
        catch (Exception e) {
            log.error("\u67e5\u627e\u75be\u75c5\u6807\u7b7e\u8c03\u7528\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public List<MedicalSortVo> getMedicalUserFills(Integer servType, String medicalDetail, String hospitalId, String deptId) {
        try {
            MedicalSortReqVo medicalSortReqVo = new MedicalSortReqVo();
            medicalSortReqVo.setMedicalUserFills(medicalDetail);
            medicalSortReqVo.setHospitalId(hospitalId);
            medicalSortReqVo.setServType(servType);
            if (servType == 5) {
                medicalSortReqVo.setDeptId(deptId);
            }
            log.info("\u83b7\u53d6\u60a3\u8005\u586b\u5199\u7684\u75c5\u4f8b\u5165\u53c2==>{}", (Object)JSON.toJSONString((Object)medicalSortReqVo));
            String body = HttpKit.jsonPost((String)this.projProperties.getGetMedicalUserFills(), (String)JSON.toJSONString((Object)medicalSortReqVo));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            List medicalSortVos = JSON.parseArray((String)JSON.toJSONString((Object)baseResponse.getData()), MedicalSortVo.class);
            log.info("\u83b7\u53d6\u60a3\u8005\u586b\u5199\u7684\u75c5\u4f8b\u8fd4\u56de\u503c: " + medicalSortVos.toString());
            return medicalSortVos;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u60a3\u8005\u586b\u5199\u7684\u75c5\u4f8b\u8c03\u7528\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public String medicalTransform(MedicalTransformVo medicalTransformVo) {
        try {
            log.info("\u75c5\u4f8b\u6570\u636e\u8fc1\u79fb\u5165\u53c2==>{}", (Object)JSON.toJSONString((Object)medicalTransformVo));
            String body = HttpKit.jsonPost((String)this.projProperties.getMedicalDataTransform(), (String)JSON.toJSONString((Object)medicalTransformVo));
            String base = JSON.toJSONString((Object)body);
            log.info("\u75c5\u4f8b\u6570\u636e\u8fc1\u79fb\u8fd4\u56de\u503c: " + base);
            return base;
        }
        catch (Exception e) {
            log.error("\u75c5\u4f8b\u6570\u636e\u8fc1\u79fb\u8c03\u7528\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public HisDeptAndDocCodeVo getHisDeptAndDocCode(String deptId, String doctorId) {
        Long deptIdL;
        BaseResponse departmentDetail;
        HisDeptAndDocCodeVo hisDeptAndDocCodeVo = new HisDeptAndDocCodeVo();
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(doctorId);
        BaseResponse personnelInfoBaseResponse = this.doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
        if (personnelInfoBaseResponse.isSuccess() && null != personnelInfoBaseResponse.getData()) {
            log.info("his\u533b\u751fcode:" + JSON.toJSONString((Object)personnelInfoBaseResponse));
            String emplCode = ((PersonnelInfo)personnelInfoBaseResponse.getData()).getEmplCode();
            hisDeptAndDocCodeVo.setDoctorCode(emplCode);
            hisDeptAndDocCodeVo.setDoctorName(((PersonnelInfo)personnelInfoBaseResponse.getData()).getDoctorName());
        }
        if ((departmentDetail = this.departmentInfoApi.getDepartmentDetail(deptIdL = Long.valueOf(deptId))).isSuccess() && null != departmentDetail.getData()) {
            log.info("his\u79d1\u5ba4code:" + JSON.toJSONString((Object)departmentDetail));
            String deptCode = ((DepartmentDetailVo)departmentDetail.getData()).getDeptCode();
            hisDeptAndDocCodeVo.setDeptCode(deptCode);
            hisDeptAndDocCodeVo.setDeptName(((DepartmentDetailVo)departmentDetail.getData()).getDeptName());
        }
        return hisDeptAndDocCodeVo;
    }

    public String insertTagsRecord(InsertTagsRecordVo insertTagsRecordVo) {
        try {
            log.info("\u4e0b\u5355\u63d2\u5165\u75c5\u4f8b\u6807\u7b7e: " + insertTagsRecordVo);
            log.info("url: " + this.projProperties.getInsertTagsRecord());
            String body = HttpKit.jsonPost((String)this.projProperties.getInsertTagsRecord(), (String)JSON.toJSONString((Object)insertTagsRecordVo));
            String baseResponse = JSON.toJSONString((Object)body);
            log.info("\u4e0b\u5355\u63d2\u5165\u75c5\u4f8b\u6807\u7b7e: " + baseResponse);
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u4e0b\u5355\u63d2\u5165\u75c5\u4f8b\u6807\u7b7e" + e.getMessage());
            return null;
        }
    }

    public List<String> getMainIdsByAdmIdAndAppCode(GetMainIdsReqVo getMainIdsReqVo) {
        try {
            log.info("\u67e5\u8be2\u5904\u65b9\u5165\u53c2:{} ", (Object)JSONObject.toJSONString((Object)getMainIdsReqVo));
            log.info("url: " + this.projProperties.getMainIdsByAdmIdAndAppCode());
            String body = HttpKit.jsonPost((String)this.projProperties.getMainIdsByAdmIdAndAppCode(), (String)JSON.toJSONString((Object)getMainIdsReqVo));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            List ids = (List)baseResponse.getData();
            log.info("\u67e5\u8be2\u5904\u65b9\u51fa\u53c2:{}", (Object)JSONObject.toJSONString((Object)ids));
            return ids;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5904\u65b9" + e.getMessage());
            return null;
        }
    }

    public String insertMedical(SavePatientDynamicMedicalReqVo param) {
        String url = this.projProperties.getBaseAddress() + "/cloud/sysinfocloud/patientDynamicMedical/insertMedical";
        try {
            log.info("\u4e0a\u4f20\u75c5\u5386\u5230\u4e91\u7aef\u4f20\u53c2:{} ", (Object)JSONObject.toJSONString((Object)param));
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)param));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), BaseResponse.class);
            log.info("\u4e0a\u4f20\u75c5\u5386\u5230\u4e91\u7aef\u8fd4\u56de\u503c:{}", (Object)JSON.toJSONString((Object)baseResponse));
            if (!baseResponse.isSuccess() || Objects.isNull(baseResponse.getData())) {
                throw new BusinessException("\u4e0a\u4f20\u75c5\u5386\u5230\u4e91\u7aef\u5931\u8d25");
            }
            log.info("\u67e5\u8be2\u5904\u65b9\u51fa\u53c2:{}", (Object)JSONObject.toJSONString((Object)baseResponse));
            return (String)baseResponse.getData();
        }
        catch (Exception e) {
            throw new BusinessException("\u4e0a\u4f20\u75c5\u5386\u5230\u4e91\u7aef\u5931\u8d25");
        }
    }

    public BaseResponse updateMedicalRecord(UpdateMedicalRecordReqVo param) {
        String url = this.projProperties.getBaseAddress() + "/cloud/sysinfocloud/patientDynamicMedical/updateMedicalNew";
        try {
            log.info("\u4fee\u6539\u75c5\u5386\u5165\u53c2:{} ", (Object)JSONObject.toJSONString((Object)param));
            log.info("url::{}", (Object)url);
            String body = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)param));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u4fee\u6539\u75c5\u5386\u51fa\u53c2:{}", (Object)JSONObject.toJSONString((Object)baseResponse));
            return baseResponse;
        }
        catch (Exception e) {
            throw new BusinessException("\u4fee\u6539\u75c5\u5386\u5931\u8d25:{}", e.getMessage());
        }
    }
}

