/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.task;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.service.PayCallBackService;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestRefundVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class RegisterTask {
    private static final Logger log = LoggerFactory.getLogger(RegisterTask.class);
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private PayCallBackService payCallBackService;
    private static final Integer MEDICARE = 1;

    @Scheduled(cron="0 50 23 * * ?")
    public void regularTimeExport() {
        List patientEntities = this.patientMapper.selectByCardType(MEDICARE);
        if (CollectionUtils.isEmpty((Collection)patientEntities)) {
            log.info("\u4e0d\u5b58\u5728\u533b\u4fdd\u60a3\u8005");
            return;
        }
        ArrayList<AdmissionEntity> admissionList = new ArrayList<AdmissionEntity>();
        for (PatientEntity patient : patientEntities) {
            QueryWrapper queryWrapper = new QueryWrapper();
            OrderEntity orderEntity = new OrderEntity();
            orderEntity.setServType(ServiceTypeEnum.NOS.getValue());
            orderEntity.setAppCode("HYT");
            orderEntity.setPatientId(patient.getXId());
            queryWrapper.setEntity((Object)orderEntity);
            List orderEntities = this.orderMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isEmpty((Collection)orderEntities)) {
                log.info("\u6b64\u60a3\u8005\u65e0\u8ba2\u5355");
                continue;
            }
            List orders = orderEntities.stream().filter(order -> !StringUtils.isEmpty((Object)order.getClinicCode()) && order.getStatus().equals(OrderStatusEnum.PAID.getValue())).collect(Collectors.toList());
            log.info("\u67d0\u60a3\u8005\u7b26\u5408\u6761\u4ef6\u8ba2\u5355:" + JSON.toJSONString(orders));
            for (OrderEntity orderE : orders) {
                QueryWrapper query = new QueryWrapper();
                AdmissionEntity admissionEntity = new AdmissionEntity();
                admissionEntity.setOrderId(orderE.getXId());
                query.setEntity((Object)admissionEntity);
                AdmissionEntity admission = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)query);
                if (null == admission || !admission.getStatus().equals(AdmissionStatusEnum.TO_BE_RECEIVED.getValue())) continue;
                log.info("\u67d0\u8ba2\u5355\u7684\u5c31\u8bca\u8bb0\u5f55:" + JSON.toJSONString((Object)admission));
                admissionList.add(admission);
            }
        }
        log.info("\u8fc7\u6ee4\u540e\u7684\u5c31\u8bca\u8bb0\u5f55:" + JSON.toJSONString(admissionList));
        if (CollectionUtils.isEmpty(admissionList)) {
            log.info("\u533b\u4fdd\u60a3\u8005\u65e0\u53ef\u9000\u53f7\u8ba2\u5355");
            return;
        }
        admissionList.stream().forEach(admissionE -> {
            RequestRefundVo requestRefundVo = new RequestRefundVo();
            requestRefundVo.setOrderId(admissionE.getOrderId());
            this.payCallBackService.refundCalls(requestRefundVo);
            AdmissionEntity admEntity = new AdmissionEntity();
            admEntity.setStatus(AdmissionStatusEnum.REFUNDED_REFUSE.getValue());
            admEntity.setXId(admissionE.getXId());
            this.admissionMapper.update(admEntity);
            log.info("admEntity\u66f4\u65b0\u540e:" + JSON.toJSONString((Object)admEntity));
        });
    }
}

