/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.physical.dto.CombinationCountDTO;
import com.ebaiyihui.physical.dto.CombinationDTO;
import com.ebaiyihui.physical.dto.CombinationDetailsDTO;
import com.ebaiyihui.physical.dto.CombinationTypeDTO;
import com.ebaiyihui.physical.entity.CombinationEntity;
import com.ebaiyihui.physical.entity.CombinationTypeEntity;
import com.ebaiyihui.physical.service.CombinationService;
import com.ebaiyihui.physical.service.CombinationTypeService;
import com.ebaiyihui.physical.vo.ChangeSort;
import com.ebaiyihui.physical.vo.CombinationOnlineVO;
import com.ebaiyihui.physical.vo.CombinationProjectVO;
import com.ebaiyihui.physical.vo.CombinationVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/combination"})
@Api(tags={"\u5957\u9910\u7ba1\u7406"})
public class CombinationManageController {
    private static final Logger log = LogManager.getLogger(CombinationManageController.class);
    @Autowired
    private CombinationTypeService combinationTypeService;
    @Autowired
    private CombinationService combinationService;

    @PostMapping(value={"/type/save"})
    @ApiOperation(value="\u5957\u9910\u5206\u7c7b\u4fdd\u5b58\u6216\u66f4\u65b0\u63a5\u53e3")
    public BaseResponse saveOrUpdateCombinationType(@RequestBody CombinationTypeEntity combinationTypeEntity) {
        return this.combinationTypeService.saveOrUpdateCombinationType(combinationTypeEntity);
    }

    @GetMapping(value={"/type/del"})
    @ApiOperation(value="\u5220\u9664\u5957\u9910\u5206\u7c7b")
    public BaseResponse delCombinationType(@RequestParam Integer id) {
        return this.combinationTypeService.delCombinationType(id);
    }

    @ApiOperation(value="\u5957\u9910\u5217\u8868")
    @PostMapping(value={"/combination/list"})
    public BaseResponse<CombinationDTO> listCombination(@RequestBody CombinationVO vo) {
        CombinationDTO combinationDTO = this.combinationService.getCombinationList(vo);
        return BaseResponse.success((Object)combinationDTO);
    }

    @ApiOperation(value="\u5957\u9910\u62d6\u52a8\u6392\u5e8f")
    @PostMapping(value={"/combination/changeSort"})
    public BaseResponse<String> changeSort(@RequestBody ChangeSort vo) {
        BaseResponse response = this.combinationService.changeSortCombination(vo);
        return response;
    }

    @ApiOperation(value="\u6839\u636e\u9879\u76ee\u53cd\u67e5\u5957\u9910")
    @PostMapping(value={"/combination/search"})
    public BaseResponse<CombinationDTO> getCombinationByProjectId(@RequestBody CombinationVO vo) {
        CombinationDTO combinationDTO = this.combinationService.getCombinationByProjectId(vo);
        return BaseResponse.success((Object)combinationDTO);
    }

    @ApiOperation(value="\u5957\u9910\u5206\u7c7b\u5217\u8868")
    @GetMapping(value={"/type/list"})
    public BaseResponse<List<CombinationTypeDTO>> listCombinationType(@RequestParam String organId) {
        List list = this.combinationTypeService.typeList(organId);
        return BaseResponse.success((Object)list);
    }

    @ApiOperation(value="\u5957\u9910\u5206\u7c7b\u662f\u5426\u5c55\u793a\u5728\u9996\u9875\uff0c0\u4e0d\u5c55\u793a1\u5c55\u793a")
    @PostMapping(value={"/type/showindex"})
    public BaseResponse setShowIndex(@RequestBody CombinationTypeEntity combinationTypeEntity) {
        this.combinationTypeService.updateIsShowIndex(combinationTypeEntity);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u5957\u9910\u7684\u4fdd\u5b58\u6216\u8005\u66f4\u65b0")
    @PostMapping(value={"/combination/save"})
    public BaseResponse<CombinationEntity> saveOrUpdateCombination(@RequestBody @Validated CombinationEntity combinationEntity) {
        return this.combinationService.saveOrUpdateCombination(combinationEntity);
    }

    @ApiOperation(value="\u5957\u9910\u5220\u9664")
    @GetMapping(value={"/combination/del"})
    public BaseResponse delCombination(@RequestParam Integer id) {
        return this.combinationService.delCombination(id);
    }

    @ApiOperation(value="\u5957\u9910\u4e0a\u67b6\u3001\u4e0b\u67b6")
    @PostMapping(value={"/combination/online"})
    public BaseResponse onlineStatusCombination(@RequestBody CombinationOnlineVO vo) {
        this.combinationService.onlineStatusCombination(vo);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u83b7\u5f97\u4f53\u68c0\u5957\u9910\u603b\u6570\u548c\u603b\u91d1\u989d")
    @PostMapping(value={"/combination/count"})
    public BaseResponse<CombinationCountDTO> getCountData() {
        CombinationCountDTO combinationCountDTO = this.combinationTypeService.getCountData();
        return BaseResponse.success((Object)combinationCountDTO);
    }

    @ApiOperation(value="\u5411\u5957\u9910\u4e2d\u6dfb\u52a0\u9879\u76ee")
    @PostMapping(value={"/combination/project"})
    public BaseResponse addProjectToCombination(@RequestBody CombinationProjectVO vo) {
        this.combinationService.addProjectToCombination(vo);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u5957\u9910\u8be6\u60c5")
    @PostMapping(value={"/combination/details"})
    public BaseResponse<CombinationDetailsDTO> getCombinationDetails(@RequestBody CombinationEntity combination) {
        CombinationDetailsDTO details = this.combinationService.getCombinationDetails(combination);
        return BaseResponse.success((Object)details);
    }

    @ApiOperation(value="\u4fee\u6539\u8ba2\u5355\u901a\u7528\u63a5\u53e3")
    @GetMapping(value={"/combination/updateOrderStatusById"})
    BaseResponse<String> updateOrderStatusById(@RequestParam(value="id") String id, @RequestParam(value="status") String status) {
        try {
            return this.combinationTypeService.updateOrderStatusById(id, status);
        }
        catch (Exception e) {
            log.error("updateOrderStatusById\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
            return BaseResponse.error((String)e.toString());
        }
    }
}

