/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.physical.entity.ProjectItemEntity;
import com.ebaiyihui.physical.entity.ProjectTypeEntity;
import com.ebaiyihui.physical.service.ProjectItemService;
import com.ebaiyihui.physical.service.ProjectTypeService;
import com.ebaiyihui.physical.vo.ProjectItemVO;
import com.ebaiyihui.physical.vo.ProjectQueryListVO;
import com.ebaiyihui.physical.vo.ProjectTypeVO;
import com.ebaiyihui.physical.vo.SaveProjectItemVO;
import com.ebaiyihui.physical.vo.SetBaseProjectVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/project"})
@Api(tags={"\u9879\u76ee\u7ba1\u7406"})
public class ProjectManagerController {
    @Autowired
    ProjectTypeService projectTypeService;
    @Autowired
    ProjectItemService projectItemService;

    @PostMapping(value={"/type/save"})
    @ApiOperation(value="\u9879\u76ee\u5206\u7c7b\u4fdd\u5b58\u6216\u66f4\u65b0\u63a5\u53e3")
    public BaseResponse save(@RequestBody @Validated ProjectTypeEntity projectTypeEntity) {
        return BaseResponse.success((Object)this.projectTypeService.saveProjectType(projectTypeEntity));
    }

    @GetMapping(value={"/type/del"})
    @ApiOperation(value="\u9879\u76ee\u5206\u7c7b\u5220\u9664")
    public BaseResponse del(@RequestParam Integer id) {
        return this.projectTypeService.delProjectType(id);
    }

    @GetMapping(value={"/type/list"})
    @ApiOperation(value="\u9879\u76ee\u5206\u7c7b\u5217\u8868\u67e5\u8be2")
    public BaseResponse<List<ProjectTypeVO>> queryProjectTypeList(@RequestParam String organId) {
        return BaseResponse.success((Object)this.projectTypeService.queryProjectTypeList(organId));
    }

    @PostMapping(value={"/item/save"})
    @ApiOperation(value="\u9879\u76ee\u4fdd\u5b58\u6216\u66f4\u65b0\u63a5\u53e3")
    public BaseResponse save(@RequestBody SaveProjectItemVO saveProjectItemVO) {
        return BaseResponse.success((Object)this.projectItemService.saveProject(saveProjectItemVO));
    }

    @PostMapping(value={"/item/del"})
    @ApiOperation(value="\u9879\u76ee\u5220\u9664")
    public BaseResponse del(@RequestBody List<ProjectItemEntity> projectItemList) {
        return this.projectItemService.delProject(projectItemList);
    }

    @PostMapping(value={"/item/list"})
    @ApiOperation(value="\u9879\u76ee\u5217\u8868\u67e5\u8be2")
    public BaseResponse<List<ProjectItemVO>> queryProjectItemList(@RequestBody ProjectQueryListVO projectQueryListVO) {
        return BaseResponse.success((Object)this.projectItemService.queryProjectItemList(projectQueryListVO));
    }

    @PostMapping(value={"/item/details"})
    @ApiOperation(value="\u9879\u76ee\u8be6\u60c5\u67e5\u8be2")
    public BaseResponse<ProjectItemVO> getProjectItemDetails(@RequestBody ProjectItemEntity projectItemEntity) {
        return BaseResponse.success((Object)this.projectItemService.getProjectItemDetails(projectItemEntity));
    }

    @PostMapping(value={"/item/setBase"})
    @ApiOperation(value="\u8bbe\u7f6e\u57fa\u7840\u4f53\u68c0\u9879")
    public BaseResponse setBaseProject(@RequestBody SetBaseProjectVO setBaseProjectVO) {
        return this.projectItemService.setBaseProject(setBaseProjectVO);
    }
}

