/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.physical.enums.ChannelEnum;
import com.ebaiyihui.physical.service.MedicalReportService;
import com.ebaiyihui.physical.utils.GateWayCommonUtil;
import com.ebaiyihui.physical.vo.base.GatewayRequest;
import com.ebaiyihui.physical.vo.base.GatewayResponse;
import com.ebaiyihui.physical.vo.report.MedicalReportDetailReq;
import com.ebaiyihui.physical.vo.report.MedicalReportDetailVo;
import com.ebaiyihui.physical.vo.report.MedicalReportListReq;
import com.ebaiyihui.physical.vo.report.MedicalReportListVo;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MedicalReportServiceImpl
implements MedicalReportService {
    private static final Logger log = LoggerFactory.getLogger(MedicalReportServiceImpl.class);
    private static final String ORGAN_CODE = "NDEFYY";
    private static final String URL = "http://58.17.24.253:9098/card/";

    public BaseResponse<List<MedicalReportListVo>> getMedicalReportList(String cardNo, String idNo) {
        GatewayRequest gatewayReq = new GatewayRequest();
        MedicalReportListReq medicalReportListReq = new MedicalReportListReq();
        medicalReportListReq.setCardNo(cardNo);
        medicalReportListReq.setIdNo(idNo);
        gatewayReq.setBody((Object)medicalReportListReq);
        gatewayReq.setChannelName(ChannelEnum.USER_APPLETS.getValue());
        gatewayReq.setChannel(ChannelEnum.USER_APPLETS.getValue());
        gatewayReq.setOrganCode(ORGAN_CODE);
        gatewayReq.setTransactionId("");
        String hisUrl = "http://58.17.24.253:9098/card/getMedicalReportList";
        log.info("\u4f20\u5165\u53c2\u6570GatewayRequest<MedicalReportListReq>:{},URL:{}", (Object)gatewayReq, (Object)hisUrl);
        GatewayResponse response = new GateWayCommonUtil().requestHis("", gatewayReq.getOrganCode(), "getMedicalReportList", gatewayReq, hisUrl);
        log.info("\u76f8\u5e94\u53c2\u6570GatewayResponse<Object>:{}}", (Object)response);
        if (response == null) {
            log.error("\u4f53\u68c0\u62a5\u544a\u5217\u8868\u67e5\u8be2 getMedicalReportList -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return BaseResponse.error((String)"his\u8bf7\u6c42\u65e0\u54cd\u5e94");
        }
        if (!"1".equals(response.getCode())) {
            log.error("\u4f53\u68c0\u62a5\u544a\u5217\u8868\u67e5\u8be2 getMedicalReportList -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)response.getErrCode(), (Object)response.getMsg());
            return BaseResponse.error((String)response.getMsg());
        }
        if (response.getData() == null) {
            log.error("\u4f53\u68c0\u62a5\u544a\u5217\u8868\u67e5\u8be2 getMedicalReportList -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return BaseResponse.error((String)"his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
        }
        List medicalReportListVos = JSON.parseArray((String)JSON.toJSONString((Object)response.getData()), MedicalReportListVo.class);
        if (CollectionUtils.isEmpty((Collection)medicalReportListVos)) {
            return BaseResponse.error((String)"Json\u8f6c\u6362\u5f02\u5e38");
        }
        return BaseResponse.success((Object)medicalReportListVos);
    }

    public BaseResponse<MedicalReportDetailVo> getMedicalReportDetail(String clinicCode, String admLoc) {
        GatewayRequest gatewayReq = new GatewayRequest();
        MedicalReportDetailReq medicalReportDetailReq = new MedicalReportDetailReq();
        medicalReportDetailReq.setClinicCode(clinicCode);
        medicalReportDetailReq.setAdmLoc(admLoc);
        gatewayReq.setBody((Object)medicalReportDetailReq);
        gatewayReq.setChannelName(ChannelEnum.USER_APPLETS.getValue());
        gatewayReq.setChannel(ChannelEnum.USER_APPLETS.getValue());
        gatewayReq.setOrganCode(ORGAN_CODE);
        gatewayReq.setTransactionId("");
        String hisUrl = "http://58.17.24.253:9098/card/getMedicalReportDetail";
        log.info("\u4f20\u5165\u53c2\u6570GatewayRequest<MedicalReportDetailReq>:{},hisUrl:{}", (Object)gatewayReq, (Object)hisUrl);
        GatewayResponse response = new GateWayCommonUtil().requestHis("", gatewayReq.getOrganCode(), "getMedicalReportDetail", gatewayReq, hisUrl);
        log.info("\u76f8\u5e94\u53c2\u6570GatewayResponse<Object>:{}}", (Object)response);
        if (response == null) {
            log.error("\u67e5\u8be2\u4f53\u68c0\u62a5\u544a\u8be6\u60c5 getMedicalReportDetail -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return BaseResponse.error((String)"his\u8bf7\u6c42\u65e0\u54cd\u5e94");
        }
        if (!"1".equals(response.getCode())) {
            log.error("\u67e5\u8be2\u4f53\u68c0\u62a5\u544a\u8be6\u60c5 getMedicalReportDetail -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)response.getErrCode(), (Object)response.getMsg());
            return BaseResponse.error((String)response.getMsg());
        }
        if (response.getData() == null) {
            log.error("\u67e5\u8be2\u4f53\u68c0\u62a5\u544a\u8be6\u60c5 getMedicalReportDetail -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return BaseResponse.error((String)"his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
        }
        MedicalReportDetailVo medicalReportDetailVo = (MedicalReportDetailVo)JSON.parseObject((String)JSON.toJSONString((Object)response.getData()), MedicalReportDetailVo.class);
        if (null == medicalReportDetailVo) {
            return BaseResponse.error((String)"Json\u8f6c\u6362\u5f02\u5e38");
        }
        return BaseResponse.success((Object)medicalReportDetailVo);
    }
}

