/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpKit;
import com.ebaiyihui.framework.utils.IPUtils;
import com.ebaiyihui.framework.utils.StringUtil;
import com.ebaiyihui.physical.config.NodeConfig;
import com.ebaiyihui.physical.constant.DateConstant;
import com.ebaiyihui.physical.dto.AuditDetailDTO;
import com.ebaiyihui.physical.dto.AuditListDTO;
import com.ebaiyihui.physical.dto.OrderCountDTO;
import com.ebaiyihui.physical.dto.OrderDetailDTO;
import com.ebaiyihui.physical.dto.OrderListDTO;
import com.ebaiyihui.physical.dto.pay.BaseOperationDTO;
import com.ebaiyihui.physical.dto.pay.MerchantDTO;
import com.ebaiyihui.physical.dto.pay.PartRefundDTO;
import com.ebaiyihui.physical.entity.CombinationEntity;
import com.ebaiyihui.physical.entity.DictionaryEntity;
import com.ebaiyihui.physical.entity.OrderEntity;
import com.ebaiyihui.physical.entity.OrderItemEntity;
import com.ebaiyihui.physical.entity.OrderQuestionEntity;
import com.ebaiyihui.physical.entity.ScheduleRecordEntity;
import com.ebaiyihui.physical.enums.OrderStatusEnum;
import com.ebaiyihui.physical.enums.PayCodeEnum;
import com.ebaiyihui.physical.enums.PayStatusEnum;
import com.ebaiyihui.physical.enums.PayTypeEnum;
import com.ebaiyihui.physical.enums.RefundStatusEnum;
import com.ebaiyihui.physical.enums.ReturnCodeEnum;
import com.ebaiyihui.physical.exception.BusinessException;
import com.ebaiyihui.physical.mapper.CombinationMapper;
import com.ebaiyihui.physical.mapper.CombinationProjectMapper;
import com.ebaiyihui.physical.mapper.CombinationTypeMapper;
import com.ebaiyihui.physical.mapper.DictionaryMapper;
import com.ebaiyihui.physical.mapper.OrderItemMapper;
import com.ebaiyihui.physical.mapper.OrderMapper;
import com.ebaiyihui.physical.mapper.OrderQuestionMapper;
import com.ebaiyihui.physical.mapper.ProjectItemMapper;
import com.ebaiyihui.physical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.physical.service.OrderService;
import com.ebaiyihui.physical.service.client.IMPushMsgFeignClient;
import com.ebaiyihui.physical.utils.DateUtils;
import com.ebaiyihui.physical.utils.ExcelUtils;
import com.ebaiyihui.physical.utils.GenSeqUtils;
import com.ebaiyihui.physical.utils.HttpUtils;
import com.ebaiyihui.physical.utils.IpUtil;
import com.ebaiyihui.physical.utils.PageUtils;
import com.ebaiyihui.physical.utils.RabbitMqUtils;
import com.ebaiyihui.physical.utils.RedisUtil;
import com.ebaiyihui.physical.utils.SignUtil;
import com.ebaiyihui.physical.vo.ApplyVO;
import com.ebaiyihui.physical.vo.CheckCodeVO;
import com.ebaiyihui.physical.vo.CreateOrderVO;
import com.ebaiyihui.physical.vo.DelayMqEntity;
import com.ebaiyihui.physical.vo.OrderExportExcel;
import com.ebaiyihui.physical.vo.OrderListVO;
import com.ebaiyihui.physical.vo.SubmitVO;
import com.ebaiyihui.physical.vo.pay.ApplyRefundVO;
import com.ebaiyihui.physical.vo.pay.PayNotifyReqVO;
import com.ebaiyihui.physical.vo.pay.PayOrderReqVo;
import com.ebaiyihui.physical.vo.pay.PayVO;
import com.ebaiyihui.physical.vo.pay.PaymentCdfyResVo;
import com.ebaiyihui.physical.vo.pay.RefundCallBackReqVO;
import com.ebaiyihui.physical.vo.pay.RefundCdfyResVo;
import com.ebaiyihui.physical.vo.pay.RefundOrderReqVo;
import com.ebaiyihui.physical.vo.question.SaveQuestionVO;
import com.ebaiyihui.physical.vo.question.StoreItemVO;
import com.ebaiyihui.physical.vo.req.OrderTaskVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class OrderServiceImpl
extends ServiceImpl<OrderMapper, OrderEntity>
implements OrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Autowired
    private RabbitMqUtils orderSender;
    @Autowired
    CombinationMapper combinationMapper;
    @Autowired
    ProjectItemMapper projectItemMapper;
    @Autowired
    OrderItemMapper orderItemMapper;
    @Autowired
    OrderQuestionMapper questionMapper;
    @Autowired
    NodeConfig nodeConfig;
    @Autowired
    DictionaryMapper dictionaryMapper;
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    StringRedisTemplate redisTemplate;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    OrderQuestionMapper orderQuestionMapper;
    @Autowired
    ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    ThreadPoolExecutor executor;
    @Autowired
    IMPushMsgFeignClient imPushMsgFeignClient;
    @Autowired
    CombinationProjectMapper combinationProjectMapper;
    @Autowired
    CombinationTypeMapper combinationTypeMapper;

    public OrderEntity createOrder(CreateOrderVO vo) {
        log.info("\u521b\u5efa\u8ba2\u5355\u5165\u53c2, {}", (Object)JSON.toJSONString((Object)vo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (StrUtil.isNotBlank((CharSequence)vo.getCombinationId()) && null != vo.getPayAmount()) {
            CombinationEntity combinationEntity = (CombinationEntity)this.combinationMapper.selectById((Serializable)((Object)vo.getCombinationId()));
            log.info("\u67e5\u8be2\u51fa\u7684\u5957\u9910\u4fe1\u606f===\u300b:{}", (Object)JSONObject.toJSONString((Object)combinationEntity));
            if (combinationEntity != null) {
                BigDecimal salePrice = combinationEntity.getSalePrice();
                if (salePrice.compareTo(vo.getPayAmount()) != 0) {
                    throw new BusinessException("\u652f\u4ed8\u91d1\u989d\u4e0e\u5957\u9910\u91d1\u989d\u4e0d\u4e00\u81f4");
                }
            } else {
                throw new BusinessException("\u5957\u9910\u4e0d\u5b58\u5728");
            }
        }
        OrderEntity orderEntity = new OrderEntity();
        List organ = this.dictionaryMapper.getAllOrgan();
        vo.setOrganName(((MerchantDTO)organ.get(0)).getOrganName());
        BeanUtils.copyProperties((Object)vo, (Object)orderEntity);
        orderEntity.setIsInvoice(vo.getIsInvoice());
        if (!StrUtil.isNotBlank((CharSequence)vo.getCombinationId())) {
            orderEntity.setId(vo.getId());
        } else {
            String uniqueNo = GenSeqUtils.getUniqueNo();
            orderEntity.setId(uniqueNo);
        }
        if (Objects.equals(vo.getAuditFlag(), 1)) {
            orderEntity.setOrderStatus(OrderStatusEnum.WAIT_AUDIT.getCode());
        } else if (this.judgeOrderZero(orderEntity.getPayAmount())) {
            orderEntity.setOrderStatus(OrderStatusEnum.WAIT_USING.getCode());
            orderEntity.setVerificCode(GenSeqUtils.getCheckCode());
        } else {
            orderEntity.setOrderStatus(OrderStatusEnum.WAIT_PAY.getCode());
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getCombinationId())) {
            orderEntity.setCombinationId(Integer.valueOf(vo.getCombinationId()));
            List itemEntityList = this.projectItemMapper.getItemByCombinationId(Integer.valueOf(vo.getCombinationId()));
            List baseItem = this.projectItemMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"base", (Object)1));
            itemEntityList.addAll(baseItem);
            List itemEntities = itemEntityList.stream().map(item -> {
                OrderItemEntity orderItem = new OrderItemEntity();
                BeanUtils.copyProperties((Object)item, (Object)orderItem);
                orderItem.setOrderId(orderEntity.getId());
                orderItem.setProjectId(item.getId());
                return orderItem;
            }).collect(Collectors.toList());
            log.info("itemEntities", (Object)JSONObject.toJSONString(itemEntities));
            this.orderItemMapper.batchInsertItem(itemEntities);
        } else {
            orderEntity.setCombinationName("\u5b9a\u5236\u5316\u4f53\u68c0\u5957\u9910");
            List orderQuestion = this.getOrderQuestion(vo, orderEntity.getId());
            List itemList = this.getItemList(vo, orderEntity.getId());
            log.info("orderQuestion->{}", (Object)JSON.toJSONString((Object)orderQuestion, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            this.orderQuestionMapper.batchInsertOrderQuestion(orderQuestion);
            this.redisUtil.del(new String[]{vo.getUserId() + vo.getCredNo() + vo.getPatientName() + "PHYSICAL_QUESTION"});
            log.info("itemList->{}", (Object)JSON.toJSONString((Object)itemList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            this.orderItemMapper.batchInsertItem(itemList);
            this.redisUtil.del(new String[]{vo.getUserId() + vo.getCredNo() + vo.getPatientName() + "PHYSICAL_PROJECT_ITEM"});
        }
        this.save((Object)orderEntity);
        OrderTaskVo orderTaskVo1 = new OrderTaskVo();
        orderTaskVo1.setType(Integer.valueOf(2));
        orderTaskVo1.setId(orderEntity.getId());
        this.orderSender.sendDelay(orderTaskVo1);
        log.info("\u521b\u5efa\u8ba2\u5355\u8fd4\u56de, {}", (Object)orderEntity);
        return orderEntity;
    }

    public List<OrderItemEntity> getItemList(CreateOrderVO vo, String orderId) {
        Object items = this.redisUtil.get(vo.getUserId() + vo.getId() + vo.getPatientName() + "PHYSICAL_PROJECT_ITEM");
        JSONArray itemJsonArray = JSON.parseArray((String)JSON.toJSONString((Object)JSON.parse((String)items.toString())));
        return itemJsonArray.stream().map(item -> {
            StoreItemVO.Item projectItem = (StoreItemVO.Item)JSON.parseObject((String)item.toString(), StoreItemVO.Item.class);
            OrderItemEntity itemEntity = new OrderItemEntity();
            BeanUtils.copyProperties((Object)projectItem, (Object)itemEntity);
            itemEntity.setOrderId(orderId);
            return itemEntity;
        }).collect(Collectors.toList());
    }

    public List<OrderQuestionEntity> getOrderQuestion(CreateOrderVO vo, String orderId) {
        Object questions = this.redisUtil.get(vo.getUserId() + vo.getId() + vo.getPatientName() + "PHYSICAL_QUESTION");
        JSONArray questionJsonArray = JSON.parseArray((String)JSON.toJSONString((Object)JSON.parse((String)questions.toString())));
        return questionJsonArray.stream().map(item -> {
            SaveQuestionVO.Question question = (SaveQuestionVO.Question)JSON.parseObject((String)item.toString(), SaveQuestionVO.Question.class);
            OrderQuestionEntity orderQuestion = new OrderQuestionEntity();
            BeanUtils.copyProperties((Object)question, (Object)orderQuestion);
            orderQuestion.setOrderId(orderId);
            orderQuestion.setOrganId(vo.getOrganId());
            orderQuestion.setUserId(vo.getUserId());
            return orderQuestion;
        }).collect(Collectors.toList());
    }

    private boolean judgeOrderZero(BigDecimal payAmount) {
        BigDecimal zero = new BigDecimal("0");
        return Objects.equals(zero.compareTo(payAmount), 0);
    }

    @Transactional(rollbackFor={Exception.class})
    public OrderEntity auditOrder(OrderEntity orderEntity) {
        log.info("\u5ba1\u6838\u8ba2\u5355\u5165\u53c2, {}", (Object)orderEntity);
        OrderEntity order = (OrderEntity)this.getById((Serializable)((Object)orderEntity.getId()));
        if (Objects.equals(order.getOrderStatus(), OrderStatusEnum.WAIT_AUDIT.getCode())) {
            Date date = new Date();
            order.setAuditTime(date);
            order.setAuditOpinion(orderEntity.getAuditOpinion());
            order.setAuditUser(orderEntity.getAuditUser());
            order.setOrderStatus(OrderStatusEnum.WAIT_SUBMIT_PAY.getCode());
            Date orderLoseTime = OrderServiceImpl.calculateOrderLoseTime((Date)date, (int)DateConstant.TWENTY_FOUR_HOURS);
            order.setLoseTime(orderLoseTime);
            DelayMqEntity delayMqEntity = new DelayMqEntity();
            delayMqEntity.setOrderId(orderEntity.getId());
            delayMqEntity.setType("1");
            RabbitMqUtils.delayedUpdateOrderStatus((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)delayMqEntity), (Integer)DateConstant.TWENTY_FOUR_HOURS);
            log.info("\u5ba1\u6838\u8ba2\u5355\u8fd4\u56de,{}", (Object)order);
            this.updateById((Object)order);
        }
        if (Objects.isNull(order.getCombinationId())) {
            this.appendExpireTime(order.getUserId(), order.getCredNo(), order.getPatientName());
        }
        return order;
    }

    private void appendExpireTime(String userId, String cardNo, String patientName) {
        StringBuffer patientKey = new StringBuffer();
        patientKey.append(userId).append(cardNo).append(patientName);
        this.redisUtil.expire(patientKey.append("PHYSICAL_QUESTION").toString(), (long)DateConstant.TWENTY_FOUR_HOURS);
        this.redisUtil.expire(patientKey.append("PHYSICAL_PROJECT_ITEM").toString(), (long)DateConstant.TWENTY_FOUR_HOURS);
    }

    private static Date calculateOrderLoseTime(Date date, int seconds) {
        SimpleDateFormat sdf = new SimpleDateFormat(DateConstant.THE_TIME_STAMP);
        long timestamp = date.getTime() / DateConstant.ONE_THOUSAND;
        long finalTimestamp = timestamp + (long)seconds;
        Date time1 = new Date(finalTimestamp * DateConstant.ONE_THOUSAND);
        String s = sdf.format(time1);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DateConstant.DATE_AND_TIME);
        Date parse = null;
        try {
            parse = dateFormat.parse(s);
        }
        catch (Exception e) {
            log.error("\u8ba1\u7b97\u8ba2\u5355\u5931\u6548\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
        }
        return parse;
    }

    public OrderListDTO orderPage(OrderListVO vo) {
        OrderListDTO dto = new OrderListDTO();
        log.info("\u67e5\u8be2\u8ba2\u5355\u5165\u53c2, {}", (Object)vo);
        int index = PageUtils.getBeginPage((Integer)vo.getCurrPage(), (Integer)vo.getPageSize());
        vo.setIndex(Integer.valueOf(index));
        List list = null;
        list = ((OrderMapper)this.baseMapper).orderPageInfo(vo);
        for (OrderEntity order : list) {
            if (null == order.getPayAmount() || this.judgeOrderZero(order.getPayAmount())) {
                order.setZeroFlag(Integer.valueOf(0));
            } else {
                order.setZeroFlag(Integer.valueOf(1));
            }
            if (null != order.getRefundAmount()) {
                order.setRelAmount(order.getPayAmount().subtract(order.getRefundAmount()));
                continue;
            }
            order.setRelAmount(order.getPayAmount());
        }
        Integer count = ((OrderMapper)this.baseMapper).getOrderNum(vo);
        list = this.addAddress(list);
        PageUtils page = new PageUtils(list, count.intValue(), vo.getPageSize().intValue(), vo.getCurrPage().intValue());
        OrderCountDTO orderCount = ((OrderMapper)this.baseMapper).getOrderCount(vo);
        dto.setOrderCount(orderCount.getOrderCount());
        dto.setCompleteOrderCount(orderCount.getCompleteOrderCount());
        dto.setActualPayAmount(orderCount.getActualPayAmount());
        dto.setOrderPage(page);
        log.info("\u67e5\u8be2\u8ba2\u5355\u8fd4\u56de, {}", (Object)dto);
        return dto;
    }

    public AuditListDTO auditOrderList(OrderListVO vo) {
        log.info("\u67e5\u8be2\u5ba1\u6838\u8ba2\u5355\u5165\u53c2, {}", (Object)vo);
        AuditListDTO dto = new AuditListDTO();
        int index = PageUtils.getBeginPage((Integer)vo.getCurrPage(), (Integer)vo.getPageSize());
        vo.setIndex(Integer.valueOf(index));
        List list = ((OrderMapper)this.baseMapper).auditOrderList(vo);
        Collections.sort(list);
        list.stream().forEach(item -> {
            if (!Objects.equals(item.getOrderStatus(), OrderStatusEnum.WAIT_AUDIT.getCode())) {
                item.setOrderStatus(OrderStatusEnum.WAIT_SUBMIT_PAY.getCode());
            }
        });
        Integer generalCount = ((OrderMapper)this.baseMapper).getAuditOrderNum(vo);
        Integer customCount = ((OrderMapper)this.baseMapper).getCustomAuditOrder(vo);
        PageUtils page = new PageUtils(list, generalCount + customCount, vo.getPageSize().intValue(), vo.getCurrPage().intValue());
        int auditCount = this.count((Wrapper)new QueryWrapper().eq((Object)"order_status", (Object)OrderStatusEnum.WAIT_AUDIT.getCode()));
        dto.setAuditCount(Integer.valueOf(auditCount));
        dto.setAuditOrderPage(page);
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(OrderStatusEnum.WAIT_AUDIT.getCode());
        statusList.add(OrderStatusEnum.WAIT_SUBMIT_PAY.getCode());
        int orderCount = this.count((Wrapper)new QueryWrapper().in((Object)"order_status", statusList));
        dto.setAuditOrderCount(Integer.valueOf(orderCount));
        log.info("\u67e5\u8be2\u8ba2\u5355\u8fd4\u56de, {}", (Object)page);
        return dto;
    }

    public PageUtils applyPage(ApplyVO vo) {
        log.info("\u7533\u8bf7\u5217\u8868\u5165\u53c2,{}", (Object)vo);
        int index = PageUtils.getBeginPage((Integer)vo.getCurrPage(), (Integer)vo.getPageSize());
        vo.setIndex(Integer.valueOf(index));
        List list = null;
        list = ((OrderMapper)this.baseMapper).selectApplyList(vo);
        list.stream().forEach(item -> item.setSalePrice(item.getPayAmount().toString()));
        list = this.addAddress(list);
        PageUtils page = new PageUtils(list, list.size(), vo.getPageSize().intValue(), vo.getCurrPage().intValue());
        log.info("\u7533\u8bf7\u5217\u8868\u8fd4\u56de,{}", (Object)page);
        return page;
    }

    private List<OrderEntity> addAddress(List<OrderEntity> list) {
        List dic = this.dictionaryMapper.getDicByCode("address");
        if (dic != null && dic.size() > 0) {
            String address = ((DictionaryEntity)dic.get(0)).getDicName();
            list.stream().forEach(item -> item.setAddress(address));
        }
        return list;
    }

    public AuditDetailDTO auditDetail(String orderId) {
        log.info("\u67e5\u8be2\u5ba1\u6838\u8be6\u60c5\u5165\u53c2, {}", (Object)orderId);
        AuditDetailDTO detailDTO = new AuditDetailDTO();
        OrderEntity orderEntity = (OrderEntity)this.getById((Serializable)((Object)orderId));
        BeanUtils.copyProperties((Object)orderEntity, (Object)detailDTO);
        CombinationEntity combination = this.combinationMapper.getCombinationExStatus(orderEntity.getCombinationId());
        if (Objects.nonNull(orderEntity.getCombinationId())) {
            detailDTO.setAuditFlag(combination.getAuditFlag());
        }
        String submitTime = DateUtils.dateToFullString((Date)orderEntity.getCreateTime());
        detailDTO.setSubmitTime(submitTime);
        List orderItemList = this.orderItemMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(OrderItemEntity::getOrderId, (Object)orderEntity.getId()));
        detailDTO.setOrderItemEntities(orderItemList);
        detailDTO.setProjectCount(Integer.valueOf(orderItemList.size()));
        log.info("\u67e5\u8be2\u5ba1\u6838\u8be6\u60c5\u8fd4\u56de, {}", (Object)detailDTO);
        return detailDTO;
    }

    public List<OrderQuestionEntity> getUserQuestionnaire(Integer organId) {
        return this.questionMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"order_id", (Object)organId));
    }

    public BaseResponse verification(CheckCodeVO vo) {
        log.info("\u8ba2\u5355\u6821\u9a8c\u5165\u53c2,{}", (Object)vo);
        StringBuffer sb = new StringBuffer();
        String key = sb.append("BYH-PHYSICAL").append(vo.getOrderId()).toString();
        Object lock = this.redisUtil.get(key);
        if (!Objects.isNull(lock)) {
            return BaseResponse.error((String)"\u8be5\u8ba2\u5355\u6b63\u5728\u8fdb\u884c\u9000\u6b3e\uff0c\u65e0\u6cd5\u6838\u9500");
        }
        this.redisUtil.setNx(key, UUID.randomUUID().toString(), 3L);
        if (StringUtils.isNotEmpty((String)vo.getVerificCode())) {
            OrderEntity orderEntity = (OrderEntity)this.getOne((Wrapper)new QueryWrapper().eq((Object)"id", (Object)vo.getOrderId()));
            if (Objects.equals(orderEntity.getOrderStatus(), OrderStatusEnum.WAIT_USING.getCode()) || Objects.equals(orderEntity.getOrderStatus(), OrderStatusEnum.PARTIAL_REFUND.getCode())) {
                orderEntity.setOrderStatus(OrderStatusEnum.DONE.getCode());
                orderEntity.setVerificUser(vo.getVerificUser());
                orderEntity.setVerificTime(new Date());
                this.updateById((Object)orderEntity);
                return BaseResponse.success((Object)"\u8ba2\u5355\u5df2\u5b8c\u6210\u6838\u9500");
            }
            return BaseResponse.error((String)"\u8ba2\u5355\u6838\u9500\u5931\u8d25");
        }
        return null;
    }

    public OrderDetailDTO orderDetail(String orderId) {
        log.info("\u8ba2\u5355ID,{}", (Object)orderId);
        OrderDetailDTO dto = new OrderDetailDTO();
        OrderEntity order = ((OrderMapper)this.baseMapper).getOrderByOrderId(orderId);
        List items = this.orderItemMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"order_id", (Object)orderId));
        for (OrderItemEntity orderItemEntity : items) {
            String baseProject = this.projectItemMapper.getBaseProject(orderItemEntity.getProjectId());
            orderItemEntity.setBase(baseProject);
        }
        List dic = this.dictionaryMapper.getDicByCode("address");
        CombinationEntity combination = this.combinationMapper.getCombinationExStatus(order.getCombinationId());
        if (null == order.getPayAmount() || this.judgeOrderZero(order.getPayAmount())) {
            order.setZeroFlag(Integer.valueOf(0));
        } else {
            order.setZeroFlag(Integer.valueOf(1));
        }
        if (order.getRefundAmount() != null) {
            order.setRefundAmount(order.getRefundAmount());
        } else {
            order.setRefundAmount(order.getPayAmount());
        }
        order.setSalePrice(order.getPayAmount().toString());
        dto.setItems(items);
        dto.setOrderEntity(order);
        if (Objects.nonNull(order.getCombinationId())) {
            dto.getOrderEntity().setAuditFlag(combination.getAuditFlag());
            dto.getOrderEntity().setCoverImgUrl(combination.getCoverImgUrl());
        } else {
            dto.getOrderEntity().setAuditFlag(order.getAuditFlag());
        }
        dto.getOrderEntity().setItemCount(Integer.valueOf(items.size()));
        dto.getOrderEntity().setAddress(((DictionaryEntity)dic.get(0)).getDicName());
        if (Objects.nonNull(order.getAppointmentDate())) {
            SimpleDateFormat sbf = new SimpleDateFormat("yyyy-MM-dd");
            String format = sbf.format(order.getAppointmentDate());
            StringBuilder sb = new StringBuilder();
            String appointment = sb.append(format).append(" ").append(order.getAppointmentTime()).toString();
            dto.getOrderEntity().setAppointment(appointment);
        }
        log.info("\u8ba2\u5355\u8be6\u60c5\u8fd4\u56de,{}", (Object)dto);
        return dto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional(rollbackFor={Exception.class})
    public BaseResponse submit(SubmitVO vo) throws ParseException {
        log.info("\u63d0\u4ea4\u8ba2\u5355\u5165\u53c2:{}", (Object)vo);
        try {
            ScheduleRecordEntity scheduleRecordEntity = (ScheduleRecordEntity)this.scheduleRecordMapper.selectById((Serializable)vo.getScheduleRecordId());
            if (scheduleRecordEntity.getAvailableCount() <= 0) return BaseResponse.error((String)"\u4f59\u53f7\u4e0d\u8db3,\u8bf7\u91cd\u65b0\u9009\u62e9\u53f7\u6e90");
            String key = "BYH-PHYSICAL" + vo.getScheduleRecordId();
            try {
                if (!StringUtil.isEmpty((String)((String)this.redisTemplate.opsForValue().get((Object)key)))) {
                    BaseResponse baseResponse = BaseResponse.error((String)"\u5f53\u524d\u53f7\u6e90\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u53f7\u6e90");
                    return baseResponse;
                }
                this.redisTemplate.opsForValue().set((Object)key, (Object)UUID.randomUUID().toString(), 5L, TimeUnit.SECONDS);
                this.scheduleRecordMapper.useSchedule(vo.getScheduleRecordId());
            }
            catch (Exception e) {
                log.error("\u9501\u5b9a\u53f7\u6e90\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.redisTemplate.delete((Object)key);
            }
            OrderEntity order = (OrderEntity)this.getById((Serializable)((Object)vo.getOrderId()));
            order.setScheduleRecordId(vo.getScheduleRecordId());
            order.setAppointmentDate(DateUtils.strToDate((String)vo.getAppointmentDate(), (String)"yyyy-MM-dd"));
            order.setAppointmentTime(vo.getAppointmentTime());
            if (!this.judgeOrderZero(order.getPayAmount())) {
                order.setOrderStatus(OrderStatusEnum.WAIT_PAY.getCode());
                Date orderLoseTime = null;
                if (Objects.nonNull(order.getCombinationId())) {
                    orderLoseTime = OrderServiceImpl.calculateOrderLoseTime((Date)new Date(), (int)DateConstant.THIRTY_MINUTES);
                    DelayMqEntity delayMqEntity = new DelayMqEntity();
                    delayMqEntity.setOrderId(order.getId());
                    delayMqEntity.setType("1");
                    RabbitMqUtils.delayedUpdateOrderStatus((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)delayMqEntity), (Integer)DateConstant.THIRTY_MINUTES);
                } else {
                    orderLoseTime = OrderServiceImpl.calculateOrderLoseTime((Date)new Date(), (int)DateConstant.THIRTY_MINUTES);
                    DelayMqEntity delayMqEntity = new DelayMqEntity();
                    delayMqEntity.setOrderId(order.getId());
                    delayMqEntity.setType("1");
                    RabbitMqUtils.delayedUpdateOrderStatus((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)delayMqEntity), (Integer)DateConstant.THIRTY_MINUTES);
                }
                order.setLoseTime(orderLoseTime);
            } else {
                order.setOrderStatus(OrderStatusEnum.WAIT_USING.getCode());
                order.setVerificCode(GenSeqUtils.getCheckCode());
                CombinationEntity combination = (CombinationEntity)this.combinationMapper.selectById((Serializable)order.getCombinationId());
                if (Objects.nonNull(combination)) {
                    combination.setSaleCount(Integer.valueOf(combination.getSaleCount() + 1));
                    this.combinationMapper.updateById((Object)combination);
                }
            }
            this.updateById((Object)order);
            return BaseResponse.success();
        }
        catch (Exception e) {
            log.info("\u63d0\u4ea4\u8ba2\u5355\u5f02\u5e38{}", (Throwable)e);
            return BaseResponse.error((String)"\u63d0\u4ea4\u8ba2\u5355\u5f02\u5e38");
        }
    }

    public BaseResponse<JSONObject> pay(PayVO payVO, HttpServletRequest request) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (this.preventManyClick(requestAttributes)) {
            throw new BusinessException("\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
        }
        return this.createTrade(payVO, request);
    }

    public BaseResponse<String> judgeCombination(String combinationId) {
        CombinationEntity combination = (CombinationEntity)this.combinationMapper.selectById((Serializable)((Object)combinationId));
        if (Objects.isNull(combination) || !Objects.equals(combination.getOnlineStatus(), 1)) {
            return BaseResponse.error((String)"\u8be5\u5957\u9910\u5df2\u4e0b\u67b6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5957\u9910");
        }
        return BaseResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<JSONObject> createTrade(PayVO payVO, HttpServletRequest request) {
        OrderEntity order = ((OrderMapper)this.baseMapper).getOrderByOrderId(payVO.getOrderId());
        if (Objects.isNull(order)) {
            return BaseResponse.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        PayOrderReqVo payOrderReqVo = new PayOrderReqVo();
        payOrderReqVo.setDescription("\u4f53\u68c0\u9884\u7ea6\u652f\u4ed8");
        payOrderReqVo.setOrderId(payVO.getOrderId());
        payOrderReqVo.setTotalAmount(order.getPayAmount().toPlainString());
        payOrderReqVo.setSpbCreIp(IpUtil.getIpAddr((HttpServletRequest)request));
        payOrderReqVo.setUserId(payVO.getPayOrderDTO().getOpenId());
        payOrderReqVo.setAccount(order.getCardNo());
        payOrderReqVo.setPayType("WX_APPLET");
        return this.cdfyPay(payOrderReqVo);
    }

    private BaseResponse cdfyPay(PayOrderReqVo payOrderReqVo) {
        try {
            PaymentCdfyResVo paymentCdfyResVo = new PaymentCdfyResVo();
            String url = new StringBuffer(this.nodeConfig.getPayUrl()).append("/payment/paycall").toString();
            log.info("\u8bf7\u6c42his\u524d\u7f6e\u673a\u5165\u53c2 - > {} \u8bf7\u6c42\u5730\u5740 - >{}", (Object)JSON.toJSONString((Object)payOrderReqVo), (Object)url);
            String result = HttpUtil.post((String)url, (String)JSON.toJSONString((Object)payOrderReqVo));
            log.info("\u8c03\u7528his\u652f\u4ed8\u8fd4\u56deresult={}", (Object)result);
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            Integer code = jsonObject.getInteger("code");
            if (200 == code) {
                paymentCdfyResVo = (PaymentCdfyResVo)JSON.parseObject((String)result, PaymentCdfyResVo.class);
                String payStr = paymentCdfyResVo.getResult().getResult();
                String backResult = payStr.replace("package", "packageValue");
                JSONObject jsonObjectStr = JSON.parseObject((String)backResult);
                jsonObjectStr.put("outTradeNo", (Object)payOrderReqVo.getOrderId());
                jsonObjectStr.put("dealTradeNo", (Object)payOrderReqVo.getOrderId());
                return BaseResponse.success((Object)jsonObjectStr);
            }
            return BaseResponse.error((String)jsonObject.getString("msg"));
        }
        catch (Exception e) {
            log.error("payCreateOrder\u6302\u53f7\u652f\u4ed8\u53d1\u8d77\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            return BaseResponse.error((String)"\u8c03\u7528\u652f\u4ed8\u63a5\u53e3\u5931\u8d25");
        }
    }

    private BaseResponse<RefundCdfyResVo> cdfyRefund(RefundOrderReqVo refundOrderReqVo) {
        RefundCdfyResVo refundResVo = new RefundCdfyResVo();
        try {
            String url = new StringBuffer(this.nodeConfig.getPayUrl()).append("/payment/refund").toString();
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)refundOrderReqVo));
            log.info("\u8c03\u7528his\u652f\u4ed8\u8fd4\u56deresult={}", (Object)result);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)result)) {
                return BaseResponse.error((String)"\u8c03\u7528his\u652f\u4ed8\u5e73\u53f0\u9000\u6b3e\u63a5\u53e3\u5931\u8d25\uff01");
            }
            refundResVo = (RefundCdfyResVo)JSON.parseObject((String)result, RefundCdfyResVo.class);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528his\u652f\u4ed8\u5e73\u53f0\u9000\u6b3e\u63a5\u53e3\u5931\u8d25: {}", (Throwable)e);
            return BaseResponse.error((String)"\u8c03\u7528his\u652f\u4ed8\u5e73\u53f0\u9000\u6b3e\u63a5\u53e3\u5f02\u5e38\uff01");
        }
        if (Objects.isNull(refundResVo)) {
            return BaseResponse.error((String)"\u8c03\u7528his\u652f\u4ed8\u5e73\u53f0\u9000\u6b3e\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        if (!Objects.equals(refundResVo.getCode(), 200)) {
            return BaseResponse.error((String)"\u8c03\u7528his\u652f\u4ed8\u5e73\u53f0\u9000\u6b3e\u63a5\u53e3\u8fd4\u56de\u9519\u8bef\uff01");
        }
        return BaseResponse.success((Object)refundResVo);
    }

    private boolean preventManyClick(RequestAttributes requestAttributes) {
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        String ip = IPUtils.getIpAddress((HttpServletRequest)request);
        String servletPath = request.getServletPath();
        String credNo = request.getParameter("credNo");
        StringBuilder sb = new StringBuilder();
        String req = sb.append(ip).append(servletPath).append(credNo).toString();
        log.info("\u8bf7\u6c42IP\u548c\u8def\u5f84\u5730\u5740,{}", (Object)req);
        String lock = (String)this.redisTemplate.opsForValue().get((Object)req);
        if (StringUtils.isEmpty((String)lock)) {
            this.redisTemplate.opsForValue().set((Object)req, (Object)req, 5L, TimeUnit.SECONDS);
            return false;
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> orderNotify(PayNotifyReqVO payNotifyReqVO) {
        log.info("\u652f\u4ed8\u56de\u8c03\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)payNotifyReqVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        OrderEntity order = ((OrderMapper)this.baseMapper).getOrderByOrderId(payNotifyReqVO.getOutTradeNo());
        OrderTaskVo orderTaskVo1 = new OrderTaskVo();
        orderTaskVo1.setType(Integer.valueOf(1));
        orderTaskVo1.setId(order.getId());
        this.orderSender.sendDelay(orderTaskVo1);
        log.info("\u652f\u4ed8\u56de\u8c03\u5185\u8ba2\u5355\u5185\u5bb9\u4e3a->{}", (Object)JSON.toJSONString((Object)order, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (Objects.isNull(order.getVerificCode())) {
            order.setVerificCode(GenSeqUtils.getCheckCode());
        }
        if ("\u5b9a\u5236\u5316\u4f53\u68c0\u5957\u9910".equals(order.getCombinationName())) {
            this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (Objects.equals(order.getOrderStatus(), OrderStatusEnum.WAIT_SUBMIT_PAY.getCode()) || Objects.equals(order.getOrderStatus(), OrderStatusEnum.WAIT_PAY.getCode())) {
            order.setOrderStatus(OrderStatusEnum.WAIT_USING.getCode());
        }
        order.setBankTradeNo(payNotifyReqVO.getTradeNo());
        order.setPayTime(payNotifyReqVO.getPayTime());
        order.setDealSeq(payNotifyReqVO.getDealTradeNo());
        this.updateById((Object)order);
        CombinationEntity combination = (CombinationEntity)this.combinationMapper.selectById((Serializable)order.getCombinationId());
        if (Objects.nonNull(combination)) {
            combination.setSaleCount(Integer.valueOf(combination.getSaleCount() + 1));
            log.info("\u652f\u4ed8\u540e\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u8fd4\u56de:{}", (Object)order);
            this.combinationMapper.updateById((Object)combination);
        }
        log.info("\u652f\u4ed8\u56de\u8c03\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)payNotifyReqVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return BaseResponse.success((Object)"SUCCESS");
    }

    public BaseResponse<String> applyRefund(BaseOperationDTO baseOperationDto) {
        StringBuffer sb = new StringBuffer();
        String key = sb.append("BYH-PHYSICAL").append(baseOperationDto.getOrderId()).toString();
        Object lock = this.redisUtil.get(key);
        if (!Objects.isNull(lock)) {
            return BaseResponse.error((String)"\u8be5\u8ba2\u5355\u6b63\u5728\u6838\u9500\uff0c\u65e0\u6cd5\u8fdb\u884c\u9000\u6b3e");
        }
        this.redisUtil.setNx(key, UUID.randomUUID().toString(), 5L);
        OrderEntity orderEntity = (OrderEntity)this.getOne((Wrapper)new QueryWrapper().eq((Object)"id", (Object)baseOperationDto.getOrderId()));
        try {
            log.info("\u9000\u6b3e\u8ba2\u5355\u4fe1\u606f{}", (Object)orderEntity);
            if (Objects.isNull(orderEntity)) {
                return BaseResponse.error((String)"\u6b64\u8ba2\u5355\u4e0d\u5b58\u5728\u6216\u672a\u652f\u4ed8\u8be5\u8ba2\u5355");
            }
            if (this.judgeOrderZero(orderEntity.getPayAmount())) {
                return BaseResponse.error((String)"0\u5143\u8ba2\u5355\u4e0d\u652f\u6301\u9000\u6b3e");
            }
            if (Objects.equals(baseOperationDto.getRefundFlag(), RefundStatusEnum.ADMIN_REFUND.getCode())) {
                orderEntity.setRefundFlag(Integer.valueOf(RefundStatusEnum.ADMIN_REFUND.getCode()));
                orderEntity.setRefundUser(baseOperationDto.getOprationUser());
                orderEntity.setOrderStatus(OrderStatusEnum.REFUND.getCode());
                orderEntity.setRefundRemarks(baseOperationDto.getRefundRemarks());
            } else {
                if (Objects.equals(orderEntity.getOrderStatus(), OrderStatusEnum.DONE.getCode())) {
                    return BaseResponse.error((String)"\u8be5\u8ba2\u5355\u5df2\u6838\u9500\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u9000\u6b3e");
                }
                orderEntity.setRefundFlag(Integer.valueOf(RefundStatusEnum.ACCOUNT_REFUND.getCode()));
                orderEntity.setRefundUser(orderEntity.getPatientName());
                orderEntity.setOrderStatus(OrderStatusEnum.REFUND.getCode());
                orderEntity.setRefundRemarks("\u7528\u6237\u4e3b\u52a8\u9000\u6b3e");
            }
            orderEntity.setRefundAmount(orderEntity.getPayAmount());
            orderEntity.setRefundType(Integer.valueOf(1));
            this.updateById((Object)orderEntity);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.applyPayServerFund(orderEntity);
    }

    private BaseResponse<String> applyPayServerFund(OrderEntity orderEntity) {
        RefundOrderReqVo refundPaymentReqVo = new RefundOrderReqVo();
        refundPaymentReqVo.setOrderId(orderEntity.getId());
        refundPaymentReqVo.setPayMoney(orderEntity.getPayAmount().toPlainString());
        refundPaymentReqVo.setRefundDesc("\u4f53\u68c0\u9884\u7ea6\u9000\u6b3e");
        refundPaymentReqVo.setRefundMoney(orderEntity.getPayAmount().toPlainString());
        refundPaymentReqVo.setRefundId(GenSeqUtils.getUniqueNo());
        BaseResponse response = this.cdfyRefund(refundPaymentReqVo);
        if (!response.isSuccess()) {
            log.error("\u7533\u8bf7\u9000\u6b3e\u5931\u8d25,\u9000\u6b3e\u8ba2\u5355\u53f7:{},\u9000\u6b3e\u91d1\u989d:{}", (Object)orderEntity.getId(), (Object)orderEntity.getPayAmount());
            return BaseResponse.error((String)response.getMsg());
        }
        RefundCdfyResVo.Result result = ((RefundCdfyResVo)response.getData()).getResult();
        orderEntity.setRefundNo(result.getRefundNo());
        orderEntity.setRefundTime(new Date());
        this.updateById((Object)orderEntity);
        log.info("\u4fee\u6539\u540e\u7684\u8ba2\u5355\u4fe1\u606f{}", (Object)orderEntity);
        if (orderEntity.getPayAmount().equals(orderEntity.getRefundAmount())) {
            this.scheduleRecordMapper.releaseSchedule(Long.valueOf(orderEntity.getScheduleRecordId()));
        }
        return BaseResponse.success((Object)"\u63d0\u4ea4\u9000\u6b3e\u6210\u529f\uff0c\u6b63\u5728\u8fdb\u884c\u5fae\u4fe1\u9000\u6b3e..");
    }

    public BaseResponse<String> refundNotify(RefundCallBackReqVO refundNotifyReqVO) {
        OrderEntity order = (OrderEntity)this.getOne((Wrapper)new QueryWrapper().eq((Object)"deal_seq", (Object)refundNotifyReqVO.getDealTradeNo()));
        log.info("\u9000\u6b3e\u56de\u8c03\u7684\u8ba2\u5355\u4fe1\u606f{}", (Object)order);
        order.setRefundNo(refundNotifyReqVO.getOutTradeNo());
        if (!refundNotifyReqVO.getPayChannel().equals("ALIPAY")) {
            order.setRefundTime(refundNotifyReqVO.getRefundTime());
        } else {
            order.setRefundTime(new Date());
        }
        this.updateById((Object)order);
        log.info("\u4fee\u6539\u540e\u7684\u8ba2\u5355\u4fe1\u606f{}", (Object)order);
        if (order.getPayAmount().equals(order.getRefundAmount())) {
            this.scheduleRecordMapper.releaseSchedule(Long.valueOf(order.getScheduleRecordId()));
        }
        return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
    }

    private boolean checkApplyKey(RefundCallBackReqVO refundNotifyReqVO) {
        String applyKey = this.orderItemMapper.queryApplyKeyByApplyId(refundNotifyReqVO.getApplyId());
        Map keyAndValue = SignUtil.getKeyAndValue((Object)refundNotifyReqVO);
        return SignUtil.checkSign((Map)keyAndValue, (String)applyKey);
    }

    public void dowOrderList(OrderListVO getOrderListReq, HttpServletResponse response) {
        List OrderEntityitem = ((OrderMapper)this.baseMapper).orderPageInfoDow(getOrderListReq);
        List list = OrderEntityitem.stream().map(item -> {
            OrderExportExcel orderExportExcel = new OrderExportExcel();
            BeanUtils.copyProperties((Object)item, (Object)orderExportExcel);
            orderExportExcel.setStatus(PayCodeEnum.getDisplay((Integer)orderExportExcel.getOrderStatus()));
            orderExportExcel.setAppointmentDate(DateUtils.dateToFullString((Date)item.getAppointmentDate()));
            orderExportExcel.setCreateTime(DateUtils.dateToFullString((Date)item.getCreateTime()));
            if (null != item.getIsMarried()) {
                switch (item.getIsMarried()) {
                    case 1: {
                        orderExportExcel.setIsMarried("\u5df2\u5a5a");
                        break;
                    }
                    case 0: {
                        orderExportExcel.setIsMarried("\u672a\u5a5a");
                        break;
                    }
                    default: {
                        orderExportExcel.setIsMarried("");
                    }
                }
            }
            orderExportExcel.setSexCode(String.valueOf(item.getSexCode()).equals("1") ? "\u7537" : "\u5973");
            log.info("\u5b9e\u4ed8\u91d1\u989d\uff1a" + item.getPayAmount());
            log.info("\u5b9e\u4ed8\u91d1\u989d\uff1a" + item.getRefundAmount());
            if (item.getRefundAmount() != null) {
                orderExportExcel.setRelAmount(item.getPayAmount().subtract(item.getRefundAmount()));
            } else {
                orderExportExcel.setRelAmount(item.getPayAmount());
            }
            orderExportExcel.setRefundRemarks(item.getRefundRemarks());
            orderExportExcel.setRefundAmount(item.getRefundAmount());
            return orderExportExcel;
        }).collect(Collectors.toList());
        ExcelUtils.exportExcel(list, (String)"\u4f53\u68c0\u8ba2\u5355", (String)"\u4f53\u68c0\u8ba2\u5355", OrderExportExcel.class, (String)"\u4f53\u68c0\u8ba2\u5355", (boolean)true, (HttpServletResponse)response);
    }

    public BaseResponse<String> refundPartOrAll(PartRefundDTO partRefundDTO) {
        OrderEntity orderEntity = (OrderEntity)this.getOne((Wrapper)new QueryWrapper().eq((Object)"id", (Object)partRefundDTO.getOrderId()));
        if (orderEntity == null) {
            throw new BusinessException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        BigDecimal refundAmount = partRefundDTO.getRefundAmount().setScale(2, 4);
        BigDecimal payAmount = orderEntity.getPayAmount().setScale(2, 4);
        if (partRefundDTO.getRefundFlag() == 1 || refundAmount.equals(payAmount)) {
            BaseOperationDTO operationDTO = new BaseOperationDTO();
            operationDTO.setOrderId(partRefundDTO.getOrderId());
            operationDTO.setOprationUser(partRefundDTO.getOprationUser());
            operationDTO.setRefundFlag(Integer.valueOf(0));
            operationDTO.setRefundRemarks(partRefundDTO.getRefundRemarks());
            return this.applyRefund(operationDTO);
        }
        if (partRefundDTO.getRefundFlag() == 2 && !refundAmount.equals(payAmount)) {
            BaseOperationDTO operationDTO = new BaseOperationDTO();
            operationDTO.setOrderId(partRefundDTO.getOrderId());
            operationDTO.setOprationUser(partRefundDTO.getOprationUser());
            operationDTO.setRefundFlag(Integer.valueOf(0));
            operationDTO.setRefundRemarks(partRefundDTO.getRefundRemarks());
            operationDTO.setRefundAmount(partRefundDTO.getRefundAmount());
            return this.partialRefund(operationDTO);
        }
        return BaseResponse.error((String)"\u9000\u6b3e\u91d1\u989d\u9519\u8bef");
    }

    public BaseResponse<String> partialRefund(BaseOperationDTO baseOperationDto) {
        StringBuffer stringBuffer = new StringBuffer();
        String key = stringBuffer.append("BYH-PHYSICAL").append(baseOperationDto.getOrderId()).toString();
        Object lock = this.redisUtil.get(key);
        if (!Objects.isNull(lock)) {
            return BaseResponse.error((String)"\u8be5\u8ba2\u5355\u6b63\u5728\u6838\u9500\uff0c\u65e0\u6cd5\u8fdb\u884c\u9000\u6b3e");
        }
        this.redisUtil.setNx(key, UUID.randomUUID().toString(), 5L);
        OrderEntity orderEntity = (OrderEntity)this.getOne((Wrapper)new QueryWrapper().eq((Object)"id", (Object)baseOperationDto.getOrderId()));
        if (baseOperationDto.getRefundAmount().compareTo(orderEntity.getPayAmount()) > 0) {
            return BaseResponse.error((String)"\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5b9e\u4ed8\u91d1\u989d");
        }
        try {
            log.info("\u90e8\u5206\u9000\u6b3e\u8ba2\u5355\u4fe1\u606f{}", (Object)orderEntity);
            if (this.judgeOrderZero(orderEntity.getPayAmount())) {
                return BaseResponse.error((String)"0\u5143\u8ba2\u5355\u4e0d\u652f\u6301\u9000\u6b3e");
            }
            if (!Objects.equals(orderEntity.getOrderStatus(), OrderStatusEnum.WAIT_USING.getCode())) {
                return BaseResponse.error((String)"\u4ec5\u652f\u6301\u5f85\u4f7f\u7528\u7684\u8ba2\u5355\u90e8\u5206\u9000\u6b3e");
            }
            orderEntity.setRefundFlag(Integer.valueOf(RefundStatusEnum.ADMIN_REFUND.getCode()));
            orderEntity.setRefundUser(baseOperationDto.getOprationUser());
            orderEntity.setOrderStatus(OrderStatusEnum.PARTIAL_REFUND.getCode());
            orderEntity.setRefundRemarks(baseOperationDto.getRefundRemarks());
            orderEntity.setRefundAmount(baseOperationDto.getRefundAmount());
            orderEntity.setRefundType(Integer.valueOf(2));
            this.updateById((Object)orderEntity);
        }
        catch (Exception e) {
            return BaseResponse.error((String)("\u90e8\u5206\u9000\u6b3e\u5931\u8d25==>" + e));
        }
        return this.applyPayServerFundPartial(orderEntity);
    }

    private BaseResponse<String> applyPayServerFundPartial(OrderEntity orderEntity) {
        ApplyRefundVO applyRefundVO = new ApplyRefundVO();
        applyRefundVO.setOutTradeNo(orderEntity.getId());
        applyRefundVO.setDealTradeNo(orderEntity.getDealSeq());
        applyRefundVO.setPayChannel(PayTypeEnum.WECHAT_PAY.getValue());
        MerchantDTO merchantInfo = ((OrderMapper)this.baseMapper).getMerchantInfo(orderEntity.getOrganId().toString());
        if (PayTypeEnum.ALI_PAY.getValue().equalsIgnoreCase(orderEntity.getPayType())) {
            applyRefundVO.setPayChannel(PayTypeEnum.ALI_PAY.getValue());
            merchantInfo = ((OrderMapper)this.baseMapper).getMerchantInfoForzfb(orderEntity.getOrganId().toString());
        }
        applyRefundVO.setTotalAmount(orderEntity.getPayAmount());
        applyRefundVO.setApplyCode(merchantInfo.getAppCode());
        applyRefundVO.setMchCode(merchantInfo.getMerchantSeq());
        applyRefundVO.setNonceStr(SignUtil.getNonceStr());
        applyRefundVO.setRefundAmount(orderEntity.getRefundAmount());
        StringBuffer refundCallbackUrl = new StringBuffer();
        refundCallbackUrl.append(this.nodeConfig.getAddress()).append(merchantInfo.getAppCode()).append("/physical/order/refundnotify");
        applyRefundVO.setRefundNotifyUrl(refundCallbackUrl.toString());
        Map paramMap = SignUtil.getKeyAndValue((Object)applyRefundVO);
        String sign = SignUtil.createSign((Map)paramMap, (String)merchantInfo.getApplyKey(), (String[])new String[0]);
        applyRefundVO.setSign(sign);
        String url = new StringBuffer(this.nodeConfig.getPaySite()).append("/trade/refund").toString();
        log.info("\u8bf7\u6c42\u9000\u6b3e\u7684url:{},\u8bf7\u6c42\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)applyRefundVO));
        try {
            String respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)applyRefundVO), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("\u9000\u6b3e\u8fd4\u56de\u7684\u4fe1\u606f:{}", (Object)respStr);
            if (ReturnCodeEnum.SUCCEED.getValue().equals(JSON.parseObject((String)respStr).getString("code"))) {
                return BaseResponse.success((Object)"\u63d0\u4ea4\u9000\u6b3e\u6210\u529f\uff0c\u6b63\u5728\u8fdb\u884c\u5fae\u4fe1\u9000\u6b3e..");
            }
            throw new BusinessException("\u7533\u8bf7\u9000\u6b3e\u5f02\u5e38");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

