/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.physical.entity.ProjectItemEntity;
import com.ebaiyihui.physical.entity.ProjectTypeEntity;
import com.ebaiyihui.physical.mapper.ProjectItemMapper;
import com.ebaiyihui.physical.mapper.ProjectTypeMapper;
import com.ebaiyihui.physical.service.ProjectTypeService;
import com.ebaiyihui.physical.vo.ProjectTypeVO;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectTypeServiceImpl
extends ServiceImpl<ProjectTypeMapper, ProjectTypeEntity>
implements ProjectTypeService {
    private static final Logger log = LoggerFactory.getLogger(ProjectTypeServiceImpl.class);
    @Autowired
    ProjectItemMapper projectItemMapper;
    @Autowired
    ProjectTypeMapper projectTypeMapper;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BaseResponse saveProjectType(ProjectTypeEntity projectTypeEntity) {
        if (Objects.isNull(projectTypeEntity.getId())) {
            ProjectTypeEntity typeEntity = (ProjectTypeEntity)this.getOne((Wrapper)new QueryWrapper().eq((Object)"type_name", (Object)projectTypeEntity.getTypeName()));
            if (!Objects.isNull(typeEntity)) return BaseResponse.error((String)"\u7c7b\u578b\u540d\u79f0\u5df2\u5b58\u5728");
            this.save((Object)projectTypeEntity);
            return BaseResponse.success();
        } else {
            List projectTypeEntityByProjectName = this.projectTypeMapper.getTypeListByProjectName(projectTypeEntity.getTypeName());
            projectTypeEntityByProjectName.removeIf(o -> o.getId() == projectTypeEntity.getId());
            if (projectTypeEntityByProjectName.size() > 0) {
                return BaseResponse.error((String)"\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
            }
            this.updateById((Object)projectTypeEntity);
        }
        return BaseResponse.success();
    }

    public List<ProjectTypeVO> queryProjectTypeList(String organId) {
        List list = ((ProjectTypeMapper)this.baseMapper).queryProjectTypeList(organId);
        log.info("\u67e5\u8be2\u9879\u76ee\u5206\u7c7b\u5217\u8868,\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)list));
        return list;
    }

    public BaseResponse delProjectType(Integer projectId) {
        Integer count = this.projectItemMapper.selectCount((Wrapper)new QueryWrapper().lambda().eq(ProjectItemEntity::getProjectTypeId, (Object)projectId));
        if (count > 0) {
            return BaseResponse.error((String)"\u9700\u5c06\u5206\u7c7b\u4e0b\u7684\u9879\u76ee\u5168\u90e8\u79fb\u9664\u540e\u624d\u53ef\u5220\u9664\u8be5\u5206\u7c7b");
        }
        this.removeById((Serializable)projectId);
        return BaseResponse.success();
    }
}

