/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.physical.dto.CreateBatchScheduleRecordDTO;
import com.ebaiyihui.physical.dto.CreateBatchScheduleRecordVDTO;
import com.ebaiyihui.physical.dto.CreateScheduleRecordDTO;
import com.ebaiyihui.physical.dto.CreateScheduleRecordVDTO;
import com.ebaiyihui.physical.dto.EditAvailableCountDTO;
import com.ebaiyihui.physical.entity.ScheduleRecordEntity;
import com.ebaiyihui.physical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.physical.service.ScheduleRecordService;
import com.ebaiyihui.physical.utils.DateUtils;
import com.ebaiyihui.physical.vo.ScheduleRecordDaysVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ScheduleRecordServiceImpl
extends ServiceImpl<ScheduleRecordMapper, ScheduleRecordEntity>
implements ScheduleRecordService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleRecordServiceImpl.class);

    public BaseResponse createSchedule(CreateScheduleRecordDTO scheduleRecordDTO) {
        List scheduleRecordList = scheduleRecordDTO.getScheduleRecordList();
        for (CreateScheduleRecordVDTO vdto : scheduleRecordList) {
            if (!Objects.isNull(vdto.getTotalCount())) continue;
            return BaseResponse.error((String)"\u6dfb\u52a0\u53f7\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<ScheduleRecordEntity> list = new ArrayList<ScheduleRecordEntity>();
        String today = DateUtils.dateToString((Date)new Date(), (String)"yyyy-MM-dd");
        List scheduleRecordEntityList = ((ScheduleRecordMapper)this.baseMapper).queryScheduleRecordList(scheduleRecordDTO.getOrganId(), today, null);
        for (CreateScheduleRecordVDTO dto : scheduleRecordDTO.getScheduleRecordList()) {
            for (ScheduleRecordEntity scheduleRecordEntity : scheduleRecordEntityList) {
                if (!Objects.equals(scheduleRecordEntity.getScheduleDate(), dto.getScheduleDate())) continue;
                if (dto.getStartTime().compareTo(dto.getEndTime()) >= 0) {
                    return BaseResponse.error((String)"\u8bbe\u7f6e\u7684\u53f7\u6e90\u65f6\u6bb5\u6709\u8bef:\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4");
                }
                if (scheduleRecordEntity.getStartTime().compareTo(dto.getEndTime()) >= 0 || scheduleRecordEntity.getEndTime().compareTo(dto.getStartTime()) <= 0) continue;
                return BaseResponse.error((String)"\u8bbe\u7f6e\u7684\u53f7\u6e90\u65f6\u6bb5\u548c\u5df2\u5b58\u5728\u7684\u53f7\u6e90\u65f6\u6bb5\u6709\u91cd\u5408");
            }
            ScheduleRecordEntity entity = new ScheduleRecordEntity();
            BeanUtils.copyProperties((Object)dto, (Object)entity);
            entity.setOrganId(scheduleRecordDTO.getOrganId());
            entity.setAvailableCount(dto.getTotalCount());
            list.add(entity);
        }
        ((ScheduleRecordMapper)this.baseMapper).insertBatchScheduleRecord(list);
        return BaseResponse.success();
    }

    public BaseResponse createBatchSchedule(CreateBatchScheduleRecordDTO scheduleBatchRecordDTO) {
        CreateScheduleRecordDTO scheduleRecordDTO = new CreateScheduleRecordDTO();
        scheduleRecordDTO.setOrganId(scheduleBatchRecordDTO.getOrganId());
        ArrayList<CreateScheduleRecordVDTO> scheduleRecordList = new ArrayList<CreateScheduleRecordVDTO>();
        Date curr = scheduleBatchRecordDTO.getStartDate();
        while (curr.getTime() <= scheduleBatchRecordDTO.getEndDate().getTime()) {
            for (CreateBatchScheduleRecordVDTO batchScheduleRecordVDTO : scheduleBatchRecordDTO.getScheduleRecordList()) {
                CreateScheduleRecordVDTO recordVDTO = new CreateScheduleRecordVDTO();
                recordVDTO.setScheduleDate(curr);
                recordVDTO.setStartTime(batchScheduleRecordVDTO.getStartTime());
                recordVDTO.setEndTime(batchScheduleRecordVDTO.getEndTime());
                recordVDTO.setTotalCount(batchScheduleRecordVDTO.getTotalCount());
                scheduleRecordList.add(recordVDTO);
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(curr);
            calendar.add(7, 1);
            curr = calendar.getTime();
        }
        scheduleRecordDTO.setScheduleRecordList(scheduleRecordList);
        return this.createSchedule(scheduleRecordDTO);
    }

    public BaseResponse editAvailableCount(EditAvailableCountDTO editAvailableCountDTO) {
        if (editAvailableCountDTO.getAvailableCount() < 0) {
            BaseResponse.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        ScheduleRecordEntity entity = (ScheduleRecordEntity)this.getById((Serializable)editAvailableCountDTO.getId());
        int used = entity.getTotalCount() - entity.getAvailableCount();
        int totalCount = used + editAvailableCountDTO.getAvailableCount();
        entity.setTotalCount(Integer.valueOf(totalCount));
        entity.setAvailableCount(editAvailableCountDTO.getAvailableCount());
        this.updateById((Object)entity);
        return BaseResponse.success((Object)entity);
    }

    public BaseResponse queryForManager(Long organId, String startTime, String endTime) {
        if (Objects.isNull(organId) || StringUtils.isEmpty((CharSequence)startTime) || StringUtils.isEmpty((CharSequence)endTime)) {
            BaseResponse.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        List scheduleRecordEntityList = ((ScheduleRecordMapper)this.baseMapper).queryScheduleRecordList(organId, startTime, endTime);
        return BaseResponse.success((Object)this.organizeData(scheduleRecordEntityList));
    }

    private List<Map<String, Object>> organizeData(List<ScheduleRecordEntity> scheduleRecordEntityList) {
        Map<Date, List<ScheduleRecordEntity>> value = scheduleRecordEntityList.stream().collect(Collectors.groupingBy(ScheduleRecordEntity::getScheduleDate));
        Set<Date> set = value.keySet();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Date key : set) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("day", DateUtils.dateToString((Date)key, (String)"yyyy-MM-dd"));
            map.put("val", value.get(key));
            result.add(map);
        }
        return result;
    }

    public BaseResponse queryForApplet(Long organId, Integer days) {
        if (Objects.isNull(organId) || Objects.isNull(days)) {
            BaseResponse.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        Date startTime = DateUtils.getDayStartTime((Integer)2);
        Date endTime = DateUtils.dateAddDays((Date)startTime, (int)(days - 1));
        List scheduleRecordDaysVOList = ((ScheduleRecordMapper)this.baseMapper).queryScheduleRecordListByDays(organId, DateUtils.dateToString((Date)startTime, (String)"yyyy-MM-dd"), DateUtils.dateToString((Date)endTime, (String)"yyyy-MM-dd"));
        Date curr = DateUtils.getDayStartTime((Integer)2);
        ArrayList<ScheduleRecordDaysVO> result = new ArrayList<ScheduleRecordDaysVO>();
        while (curr.getTime() <= endTime.getTime()) {
            ScheduleRecordDaysVO currVo = new ScheduleRecordDaysVO();
            currVo.setScheduleDate(curr);
            boolean hasValue = false;
            for (ScheduleRecordDaysVO svo : scheduleRecordDaysVOList) {
                if (!Objects.equals(svo.getScheduleDate(), curr)) continue;
                currVo.setAvailableCount(svo.getAvailableCount());
                currVo.setTotalCount(svo.getTotalCount());
                hasValue = true;
                break;
            }
            if (!hasValue) {
                currVo.setAvailableCount(Integer.valueOf(0));
                currVo.setTotalCount(Integer.valueOf(0));
            }
            result.add(currVo);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(curr);
            calendar.add(7, 1);
            curr = calendar.getTime();
        }
        return BaseResponse.success(result);
    }

    public BaseResponse queryForAppletByDay(Long organId, String day) {
        if (Objects.isNull(organId) || StringUtils.isEmpty((CharSequence)day)) {
            BaseResponse.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        List scheduleRecordEntityList = ((ScheduleRecordMapper)this.baseMapper).queryScheduleRecordList(organId, day, day);
        return BaseResponse.success((Object)scheduleRecordEntityList);
    }
}

