/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.test;

import com.ebaiyihui.physical.entity.OrderEntity;
import com.ebaiyihui.physical.mapper.OrderMapper;
import com.ebaiyihui.physical.service.ProgramPushService;
import com.ebaiyihui.physical.utils.DateUtils;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class ScheduleTask {
    private static final Logger log = LoggerFactory.getLogger(ScheduleTask.class);
    @Autowired
    OrderMapper orderMapper;
    @Resource
    private ProgramPushService programPushService;

    @Scheduled(cron="0 59 23 * * ?")
    public void topicCustomerTask() {
        Date dateBefore = DateUtils.getDateBefore((Date)new Date(), (int)335);
        String date = DateUtils.dateToString((Date)dateBefore, (String)"yyyy-MM-dd");
        List OrderEntityitem = this.orderMapper.queryOrderByDate(date);
        try {
            for (OrderEntity order : OrderEntityitem) {
                this.programPushService.returnVisitNotify(order);
            }
        }
        catch (Exception e) {
            log.error("\u590d\u8d2d\u6d88\u606f\u63a8\u9001\u51fa\u9519", (Throwable)e);
        }
    }
}

