/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.physical.dto.question.AppPatientPage;
import com.ebaiyihui.physical.dto.question.MatchingItemDTO;
import com.ebaiyihui.physical.dto.question.OrderQuestionDTO;
import com.ebaiyihui.physical.dto.question.QuestionDTO;
import com.ebaiyihui.physical.service.CustomService;
import com.ebaiyihui.physical.vo.question.AcceptVO;
import com.ebaiyihui.physical.vo.question.AppPatientVO;
import com.ebaiyihui.physical.vo.question.QuestionVO;
import com.ebaiyihui.physical.vo.question.SaveQuestionVO;
import com.ebaiyihui.physical.vo.question.SearchQuestionVO;
import com.ebaiyihui.physical.vo.question.StoreItemVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/custom"})
@Api(tags={"\u5b9a\u5236\u7ba1\u7406"})
public class CustomController {
    private static final Logger log = LogManager.getLogger(CustomController.class);
    @Autowired
    CustomService customService;

    @ApiOperation(value="\u5206\u914d\u8c03\u67e5\u95ee\u5377")
    @PostMapping(value={"/distribution"})
    public BaseResponse<List<QuestionDTO>> distributionQuestion(@RequestBody QuestionVO vo) {
        List res = this.customService.distributionQuestion(vo);
        return BaseResponse.success((Object)res);
    }

    @ApiOperation(value="\u5339\u914d\u4f53\u68c0\u9879\u76ee")
    @PostMapping(value={"/matching"})
    public BaseResponse<MatchingItemDTO> matchingProject(@RequestBody SaveQuestionVO vo) {
        MatchingItemDTO result = this.customService.matchingProject(vo);
        return BaseResponse.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u4f53\u68c0\u9879\u76ee")
    @GetMapping(value={"/item"})
    public BaseResponse projectItemList() {
        List result = this.customService.getProjectItemList();
        return BaseResponse.success((Object)result);
    }

    @ApiOperation(value="\u4fdd\u5b58\u3001\u83b7\u53d6\u3001\u4fee\u6539\u7f13\u5b58\u4e2d\u7684\u4f53\u68c0\u9879")
    @PostMapping(value={"/store"})
    public BaseResponse<List<StoreItemVO.Item>> saveOrGetProject(@RequestBody StoreItemVO vo) {
        List result = this.customService.store(vo);
        return BaseResponse.success((Object)result);
    }

    @ApiOperation(value="\u67e5\u770b\u7528\u6237\u7684\u8c03\u67e5\u95ee\u5377")
    @PostMapping(value={"/peek"})
    public BaseResponse<List<OrderQuestionDTO>> getUserQuestionnaire(@RequestBody SearchQuestionVO vo) {
        List result = this.customService.getOrderQuestion(vo);
        return BaseResponse.success((Object)result);
    }

    @ApiOperation(value="APP\u4f53\u68c0\u60a3\u8005\u7533\u8bf7\u5217\u8868")
    @PostMapping(value={"/impatient"})
    public BaseResponse<AppPatientPage> getAppPatientList(@RequestBody AppPatientVO vo) {
        try {
            return BaseResponse.success((Object)this.customService.getAppPatientList(vo));
        }
        catch (Exception e) {
            log.error("impatient \u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="\u533b\u751f\u63a5\u8bca")
    @PostMapping(value={"/accept"})
    public BaseResponse accepts(@RequestBody AcceptVO vo) {
        this.customService.accept(vo);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u83b7\u53d6\u662f\u5426\u6709\u5728\u7ebf\u7684\u533b\u751f \u8fd4\u56detrue \u4ee3\u8868\u6709\u533b\u751f\u5728\u7ebf \u5426\u5219\u8fd4\u56defalse")
    @GetMapping(value={"/getDoctorOnline"})
    public BaseResponse<String> getDoctorOnline(@RequestParam(value="appcode") String appcode, @RequestParam(value="organId") String organId, @RequestParam(value="serviceCode") String serviceCode) {
        try {
            List doctorOnline = this.customService.getDoctorOnline(appcode, organId, serviceCode);
            if (doctorOnline.size() == 0) {
                return BaseResponse.success((Object)"false");
            }
            return BaseResponse.success((Object)"true");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u662f\u5426\u6709\u5728\u7ebf\u7684\u533b\u751f\u63a5\u53e3\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
            return BaseResponse.error((String)e.toString());
        }
    }

    @ApiOperation(value="APP\u7aef\u83b7\u53d6\u7528\u6237\u9009\u62e9\u7684\u9879\u76ee")
    @GetMapping(value={"/getSelectedItems"})
    BaseResponse<StoreItemVO> getSelectedItems(@RequestParam(value="orderId") String orderId, @RequestParam(value="userId") String userId, @RequestParam(value="patientName") String patientName) {
        try {
            return BaseResponse.success((Object)this.customService.getSelectedItems(orderId, userId, patientName));
        }
        catch (Exception e) {
            log.error("getSelectedItems\u51fa\u73b0\u4e25\u91cd\u9519\u8bef->{}", (Throwable)e);
            return BaseResponse.error((String)e.toString());
        }
    }
}

