/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.doctor.basedata.api.vo.BusinessDoctorPageReqVo;
import com.doctor.basedata.api.vo.DoctorBasicRespVO;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.AccountVO;
import com.ebaiyihui.imforward.client.vo.PushSingleMsgDataVO;
import com.ebaiyihui.imforward.client.vo.PushSingleMsgReqVO;
import com.ebaiyihui.physical.constant.DateConstant;
import com.ebaiyihui.physical.dto.question.AddProjectDTO;
import com.ebaiyihui.physical.dto.question.AppPatientPage;
import com.ebaiyihui.physical.dto.question.MatchingItemDTO;
import com.ebaiyihui.physical.dto.question.OrderQuestionDTO;
import com.ebaiyihui.physical.dto.question.QuestionDTO;
import com.ebaiyihui.physical.entity.AnswerEntity;
import com.ebaiyihui.physical.entity.OrderEntity;
import com.ebaiyihui.physical.entity.OrderItemEntity;
import com.ebaiyihui.physical.entity.ProjectItemEntity;
import com.ebaiyihui.physical.entity.ProjectLabelEntity;
import com.ebaiyihui.physical.enums.OrderStatusEnum;
import com.ebaiyihui.physical.mapper.AnswerMapper;
import com.ebaiyihui.physical.mapper.OrderItemMapper;
import com.ebaiyihui.physical.mapper.OrderMapper;
import com.ebaiyihui.physical.mapper.OrderQuestionMapper;
import com.ebaiyihui.physical.mapper.ProjectItemMapper;
import com.ebaiyihui.physical.mapper.ProjectLabelMapper;
import com.ebaiyihui.physical.mapper.QuestionMapper;
import com.ebaiyihui.physical.service.CustomService;
import com.ebaiyihui.physical.service.client.DoctorWorkingServiceClient;
import com.ebaiyihui.physical.service.client.IMPushMsgFeignClient;
import com.ebaiyihui.physical.utils.DateUtils;
import com.ebaiyihui.physical.utils.RabbitMqUtils;
import com.ebaiyihui.physical.utils.RedisUtil;
import com.ebaiyihui.physical.vo.DelayMqEntity;
import com.ebaiyihui.physical.vo.question.AcceptVO;
import com.ebaiyihui.physical.vo.question.AppPatientVO;
import com.ebaiyihui.physical.vo.question.QuestionVO;
import com.ebaiyihui.physical.vo.question.SaveQuestionVO;
import com.ebaiyihui.physical.vo.question.SearchQuestionVO;
import com.ebaiyihui.physical.vo.question.StoreItemVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CustomServiceImpl
implements CustomService {
    private static final Logger log = LoggerFactory.getLogger(CustomServiceImpl.class);
    @Autowired
    QuestionMapper questionMapper;
    @Autowired
    AnswerMapper answerMapper;
    @Autowired
    ProjectLabelMapper projectLabelMapper;
    @Autowired
    ProjectItemMapper projectItemMapper;
    @Autowired
    OrderItemMapper orderItemMapper;
    @Autowired
    OrderQuestionMapper orderQuestionMapper;
    @Autowired
    OrderMapper orderMapper;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    ThreadPoolExecutor executor;
    @Autowired
    DoctorWorkingServiceClient doctorWorkingServiceClient;
    @Autowired
    IMPushMsgFeignClient imPushMsgFeignClient;
    @Autowired
    RabbitTemplate rabbitTemplate;

    public List<QuestionDTO> distributionQuestion(QuestionVO vo) {
        log.info("\u83b7\u53d6\u8c03\u67e5\u95ee\u5377\u5165\u53c2{}", (Object)vo);
        List questionList = this.questionMapper.selectQuestionBySexCode(vo);
        List<QuestionDTO> result = questionList.stream().map(item -> {
            ArrayList<QuestionDTO.Answer> ansList = new ArrayList<QuestionDTO.Answer>();
            QuestionDTO questionDTO = new QuestionDTO();
            BeanUtils.copyProperties((Object)item, (Object)questionDTO);
            String[] answerId = item.getAnswerId().split(",");
            String[] answer = item.getAnswer().split(",");
            for (int i = 0; i < answerId.length; ++i) {
                QuestionDTO.Answer ans = new QuestionDTO.Answer();
                ans.setAnswerId(Integer.valueOf(answerId[i]));
                ans.setAnswer(answer[i]);
                ansList.add(ans);
            }
            Collections.sort(ansList);
            questionDTO.setAnswer(ansList);
            return questionDTO;
        }).collect(Collectors.toList());
        log.info("\u8c03\u67e5\u95ee\u5377\u83b7\u53d6\u7ed3\u679c{}", result);
        return result;
    }

    public MatchingItemDTO matchingProject(SaveQuestionVO vo) {
        log.info("\u5339\u914d\u4f53\u68c0\u9879\u76ee\u5165\u53c2{}", (Object)JSON.toJSONString((Object)vo.getSaveList()));
        CompletableFuture.runAsync(() -> this.saveQuestionToRedis(vo), this.executor);
        MatchingItemDTO dto = new MatchingItemDTO();
        ArrayList allAnswerList = new ArrayList();
        vo.getSaveList().stream().forEach(item -> {
            Object[] answerIds = item.getAnswerId().split(",");
            List answerList = this.answerMapper.selectList((Wrapper)new QueryWrapper().lambda().in(AnswerEntity::getId, answerIds));
            allAnswerList.addAll(answerList);
        });
        List labelIds = allAnswerList.stream().filter(item -> !Objects.equals(item.getMatchingLabelId(), 0)).map(item -> item.getMatchingLabelId()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(labelIds)) {
            List labelList = this.projectLabelMapper.selectList((Wrapper)new QueryWrapper().lambda().in(ProjectLabelEntity::getLabelId, labelIds));
            List projectIds = labelList.stream().map(item -> item.getProjectId()).distinct().collect(Collectors.toList());
            List<Object> resultList = new ArrayList();
            resultList = this.projectItemMapper.selectMatchingProject(projectIds);
            resultList = resultList.stream().distinct().collect(Collectors.toList());
            BigDecimal totalPrice = BigDecimal.ZERO;
            for (ProjectItemEntity projectItemEntity : resultList) {
                totalPrice = totalPrice.add(projectItemEntity.getProjectPrice());
            }
            dto.setItemTotalPrice(totalPrice.toString());
            dto.setItemList(resultList);
            dto.setItemCount(Integer.valueOf(resultList.size()));
            return dto;
        }
        return null;
    }

    public void saveQuestionToRedis(SaveQuestionVO vo) {
        StringBuffer buffer = new StringBuffer();
        String key = buffer.append(vo.getUserId() + vo.getOrderId()).append(vo.getPatientName()).append("PHYSICAL_QUESTION").toString();
        if (Objects.isNull(this.redisUtil.get(key))) {
            this.redisUtil.set(key, (Object)JSON.toJSONString((Object)vo.getSaveList()));
        } else {
            this.redisUtil.del(new String[]{key});
            this.redisUtil.set(key, (Object)JSON.toJSONString((Object)vo.getSaveList()));
        }
    }

    public List<OrderQuestionDTO> getOrderQuestion(SearchQuestionVO vo) {
        return this.orderQuestionMapper.getUserQuestion(vo);
    }

    public List<AddProjectDTO> getProjectItemList() {
        return this.questionMapper.getProjectItemList();
    }

    public List<StoreItemVO.Item> store(StoreItemVO vo) {
        StringBuffer buffer = new StringBuffer();
        String key = buffer.append(vo.getUserId() + vo.getOrderId()).append(vo.getPatientName()).append("PHYSICAL_PROJECT_ITEM").toString();
        if (CollectionUtils.isEmpty((Collection)vo.getItems())) {
            String o = (String)this.redisUtil.get(key);
            List items = JSON.parseArray((String)o, StoreItemVO.Item.class);
            return items;
        }
        this.redisUtil.set(key, (Object)JSON.toJSONString((Object)vo.getItems(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (!StrUtil.isNotBlank((CharSequence)vo.getOrderId())) {
            return vo.getItems();
        }
        try {
            this.replacementOrderItem(vo);
        }
        catch (Exception e) {
            log.error("\u66ff\u6362\u6570\u636e\u5931\u8d25{}", (Throwable)e);
        }
        return vo.getItems();
    }

    private void replacementOrderItem(StoreItemVO vo) {
        QueryWrapper orderItemEntityQueryWrapper = new QueryWrapper();
        orderItemEntityQueryWrapper.eq((Object)"order_id", (Object)vo.getOrderId());
        List orderItemEntities = this.orderItemMapper.selectList((Wrapper)orderItemEntityQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)orderItemEntities)) {
            log.info("\u67e5\u8be2\u5f53\u524d\u8ba2\u5355\u5957\u9910\u4e3a\u7a7a");
            return;
        }
        int delete = this.orderItemMapper.delete((Wrapper)orderItemEntityQueryWrapper);
        log.info("\u5220\u9664item\u8868\u539f\u6570\u636e\u8fd4\u56de\u503c->{}", (Object)delete);
        ArrayList<OrderItemEntity> orderItemList = new ArrayList<OrderItemEntity>();
        for (StoreItemVO.Item item : vo.getItems()) {
            OrderItemEntity orderItemEntity = new OrderItemEntity();
            orderItemEntity.setStatus(Integer.valueOf(1));
            orderItemEntity.setOrderId(vo.getOrderId());
            orderItemEntity.setProjectId(item.getProjectId());
            orderItemEntity.setProjectName(item.getProjectName());
            orderItemEntity.setProjectPrice(item.getProjectPrice());
            orderItemEntity.setProjectDesc(item.getProjectDesc());
            orderItemList.add(orderItemEntity);
        }
        this.orderItemMapper.batchInsertItem(orderItemList);
        this.updateOrderPayAmountById(vo);
    }

    private void updateOrderPayAmountById(StoreItemVO vo) {
        OrderEntity orderEntity = new OrderEntity();
        orderEntity.setId(vo.getOrderId());
        orderEntity.setPayAmount(vo.getItems().stream().map(StoreItemVO.Item::getProjectPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        int i = this.orderMapper.updateById((Object)orderEntity);
        log.info("\u540c\u6b65\u4fee\u6539\u8ba2\u5355\u91d1\u989d\u8fd4\u56de\u6570\u636e\u96c6\u4e3a->{}", (Object)i);
    }

    public AppPatientPage getAppPatientList(AppPatientVO vo) {
        AppPatientPage page = new AppPatientPage();
        QueryWrapper orderEntityQueryWrapper = new QueryWrapper();
        orderEntityQueryWrapper.in((Object)"order_status", (Collection)vo.getOrderStatus());
        orderEntityQueryWrapper.eq(StrUtil.isNotBlank((CharSequence)vo.getOrganId()), (Object)"organ_id", (Object)vo.getOrganId());
        orderEntityQueryWrapper.eq(StrUtil.isNotBlank((CharSequence)vo.getDoctorId()), (Object)"doctor_id", (Object)vo.getDoctorId());
        orderEntityQueryWrapper.like(StrUtil.isNotBlank((CharSequence)vo.getSearch()), (Object)"patient_name", (Object)vo.getSearch());
        orderEntityQueryWrapper.eq((Object)"status", (Object)1);
        orderEntityQueryWrapper.orderByAsc((Object)"create_time");
        Page orderEntityPage = new Page((long)vo.getCurrPage().intValue(), (long)vo.getPageSize().intValue());
        IPage orderEntityIPage = this.orderMapper.selectPage((IPage)orderEntityPage, (Wrapper)orderEntityQueryWrapper);
        page.setPages(orderEntityIPage.getPages());
        page.setCurrent(orderEntityIPage.getCurrent());
        page.setSize(orderEntityIPage.getSize());
        orderEntityIPage.getRecords().stream().forEach(item -> item.setUpdateTime(this.dateToStamp(item.getUpdateTime())));
        page.setOrderEntities(orderEntityIPage.getRecords().stream().sorted(Comparator.comparing(OrderEntity::getCreateTime)).collect(Collectors.toList()));
        page.setTotal(orderEntityIPage.getTotal());
        return page;
    }

    private String dateToStamp(String s) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = simpleDateFormat.parse(s);
            long ts = date.getTime();
            String res = String.valueOf(ts);
            return res;
        }
        catch (ParseException e) {
            return String.valueOf(System.currentTimeMillis());
        }
    }

    public void accept(AcceptVO vo) {
        OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)vo.getOrderId()));
        if (Objects.equals(vo.getAcceptFlag(), 1)) {
            orderEntity.setOrderStatus(OrderStatusEnum.VISITS.getCode());
            orderEntity.setLoseTime(DateUtils.calculateOrderLoseTime((Date)new Date(), (int)DateConstant.TWENTY_FOUR_HOURS));
            this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            DelayMqEntity delayMqEntity = new DelayMqEntity();
            delayMqEntity.setOrderId(orderEntity.getId());
            delayMqEntity.setType("2");
            RabbitMqUtils.delayedUpdateOrderStatus((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)delayMqEntity), (Integer)DateConstant.TWENTY_FOUR_HOURS);
        } else {
            orderEntity.setOrderStatus(OrderStatusEnum.VISITS_END.getCode());
            this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.orderMapper.updateById((Object)orderEntity);
    }

    private void imMsgPush(AcceptVO vo, OrderEntity orderEntity, String appCode, String msg) {
        PushSingleMsgReqVO pushSingleMsgReqVO = new PushSingleMsgReqVO();
        pushSingleMsgReqVO.setBusiCode(vo.getBusiCode());
        pushSingleMsgReqVO.setUniqueId(vo.getOrderId());
        ArrayList<PushSingleMsgDataVO> list = new ArrayList<PushSingleMsgDataVO>();
        PushSingleMsgDataVO pushSingleMsgDataVO = new PushSingleMsgDataVO();
        pushSingleMsgDataVO.setActionType("system");
        pushSingleMsgDataVO.setMessage(msg);
        AccountVO accountVO = new AccountVO();
        accountVO.setAppCode(appCode);
        accountVO.setUserId(orderEntity.getUserId());
        pushSingleMsgDataVO.setToAccount(accountVO);
        list.add(pushSingleMsgDataVO);
        pushSingleMsgReqVO.setMsgData(list);
        log.info("\u7ed3\u675f\u95ee\u8bca\u7ed9\u60a3\u8005\u53d1\u9001\u7cfb\u7edf\u6d88\u606f\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)pushSingleMsgReqVO));
        BaseResponse baseResponse1 = this.imPushMsgFeignClient.pushSingleMsg(pushSingleMsgReqVO);
        log.info("\u7ed3\u675f\u95ee\u8bca\u7ed9\u60a3\u8005\u53d1\u9001\u7cfb\u7edf\u6d88\u606f\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)baseResponse1));
    }

    public List<DoctorBasicRespVO> getDoctorOnline(String appcode, String organId, String serviceCode) {
        BusinessDoctorPageReqVo businessDoctorPageReqVo = new BusinessDoctorPageReqVo();
        businessDoctorPageReqVo.setAppCode(appcode);
        businessDoctorPageReqVo.setOrganId(Long.valueOf(organId));
        businessDoctorPageReqVo.setServiceCode(serviceCode);
        businessDoctorPageReqVo.setSeq(1);
        businessDoctorPageReqVo.setPageNum(1);
        businessDoctorPageReqVo.setPageSize(50);
        businessDoctorPageReqVo.setStatus(1);
        BaseResponse businessDoctorBaseInfoPage = this.doctorWorkingServiceClient.getBusinessDoctorBaseInfoPage(businessDoctorPageReqVo);
        List content = ((PageResult)businessDoctorBaseInfoPage.getData()).getContent();
        return content;
    }

    public StoreItemVO getSelectedItems(String orderId, String userId, String patientName) {
        String o = (String)this.redisUtil.get(userId + orderId + patientName + "PHYSICAL_PROJECT_ITEM");
        List items = JSON.parseArray((String)o, StoreItemVO.Item.class);
        if (items.size() == 0) {
            return new StoreItemVO();
        }
        StoreItemVO storeItemVO = new StoreItemVO();
        storeItemVO.setItems(items);
        storeItemVO.setItemsCount(String.valueOf(items.size()));
        storeItemVO.setItemsAmount(items.stream().map(StoreItemVO.Item::getProjectPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
        return storeItemVO;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ void access$100(CustomServiceImpl x0, AcceptVO x1, OrderEntity x2, String x3, String x4) {
        x0.imMsgPush(x1, x2, x3, x4);
    }
}

