/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.physical.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.physical.entity.ProjectItemEntity;
import com.ebaiyihui.physical.entity.ProjectLabelEntity;
import com.ebaiyihui.physical.mapper.CombinationProjectMapper;
import com.ebaiyihui.physical.mapper.ProjectItemMapper;
import com.ebaiyihui.physical.mapper.ProjectLabelMapper;
import com.ebaiyihui.physical.service.ProjectItemService;
import com.ebaiyihui.physical.service.ProjectLabelService;
import com.ebaiyihui.physical.vo.ProjectItemVO;
import com.ebaiyihui.physical.vo.ProjectQueryListVO;
import com.ebaiyihui.physical.vo.SaveProjectItemVO;
import com.ebaiyihui.physical.vo.SetBaseProjectVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectItemServiceImpl
extends ServiceImpl<ProjectItemMapper, ProjectItemEntity>
implements ProjectItemService {
    private static final Logger log = LoggerFactory.getLogger(ProjectItemServiceImpl.class);
    @Autowired
    ProjectLabelMapper projectLabelMapper;
    @Autowired
    ProjectLabelService projectLabelService;
    @Autowired
    CombinationProjectMapper combinationProjectMapper;

    @Transactional
    public BaseResponse saveProject(SaveProjectItemVO saveProjectItemVO) {
        ProjectItemEntity p;
        log.info("\u4fdd\u5b58\u9879\u76ee,\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)saveProjectItemVO));
        boolean editFlag = Objects.nonNull(saveProjectItemVO.getId());
        if (editFlag) {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            ids.add(saveProjectItemVO.getId());
            Integer count = this.combinationProjectMapper.checkProjectIdsInCombination(ids);
            if (count > 0) {
                return BaseResponse.error((String)"\u6240\u5728\u5957\u9910\u4e3a\u9500\u552e\u72b6\u6001\u65f6\u4e0d\u53ef\u66f4\u6539\u4f53\u68c0\u9879\u76ee\u5185\u5bb9");
            }
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_name", (Object)saveProjectItemVO.getProjectName());
        if (editFlag) {
            queryWrapper.ne((Object)"id", (Object)saveProjectItemVO.getId());
        }
        if (Objects.nonNull(p = (ProjectItemEntity)this.getOne((Wrapper)queryWrapper))) {
            return BaseResponse.error((String)"\u9879\u76ee\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (editFlag) {
            this.projectLabelMapper.deleteByProjectId(saveProjectItemVO.getId());
        }
        ProjectItemEntity projectItemEntity = new ProjectItemEntity();
        BeanUtils.copyProperties((Object)saveProjectItemVO, (Object)projectItemEntity);
        log.info("\u4fdd\u5b58\u7684\u5b9e\u4f53:{}", (Object)JSON.toJSONString((Object)projectItemEntity));
        this.saveOrUpdate((Object)projectItemEntity);
        saveProjectItemVO.setId(projectItemEntity.getId());
        if (Objects.nonNull(saveProjectItemVO.getLabelIdList())) {
            ArrayList<ProjectLabelEntity> projectLabelEntityList = new ArrayList<ProjectLabelEntity>();
            for (Integer labelId : saveProjectItemVO.getLabelIdList()) {
                ProjectLabelEntity projectLabelEntity = new ProjectLabelEntity();
                projectLabelEntity.setProjectId(projectItemEntity.getId());
                projectLabelEntity.setLabelId(labelId);
                projectLabelEntityList.add(projectLabelEntity);
            }
            this.projectLabelService.saveBatch(projectLabelEntityList);
        }
        return BaseResponse.success((Object)saveProjectItemVO);
    }

    public List<ProjectItemVO> queryProjectItemList(ProjectQueryListVO projectQueryListVO) {
        log.info("\u67e5\u8be2\u9879\u76ee\u5217\u8868,\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)projectQueryListVO));
        List list = ((ProjectItemMapper)this.baseMapper).getProjectList(projectQueryListVO);
        log.info("\u67e5\u8be2\u9879\u76ee\u5217\u8868,\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)list));
        return list;
    }

    public ProjectItemVO getProjectItemDetails(ProjectItemEntity projectItemEntity) {
        ProjectItemEntity projectItem = (ProjectItemEntity)((ProjectItemMapper)this.baseMapper).selectById((Serializable)projectItemEntity.getId());
        if (Objects.isNull(projectItem)) {
            log.info("\u672a\u67e5\u8be2\u5230\u6570\u636e!");
            return null;
        }
        ProjectItemVO projectItemVO = new ProjectItemVO();
        BeanUtils.copyProperties((Object)projectItem, (Object)projectItemVO);
        List dictionaryEntityList = ((ProjectItemMapper)this.baseMapper).getLabelByProjectId(projectItemEntity.getId());
        projectItemVO.setLabelList(dictionaryEntityList);
        log.info("\u67e5\u8be2\u7684\u9879\u76ee\u8be6\u60c5:{}", (Object)JSON.toJSONString((Object)projectItemVO));
        return projectItemVO;
    }

    public BaseResponse setBaseProject(SetBaseProjectVO setBaseProjectVO) {
        log.info("\u8bbe\u7f6e\u57fa\u7840\u4f53\u68c0\u9879\u7684\u9879\u76eeid\u4e3a:{}", (Object)JSON.toJSONString((Object)setBaseProjectVO.getProjectIds()));
        ((ProjectItemMapper)this.baseMapper).setBaseProject(setBaseProjectVO);
        return BaseResponse.success();
    }

    public BaseResponse delProject(List<ProjectItemEntity> projectItemList) {
        if (Objects.nonNull(projectItemList) && projectItemList.size() > 0) {
            List ids = projectItemList.stream().map(item -> item.getId()).collect(Collectors.toList());
            Integer count = this.combinationProjectMapper.checkProjectIdsInCombination(ids);
            if (Objects.nonNull(count) && count > 0) {
                return BaseResponse.error((String)"\u6240\u9009\u9879\u76ee\u4e2d\u6709\u9500\u552e\u4e2d\u72b6\u6001\u4e0d\u53ef\u5220\u9664,\u8bf7\u68c0\u67e5\u540e\u518d\u64cd\u4f5c");
            }
            this.removeByIds(ids);
        }
        return BaseResponse.success();
    }
}

