/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitMqConfig {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqConfig.class);
    private static final String LISTEN_KEY = "push.msg.#";
    @Value(value="${node.rabbitmq.exchange}")
    private String exchangeName;
    @Value(value="${node.rabbitmq.queueName}")
    private String queueName;

    @Bean(name={"PUSH_MESSAGE_EXCHANGE"})
    Exchange exchange() {
        return ExchangeBuilder.topicExchange((String)this.exchangeName).durable(true).build();
    }

    @Bean(name={"PUSH_MESSAGE_QUEUE"})
    public Queue queue() {
        return new Queue(this.queueName, true);
    }

    @Bean
    public Binding binding(@Qualifier(value="PUSH_MESSAGE_EXCHANGE") Exchange exchange, @Qualifier(value="PUSH_MESSAGE_QUEUE") Queue queue) {
        return BindingBuilder.bind((Queue)queue).to(exchange).with(LISTEN_KEY).noargs();
    }
}

