/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.controller;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.push.pojo.alisms.AliSmsSendAuthCodeReqPhoneVO;
import com.ebaiyihui.push.pojo.sms.SmsSendAuthCodeRsp;
import com.ebaiyihui.push.pojo.sms.SmsVerifiAuthCodeReqVO;
import com.ebaiyihui.push.sms.service.IAliSmsService;
import com.ebaiyihui.push.sms.service.ISmsService;
import com.ebaiyihui.push.umeng.pojo.bo.ValidationResultBO;
import com.ebaiyihui.push.utils.ParamsValidationUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/alismsapi"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"\u963f\u91cc\u77ed\u4fe1\u63a8\u9001"})
public class AliSmsController {
    private static final Logger log = LoggerFactory.getLogger(AliSmsController.class);
    @Autowired
    private IAliSmsService aliSmsService;
    @Autowired
    private ISmsService smsService;

    @ApiOperation(value="\u4f7f\u7528\u963f\u91cc\u77ed\u4fe1\u670d\u52a1\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801(\u4f20\u624b\u673a\u53f7)", httpMethod="POST", notes="\u4f7f\u7528\u963f\u91cc\u77ed\u4fe1\u670d\u52a1\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801(\u4f20\u624b\u673a\u53f7)")
    @ApiImplicitParam(name="reqVO", value="\u4f7f\u7528\u963f\u91cc\u77ed\u4fe1\u670d\u52a1\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801(\u4f20\u624b\u673a\u53f7)", required=true, dataType="AliSmsSendAuthCodeReqPhoneVO")
    @RequestMapping(value={"/sendAuthCodeWithPhone"}, method={RequestMethod.POST})
    public BaseResponse<SmsSendAuthCodeRsp> sendAuthCodeWithPhone(@RequestBody AliSmsSendAuthCodeReqPhoneVO reqVO) {
        log.info("sendAuthCodeWithPhone param =" + JSON.toJSONString((Object)reqVO));
        return this.aliSmsService.sendAuthCodeWithPhone(reqVO);
    }

    @ApiOperation(value="\u65b0\u7248\u4f7f\u7528\u963f\u91cc\u77ed\u4fe1\u670d\u52a1\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801(\u4f20\u624b\u673a\u53f7)", httpMethod="POST", notes="\u65b0\u7248\u4f7f\u7528\u963f\u91cc\u77ed\u4fe1\u670d\u52a1\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801(\u4f20\u624b\u673a\u53f7)")
    @ApiImplicitParam(name="reqVO", value="\u65b0\u7248\u4f7f\u7528\u963f\u91cc\u77ed\u4fe1\u670d\u52a1\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801(\u4f20\u624b\u673a\u53f7)", required=true, dataType="AliSmsSendAuthCodeReqPhoneVO")
    @RequestMapping(value={"/sendAuthCodeWithPhoneV2"}, method={RequestMethod.POST})
    public BaseResponse<SmsSendAuthCodeRsp> sendAuthCodeWithPhoneV2(@RequestBody AliSmsSendAuthCodeReqPhoneVO reqVO) {
        log.info("sendAuthCodeWithPhoneV2 param =" + JSON.toJSONString((Object)reqVO));
        return this.aliSmsService.sendAuthCodeWithPhoneV2(reqVO);
    }

    @ApiOperation(value="\u9a8c\u8bc1\u963f\u91cc\u77ed\u4fe1\u9a8c\u8bc1\u7801\u63a5\u53e3", httpMethod="POST", notes="\u9a8c\u8bc1\u963f\u91cc\u77ed\u4fe1\u9a8c\u8bc1\u7801\u63a5\u53e3")
    @ApiImplicitParam(name="reqVO", value="\u9a8c\u8bc1\u77ed\u4fe1\u9a8c\u8bc1\u7801\u63a5\u53e3", required=true, dataType="SmsVerifiAuthCodeReqVO")
    @RequestMapping(value={"/verifialismsauthcode"}, method={RequestMethod.POST})
    public BaseResponse<?> verfiAliAuthCode(@RequestBody SmsVerifiAuthCodeReqVO reqVO) {
        log.info("verfiAliAuthCode param =" + JSON.toJSONString((Object)reqVO));
        ValidationResultBO validateBo = ParamsValidationUtils.validateEntity((Object)reqVO);
        if (validateBo.isHasErrors()) {
            return BaseResponse.error((String)validateBo.getErrorMsg().toString());
        }
        return this.smsService.verifySmsAuthCode(reqVO);
    }

    @GetMapping(value={"/get_auth_code"})
    public BaseResponse<?> getAuthCode(@RequestParam(value="phone") String phone) {
        log.info("get authCode param =" + phone);
        return this.smsService.getAuthKey(phone);
    }

    @GetMapping(value={"/black_list/edit"})
    public BaseResponse<?> editBlackList(@RequestParam(value="phone") String phone, @RequestParam(value="type") String type) {
        log.info("editBlackList param  phone=" + phone + ",type=" + type);
        return this.smsService.editBlackList(phone, type);
    }

    @GetMapping(value={"configSms"})
    public BaseResponse<?> configSms(@RequestParam(value="appCode") String appCode, @RequestParam(value="name") String name, @RequestParam String appid, @RequestParam String secret) {
        this.smsService.configSms(appCode, name, appid, secret);
        return BaseResponse.success();
    }

    @GetMapping(value={"deleteAppCode"})
    public BaseResponse<?> deleteAppCode(@RequestParam(value="appCode") String appCode) {
        this.smsService.deleteAppCode(appCode);
        return BaseResponse.success();
    }
}

