/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.controller;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.push.mail.service.SendService;
import com.ebaiyihui.push.pojo.MailVerificationVO;
import com.ebaiyihui.push.pojo.MailWithTemplateVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mail"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"\u90ae\u4ef6\u63a8\u9001"})
public class MailController {
    private static final Logger log = LoggerFactory.getLogger(MailController.class);
    @Autowired
    private SendService sendService;

    @ApiOperation(value="\u53d1\u9001\u6a21\u677f\u90ae\u4ef6", httpMethod="POST", notes="\u53d1\u9001\u6a21\u677f\u90ae\u4ef6")
    @ApiImplicitParam(name="reqVO", value="\u53d1\u9001\u90ae\u4ef6", required=true, dataType="MailWithTemplateVO")
    @RequestMapping(value={"/send"}, method={RequestMethod.POST})
    public BaseResponse<?> sendWithTemplate(@RequestBody @Validated MailWithTemplateVO reqVO, BindingResult result) {
        log.info("sendWithTemplate email  param =" + JSON.toJSONString((Object)reqVO));
        if (result.hasErrors()) {
            return BaseResponse.error((String)result.getFieldError().getDefaultMessage());
        }
        return this.sendService.sendWithTemplate(reqVO);
    }

    @ApiOperation(value="\u9a8c\u8bc1\u90ae\u4ef6", httpMethod="POST", notes="\u9a8c\u8bc1\u90ae\u4ef6")
    @ApiImplicitParam(name="reqVO", value="\u9a8c\u8bc1\u90ae\u4ef6", required=true, dataType="MailVerificationVO")
    @RequestMapping(value={"/verify"}, method={RequestMethod.POST})
    public BaseResponse<?> verify(@RequestBody @Validated MailVerificationVO reqVO, BindingResult result) {
        log.info("verify email  param =" + JSON.toJSONString((Object)reqVO));
        if (result.hasErrors()) {
            return BaseResponse.error((String)result.getFieldError().getDefaultMessage());
        }
        return this.sendService.verify(reqVO);
    }
}

