/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.controller;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.push.miniapp.pojo.MiniAppInfo;
import com.ebaiyihui.push.miniapp.pojo.MiniAppMsgTmp;
import com.ebaiyihui.push.miniapp.service.MiniappService;
import com.ebaiyihui.push.miniapp.wechat.service.WxMiniappServiceImpl;
import com.ebaiyihui.push.pojo.miniapp.MiniappTmpMsgReqVO;
import com.ebaiyihui.push.pojo.wechat.GetTokenReqVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u6d88\u606f\u63a8\u9001 \u76f8\u5173\u64cd\u4f5c"})
@RestController
@RequestMapping(value={"/miniAppMsg"}, produces={"application/json;charset=UTF-8"})
public class MiniAppMsgController {
    private static final Logger log = LoggerFactory.getLogger(MiniAppMsgController.class);
    @Autowired
    private MiniappService miniappServiceImpl;
    @Autowired
    private WxMiniappServiceImpl wxminiAppServiceImpl;

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u6d88\u606f\u63a8\u9001\u63a5\u53e3", httpMethod="POST", notes="\u5fae\u4fe1\u8ba2\u9605\u6d88\u606f\u63a8\u9001\u63a5\u53e3")
    @ApiImplicitParam(name="reqVO", value="\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u6d88\u606f\u63a8\u9001\u63a5\u53e3", required=true, dataType="MiniappTmpMsgReqVO")
    @PostMapping(value={"/msg_push"})
    public BaseResponse<?> pushSubscribeMessage(@RequestBody MiniappTmpMsgReqVO reqVO) {
        log.info("pushSubscribeMessage param = {}", (Object)reqVO);
        return this.miniappServiceImpl.pushSubscribeMessage(reqVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u5fae\u4fe1AccessToken", httpMethod="POST", notes="\u83b7\u53d6\u5fae\u4fe1AccessToken")
    @ApiImplicitParam(name="reqVO", value="\u83b7\u53d6\u5fae\u4fe1AccessToken", required=true, dataType="GetTokenReqVO")
    @PostMapping(value={"/get_access_token"})
    public BaseResponse<?> getAccessToken(@RequestBody GetTokenReqVO reqVO) {
        log.info("getAccessToken param = {}", (Object)JSONObject.toJSONString((Object)reqVO));
        return this.wxminiAppServiceImpl.getAccessToken(reqVO);
    }

    @PostMapping(value={"/subscribe_template_get"})
    public BaseResponse<List<Map<String, Object>>> getSubscribeTemplate(@RequestBody GetTokenReqVO reqVO) {
        log.info("getSubscribeTemplate param = {}", (Object)JSONObject.toJSONString((Object)reqVO));
        List res = this.miniappServiceImpl.getTmpByAppCode(reqVO.getClientCode());
        return BaseResponse.success((Object)res);
    }

    @GetMapping(value={"/check_health"})
    public BaseResponse<?> checkHealth() {
        return this.wxminiAppServiceImpl.checkHealth();
    }

    @PostMapping(value={"/saveMiniapp"})
    public BaseResponse<?> saveMiniapp(@RequestBody MiniAppInfo miniAppInfo) {
        boolean b = this.miniappServiceImpl.saveMiniapp(miniAppInfo);
        return b ? BaseResponse.success() : BaseResponse.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @PostMapping(value={"/saveMiniappMsgTmp"})
    public BaseResponse<?> saveMiniappMsgTmp(@RequestBody MiniAppMsgTmp miniAppMsgTmp) {
        boolean b = this.miniappServiceImpl.saveMiniappMsgTmp(miniAppMsgTmp);
        return b ? BaseResponse.success() : BaseResponse.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }
}

