/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.interceptor;

import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class LogInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(LogInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String serverName = request.getServerName();
        String requestURI = request.getRequestURI();
        Enumeration parameterNames = request.getParameterNames();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        while (parameterNames.hasMoreElements()) {
            String key = (String)parameterNames.nextElement();
            String value = request.getParameter(key);
            paramMap.put(key, value);
        }
        log.info("===domain===:{}===URI===:{}===params===:{}", new Object[]{serverName, requestURI, ((Object)paramMap).toString()});
        return super.preHandle(request, response, handler);
    }
}

