/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.mail.business;

import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class Mail {
    private static final Logger log = LoggerFactory.getLogger(Mail.class);
    private String from;
    private String subject;
    private String mailAddress;
    private String content;
    private Boolean isHtml;
    private String alias;

    public Mail() {
    }

    public Mail(String from, String subject, String mailAddress, String content, Boolean isHtml, String alias) {
        this.from = from;
        this.subject = subject;
        this.mailAddress = mailAddress;
        this.content = content;
        this.isHtml = isHtml;
        this.alias = alias;
    }

    public void launcherSend(JavaMailSenderImpl javaMailSender) {
        try {
            MimeMessage msg = javaMailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(msg, true);
            String nick = MimeUtility.encodeText((String)this.alias);
            helper.setFrom(new InternetAddress(nick + " <" + this.from + ">"));
            helper.setTo(this.mailAddress);
            helper.setSubject(this.subject);
            helper.setText(this.content, this.isHtml.booleanValue());
            javaMailSender.send(msg);
        }
        catch (Exception e) {
            log.error("launcherSend error,e=", (Throwable)e);
        }
    }
}

