/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.mail.service;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.push.mail.dao.MailRecordMapper;
import com.ebaiyihui.push.mail.dao.MailTemplateMapper;
import com.ebaiyihui.push.mail.pojo.entity.MailRecordEntity;
import com.ebaiyihui.push.mail.pojo.entity.MailTemplateEntity;
import com.ebaiyihui.push.mail.pojo.vo.SendResVO;
import com.ebaiyihui.push.mail.service.SendService;
import com.ebaiyihui.push.pojo.MailVerificationVO;
import com.ebaiyihui.push.pojo.MailWithTemplateVO;
import com.ebaiyihui.push.sms.enums.SmsNotificationEnum;
import com.ebaiyihui.push.utils.FreemarkerUtil;
import com.ebaiyihui.push.utils.MessageUtils;
import com.ebaiyihui.push.utils.RandomUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class SendServiceImpl
implements SendService {
    private static final Logger log = LoggerFactory.getLogger(SendServiceImpl.class);
    @Autowired
    private MailTemplateMapper mailTemplateMapper;
    @Autowired
    private MailRecordMapper mailRecordMapper;
    @Autowired
    private RedisTemplate redisTemplate;
    private long effTime = 600000L;
    private static ExecutorService executorService = Executors.newSingleThreadExecutor();

    public BaseResponse sendWithTemplate(MailWithTemplateVO reqVO) {
        String authKey = RandomUtils.getRandom8Length().toUpperCase();
        try {
            MailTemplateEntity mailTemplateEntity = this.mailTemplateMapper.selectOne(reqVO.getBusinessCode());
            Map param = reqVO.getParam();
            String authCode = RandomUtils.getRandom8Length().toUpperCase();
            this.addParam(param, authCode);
            String content = FreemarkerUtil.parseTpl((String)mailTemplateEntity.getPath(), (Map)param);
            this.send(reqVO, content, true);
            this.redisTemplate.opsForHash().put((Object)authKey, (Object)reqVO.getMailAddress(), (Object)authCode);
            this.redisTemplate.expire((Object)authKey, this.effTime, TimeUnit.MILLISECONDS);
            MailRecordEntity mailRecordEntity = this.getMailRecordEntity(reqVO);
            mailRecordEntity.setAuthCode(authCode);
            mailRecordEntity.setAuthKey(authKey);
            this.saveRecord(mailRecordEntity);
        }
        catch (Exception e) {
            log.error("send email error,e=", (Throwable)e);
            return BaseResponse.error((String)"send email error");
        }
        SendResVO sendResVO = this.getSendResVO(authKey);
        return BaseResponse.success((Object)sendResVO);
    }

    private SendResVO getSendResVO(String authKey) {
        SendResVO sendResVO = new SendResVO();
        sendResVO.setAuthKey(authKey);
        return sendResVO;
    }

    public BaseResponse<?> verify(MailVerificationVO reqVO) {
        String authKey = reqVO.getAuthKey();
        String authCode = reqVO.getAuthCode();
        String mailAddress = reqVO.getMailAddress();
        if (this.redisTemplate.opsForHash().hasKey((Object)authKey, (Object)mailAddress).booleanValue()) {
            String authCodeCache = this.redisTemplate.opsForHash().get((Object)authKey, (Object)mailAddress).toString();
            log.info("get authCodeCache=" + authCodeCache);
            try {
                if (authCode.equals(authCodeCache)) {
                    this.redisTemplate.delete((Object)authKey);
                    log.info("delete mail authCode!");
                    return BaseResponse.success();
                }
            }
            catch (Exception e) {
                log.error("verify authCode error,e=", (Throwable)e);
            }
        }
        return BaseResponse.error((String)MessageUtils.get((String)SmsNotificationEnum.ENTER_CORRECT_VERIFICATION_CODE.name()));
    }

    private MailRecordEntity getMailRecordEntity(MailWithTemplateVO reqVO) {
        MailRecordEntity mailRecordEntity = new MailRecordEntity();
        mailRecordEntity.setBusinessCode(reqVO.getBusinessCode());
        mailRecordEntity.setParam(JSONObject.toJSONString((Object)reqVO.getParam()));
        mailRecordEntity.setMailAddress(reqVO.getMailAddress());
        mailRecordEntity.setSubject(reqVO.getSubject());
        return mailRecordEntity;
    }

    private void send(MailWithTemplateVO reqVO, String content, boolean isHtml) {
    }

    private void saveRecord(MailRecordEntity mailRecordEntity) {
        this.mailRecordMapper.insertOne(mailRecordEntity);
    }

    private void addParam(Map<String, Object> param, String authCode) {
        if (param == null) {
            param = new LinkedHashMap<String, Object>();
        }
        param.put("code", authCode);
    }
}

