/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.miniapp.service.impl;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.push.miniapp.alipay.service.AliMiniServiceImpl;
import com.ebaiyihui.push.miniapp.pojo.MiniAppInfo;
import com.ebaiyihui.push.miniapp.pojo.MiniAppMsgTmp;
import com.ebaiyihui.push.miniapp.service.MiniAppInfoService;
import com.ebaiyihui.push.miniapp.service.MiniAppMsgTmpService;
import com.ebaiyihui.push.miniapp.service.MiniappService;
import com.ebaiyihui.push.miniapp.wechat.service.WxMiniappServiceImpl;
import com.ebaiyihui.push.pojo.miniapp.MiniappTmpMsgReqVO;
import com.ebaiyihui.push.utils.SpringContextHolder;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MiniappServiceImpl
implements MiniappService {
    private static final Logger log = LoggerFactory.getLogger(MiniappServiceImpl.class);
    private final MiniAppInfoService miniAppInfoServiceImpl;
    private final MiniAppMsgTmpService miniAppMsgTmpServiceImpl;

    public BaseResponse<?> pushSubscribeMessage(MiniappTmpMsgReqVO reqVO) {
        String platform;
        switch (platform = reqVO.getPlatform()) {
            case "wx": {
                WxMiniappServiceImpl wx = (WxMiniappServiceImpl)SpringContextHolder.getBean(WxMiniappServiceImpl.class);
                return wx.pushSubscribeMessage(reqVO);
            }
            case "alipay": {
                AliMiniServiceImpl ali = (AliMiniServiceImpl)SpringContextHolder.getBean(AliMiniServiceImpl.class);
                return ali.pushSubscribeMessage(reqVO);
            }
        }
        throw new IllegalStateException("Unexpected value: " + platform);
    }

    public boolean saveMiniapp(MiniAppInfo miniAppInfo) {
        miniAppInfo.setEnabled(Integer.valueOf(1));
        miniAppInfo.setGrantType("client_credential");
        return this.miniAppInfoServiceImpl.save(miniAppInfo);
    }

    public boolean saveMiniappMsgTmp(MiniAppMsgTmp miniAppInfo) {
        return this.miniAppMsgTmpServiceImpl.save(miniAppInfo);
    }

    public List<Map<String, Object>> getTmpByAppCode(String clientCode) {
        MiniAppInfo byAppCode = this.miniAppInfoServiceImpl.getByAppCode(clientCode);
        return this.miniAppMsgTmpServiceImpl.selListByAppId(byAppCode.getId());
    }

    public MiniappServiceImpl(MiniAppInfoService miniAppInfoServiceImpl, MiniAppMsgTmpService miniAppMsgTmpServiceImpl) {
        this.miniAppInfoServiceImpl = miniAppInfoServiceImpl;
        this.miniAppMsgTmpServiceImpl = miniAppMsgTmpServiceImpl;
    }
}

