/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.miniapp.wechat.manager;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.push.miniapp.wechat.pojo.bo.BaseResBO;
import com.ebaiyihui.push.miniapp.wechat.pojo.bo.GetTokenResBO;
import com.ebaiyihui.push.miniapp.wechat.utils.RedisUtil;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;
import redis.clients.jedis.JedisCluster;

public class WechatMessage {
    private static final Logger log = LoggerFactory.getLogger(WechatMessage.class);
    private static final JedisCluster jedisCluster = RedisUtil.getJedis();

    public static GetTokenResBO getAccessTokenFromDB(String appId, String appSecret, String clientCode) {
        RestTemplate restTemplate = new RestTemplate();
        String accessTokenUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appId=" + appId + "&secret=" + appSecret;
        String result = (String)restTemplate.getForObject(accessTokenUrl, String.class, new Object[0]);
        GetTokenResBO wechatGetTokenResBo = (GetTokenResBO)JSONObject.parseObject((String)result, GetTokenResBO.class);
        log.info("WechatGetTokenResBo: " + JSONObject.toJSONString((Object)wechatGetTokenResBo));
        if (Objects.nonNull(wechatGetTokenResBo) && Objects.isNull(wechatGetTokenResBo.getErrcode())) {
            String redisTokenKey = clientCode + "_" + "wechat_access_token";
            RedisUtil.setDataAndExpired((String)redisTokenKey, (String)wechatGetTokenResBo.getAccessToken(), (int)wechatGetTokenResBo.getExpiresIn());
        }
        return wechatGetTokenResBo;
    }

    public static String getAccessTokenFromCache(String clientCode) {
        String redisKey = clientCode + "_" + "wechat_access_token";
        boolean flag = jedisCluster.exists(redisKey);
        if (flag) {
            return jedisCluster.get(redisKey);
        }
        return null;
    }

    public static <T> BaseResBO push(T t, String accessToken, String url) {
        RestTemplate restTemplate = new RestTemplate();
        String pushUrl = url + accessToken;
        String pushData = JSONObject.toJSONString(t);
        log.info("push data ={}", (Object)pushData);
        pushData = new String(pushData.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
        return (BaseResBO)restTemplate.postForObject(pushUrl, (Object)pushData, BaseResBO.class, new Object[0]);
    }
}

