/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.miniapp.wechat.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.push.miniapp.pojo.MiniAppInfo;
import com.ebaiyihui.push.miniapp.pojo.MiniAppMsgRecord;
import com.ebaiyihui.push.miniapp.pojo.MiniAppMsgTmp;
import com.ebaiyihui.push.miniapp.service.MiniAppInfoService;
import com.ebaiyihui.push.miniapp.service.MiniAppMsgRecordService;
import com.ebaiyihui.push.miniapp.service.MiniAppMsgTmpService;
import com.ebaiyihui.push.miniapp.wechat.dao.WxPushApplicationMapper;
import com.ebaiyihui.push.miniapp.wechat.dao.WxPushHistoryMapper;
import com.ebaiyihui.push.miniapp.wechat.dao.WxPushTemplateMapper;
import com.ebaiyihui.push.miniapp.wechat.enums.PushDataKeyEnum;
import com.ebaiyihui.push.miniapp.wechat.enums.ResultEnum;
import com.ebaiyihui.push.miniapp.wechat.enums.WxNotificationEnum;
import com.ebaiyihui.push.miniapp.wechat.manager.WechatMessage;
import com.ebaiyihui.push.miniapp.wechat.pojo.bo.BaseResBO;
import com.ebaiyihui.push.miniapp.wechat.pojo.bo.GetTokenResBO;
import com.ebaiyihui.push.miniapp.wechat.pojo.bo.TemplateMessageBO;
import com.ebaiyihui.push.miniapp.wechat.pojo.entity.SubMsgApp;
import com.ebaiyihui.push.miniapp.wechat.pojo.entity.SubMsgHis;
import com.ebaiyihui.push.miniapp.wechat.service.WxMiniappService;
import com.ebaiyihui.push.pojo.miniapp.MiniappTmpMsgReqVO;
import com.ebaiyihui.push.pojo.wechat.GetTokenReqVO;
import com.ebaiyihui.push.pojo.wechat.PushTemplateMessageReqVO;
import com.ebaiyihui.push.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WxMiniappServiceImpl
implements WxMiniappService {
    private static final Logger log = LoggerFactory.getLogger(WxMiniappServiceImpl.class);
    @Autowired
    private WxPushApplicationMapper wxPushApplicationMapper;
    @Autowired
    private WxPushTemplateMapper wxPushTemplateMapper;
    @Autowired
    private WxPushHistoryMapper wxPushHistoryMapper;
    @Autowired
    private MiniAppInfoService miniAppInfoServiceImpl;
    @Autowired
    private MiniAppMsgTmpService miniAppMsgTmpServiceImpl;
    @Autowired
    private MiniAppMsgRecordService miniAppMsgRecordServiceImpl;

    public BaseResponse<?> getAccessToken(GetTokenReqVO getTokenReqVO) {
        GetTokenResBO getTokenResBO = this.getGetTokenResBO(getTokenReqVO.getClientCode());
        if (getTokenResBO.getErrcode() == null) {
            return BaseResponse.success((Object)getTokenResBO.getAccessToken());
        }
        return BaseResponse.error((String)JSONObject.toJSONString((Object)getTokenResBO));
    }

    public BaseResponse<?> pushSubscribeMessage(MiniappTmpMsgReqVO req) {
        log.info("pushSubscribeMessage ={}", (Object)req);
        String clientCode = req.getGetTokenReqVO().getClientCode();
        MiniAppInfo appinfo = this.miniAppInfoServiceImpl.getByAppCode(clientCode);
        GetTokenResBO getTokenResBO = this.getGetTokenResBO(clientCode);
        MiniAppMsgTmp tmp = this.miniAppMsgTmpServiceImpl.getOneByTmpCodeAndAppId(req.getTemplateCode(), appinfo.getId());
        log.info("template info={},data={}", (Object)tmp, (Object)req.getData());
        this.transformData(tmp, req);
        TemplateMessageBO templateMessageBO = this.initSubscribeParam(req, tmp.getTmpId());
        log.info("wx push subscribMessage req param={}", (Object)templateMessageBO);
        BaseResBO baseResBO = WechatMessage.push((Object)templateMessageBO, (String)getTokenResBO.getAccessToken(), (String)"https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token=");
        log.info("wx push subscribMessage res data={}", (Object)JSONObject.toJSONString((Object)baseResBO));
        MiniAppMsgRecord a = new MiniAppMsgRecord();
        a.setAppId(appinfo.getId());
        a.setTmpId(tmp.getId());
        a.setToUserId(req.getOpenId());
        a.setPushParams(JSON.toJSONString((Object)req));
        a.setPushRes(JSON.toJSONString((Object)baseResBO));
        this.miniAppMsgRecordServiceImpl.save(a);
        if (baseResBO.getErrcode() == 0) {
            return BaseResponse.success((Object)baseResBO);
        }
        return BaseResponse.error((String)baseResBO.getErrmsg());
    }

    public BaseResponse<?> getSubscribeTemplate(String clientCode) {
        try {
            MiniAppInfo byAppCode = this.miniAppInfoServiceImpl.getByAppCode(clientCode);
            if (byAppCode == null) {
                return BaseResponse.error((String)("this application is not exists,clientCode=" + clientCode));
            }
            List maps = this.miniAppMsgTmpServiceImpl.selListByAppId(byAppCode.getId());
            return BaseResponse.success((Object)maps);
        }
        catch (Exception e) {
            log.error("getSubscribeTemplate error,e=", (Throwable)e);
            return BaseResponse.error((String)MessageUtils.get((String)WxNotificationEnum.GET_PUSH_TEMPLATE_ERROR.name()));
        }
    }

    public BaseResponse<?> checkHealth() {
        try {
            SubMsgApp subMsgApp = this.wxPushApplicationMapper.selectByClientCode("server_finished_notify");
            if (subMsgApp == null) {
                return BaseResponse.error((String)"this application is not exists,clientCode=server_finished_notify");
            }
            return BaseResponse.success((Object)this.wxPushTemplateMapper.selectList(subMsgApp.getId()));
        }
        catch (Exception e) {
            log.error("getSubscribeTemplate error,e=", (Throwable)e);
            return BaseResponse.error((String)MessageUtils.get((String)WxNotificationEnum.GET_PUSH_TEMPLATE_ERROR.name()));
        }
    }

    private void transformData(MiniAppMsgTmp subMsgTmp, MiniappTmpMsgReqVO req) {
        LinkedHashMap resultMap = new LinkedHashMap();
        ArrayList<String> templateParamList = new ArrayList<String>(Arrays.asList(subMsgTmp.getTmpContent().split(",")));
        Map dataMap = req.getData();
        for (int i = 0; i < templateParamList.size(); ++i) {
            Iterator iterator = dataMap.entrySet().iterator();
            if (!iterator.hasNext()) continue;
            Map.Entry entry = iterator.next();
            resultMap.put(templateParamList.get(i), entry.getValue());
            dataMap.remove(entry.getKey());
        }
        req.setData(resultMap);
        log.info("subscribe data ={}", resultMap);
    }

    private TemplateMessageBO initSubscribeParam(MiniappTmpMsgReqVO reqVO, String templateId) {
        TemplateMessageBO templateMessageBO = new TemplateMessageBO();
        templateMessageBO.setTouser(reqVO.getOpenId());
        templateMessageBO.setData(reqVO.getData());
        templateMessageBO.setPage(reqVO.getPage());
        templateMessageBO.setTemplate_id(templateId);
        templateMessageBO.setLang(reqVO.getLang());
        return templateMessageBO;
    }

    private GetTokenResBO getMsgAccessToken(String clientCode) {
        String accessToken = WechatMessage.getAccessTokenFromCache((String)clientCode);
        if (accessToken != null) {
            return new GetTokenResBO(accessToken);
        }
        return this.getGetTokenResBO(clientCode);
    }

    private GetTokenResBO getGetTokenResBO(String clientCode) {
        MiniAppInfo subMsgApp = this.miniAppInfoServiceImpl.getByAppCode(clientCode);
        return WechatMessage.getAccessTokenFromDB((String)subMsgApp.getAppid(), (String)subMsgApp.getSecret(), (String)clientCode);
    }

    private <T> SubMsgHis buildMsgHistory(T t, TemplateMessageBO templateMessageBO, MiniAppMsgTmp subMsgTmp, BaseResBO baseResBO) {
        SubMsgHis subMsgHis = new SubMsgHis();
        subMsgHis.setOpenId(templateMessageBO.getTouser());
        subMsgHis.setTempFkId(subMsgTmp.getId());
        subMsgHis.setWxPushParam(JSONObject.toJSONString(t));
        Integer errCode = baseResBO.getErrcode();
        if (errCode == 0) {
            subMsgHis.setWxPushStatus(ResultEnum.SUCCESS.toString().toLowerCase());
        } else {
            subMsgHis.setWxPushStatus(ResultEnum.ERROR.toString().toLowerCase());
        }
        subMsgHis.setWxErrcode(baseResBO.getErrcode().toString());
        subMsgHis.setWxErrmsg(baseResBO.getErrmsg());
        return subMsgHis;
    }

    private void initPushParams(TemplateMessageBO templateMessageBO, PushTemplateMessageReqVO templateMessageReqVO) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(templateMessageReqVO.getParams().split(",")));
        LinkedHashMap map = new LinkedHashMap();
        for (int i = 0; i < list.size(); ++i) {
            HashMap valueMap = new HashMap();
            valueMap.put(PushDataKeyEnum.VALUE.getName(), list.get(i));
            int num = i + 1;
            map.put("keyword" + num, valueMap);
        }
        templateMessageBO.setData(map);
    }
}

