/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.miniapp.wechat.utils;

import com.ebaiyihui.push.miniapp.wechat.config.EnvironmentAlone;
import java.util.HashSet;
import java.util.Set;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;

public class RedisUtil {
    private static JedisCluster jedisCluster = new JedisCluster(RedisUtil.getNodes());

    private static Set<HostAndPort> getNodes() {
        String nodes = EnvironmentAlone.getInstance().getEnvironmentParam("spring.redis.cluster.nodes");
        String[] serverArray = nodes.split(",");
        HashSet<HostAndPort> nodeSet = new HashSet<HostAndPort>();
        for (String ipPort : serverArray) {
            String[] ipPortPair = ipPort.split(":");
            nodeSet.add(new HostAndPort(ipPortPair[0].trim(), Integer.valueOf(ipPortPair[1].trim()).intValue()));
        }
        return nodeSet;
    }

    public static JedisCluster getJedis() {
        return jedisCluster;
    }

    public static void setDataAndExpired(String key, String data, int expiredTime) {
        jedisCluster.set(key, data);
        jedisCluster.expire(key, expiredTime);
    }
}

