/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.push.umeng.pojo.bo;

import com.ebaiyihui.push.umeng.pojo.bo.AndroidNotification;
import com.ebaiyihui.push.umeng.pojo.bo.UmengNotification;
import java.util.Arrays;
import java.util.HashSet;
import org.json.JSONObject;

public abstract class AndroidNotification
extends UmengNotification {
    protected static final HashSet<String> PAYLOAD_KEYS = new HashSet<String>(Arrays.asList("display_type"));
    protected static final HashSet<String> BODY_KEYS = new HashSet<String>(Arrays.asList("ticker", "title", "text", "builder_id", "icon", "largeIcon", "img", "play_vibrate", "play_lights", "play_sound", "sound", "after_open", "url", "activity", "custom"));

    public boolean setPredefinedKeyValue(String key, Object value) throws Exception {
        if (ROOT_KEYS.contains(key)) {
            this.rootJson.put(key, value);
        } else if (PAYLOAD_KEYS.contains(key)) {
            JSONObject payloadJson = null;
            if (this.rootJson.has("payload")) {
                payloadJson = this.rootJson.getJSONObject("payload");
            } else {
                payloadJson = new JSONObject();
                this.rootJson.put("payload", (Object)payloadJson);
            }
            payloadJson.put(key, value);
        } else if (BODY_KEYS.contains(key)) {
            JSONObject bodyJson = null;
            JSONObject payloadJson = null;
            if (this.rootJson.has("payload")) {
                payloadJson = this.rootJson.getJSONObject("payload");
            } else {
                payloadJson = new JSONObject();
                this.rootJson.put("payload", (Object)payloadJson);
            }
            if (payloadJson.has("body")) {
                bodyJson = payloadJson.getJSONObject("body");
            } else {
                bodyJson = new JSONObject();
                payloadJson.put("body", (Object)bodyJson);
            }
            bodyJson.put(key, value);
        } else if (POLICY_KEYS.contains(key)) {
            JSONObject policyJson = null;
            if (this.rootJson.has("policy")) {
                policyJson = this.rootJson.getJSONObject("policy");
            } else {
                policyJson = new JSONObject();
                this.rootJson.put("policy", (Object)policyJson);
            }
            policyJson.put(key, value);
        } else {
            if (key == "payload" || key == "body" || key == "policy" || key == "extra") {
                throw new Exception("You don't need to set value for " + key + " , just set values for the sub keys in it.");
            }
            throw new Exception("Unknown key: " + key);
        }
        return true;
    }

    public boolean setExtraField(String key, String value) throws Exception {
        JSONObject payloadJson = null;
        JSONObject extraJson = null;
        if (this.rootJson.has("payload")) {
            payloadJson = this.rootJson.getJSONObject("payload");
        } else {
            payloadJson = new JSONObject();
            this.rootJson.put("payload", (Object)payloadJson);
        }
        if (payloadJson.has("extra")) {
            extraJson = payloadJson.getJSONObject("extra");
        } else {
            extraJson = new JSONObject();
            payloadJson.put("extra", (Object)extraJson);
        }
        extraJson.put(key, (Object)value);
        return true;
    }

    public void setDisplayType(DisplayType d) throws Exception {
        this.setPredefinedKeyValue("display_type", (Object)d.getValue());
    }

    public void setTicker(String ticker) throws Exception {
        this.setPredefinedKeyValue("ticker", (Object)ticker);
    }

    public void setTitle(String title) throws Exception {
        this.setPredefinedKeyValue("title", (Object)title);
    }

    public void setText(String text) throws Exception {
        this.setPredefinedKeyValue("text", (Object)text);
    }

    public void setBuilderId(Integer builder_id) throws Exception {
        this.setPredefinedKeyValue("builder_id", (Object)builder_id);
    }

    public void setIcon(String icon) throws Exception {
        this.setPredefinedKeyValue("icon", (Object)icon);
    }

    public void setLargeIcon(String largeIcon) throws Exception {
        this.setPredefinedKeyValue("largeIcon", (Object)largeIcon);
    }

    public void setImg(String img) throws Exception {
        this.setPredefinedKeyValue("img", (Object)img);
    }

    public void setPlayVibrate(Boolean play_vibrate) throws Exception {
        this.setPredefinedKeyValue("play_vibrate", (Object)play_vibrate.toString());
    }

    public void setPlayLights(Boolean play_lights) throws Exception {
        this.setPredefinedKeyValue("play_lights", (Object)play_lights.toString());
    }

    public void setPlaySound(Boolean play_sound) throws Exception {
        this.setPredefinedKeyValue("play_sound", (Object)play_sound.toString());
    }

    public void setSound(String sound) throws Exception {
        this.setPredefinedKeyValue("sound", (Object)sound);
    }

    public void setPlaySound(String sound) throws Exception {
        this.setPlaySound(Boolean.valueOf(true));
        this.setSound(sound);
    }

    public void goAppAfterOpen() throws Exception {
        this.setAfterOpenAction(AfterOpenAction.go_app);
    }

    public void goUrlAfterOpen(String url) throws Exception {
        this.setAfterOpenAction(AfterOpenAction.go_url);
        this.setUrl(url);
    }

    public void goActivityAfterOpen(String activity) throws Exception {
        this.setAfterOpenAction(AfterOpenAction.go_activity);
        this.setActivity(activity);
    }

    public void goCustomAfterOpen(String custom) throws Exception {
        this.setAfterOpenAction(AfterOpenAction.go_custom);
        this.setCustomField(custom);
    }

    public void goCustomAfterOpen(JSONObject custom) throws Exception {
        this.setAfterOpenAction(AfterOpenAction.go_custom);
        this.setCustomField(custom);
    }

    public void setAfterOpenAction(AfterOpenAction action) throws Exception {
        this.setPredefinedKeyValue("after_open", (Object)action.toString());
    }

    public void setUrl(String url) throws Exception {
        this.setPredefinedKeyValue("url", (Object)url);
    }

    public void setActivity(String activity) throws Exception {
        this.setPredefinedKeyValue("activity", (Object)activity);
    }

    public void setCustomField(String custom) throws Exception {
        this.setPredefinedKeyValue("custom", (Object)custom);
    }

    public void setCustomField(JSONObject custom) throws Exception {
        this.setPredefinedKeyValue("custom", (Object)custom);
    }
}

