/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.constant.ConfigurationConstant;
import com.ebaiyihui.service.entity.AccountEntity;
import com.ebaiyihui.service.entity.InitializeInfoEntity;
import com.ebaiyihui.service.entity.OrganInfoEntity;
import com.ebaiyihui.service.mapper.AccountMapper;
import com.ebaiyihui.service.mapper.InitializeInfoMapper;
import com.ebaiyihui.service.mapper.OrganInfoMapper;
import com.ebaiyihui.service.service.CallJmeterService;
import com.ebaiyihui.service.service.JobService;
import com.ebaiyihui.service.utils.RunSqlScript;
import com.ebaiyihui.service.utils.XmlTemplateKit;
import com.ebaiyihui.service.vo.CallJmeter;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CallJmeterServiceImpl
implements CallJmeterService {
    private static final Logger log = LoggerFactory.getLogger(CallJmeterServiceImpl.class);
    @Autowired
    private InitializeInfoMapper initializeInfoMapper;
    @Autowired
    private OrganInfoMapper organInfoMapper;
    @Autowired
    private JobService jobService;
    @Autowired
    private AccountMapper accountMapper;

    public BaseResponse<String> callJmeter(String appCode, Integer type) {
        OrganInfoEntity organInfoEntity = this.organInfoMapper.getListByAppCode(appCode, type);
        InitializeInfoEntity initializeInfoEntity = this.initializeInfoMapper.getById(organInfoEntity.getInitializeId());
        CallJmeter callJmeter = new CallJmeter();
        callJmeter.setDns(initializeInfoEntity.getDomainName());
        callJmeter.setAppCode(organInfoEntity.getAppCode());
        callJmeter.setOrganId(organInfoEntity.getOrganId().toString());
        callJmeter.setOrganName(organInfoEntity.getOrganName());
        callJmeter.setWebaccountNo(organInfoEntity.getAccountNo());
        callJmeter.setWebpassword(organInfoEntity.getWebPassword());
        XmlTemplateKit.init();
        HashMap<String, CallJmeter> map = new HashMap<String, CallJmeter>();
        log.info("==callJmeter==>{}", (Object)JSON.toJSONString((Object)callJmeter));
        map.put("callJmeter", callJmeter);
        String configServiceXml = XmlTemplateKit.processSql((String)"call_jmeter", map);
        if (StringUtils.isEmpty((CharSequence)configServiceXml)) {
            return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        try {
            RunSqlScript.writeToResource((String)configServiceXml, (String)"data.csv", (Integer)ConfigurationConstant.STATUS_VALID);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.createAccount(organInfoEntity.getType());
        this.jobService.callJmeter();
        return BaseResponse.success();
    }

    public BaseResponse<String> createAccount(Integer type) {
        AccountEntity accountEntity = this.accountMapper.getByType(type);
        XmlTemplateKit.init();
        HashMap<String, AccountEntity> map = new HashMap<String, AccountEntity>();
        log.info("==accountMapperById==>{}", (Object)JSON.toJSONString((Object)accountEntity));
        map.put("accountEntity", accountEntity);
        String configServiceXml = XmlTemplateKit.processSql((String)"super_name", map);
        if (StringUtils.isEmpty((CharSequence)configServiceXml)) {
            return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        try {
            RunSqlScript.writeToResource((String)configServiceXml, (String)"super_Name.csv", (Integer)ConfigurationConstant.STATUS_VALID);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return BaseResponse.success();
    }
}

