/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.config.RestConfiguration;
import com.ebaiyihui.service.constant.ConfigurationConstant;
import com.ebaiyihui.service.entity.ConfigurationFileEntity;
import com.ebaiyihui.service.entity.DeploymentSituationEntity;
import com.ebaiyihui.service.entity.InitializeInfoEntity;
import com.ebaiyihui.service.entity.JobServerIpEntity;
import com.ebaiyihui.service.entity.MonitoringInterfaceEntity;
import com.ebaiyihui.service.entity.NodeConfigurationEntity;
import com.ebaiyihui.service.entity.OrganInfoEntity;
import com.ebaiyihui.service.entity.PlatformInfoEntity;
import com.ebaiyihui.service.mapper.ConfigurationFileMapper;
import com.ebaiyihui.service.mapper.DeploymentSituationMapper;
import com.ebaiyihui.service.mapper.InitializeInfoMapper;
import com.ebaiyihui.service.mapper.JobServerIpMapper;
import com.ebaiyihui.service.mapper.MonitoringInterfaceMapper;
import com.ebaiyihui.service.mapper.NodeConfigurationMapper;
import com.ebaiyihui.service.mapper.OrganInfoMapper;
import com.ebaiyihui.service.mapper.PlatformInfoMapper;
import com.ebaiyihui.service.service.DeploymentSituationService;
import com.ebaiyihui.service.service.JobService;
import com.ebaiyihui.service.vo.ApplicationVo;
import com.ebaiyihui.service.vo.SaveAppInfoRequestVo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DeploymentSituationServiceImpl
implements DeploymentSituationService {
    private static final Logger log = LoggerFactory.getLogger(DeploymentSituationServiceImpl.class);
    @Autowired
    private DeploymentSituationMapper deploymentSituationMapper;
    @Autowired
    private InitializeInfoMapper initializeInfoMapper;
    @Autowired
    private MonitoringInterfaceMapper monitoringInterfaceMapper;
    @Autowired
    private JobService jobService;
    @Autowired
    private NodeConfigurationMapper nodeConfigurationMapper;
    @Autowired
    private ConfigurationFileMapper configurationFileMapper;
    @Autowired
    private JobServerIpMapper jobServerIpMapper;
    @Autowired
    private PlatformInfoMapper platformInfoMapper;
    @Autowired
    private OrganInfoMapper organInfoMapper;

    public BaseResponse<Integer> saveDeploymentSituation(NodeConfigurationEntity nodeConfigurationEntity, ConfigurationFileEntity configurationFileEntity) {
        DeploymentSituationEntity nodeIdAndFileId = this.deploymentSituationMapper.getByNodeIdAndFileId(nodeConfigurationEntity.getId(), configurationFileEntity.getId());
        if (nodeIdAndFileId == null) {
            DeploymentSituationEntity deploymentSituationEntity = new DeploymentSituationEntity();
            MonitoringInterfaceEntity monitoringInterfaceEntity = this.monitoringInterfaceMapper.getByFileId(configurationFileEntity.getId());
            if (monitoringInterfaceEntity != null) {
                deploymentSituationEntity.setNodeId(nodeConfigurationEntity.getId());
                deploymentSituationEntity.setNodeName(nodeConfigurationEntity.getNodeName());
                deploymentSituationEntity.setFileId(configurationFileEntity.getId());
                deploymentSituationEntity.setChineseNameService(configurationFileEntity.getChineseNameService());
                deploymentSituationEntity.setServiceName(configurationFileEntity.getProjectName());
                deploymentSituationEntity.setAppCode(nodeConfigurationEntity.getAppCode());
                InitializeInfoEntity initializeInfoEntity = this.initializeInfoMapper.getByAppCode(nodeConfigurationEntity.getAppCode(), nodeConfigurationEntity.getBelongs());
                deploymentSituationEntity.setDomainName(initializeInfoEntity.getDomainName());
                deploymentSituationEntity.setInterfaceUrl(monitoringInterfaceEntity.getInterfaceUrl());
                deploymentSituationEntity.setJobNumber(ConfigurationConstant.STATUS_INVALID);
                deploymentSituationEntity.setStatus(ConfigurationConstant.STATUS_INVALID);
                this.deploymentSituationMapper.insert(deploymentSituationEntity);
            }
        }
        if (nodeIdAndFileId != null) {
            nodeIdAndFileId.setStatus(ConfigurationConstant.STATUS_INVALID);
            this.deploymentSituationMapper.update(nodeIdAndFileId);
        }
        return BaseResponse.success();
    }

    public BaseResponse<List<DeploymentSituationEntity>> getListByNodeIdAndFileId(Long nodeId, Long fileId, String searchParam) {
        List deploymentSituationEntityList = this.deploymentSituationMapper.getListByNodeIdAndFileId(nodeId, fileId, searchParam);
        return BaseResponse.success((Object)deploymentSituationEntityList);
    }

    public BaseResponse<String> redeploy(Long nodeId, Long fileId) {
        NodeConfigurationEntity nodeConfigurationEntity = this.nodeConfigurationMapper.getById(nodeId);
        ConfigurationFileEntity configurationFileEntity = this.configurationFileMapper.getById(fileId);
        DeploymentSituationEntity byNodeIdAndFile = this.deploymentSituationMapper.getByNodeIdAndFileId(nodeId, fileId);
        byNodeIdAndFile.setStatus(ConfigurationConstant.STATUS_INVALID);
        this.deploymentSituationMapper.update(byNodeIdAndFile);
        JobServerIpEntity byNodeIdAndFileId = this.jobServerIpMapper.getByNodeIdAndFileId(nodeId, fileId);
        this.jobService.deploymentNode(nodeConfigurationEntity.getView(), nodeConfigurationEntity.getViewName(), byNodeIdAndFileId.getTagsNumber(), configurationFileEntity.getProjectName(), nodeConfigurationEntity.getDeploymentType());
        return BaseResponse.success();
    }

    public BaseResponse<ApplicationVo> application(Long nodeId, Long platformId) {
        PlatformInfoEntity platformInfoEntity;
        ApplicationVo applicationVo = new ApplicationVo();
        NodeConfigurationEntity nodeConfigurationEntity = this.nodeConfigurationMapper.getById(nodeId);
        if (nodeConfigurationEntity.getDeploymentType().toString().equals(ConfigurationConstant.TYPE_TWO.toString())) {
            InitializeInfoEntity infoMapperByAppCode = this.initializeInfoMapper.getByAppCode(nodeConfigurationEntity.getAppCode(), nodeConfigurationEntity.getBelongs());
            String dbNetworkIp = infoMapperByAppCode.getDbNetworkIp();
            if (platformId != null) {
                platformInfoEntity = this.platformInfoMapper.getById(platformId);
                applicationVo.setAppCode(platformInfoEntity.getPlatformCode());
            } else {
                applicationVo.setAppCode(nodeConfigurationEntity.getAppCode());
            }
            applicationVo.setServerIp(dbNetworkIp);
            applicationVo.setBelongs(nodeConfigurationEntity.getBelongs());
            applicationVo.setType(ConfigurationConstant.CONFIGURATION_TWO);
        }
        if (nodeConfigurationEntity.getDeploymentType().toString().equals(ConfigurationConstant.TYPE_THREE.toString())) {
            Long status = 0L;
            if (nodeConfigurationEntity.getStatus().toString().equals(ConfigurationConstant.TYPE_ONE.toString())) {
                status = ConfigurationConstant.CLOUD_GATEWAY.longValue();
            } else if (nodeConfigurationEntity.getStatus().toString().equals(ConfigurationConstant.TYPE_TWO.toString())) {
                status = ConfigurationConstant.NODE_GATEWAY.longValue();
            } else if (nodeConfigurationEntity.getStatus().toString().equals(ConfigurationConstant.TYPE_THREE.toString())) {
                status = ConfigurationConstant.CLOUD_GATEWAY.longValue();
            } else if (nodeConfigurationEntity.getStatus().toString().equals(ConfigurationConstant.TYPE_FOUR.toString())) {
                status = ConfigurationConstant.NODE_GATEWAY.longValue();
            }
            JobServerIpEntity byNodeIdAndFileId = this.jobServerIpMapper.getByNodeIdAndFileId(nodeId, status);
            applicationVo.setServerIp(byNodeIdAndFileId.getServerIp());
            if (platformId != null) {
                platformInfoEntity = this.platformInfoMapper.getById(platformId);
                applicationVo.setAppCode(platformInfoEntity.getPlatformCode());
            } else {
                applicationVo.setAppCode(nodeConfigurationEntity.getAppCode());
            }
            applicationVo.setBelongs(nodeConfigurationEntity.getBelongs());
            applicationVo.setType(ConfigurationConstant.CONFIGURATION_ONE);
        }
        return BaseResponse.success((Object)applicationVo);
    }

    public BaseResponse<String> mercuryAdd(SaveAppInfoRequestVo saveAppInfoRequestVo) {
        OrganInfoEntity listByAppCode = this.organInfoMapper.getListByAppCode(saveAppInfoRequestVo.getAppCode(), saveAppInfoRequestVo.getBelongs());
        InitializeInfoEntity initializeInfoEntity = this.initializeInfoMapper.getById(listByAppCode.getInitializeId());
        RestTemplate restTemplate = new RestConfiguration().restTemplate();
        String mercury_login_url = "https://" + initializeInfoEntity.getDomainName() + "/mercury/api/v1/app_info/login";
        HttpHeaders headervo = new HttpHeaders();
        headervo.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity requestS = new HttpEntity((Object)"userName=byh&password=byh12@2019..", (MultiValueMap)headervo);
        log.info("===mercury_login_url==>{}", (Object)JSON.toJSONString((Object)mercury_login_url));
        log.info("===requestS==>{}", (Object)JSON.toJSONString((Object)requestS));
        BaseResponse forObject = (BaseResponse)restTemplate.postForObject(mercury_login_url, (Object)requestS, BaseResponse.class, new Object[0]);
        log.info("===forObject==>{}", (Object)JSON.toJSONString((Object)forObject));
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)forObject.getData()), Map.class);
        String mercury_url = "https://" + initializeInfoEntity.getDomainName() + "/mercury/api/v1/app_info/save";
        String name = null;
        if (saveAppInfoRequestVo.getIpType().toString().equals(ConfigurationConstant.CONFIGURATION_ONE.toString())) {
            name = "applicationName=" + saveAppInfoRequestVo.getApplicationName() + "&domainName=&intranetIp=" + saveAppInfoRequestVo.getIntranetIp() + "&extranetIp=&appPort=" + saveAppInfoRequestVo.getAppPort() + "&ipType=" + saveAppInfoRequestVo.getIpType() + "&appCode=" + saveAppInfoRequestVo.getAppCode() + "&needPrefix=" + saveAppInfoRequestVo.getNeedPrefix();
        }
        if (saveAppInfoRequestVo.getIpType().toString().equals(ConfigurationConstant.CONFIGURATION_TWO.toString())) {
            name = "applicationName=" + saveAppInfoRequestVo.getApplicationName() + "&domainName=&intranetIp=&extranetIp=" + saveAppInfoRequestVo.getIntranetIp() + "&appPort=" + saveAppInfoRequestVo.getAppPort() + "&ipType=" + saveAppInfoRequestVo.getIpType() + "&appCode=" + saveAppInfoRequestVo.getAppCode() + "&needPrefix=" + saveAppInfoRequestVo.getNeedPrefix();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.put("id", Collections.singletonList((String)map.get("userName")));
        headers.put("token", Collections.singletonList((String)map.get("token")));
        HttpEntity request = new HttpEntity((Object)name, (MultiValueMap)headers);
        log.info("===mercury_url==>{}", (Object)JSON.toJSONString((Object)mercury_url));
        log.info("===request==>{}", (Object)JSON.toJSONString((Object)request));
        String response = (String)restTemplate.postForObject(mercury_url, (Object)request, String.class, new Object[0]);
        log.info("===response==>{}", (Object)JSON.toJSONString((Object)response));
        return BaseResponse.success();
    }
}

