/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.config.RestConfiguration;
import com.ebaiyihui.service.constant.ConfigurationConstant;
import com.ebaiyihui.service.entity.InitializeInfoEntity;
import com.ebaiyihui.service.entity.NodeConfigurationEntity;
import com.ebaiyihui.service.mapper.InitializeInfoMapper;
import com.ebaiyihui.service.mapper.NodeConfigurationMapper;
import com.ebaiyihui.service.service.GitLabFileService;
import com.ebaiyihui.service.utils.RunSqlScript;
import com.ebaiyihui.service.utils.XmlTemplateKit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class GitLabFileServiceImpl
implements GitLabFileService {
    private static final Logger log = LoggerFactory.getLogger(GitLabFileServiceImpl.class);
    @Autowired
    private InitializeInfoMapper initializeInfoMapper;
    @Autowired
    private NodeConfigurationMapper nodeConfigurationMapper;

    public BaseResponse<String> insertGitLabNodeFile(Long id) {
        RestTemplate restTemplate = new RestConfiguration().restTemplate();
        InitializeInfoEntity initializeInfoEntity = this.initializeInfoMapper.getById(id);
        NodeConfigurationEntity nodeConfigurationEntity = this.nodeConfigurationMapper.getByAppCode(initializeInfoEntity.getAppCode(), initializeInfoEntity.getType());
        String ref = null;
        String fileName = null;
        if (nodeConfigurationEntity.getAppCode().equals("cloud")) {
            ref = "test_cloud_file";
            fileName = "cloudFile";
        } else {
            ref = "test_node_file";
            fileName = "nodeFile";
        }
        String nodeUrl = "https://git.chinachdu.com/api/v4/projects/187/repository/tree?ref=" + ref + "&private_token=pQMBMmurRkVH6zFs6Rxv";
        log.info("url :{}", (Object)JSON.toJSONString((Object)nodeUrl));
        String response = (String)restTemplate.getForObject(nodeUrl, String.class, new Object[0]);
        List stringList = JSONArray.parseArray((String)response, String.class);
        for (String flie : stringList) {
            Map map = (Map)JSON.parseObject((String)flie, Map.class);
            String fileUrl = "https://git.chinachdu.com/api/v4/projects/187/repository/files/" + (String)map.get("name") + "/raw?ref=" + ref + "&private_token=pQMBMmurRkVH6zFs6Rxv";
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.setContentType(MediaType.APPLICATION_JSON_UTF8);
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
            ResponseEntity responseEntity = restTemplate.exchange(fileUrl, HttpMethod.GET, requestEntity, String.class, new Object[0]);
            log.info("responseEntity==>{}", (Object)JSON.toJSONString((Object)responseEntity.getBody()));
            try {
                RunSqlScript.writeToResource((String)((String)responseEntity.getBody()), (String)(fileName + "/" + (String)map.get("name")), (Integer)ConfigurationConstant.STATUS_INVALID);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String getBranchesUrl = "https://git.chinachdu.com/api/v4/projects/187/repository/branches?private_token=pQMBMmurRkVH6zFs6Rxv&per_page=100&page=1";
        log.info("getBranchUrl :{}", (Object)JSON.toJSONString((Object)getBranchesUrl));
        String getBranches = (String)restTemplate.getForObject(getBranchesUrl, String.class, new Object[0]);
        Integer brancheType = 0;
        List getBranchesList = JSONArray.parseArray((String)getBranches, String.class);
        for (String getBranche : getBranchesList) {
            Map mapBranche = (Map)JSON.parseObject((String)getBranche, Map.class);
            String brancheName = (String)mapBranche.get("name");
            if (!brancheName.equals(nodeConfigurationEntity.getLabel())) continue;
            brancheType = 1;
            break;
        }
        log.info("brancheType :{}", (Object)brancheType);
        if (brancheType == 0) {
            String branchUrl = "https://git.chinachdu.com/api/v4/projects/187/repository/branches";
            HashMap<String, String> branchMap = new HashMap<String, String>();
            branchMap.put("branch", nodeConfigurationEntity.getLabel());
            branchMap.put("ref", "master");
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            headers.set("PRIVATE-TOKEN", "pQMBMmurRkVH6zFs6Rxv");
            HttpEntity request = new HttpEntity((Object)JSON.toJSONString(branchMap), (MultiValueMap)headers);
            restTemplate.postForObject(branchUrl, (Object)request, String.class, new Object[0]);
        }
        LinkedHashMap<String, String> mapVo = new LinkedHashMap<String, String>();
        mapVo.put("redisPortOne", initializeInfoEntity.getRedisPortOne().toString());
        mapVo.put("redisPortTwo", initializeInfoEntity.getRedisPortTwo().toString());
        mapVo.put("redisPortThree", initializeInfoEntity.getRedisPortThree().toString());
        mapVo.put("mySqlPort", initializeInfoEntity.getDbPort().toString());
        mapVo.put("mySqlPassword", initializeInfoEntity.getDbPassword());
        mapVo.put("rabbitmqUsername", initializeInfoEntity.getMqUsername());
        mapVo.put("rabbitmqPassword", initializeInfoEntity.getMqPassword());
        mapVo.put("domainName", initializeInfoEntity.getDomainName());
        mapVo.put("appCode", initializeInfoEntity.getAppCode());
        mapVo.put("name", initializeInfoEntity.getName());
        mapVo.put("mongodbHost", "192.168.0.112");
        for (String flie : stringList) {
            HttpEntity httpEntity;
            HttpHeaders headers;
            HashMap<String, String> contentMap;
            Object getTreeUrl;
            String getFile;
            Map mapFile = (Map)JSON.parseObject((String)flie, Map.class);
            String pash = "/" + fileName + "/" + (String)mapFile.get("name");
            String processFile = XmlTemplateKit.autoReplace((String)pash, mapVo);
            log.info("==pash==>{}", (Object)JSON.toJSONString((Object)pash));
            log.info("====processFile===>{}", (Object)JSON.toJSONString((Object)processFile));
            String file_path = StringUtils.substringBefore((String)((String)mapFile.get("name")), (String)".") + "-" + nodeConfigurationEntity.getProfile() + ".yml";
            String contentUrl = "https://git.chinachdu.com/api/v4/projects/187/repository/files/" + file_path;
            ArrayList treeList = new ArrayList();
            for (int i = 1; i < 5 && !(getFile = (String)restTemplate.getForObject((String)(getTreeUrl = "https://git.chinachdu.com/api/v4/projects/187/repository/tree?private_token=pQMBMmurRkVH6zFs6Rxv&ref=" + nodeConfigurationEntity.getLabel() + "&per_page=100&page=" + i), String.class, new Object[0])).equals("[]"); ++i) {
                List getTreeList = JSONArray.parseArray((String)getFile, String.class);
                treeList.addAll(getTreeList);
            }
            Integer treeType = 0;
            getTreeUrl = treeList.iterator();
            while (getTreeUrl.hasNext()) {
                String tree = (String)getTreeUrl.next();
                Map mapTree = (Map)JSON.parseObject((String)tree, Map.class);
                String treeName = (String)mapTree.get("name");
                if (!treeName.equals(file_path)) continue;
                treeType = 1;
                break;
            }
            if (treeType == 1) {
                contentMap = new HashMap<String, String>();
                contentMap.put("branch", nodeConfigurationEntity.getLabel());
                contentMap.put("content", processFile);
                contentMap.put("commit_message", "<feat>:<\u4fee\u6539" + file_path + "\u914d\u5236>");
                headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                headers.set("PRIVATE-TOKEN", "pQMBMmurRkVH6zFs6Rxv");
                httpEntity = new HttpEntity((Object)JSON.toJSONString(contentMap), (MultiValueMap)headers);
                restTemplate.put(contentUrl, (Object)httpEntity, new Object[]{String.class});
            }
            if (treeType != 0) continue;
            contentMap = new HashMap();
            contentMap.put("branch", nodeConfigurationEntity.getLabel());
            contentMap.put("content", processFile);
            contentMap.put("commit_message", "<feat>:<\u63d0\u4ea4" + StringUtils.substringBefore((String)((String)mapFile.get("name")), (String)".") + "\u914d\u5236>");
            headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            headers.set("PRIVATE-TOKEN", "pQMBMmurRkVH6zFs6Rxv");
            httpEntity = new HttpEntity((Object)JSON.toJSONString(contentMap), (MultiValueMap)headers);
            restTemplate.postForObject(contentUrl, (Object)httpEntity, String.class, new Object[0]);
        }
        XmlTemplateKit.init();
        HashMap<String, InitializeInfoEntity> map = new HashMap<String, InitializeInfoEntity>();
        log.info("initializeInfoEntity==>{}", (Object)JSON.toJSONString((Object)initializeInfoEntity));
        map.put("initializeInfoEntity", initializeInfoEntity);
        String configServiceXml = XmlTemplateKit.processSql((String)"gateway", map);
        if (StringUtils.isEmpty((CharSequence)configServiceXml)) {
            return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        try {
            RunSqlScript.writeToResource((String)configServiceXml, (String)"database/gateway.sql", (Integer)ConfigurationConstant.STATUS_INVALID);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (nodeConfigurationEntity.getStatus().toString().equals(ConfigurationConstant.TYPE_ONE.toString()) || nodeConfigurationEntity.getStatus().toString().equals(ConfigurationConstant.TYPE_TWO.toString())) {
            RunSqlScript.executeSql((String)"gateway", (String)"47.92.68.235:13507", (String)"root", (String)"Baiyihui@@2018!!", (Integer)ConfigurationConstant.STATUS_VALID);
        }
        if (nodeConfigurationEntity.getStatus().toString().equals(ConfigurationConstant.TYPE_THREE.toString()) || nodeConfigurationEntity.getStatus().toString().equals(ConfigurationConstant.TYPE_FOUR.toString())) {
            RunSqlScript.executeSql((String)"gateway", (String)"47.92.55.208:3309", (String)"root", (String)"Cloudpro@@2020!!", (Integer)ConfigurationConstant.STATUS_VALID);
        }
        return BaseResponse.success();
    }
}

