/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.config.RestConfiguration;
import com.ebaiyihui.service.constant.ConfigurationConstant;
import com.ebaiyihui.service.constant.enums.NodeEnum;
import com.ebaiyihui.service.entity.InitializeInfoEntity;
import com.ebaiyihui.service.entity.JobServerIpEntity;
import com.ebaiyihui.service.entity.NodeConfigurationEntity;
import com.ebaiyihui.service.entity.OrganInfoEntity;
import com.ebaiyihui.service.mapper.InitializeInfoMapper;
import com.ebaiyihui.service.mapper.JobServerIpMapper;
import com.ebaiyihui.service.mapper.NodeConfigurationMapper;
import com.ebaiyihui.service.mapper.OrganInfoMapper;
import com.ebaiyihui.service.service.InitializeService;
import com.ebaiyihui.service.service.JobService;
import com.ebaiyihui.service.utils.PreparationUtils;
import com.ebaiyihui.service.utils.RunSqlScript;
import com.ebaiyihui.service.utils.StrinUtils;
import com.ebaiyihui.service.utils.UUIDUtil;
import com.ebaiyihui.service.utils.XmlTemplateKit;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class InitializeServiceImpl
implements InitializeService {
    private static final Logger log = LoggerFactory.getLogger(InitializeServiceImpl.class);
    @Autowired
    private InitializeInfoMapper initializeInfoMapper;
    @Autowired
    private OrganInfoMapper organInfoMapper;
    @Autowired
    private JobService jobService;
    @Autowired
    private NodeConfigurationMapper nodeConfigurationMapper;
    @Autowired
    private JobServerIpMapper jobServerIpMapper;

    public BaseResponse<String> saveInitialize(InitializeInfoEntity initializeInfoEntity) {
        NodeConfigurationEntity nodeConfigurationEntity;
        List listByFileIdAndNodeId;
        String serverIp;
        Integer testMethod;
        InitializeInfoEntity infoEntity = this.initializeInfoMapper.getByAppCode(initializeInfoEntity.getAppCode(), initializeInfoEntity.getType());
        if (infoEntity == null) {
            this.initializeInfoMapper.insert(initializeInfoEntity);
        }
        if (infoEntity != null) {
            this.initializeInfoMapper.update(initializeInfoEntity);
        }
        if ((testMethod = StrinUtils.testMethod((String)(serverIp = ((JobServerIpEntity)(listByFileIdAndNodeId = this.jobServerIpMapper.getListByFileIdAndNodeId(null, (nodeConfigurationEntity = this.nodeConfigurationMapper.getByAppCode(initializeInfoEntity.getAppCode(), initializeInfoEntity.getType())).getId())).get(0)).getServerIp()))) != 0) {
            String method = StrinUtils.method((String)serverIp);
            nodeConfigurationEntity.setExtraHosts(NodeEnum.getExtraHosts((String)method, (String)initializeInfoEntity.getDbIntranetIp(), (String)initializeInfoEntity.getMqIp(), (String)initializeInfoEntity.getRedisIp()));
        } else {
            nodeConfigurationEntity.setExtraHosts(NodeEnum.getExtraHosts((String)serverIp, (String)initializeInfoEntity.getDbIntranetIp(), (String)initializeInfoEntity.getMqIp(), (String)initializeInfoEntity.getRedisIp()));
        }
        this.nodeConfigurationMapper.update(nodeConfigurationEntity);
        this.jobService.uodateJobNode(nodeConfigurationEntity);
        return BaseResponse.success();
    }

    public BaseResponse<List<InitializeInfoEntity>> getListBySearch(String searchParam, Integer searchType) {
        List listBySearch = this.initializeInfoMapper.getListBySearch(searchParam, searchType);
        return BaseResponse.success((Object)listBySearch);
    }

    public BaseResponse<String> saveOrganInfo(OrganInfoEntity organInfoEntity) {
        OrganInfoEntity organInfoEntities = this.organInfoMapper.getListByAppCode(organInfoEntity.getAppCode(), organInfoEntity.getType());
        if (organInfoEntities == null) {
            this.organInfoMapper.insert(organInfoEntity);
        }
        if (organInfoEntities != null) {
            this.organInfoMapper.update(organInfoEntity);
        }
        return BaseResponse.success();
    }

    public BaseResponse<String> deployment(Long initializeId, Integer middlewareType) {
        InitializeInfoEntity initializeInfoEntity = this.initializeInfoMapper.getById(initializeId);
        this.jobService.uodateJobNodeInitialize(initializeInfoEntity, middlewareType);
        this.jobService.deploymentInitialize(middlewareType);
        return BaseResponse.success();
    }

    public BaseResponse<String> getWebAccount(OrganInfoEntity organInfoEntity) {
        log.info("===organInfoEntity===>{}", (Object)JSON.toJSONString((Object)organInfoEntity));
        this.organInfoMapper.update(organInfoEntity);
        organInfoEntity.setAccountId(UUIDUtil.generateViewId());
        InitializeInfoEntity initializeInfoEntity = this.initializeInfoMapper.getById(organInfoEntity.getInitializeId());
        PreparationUtils.dealWhite((String)initializeInfoEntity.getDomainName(), (String)initializeInfoEntity.getAppCode());
        PreparationUtils.processingPermissions((String)initializeInfoEntity.getDomainName(), (OrganInfoEntity)organInfoEntity);
        PreparationUtils.deleteWhite((String)initializeInfoEntity.getDomainName(), (String)initializeInfoEntity.getAppCode());
        XmlTemplateKit.init();
        HashMap<String, OrganInfoEntity> map = new HashMap<String, OrganInfoEntity>();
        log.info("==organInfoEntity==>{}", (Object)JSON.toJSONString((Object)organInfoEntity));
        map.put("organInfoEntity", organInfoEntity);
        String configServiceXml = XmlTemplateKit.processSql((String)"organ", map);
        if (StringUtils.isEmpty((CharSequence)configServiceXml)) {
            return BaseResponse.error((String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        try {
            RunSqlScript.writeToResource((String)configServiceXml, (String)"database/organ.sql", (Integer)ConfigurationConstant.STATUS_INVALID);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        RunSqlScript.executeSql((String)"organ", (String)(initializeInfoEntity.getDbNetworkIp() + ":" + initializeInfoEntity.getDbPort()), (String)initializeInfoEntity.getDbUsername(), (String)initializeInfoEntity.getDbPassword(), (Integer)ConfigurationConstant.STATUS_VALID);
        return BaseResponse.success();
    }

    public BaseResponse<String> deleteJob(Long nodeId) {
        this.jobService.deleteJob(nodeId);
        return BaseResponse.success();
    }

    public BaseResponse<String> configSms(String appCode, Integer type) {
        OrganInfoEntity organInfoEntities = this.organInfoMapper.getListByAppCode(appCode, type);
        InitializeInfoEntity initializeInfoEntity = this.initializeInfoMapper.getById(organInfoEntities.getInitializeId());
        RestTemplate restTemplate = new RestConfiguration().restTemplate();
        String url = "https://" + initializeInfoEntity.getDomainName() + "/cloud/push/alismsapi/configSms" + "?appCode=" + appCode + "&name=" + organInfoEntities.getOrganName() + "&appid=" + organInfoEntities.getAppletId() + "&secret=" + organInfoEntities.getAppletSecret();
        String pushSms = (String)restTemplate.getForObject(url, String.class, new Object[0]);
        log.info("push\u670d\u52a1\u77ed\u4fe1\u63a8\u9001\u914d\u5236==>{}", (Object)JSON.toJSONString((Object)pushSms));
        String dockerUserUrl = "https://" + initializeInfoEntity.getDomainName() + "/cloud/doctoruser/configuration/add" + "?appCode=" + appCode;
        log.info("url :{}", (Object)JSON.toJSONString((Object)dockerUserUrl));
        String response = (String)restTemplate.getForObject(dockerUserUrl, String.class, new Object[0]);
        log.info("dockerUser\u670d\u52a1\u77ed\u4fe1\u63a8\u9001\u914d\u5236==>{}", (Object)JSON.toJSONString((Object)response));
        return BaseResponse.success();
    }

    public BaseResponse<List<OrganInfoEntity>> getListByOrgan(Long initializeId) {
        List organInfoEntityList = this.organInfoMapper.getListByInitializeId(initializeId);
        return BaseResponse.success((Object)organInfoEntityList);
    }

    public BaseResponse<String> openOrganServiceIteration(Long organId) {
        return null;
    }
}

