/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.config.RestConfiguration;
import com.ebaiyihui.service.constant.ConfigurationConstant;
import com.ebaiyihui.service.constant.enums.DomainNameEnum;
import com.ebaiyihui.service.constant.enums.OrganEnum;
import com.ebaiyihui.service.entity.ConfigurationFileEntity;
import com.ebaiyihui.service.entity.ConfigurationSealingPlateEntity;
import com.ebaiyihui.service.entity.InitializeInfoEntity;
import com.ebaiyihui.service.entity.JobServerIpEntity;
import com.ebaiyihui.service.entity.NodeConfigurationEntity;
import com.ebaiyihui.service.entity.PlatformInfoEntity;
import com.ebaiyihui.service.mapper.ConfigurationFileMapper;
import com.ebaiyihui.service.mapper.ConfigurationSealingPlateMapper;
import com.ebaiyihui.service.mapper.InitializeInfoMapper;
import com.ebaiyihui.service.mapper.JobServerIpMapper;
import com.ebaiyihui.service.mapper.NodeConfigurationMapper;
import com.ebaiyihui.service.mapper.PlatformInfoMapper;
import com.ebaiyihui.service.mapper.PlatformOutreachMapper;
import com.ebaiyihui.service.service.PlatformInfoService;
import com.ebaiyihui.service.vo.ConfigurationFileVo;
import com.ebaiyihui.service.vo.ConfigurationSealingPlateVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class PlatformInfoServiceImpl
implements PlatformInfoService {
    private static final Logger log = LoggerFactory.getLogger(PlatformInfoServiceImpl.class);
    @Autowired
    private PlatformInfoMapper platformInfoMapper;
    @Autowired
    private NodeConfigurationMapper nodeConfigurationMapper;
    @Autowired
    private ConfigurationFileMapper configurationFileMapper;
    @Autowired
    private PlatformOutreachMapper platformOutreachMapper;
    @Autowired
    private JobServerIpMapper jobServerIpMapper;
    @Autowired
    private ConfigurationSealingPlateMapper configurationSealingPlateMapper;
    @Autowired
    private InitializeInfoMapper initializeInfoMapper;

    public BaseResponse<List<PlatformInfoEntity>> getListByPlatform() {
        List byList = this.platformInfoMapper.getByList();
        return BaseResponse.success((Object)byList);
    }

    public BaseResponse<List<NodeConfigurationEntity>> getListByNodeConfiguration() {
        List byList = this.nodeConfigurationMapper.getByList();
        return BaseResponse.success((Object)byList);
    }

    public BaseResponse<List<ConfigurationFileVo>> getListConfiguration(Long nodeId, Long platformId) {
        ArrayList<ConfigurationFileVo> configurationFileEntityList = new ArrayList<ConfigurationFileVo>();
        NodeConfigurationEntity byStatus = this.nodeConfigurationMapper.getById(nodeId);
        List listByStatus = this.configurationFileMapper.getListByStatus(ConfigurationConstant.TYPE_THREE, null);
        for (ConfigurationFileEntity configurationFile : listByStatus) {
            ConfigurationFileVo configurationFileVo = new ConfigurationFileVo();
            BeanUtils.copyProperties((Object)configurationFile, (Object)configurationFileVo);
            configurationFileVo.setNodeId(byStatus.getId());
            JobServerIpEntity byNodeIdAndFileId = this.jobServerIpMapper.getByNodeIdAndFileId(byStatus.getId(), configurationFile.getId());
            if (byNodeIdAndFileId == null) continue;
            configurationFileEntityList.add(configurationFileVo);
        }
        if (platformId == null) {
            List listByFileIdAndNodeId = this.jobServerIpMapper.getListByFileIdAndNodeId(null, nodeId);
            for (JobServerIpEntity jobServerIpEntity : listByFileIdAndNodeId) {
                if (jobServerIpEntity.getFileId() == 0L) continue;
                ConfigurationFileVo configurationFileVo = new ConfigurationFileVo();
                configurationFileVo.setId(jobServerIpEntity.getFileId());
                configurationFileVo.setChineseNameService(jobServerIpEntity.getChineseNameService());
                configurationFileVo.setProjectName(jobServerIpEntity.getServiceName());
                configurationFileVo.setNodeId(nodeId);
                configurationFileEntityList.add(configurationFileVo);
            }
        }
        if (platformId != null) {
            List listByPlatformIdAndNodeId = this.platformOutreachMapper.getListByPlatformIdAndNodeId(platformId, nodeId);
            listByPlatformIdAndNodeId.stream().forEach(platformOutreachEntity -> {
                ConfigurationFileVo configurationFileVo = new ConfigurationFileVo();
                configurationFileVo.setId(platformOutreachEntity.getFileId());
                configurationFileVo.setChineseNameService(platformOutreachEntity.getChineseNameService());
                configurationFileVo.setProjectName(platformOutreachEntity.getServiceName());
                configurationFileVo.setNodeId(nodeId);
                configurationFileEntityList.add(configurationFileVo);
            });
        }
        return BaseResponse.success(configurationFileEntityList);
    }

    public BaseResponse<List<ConfigurationFileVo>> getListNodeByConfiguration(Long nodeId) {
        ArrayList<ConfigurationFileVo> configurationFileEntityList = new ArrayList<ConfigurationFileVo>();
        NodeConfigurationEntity byId = this.nodeConfigurationMapper.getById(nodeId);
        List listByStatus = this.configurationFileMapper.getListByStatus(ConfigurationConstant.TYPE_THREE, null);
        for (ConfigurationFileEntity configurationFile : listByStatus) {
            ConfigurationFileVo configurationFileVo = new ConfigurationFileVo();
            BeanUtils.copyProperties((Object)configurationFile, (Object)configurationFileVo);
            configurationFileVo.setNodeId(nodeId);
            JobServerIpEntity byNodeIdAndFileId = this.jobServerIpMapper.getByNodeIdAndFileId(byId.getId(), configurationFile.getId());
            if (byNodeIdAndFileId == null) continue;
            configurationFileEntityList.add(configurationFileVo);
        }
        return BaseResponse.success(configurationFileEntityList);
    }

    public BaseResponse<List<ConfigurationSealingPlateVo>> getListConfigurationFile(Integer status) {
        List listByStatus = this.configurationFileMapper.getListByStatus(status, null);
        ArrayList<ConfigurationSealingPlateVo> sealingPlateVos = new ArrayList<ConfigurationSealingPlateVo>();
        for (ConfigurationFileEntity configurationFileEntity : listByStatus) {
            ConfigurationSealingPlateVo configurationSealingPlateVo = new ConfigurationSealingPlateVo();
            BeanUtils.copyProperties((Object)configurationFileEntity, (Object)configurationSealingPlateVo);
            ConfigurationSealingPlateEntity sealingPlateEntity = this.configurationSealingPlateMapper.getByFileId(configurationFileEntity.getId());
            configurationSealingPlateVo.setProfile(sealingPlateEntity.getProfile());
            sealingPlateVos.add(configurationSealingPlateVo);
        }
        return BaseResponse.success(sealingPlateVos);
    }

    public BaseResponse<Object> informationPlatform(String vueType, String appCode) {
        Integer value = DomainNameEnum.domainNameValueEnum((String)vueType);
        InitializeInfoEntity mapperByAppCode = this.initializeInfoMapper.getByAppCode(appCode, value);
        Object content = new Object();
        if (null != mapperByAppCode) {
            String domainDesc = "https://" + mapperByAppCode.getDomainName() + "/cloud/doctorbasedata/hospital_info/select_list";
            RestTemplate restTemplate = new RestConfiguration().restTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            HttpEntity request = new HttpEntity((Object)"{\"hospitalIdOrName\":\"\",\"pageNum\":1,\"pageSize\":100,\"statusArr\":[\"1\",\"2\",\"8\"]}", (MultiValueMap)headers);
            BaseResponse baseResponse = (BaseResponse)restTemplate.postForObject(domainDesc, (Object)request, BaseResponse.class, new Object[0]);
            log.info("informationPlatform==>{}", (Object)JSON.toJSONString((Object)baseResponse));
            Object data = baseResponse.getData();
            Object hospitalPage = ((Map)JSON.parseObject((String)JSON.toJSONString((Object)data), Map.class)).get("hospitalPage");
            content = ((Map)JSON.parseObject((String)JSON.toJSONString(hospitalPage), Map.class)).get("content");
        }
        return BaseResponse.success((Object)content);
    }

    public BaseResponse<List<NodeConfigurationEntity>> subordinateNode(String vueType) {
        Integer nameValueEnum = DomainNameEnum.domainNameValueEnum((String)vueType);
        List listByBelongs = this.nodeConfigurationMapper.getListByBelongs(nameValueEnum);
        return BaseResponse.success((Object)listByBelongs);
    }

    public BaseResponse<Object> subordinateOrganName(String organName, Integer type) {
        String organDesc = OrganEnum.getOrganDesc((Integer)type);
        RestTemplate restTemplate = new RestConfiguration().restTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)("{\"organIdOrName\":\"" + organName + "\",\"pageNum\":1,\"pageSize\":100,\"statusArr\":[\"1\",\"2\"],\"appCode\":\"\",\"level\":\"\"}"), (MultiValueMap)headers);
        BaseResponse baseResponse = (BaseResponse)restTemplate.postForObject(organDesc, (Object)request, BaseResponse.class, new Object[0]);
        log.info("subordinateOrganName==>{}", (Object)JSON.toJSONString((Object)baseResponse));
        Object hospitalPage = ((Map)JSON.parseObject((String)JSON.toJSONString((Object)baseResponse.getData()), Map.class)).get("hospitalPage");
        Object content = ((Map)JSON.parseObject((String)JSON.toJSONString(hospitalPage), Map.class)).get("content");
        return BaseResponse.success(content);
    }
}

