/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.constant.ConfigurationConstant;
import com.ebaiyihui.service.constant.enums.OrganEnum;
import com.ebaiyihui.service.entity.ConfigurationFileEntity;
import com.ebaiyihui.service.entity.ConfigurationSealingPlateEntity;
import com.ebaiyihui.service.entity.DependencyManagementInfoEntity;
import com.ebaiyihui.service.entity.DeploymentSituationEntity;
import com.ebaiyihui.service.entity.JobServerIpEntity;
import com.ebaiyihui.service.entity.NodeConfigurationEntity;
import com.ebaiyihui.service.entity.VersionHistoryEntity;
import com.ebaiyihui.service.mapper.AccountMapper;
import com.ebaiyihui.service.mapper.ConfigurationFileMapper;
import com.ebaiyihui.service.mapper.ConfigurationSealingPlateMapper;
import com.ebaiyihui.service.mapper.DependencyManagementInfoMapper;
import com.ebaiyihui.service.mapper.DeploymentSituationMapper;
import com.ebaiyihui.service.mapper.JobServerIpMapper;
import com.ebaiyihui.service.mapper.NodeConfigurationMapper;
import com.ebaiyihui.service.mapper.VersionHistoryMapper;
import com.ebaiyihui.service.service.JobService;
import com.ebaiyihui.service.service.ServiceVersioningService;
import com.ebaiyihui.service.vo.IterationVO;
import com.ebaiyihui.service.vo.IterationVersionHistoryVO;
import com.ebaiyihui.service.vo.SearchVO;
import com.ebaiyihui.service.vo.ServiceVersioningDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service
public class ServiceVersioningServiceImpl
implements ServiceVersioningService {
    private static final Logger log = LoggerFactory.getLogger(ServiceVersioningServiceImpl.class);
    @Autowired
    private NodeConfigurationMapper nodeConfigurationMapper;
    @Autowired
    private ConfigurationFileMapper configurationFileMapper;
    @Autowired
    private JobServerIpMapper jobServerIpMapper;
    @Autowired
    private VersionHistoryMapper versionHistoryMapper;
    @Autowired
    private DependencyManagementInfoMapper dependencyManagementInfoMapper;
    @Autowired
    private JobService jobService;
    @Autowired
    JavaMailSender javaMailSender;
    @Autowired
    private AccountMapper accountMapper;
    @Autowired
    private DeploymentSituationMapper deploymentSituationMapper;
    @Autowired
    private ConfigurationSealingPlateMapper configurationSealingPlateMapper;

    public BaseResponse<List<SearchVO>> getListBySearch(String searchParam) {
        List fileMapperListByStatus = this.configurationFileMapper.getListByStatus(ConfigurationConstant.TYPE_THREE, searchParam);
        List listByStatus = this.configurationFileMapper.getListByStatus(ConfigurationConstant.TYPE_FOUR, searchParam);
        fileMapperListByStatus.addAll(listByStatus);
        ArrayList searchVOS = new ArrayList();
        fileMapperListByStatus.stream().forEach(ele -> {
            SearchVO searchVO = new SearchVO();
            searchVO.setFileId(ele.getId());
            searchVO.setCreateTime(ele.getCreateTime());
            searchVO.setUpdateTime(ele.getUpdateTime());
            searchVO.setProjectName(ele.getProjectName());
            if (ele.getStatus().toString().equals(ConfigurationConstant.TYPE_THREE.toString())) {
                searchVO.setChineseNameService("\u4e91\u7aef" + ele.getChineseNameService());
            }
            if (ele.getStatus().toString().equals(ConfigurationConstant.TYPE_FOUR.toString())) {
                searchVO.setChineseNameService("\u8282\u70b9" + ele.getChineseNameService());
            }
            searchVO.setServiceName(ele.getServiceName());
            searchVO.setGitAddress(ele.getGitAddress());
            searchVO.setPort(ele.getPort().substring(2, 6));
            Integer count = this.jobServerIpMapper.countByFileId(ele.getId());
            searchVO.setCount(count);
            ConfigurationSealingPlateEntity plateEntity = this.configurationSealingPlateMapper.getByFileId(ele.getId());
            searchVO.setSealingPlate(plateEntity == null ? null : plateEntity.getProfile());
            searchVOS.add(searchVO);
        });
        return BaseResponse.success(searchVOS);
    }

    public BaseResponse<List<SearchVO>> serviceDetails(String searchParam, Long fileId) {
        List listByFileIdAndNodeId = this.jobServerIpMapper.getListByFileIdAndNodeId(fileId, null);
        ConfigurationFileEntity fileMapperById = this.configurationFileMapper.getById(fileId);
        ArrayList searchVOS = new ArrayList();
        listByFileIdAndNodeId.stream().forEach(ele -> {
            SearchVO searchVO = new SearchVO();
            NodeConfigurationEntity configurationEntity = this.nodeConfigurationMapper.getById(ele.getNodeId());
            searchVO.setBelongs(OrganEnum.organCodeEnum((Integer)configurationEntity.getBelongs()));
            searchVO.setFileId(ele.getFileId());
            searchVO.setCreateTime(ele.getCreateTime());
            searchVO.setUpdateTime(ele.getUpdateTime());
            searchVO.setProjectName(ele.getServiceName());
            if (fileMapperById.getStatus().toString().equals(ConfigurationConstant.TYPE_THREE.toString())) {
                searchVO.setChineseNameService("\u4e91\u7aef" + ele.getChineseNameService());
            }
            if (fileMapperById.getStatus().toString().equals(ConfigurationConstant.TYPE_FOUR.toString())) {
                searchVO.setChineseNameService("\u8282\u70b9" + ele.getChineseNameService());
            }
            searchVO.setPort(fileMapperById.getPort().substring(2, 6));
            searchVO.setNodeId(ele.getNodeId());
            searchVO.setServerIp(ele.getServerIp());
            searchVO.setTagsNumber(ele.getTagsNumber());
            searchVO.setStatus(ele.getStatus());
            searchVO.setJobServerId(ele.getId());
            searchVOS.add(searchVO);
        });
        return BaseResponse.success(searchVOS);
    }

    public BaseResponse<String> add(ServiceVersioningDTO serviceVersioningDTO) {
        ConfigurationFileEntity configurationFileEntity = new ConfigurationFileEntity();
        configurationFileEntity.setProjectName(serviceVersioningDTO.getProjectName());
        configurationFileEntity.setChineseNameService(serviceVersioningDTO.getChineseNameService());
        configurationFileEntity.setGitAddress(serviceVersioningDTO.getGitAddress());
        configurationFileEntity.setBuildConfigurationTest("clean deploy -P dev -DskipTests -U");
        configurationFileEntity.setBuildConfigurationPro("clean deploy -P pro -DskipTests -U");
        configurationFileEntity.setDockerFileTest("byh-registry:5000/" + serviceVersioningDTO.getServiceName());
        configurationFileEntity.setDockerFilePro("byh-registry-pro:5000/" + serviceVersioningDTO.getServiceName());
        configurationFileEntity.setPort("- " + serviceVersioningDTO.getPort() + ":" + serviceVersioningDTO.getPort());
        configurationFileEntity.setServiceName(serviceVersioningDTO.getServiceName());
        if (serviceVersioningDTO.getType().toString().equals(ConfigurationConstant.TYPE_ONE)) {
            configurationFileEntity.setStatus(ConfigurationConstant.TYPE_THREE);
        }
        if (serviceVersioningDTO.getType().toString().equals(ConfigurationConstant.TYPE_TWO)) {
            configurationFileEntity.setStatus(ConfigurationConstant.TYPE_FOUR);
        }
        configurationFileEntity.setType(Integer.valueOf(serviceVersioningDTO.getNodeId().intValue()));
        this.configurationFileMapper.insert(configurationFileEntity);
        serviceVersioningDTO.setFileId(configurationFileEntity.getId());
        VersionHistoryEntity versionHistoryEntity = new VersionHistoryEntity();
        versionHistoryEntity.setChineseNameService(serviceVersioningDTO.getChineseNameService());
        versionHistoryEntity.setServiceName(serviceVersioningDTO.getServiceName());
        versionHistoryEntity.setFileId(serviceVersioningDTO.getFileId());
        versionHistoryEntity.setTagsNumber(serviceVersioningDTO.getTagsNumber());
        List byParentId = this.dependencyManagementInfoMapper.getByParentId(serviceVersioningDTO.getFileId());
        versionHistoryEntity.setVersionHistoryJson(JSON.toJSONString((Object)byParentId));
        log.info(" ==\u6dfb\u52a0\u5386\u53f2\u7248\u672c===>{}", (Object)JSON.toJSONString((Object)versionHistoryEntity));
        this.versionHistoryMapper.insert(versionHistoryEntity);
        return BaseResponse.success((Object)serviceVersioningDTO.getFileId().toString());
    }

    public BaseResponse<String> update(ServiceVersioningDTO serviceVersioningDTO) {
        ConfigurationFileEntity configurationFileEntity = new ConfigurationFileEntity();
        NodeConfigurationEntity nodeConfigurationMapperById = this.nodeConfigurationMapper.getById(serviceVersioningDTO.getNodeId());
        configurationFileEntity.setProjectName(serviceVersioningDTO.getProjectName());
        configurationFileEntity.setChineseNameService(serviceVersioningDTO.getChineseNameService());
        configurationFileEntity.setGitAddress(serviceVersioningDTO.getGitAddress());
        configurationFileEntity.setDockerFileTest("byh-registry:5000/" + serviceVersioningDTO.getServiceName());
        configurationFileEntity.setDockerFilePro("byh-registry-pro:5000/" + serviceVersioningDTO.getServiceName());
        configurationFileEntity.setPort("- " + serviceVersioningDTO.getPort() + ":" + serviceVersioningDTO.getPort());
        configurationFileEntity.setServiceName(serviceVersioningDTO.getServiceName());
        configurationFileEntity.setId(serviceVersioningDTO.getFileId());
        this.configurationFileMapper.update(configurationFileEntity);
        return BaseResponse.success();
    }

    public BaseResponse<String> deployment(Long jobServerId, String tagsNumber) {
        JobServerIpEntity byNodeIdAndFileId = this.jobServerIpMapper.getById(jobServerId);
        NodeConfigurationEntity nodeConfigurationEntity = this.nodeConfigurationMapper.getById(byNodeIdAndFileId.getNodeId());
        ConfigurationFileEntity configurationFileEntity = this.configurationFileMapper.getById(byNodeIdAndFileId.getFileId());
        this.jobService.deploymentNode(nodeConfigurationEntity.getView(), nodeConfigurationEntity.getViewName(), tagsNumber, configurationFileEntity.getProjectName(), nodeConfigurationEntity.getDeploymentType());
        if (!byNodeIdAndFileId.getTagsNumber().equals(tagsNumber)) {
            byNodeIdAndFileId.setTagsNumber(tagsNumber);
            byNodeIdAndFileId.setStatus(ConfigurationConstant.STATUS_VALID);
            this.jobServerIpMapper.update(byNodeIdAndFileId);
            VersionHistoryEntity versionHistoryEntity = new VersionHistoryEntity();
            versionHistoryEntity.setChineseNameService(byNodeIdAndFileId.getChineseNameService());
            versionHistoryEntity.setServiceName(byNodeIdAndFileId.getServiceName());
            versionHistoryEntity.setFileId(byNodeIdAndFileId.getFileId());
            versionHistoryEntity.setTagsNumber(tagsNumber);
            List byParentId = this.dependencyManagementInfoMapper.getByParentId(byNodeIdAndFileId.getFileId());
            versionHistoryEntity.setVersionHistoryJson(JSON.toJSONString((Object)byParentId));
            log.info(" ==\u6dfb\u52a0\u5386\u53f2\u7248\u672c===>{}", (Object)JSON.toJSONString((Object)versionHistoryEntity));
            this.versionHistoryMapper.insert(versionHistoryEntity);
        }
        DeploymentSituationEntity nodeIdAndFileId = this.deploymentSituationMapper.getByNodeIdAndFileId(nodeConfigurationEntity.getId(), configurationFileEntity.getId());
        nodeIdAndFileId.setStatus(ConfigurationConstant.STATUS_INVALID);
        this.deploymentSituationMapper.update(nodeIdAndFileId);
        return BaseResponse.success((Object)nodeConfigurationEntity.getId().toString());
    }

    public BaseResponse<List<VersionHistoryEntity>> getListByVersionHistory(Long fileId) {
        List historyEntities = this.versionHistoryMapper.getByFileId(fileId);
        log.info(" ===\u67e5\u8be2\u5386\u53f2\u7248\u672c===>{}", (Object)JSON.toJSONString((Object)historyEntities));
        return BaseResponse.success((Object)historyEntities);
    }

    public BaseResponse<String> addRely(List<DependencyManagementInfoEntity> dependencyManagementInfoEntities) {
        dependencyManagementInfoEntities.stream().forEach(dependencyManagementInfoEntity -> {
            DependencyManagementInfoEntity parentIdAndFileId = this.dependencyManagementInfoMapper.getParentIdAndFileId(dependencyManagementInfoEntity.getParentId(), dependencyManagementInfoEntity.getFileId());
            if (parentIdAndFileId == null) {
                this.dependencyManagementInfoMapper.insert(dependencyManagementInfoEntity);
            }
        });
        return BaseResponse.success();
    }

    public BaseResponse<String> addIteration(IterationVO iterationVO) {
        iterationVO.getVersionHistoryVOS().stream().forEach(versionHistory -> {
            JobServerIpEntity jobServerIpEntity = this.jobServerIpMapper.getByNodeIdAndFileId(versionHistory.getNodeId(), versionHistory.getFileId());
            jobServerIpEntity.setTagsNumber(versionHistory.getTagsNumber());
            jobServerIpEntity.setStatus(ConfigurationConstant.STATUS_INVALID);
            log.info("====\u4fee\u6539jobServerIpMapper===>{}", (Object)JSON.toJSONString((Object)jobServerIpEntity));
            this.jobServerIpMapper.update(jobServerIpEntity);
            VersionHistoryEntity versionHistoryEntity = new VersionHistoryEntity();
            List byParentId = this.dependencyManagementInfoMapper.getByParentId(versionHistory.getFileId());
            versionHistoryEntity.setVersionHistoryJson(JSON.toJSONString((Object)byParentId));
            versionHistoryEntity.setTagsNumber(versionHistory.getTagsNumber());
            versionHistoryEntity.setChineseNameService(versionHistory.getChineseNameService());
            versionHistoryEntity.setServiceName(versionHistory.getServiceName());
            versionHistoryEntity.setFileId(versionHistory.getFileId());
            log.info(" \u6dfb\u52a0===>{}", (Object)JSON.toJSONString((Object)versionHistoryEntity));
            this.versionHistoryMapper.insert(versionHistoryEntity);
            this.sendEmail(jobServerIpEntity);
        });
        return BaseResponse.success();
    }

    public void sendEmail(JobServerIpEntity jobServerIpEntity) {
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        List accountList = this.accountMapper.getNameByStatus(ConfigurationConstant.CONFIGURATION_TWO);
        MimeMessageHelper helper = null;
        try {
            helper = new MimeMessageHelper(mimeMessage, true);
            helper.setSubject("\u670d\u52a1\u7248\u672c\u8fed\u4ee3\u53d1\u5e03");
            helper.setFrom("1043400691@qq.com");
            String[] to = accountList.toArray(new String[accountList.size()]);
            helper.setTo(to);
            helper.setSentDate(new Date());
            helper.setText("\u60a8\u597d\uff0c\u5728" + jobServerIpEntity.getNodeName() + "\u4e2d" + jobServerIpEntity.getChineseNameService() + "/" + jobServerIpEntity.getServiceName() + "\u8fed\u4ee3\u4e86\u4e00\u7248\u4ee3\u7801\uff0c\u73b0\u7248\u672c\u4e3a" + jobServerIpEntity.getTagsNumber() + "\uff0c\u8bf7\u67e5\u6536\u3002");
            this.javaMailSender.send(mimeMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BaseResponse<List<IterationVersionHistoryVO>> getListDependencyManagement(Long fileId) {
        List byParentId = this.dependencyManagementInfoMapper.getByParentId(fileId);
        return BaseResponse.success((Object)byParentId);
    }
}

